/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.service.impl;

import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.spider.api.SpiderTempService;
import com.tydic.nicc.spider.api.bo.GoodsBO;
import com.tydic.nicc.spider.api.bo.SpiderBO;
import com.tydic.nicc.spider.compoent.processor.category.CategoryTempProcessor;
import com.tydic.nicc.spider.compoent.processor.description.GoodsDetailsTempProcessor;
import com.tydic.nicc.spider.compoent.processor.goods.GoodsTempProcessor;
import com.tydic.nicc.spider.config.aspect.SpiderLog;
import com.tydic.nicc.spider.mapper.CategoryMapper;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SpiderTempServiceImpl
implements SpiderTempService {
    private static final Logger log = LoggerFactory.getLogger(SpiderTempServiceImpl.class);
    @Autowired
    private CategoryMapper categoryMapper;
    @Autowired
    private CategoryTempProcessor categoryTempProcessor;
    @Autowired
    private GoodsTempProcessor goodsTempProcessor;
    @Autowired
    private GoodsDetailsTempProcessor goodsDetailsTempProcessor;

    public void spiderCategory(String mall) {
        this.categoryTempProcessor.categoryProcess(mall);
    }

    @SpiderLog(spiderType="1")
    public Rsp spiderGoodsList(SpiderBO spiderBO) {
        try {
            String exectNumber = spiderBO.getExecutionNumber();
            CategoryPO categoryPO = this.categoryMapper.selectCategoryByCategoryId(spiderBO.getCategoryId(), spiderBO.getMall());
            this.goodsTempProcessor.process(categoryPO, exectNumber);
        }
        catch (Exception e) {
            log.error("\u722c\u53d6\u6570\u636e\u5f02\u5e38", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    @SpiderLog(spiderType="2")
    public Rsp spiderGoodsBykeyword(SpiderBO spiderBO) {
        try {
            String exectNumber = spiderBO.getExecutionNumber();
            CategoryPO categoryPO = new CategoryPO();
            categoryPO.setKeyword(spiderBO.getKeyword());
            categoryPO.setSign(spiderBO.getMall());
            this.goodsTempProcessor.process(categoryPO, exectNumber);
        }
        catch (Exception e) {
            log.error("\u722c\u53d6\u6570\u636e\u5f02\u5e38", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    @SpiderLog(spiderType="3")
    public Rsp spiderGoodsDetails(GoodsBO goodsBO) {
        try {
            Goods goods = new Goods();
            goodsBO.setSkuId(goodsBO.getGoodsNo());
            BeanUtils.copyProperties((Object)goodsBO, (Object)goods);
            this.goodsDetailsTempProcessor.process(goods);
        }
        catch (Exception e) {
            log.error("\u722c\u53d6\u6570\u636e\u5f02\u5e38", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }
}

