/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.service.impl;

import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.spider.api.CommodityInformationService;
import com.tydic.nicc.spider.api.bo.GoodsBO;
import com.tydic.nicc.spider.api.bo.SpiderBO;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.CategoryPipeline;
import com.tydic.nicc.spider.compoent.pipeline.GoodsDetailPipeline;
import com.tydic.nicc.spider.compoent.processor.category.XfsCategoryProcessor;
import com.tydic.nicc.spider.compoent.processor.description.XfsDescriptionProcessor;
import com.tydic.nicc.spider.compoent.processor.goods.XfsProcessor;
import com.tydic.nicc.spider.mapper.GoodsMapper;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.service.impl.CacheInfoServiceImpl;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.processor.PageProcessor;

@Service(value="xfs")
public class XfsSpiderServiceImpl
implements CommodityInformationService {
    private static final Logger log = LoggerFactory.getLogger(XfsSpiderServiceImpl.class);
    private final XfsCategoryProcessor xfsCategoryProcessor;
    private final CategoryPipeline categoryPipeline;
    private final GoodsDetailPipeline goodsDetailPipeline;
    private final CacheInfoServiceImpl cacheInfoServiceImpl;
    @Resource
    private XfsProcessor xfsProcessor;
    @Resource
    private GoodsMapper goodsMapper;
    @Autowired
    private XfsDescriptionProcessor xfsDescriptionProcessor;

    public void addCategory() {
        String url = "https://www.xfs.com";
        Spider.create((PageProcessor)this.xfsCategoryProcessor).addUrl(new String[]{url}).addPipeline((Pipeline)this.categoryPipeline).run();
        log.info("\u946b\u65b9\u76db\u5546\u57ce\u722c\u53d6\u5206\u7c7b\u4fe1\u606f\u5b8c\u6210");
    }

    public String handleUrl(String param) {
        return "https://www.xfs.com/category/" + param + "_3.html";
    }

    public Rsp climbCommodityTabulate(SpiderBO parameter) {
        long startTime = System.currentTimeMillis();
        String categoryId = parameter.getCategoryId();
        String executionNumber = parameter.getExecutionNumber();
        try {
            String url = this.handleUrl(categoryId);
            CategoryPO categoryPO = new CategoryPO();
            categoryPO.setUrl(url);
            this.xfsProcessor.process(categoryPO, executionNumber);
        }
        catch (Exception e) {
            log.error("\u946b\u65b9\u76db\u5546\u57ce\u5206\u7c7b{}\u5217\u8868\u722c\u53d6\u5931\u8d25", (Object)categoryId, (Object)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        long endTime = System.currentTimeMillis();
        log.info("\u946b\u65b9\u76db\u5546\u57ce\u722c\u53d6\u5217\u8868\u9700\u8981:{}ms", (Object)(endTime - startTime));
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    public Rsp climbProductDetailsWithCategoryId(SpiderBO spiderBO) {
        String categoryId = spiderBO.getCategoryId();
        String executionNumber = spiderBO.getExecutionNumber();
        try {
            List goodsList = this.goodsMapper.selectListByCategoryId(MallType.Xfs.getCode(), categoryId, executionNumber);
            if (CollectionUtils.isNotEmpty((Collection)goodsList)) {
                this.processDetailsRequestList(goodsList);
            } else {
                log.error("{}\u5206\u7c7b\u4e0b\u6ca1\u6709\u5546\u54c1\u6216\u5df2\u7ecf\u66f4\u65b0\u5b8c\u6bd5", (Object)categoryId);
            }
        }
        catch (Exception e) {
            log.error("xfs\u5206\u7c7b{}\u722c\u53d6\u8be6\u60c5\u5931\u8d25", (Object)categoryId, (Object)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    private void processDetailsRequestList(List<Goods> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            int num;
            int lastIndex = num = 100;
            int i = 0;
            while (i < list.size()) {
                if (lastIndex >= list.size()) {
                    this.spiderDesc(list.subList(i, list.size()));
                    break;
                }
                this.spiderDesc(list.subList(i, lastIndex));
                i = lastIndex;
                lastIndex = i + num;
            }
        }
    }

    private void spiderDesc(List<Goods> list) {
        long startTime = System.currentTimeMillis();
        HashMap hashMap = new HashMap();
        Request request = new Request();
        list.forEach(goods -> {
            try {
                this.spiderDetail(hashMap, request, (Goods)goods, null);
            }
            catch (Exception e) {
                log.error("\u946b\u65b9\u76db\u5546\u57ce\u66f4\u65b0\u8be6\u60c5\u5546\u54c1\u7f16\u7801{}\u5931\u8d25", (Object)goods.getGoodsNo(), (Object)e);
            }
        });
        long endTime = System.currentTimeMillis();
        log.info("\u946b\u65b9\u76db\u5546\u57ce\u8be6\u60c5\u722c\u53d6:{}\u5206\u7c7b\u9700\u8981:{}ms", (Object)list.get(0).getCategoryId(), (Object)(endTime - startTime));
    }

    private void spiderDetail(HashMap<String, Object> hashMap, Request request, Goods goods, String keyword) {
        hashMap.put("goods", goods);
        request.setUrl(goods.getUrl());
        request.setExtras(hashMap);
        request.putExtra("keyword", (Object)keyword);
        Spider.create((PageProcessor)this.xfsDescriptionProcessor).addRequest(new Request[]{request}).addPipeline((Pipeline)this.goodsDetailPipeline).run();
    }

    public Rsp climbProductDetailsByGoodsNo(GoodsBO goodsBO) {
        Request request = new Request();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            Goods goods = new Goods();
            BeanUtils.copyProperties((Object)goodsBO, (Object)goods);
            this.spiderDetail(hashMap, request, goods, null);
        }
        catch (Exception e) {
            log.error("xfs\u5546\u57ce\u66f4\u65b0\u5355\u4e2a\u5546\u54c1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    public Rsp climbProductDetailsByKeyword(SpiderBO spiderBO) {
        String keyword = spiderBO.getKeyword().replace("\n", "");
        String executionNumber = spiderBO.getExecutionNumber();
        String url = "https://www.xfs.com/searchPro/" + keyword + ".html?jsthty=1&stype=3";
        try {
            URLEncoder.encode(url, "utf-8");
            CategoryPO categoryPO = new CategoryPO();
            categoryPO.setUrl(url);
            categoryPO.setKeyword(keyword);
            this.xfsProcessor.process(categoryPO, executionNumber);
        }
        catch (Exception e) {
            log.error("\u946b\u65b9\u76db\u5546\u57ce\u5173\u952e\u8bcd\u641c\u7d22\u5f02\u5e38", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    public XfsSpiderServiceImpl(XfsCategoryProcessor xfsCategoryProcessor, CategoryPipeline categoryPipeline, GoodsDetailPipeline goodsDetailPipeline, CacheInfoServiceImpl cacheInfoServiceImpl, XfsProcessor xfsProcessor, GoodsMapper goodsMapper, XfsDescriptionProcessor xfsDescriptionProcessor) {
        this.xfsCategoryProcessor = xfsCategoryProcessor;
        this.categoryPipeline = categoryPipeline;
        this.goodsDetailPipeline = goodsDetailPipeline;
        this.cacheInfoServiceImpl = cacheInfoServiceImpl;
        this.xfsProcessor = xfsProcessor;
        this.goodsMapper = goodsMapper;
        this.xfsDescriptionProcessor = xfsDescriptionProcessor;
    }
}

