/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.service.impl;

import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.spider.api.CommodityInformationService;
import com.tydic.nicc.spider.api.bo.GoodsBO;
import com.tydic.nicc.spider.api.bo.SpiderBO;
import com.tydic.nicc.spider.compoent.eum.MallState;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.eum.RedisCacheKey;
import com.tydic.nicc.spider.compoent.pipeline.CategoryPipeline;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.compoent.processor.category.DlCategoryProcessorWithJsoup;
import com.tydic.nicc.spider.compoent.processor.description.XhgjDescriptionProcessor;
import com.tydic.nicc.spider.compoent.processor.goods.DlProcessorWithSelfDriver;
import com.tydic.nicc.spider.compoent.processor.goods.XhgjProcessor;
import com.tydic.nicc.spider.mapper.CategoryMapper;
import com.tydic.nicc.spider.mapper.GoodsMapper;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import com.tydic.nicc.spider.service.impl.CacheInfoServiceImpl;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.processor.PageProcessor;

@Service(value="xhgj")
public class XhgjSpiderServiceImpl
implements CommodityInformationService {
    private static final Logger log = LoggerFactory.getLogger(XhgjSpiderServiceImpl.class);
    @Resource
    private DlCategoryProcessorWithJsoup dlCategoryProcessorWithJsoup;
    @Resource
    private CategoryPipeline categoryPipeline;
    @Autowired
    private ProcessDataPipeline processDataPipeline;
    @Resource
    private CategoryMapper categoryMapper;
    @Resource
    private GoodsMapper goodsMapper;
    @Autowired
    private CacheInfoServiceImpl cacheInfoServiceImpl;
    @Autowired
    private XhgjProcessor xhgjProcessor;
    @Autowired
    private XhgjDescriptionProcessor xhgjDescriptionProcessor;

    public void addCategory() {
        String url = "https://b2b.nbdeli.com/";
        Spider.create((PageProcessor)this.dlCategoryProcessorWithJsoup).addUrl(new String[]{url}).addPipeline((Pipeline)this.categoryPipeline).run();
        log.info("\u5f97\u529b\u5546\u57ce\u5206\u7c7b\u4fe1\u606f\u722c\u53d6\u5b8c\u6210");
    }

    public Rsp climbCommodityTabulate(SpiderBO parameter) {
        long startTime = System.currentTimeMillis();
        String categoryId = parameter.getCategoryId();
        String executionNumber = parameter.getExecutionNumber();
        try {
            if (BooleanUtils.isTrue((Boolean)MallState.DL.isState())) {
                return BaseRspUtils.createErrorRsp((String)"7777", (String)"\u5df2\u6682\u505c\u6267\u884c");
            }
            CategoryPO categoryPO = this.categoryMapper.selectCategoryByCategoryId(categoryId, parameter.getMall());
            if (!Objects.isNull(categoryPO)) {
                DlProcessorWithSelfDriver.process(categoryPO, this.processDataPipeline, executionNumber);
            }
        }
        catch (Exception e) {
            log.error("\u5f97\u529b{}\u722c\u53d6\u5931\u8d25", (Object)categoryId, (Object)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        log.info("\u5f97\u529b\u5546\u57ce\u5206\u7c7b{}\u5546\u54c1\u6570\u636e\u5b8c\u6210", (Object)categoryId);
        long endTime = System.currentTimeMillis();
        log.info("\u5f97\u529b\u5546\u57ce\u722c\u53d6\u5217\u8868\u9700\u8981:{}\u5206\u949f", (Object)TimeUnit.MILLISECONDS.toMinutes(endTime - startTime));
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    public Rsp climbProductDetailsWithCategoryId(SpiderBO spiderBo) {
        int size = 5000;
        String categoryId = spiderBo.getCategoryId();
        String executionNumber = spiderBo.getExecutionNumber();
        try {
            for (int pageNo = 1; pageNo < Integer.MAX_VALUE; ++pageNo) {
                List goodsList = this.goodsMapper.selectListByCategoryIdWithLimit(MallType.Xhgj.getCode(), categoryId, (pageNo - 1) * size, size, executionNumber);
                if (CollectionUtils.isNotEmpty((Collection)goodsList)) {
                    log.info("\u5f97\u529b\u5546\u57ce \u5206\u9875\u67e5\u8be2\u5206\u7c7b{}\u5546\u54c1\u6570\u636e{}\u6761", (Object)categoryId, (Object)goodsList.size());
                    this.processDetailsWithSelfDriver(goodsList, spiderBo);
                }
                if (!CollectionUtils.isEmpty((Collection)goodsList) && goodsList.size() >= size) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            log.error("\u5f97\u529b{}\u722c\u53d6\u8be6\u60c5\u5931\u8d25", (Object)categoryId, (Object)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    private void processDetailsWithSelfDriver(List<Goods> goodsList, SpiderBO spiderBO) {
        if (CollectionUtils.isNotEmpty(goodsList)) {
            int num;
            int lastIndex = num = 100;
            int i = 0;
            while (i < goodsList.size()) {
                if (lastIndex >= goodsList.size()) {
                    this.spiderDesc(goodsList.subList(i, goodsList.size()), spiderBO);
                    break;
                }
                this.spiderDesc(goodsList.subList(i, lastIndex), spiderBO);
                i = lastIndex;
                lastIndex = i + num;
            }
        }
        log.info("DlSpiderServiceImpl driver exit");
    }

    private void spiderDesc(List<Goods> goodsList, SpiderBO spiderBO) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Goods> goodList = new ArrayList<Goods>();
        ArrayList<GoodsDetailsWithBLOBs> goodsDetailsList = new ArrayList<GoodsDetailsWithBLOBs>();
        String keyword = spiderBO.getKeyword();
        for (Goods goods : goodsList) {
            try {
                Map<String, Object> dataMap = this.xhgjDescriptionProcessor.process(goods);
                if (Objects.isNull(dataMap)) continue;
                Goods goods1 = (Goods)dataMap.get("goods");
                GoodsDetailsWithBLOBs goodsDetailsWithBLOBs = (GoodsDetailsWithBLOBs)dataMap.get("goodsDetails");
                goodList.add(goods1);
                goodsDetailsList.add(goodsDetailsWithBLOBs);
            }
            catch (Exception e) {
                log.error("xhgj\u8be6\u60c5\u5931\u8d25", (Throwable)e);
            }
        }
        map.put("goodsList", goodList);
        map.put("goodsDetailsList", goodsDetailsList);
        map.put("keyword", keyword);
        this.processDataPipeline.processDataMap(map);
    }

    public void climbProductInfoByCache() {
        RedisCacheKey redisCacheKey = RedisCacheKey.fromMall(MallType.DL.getCode());
        List<Goods> goodsList;
        while (!CollectionUtils.isEmpty(goodsList = this.cacheInfoServiceImpl.getGoodsCache(redisCacheKey, 50L))) {
            this.processDetailsWithSelfDriver(goodsList, null);
        }
        return;
    }

    public Rsp climbProductDetailsByGoodsNo(GoodsBO goodsBO) {
        Goods goods = new Goods();
        BeanUtils.copyProperties((Object)goodsBO, (Object)goods);
        ArrayList<Goods> goodList = new ArrayList<Goods>();
        ArrayList<GoodsDetailsWithBLOBs> goodsDetailsList = new ArrayList<GoodsDetailsWithBLOBs>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Map<String, Object> dataMap = this.xhgjDescriptionProcessor.process(goods);
            if (!Objects.isNull(dataMap)) {
                Goods goods1 = (Goods)dataMap.get("goods");
                GoodsDetailsWithBLOBs goodsDetailsWithBLOBs = (GoodsDetailsWithBLOBs)dataMap.get("goodsDetails");
                goodList.add(goods1);
                goodsDetailsList.add(goodsDetailsWithBLOBs);
            }
            map.put("goodsList", goodList);
            map.put("goodsDetailsList", goodsDetailsList);
            map.put("keyword", null);
            this.processDataPipeline.processDataMap(map);
        }
        catch (Exception e) {
            log.error("xhgj\u722c\u53d6\u5355\u4e2a\u5546\u54c1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    public Rsp climbProductDetailsByKeyword(SpiderBO spiderBO) {
        String executionNumber = spiderBO.getExecutionNumber();
        String keyword = spiderBO.getKeyword().replace("\n", "");
        try {
            String encodedText = URLEncoder.encode(keyword, StandardCharsets.UTF_8.toString());
            String url = "https://www.xhgjmall.com/SearchProduct?keywords=" + encodedText + "&brandid=&field=&sortName=&sortType=&maxPrice=&minPrice=&curpage=1&pagesize=20";
            CategoryPO categoryPO = new CategoryPO();
            categoryPO.setKeyword(keyword);
            categoryPO.setUrl(url);
            XhgjProcessor.process(categoryPO, this.processDataPipeline, executionNumber);
        }
        catch (Exception e) {
            log.error("\u5f97\u529b\u722c\u53d6\u5173\u952e\u8bcd{}\u5f02\u5e38", (Object)keyword, (Object)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }
}

