/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.service.impl;

import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.spider.api.CommodityInformationService;
import com.tydic.nicc.spider.api.bo.GoodsBO;
import com.tydic.nicc.spider.api.bo.SpiderBO;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.CategoryPipeline;
import com.tydic.nicc.spider.compoent.pipeline.GoodsDetailPipeline;
import com.tydic.nicc.spider.compoent.processor.category.XyOneLevelCategoryProcessor;
import com.tydic.nicc.spider.compoent.processor.category.XySecondaryCategoryProcessor;
import com.tydic.nicc.spider.compoent.processor.description.XyDescriptionProcessor;
import com.tydic.nicc.spider.compoent.processor.goods.XyProcessor;
import com.tydic.nicc.spider.mapper.CategoryMapper;
import com.tydic.nicc.spider.mapper.GoodsMapper;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.processor.PageProcessor;

@Service(value="ehsy")
public class XiYuSpiderServiceImpl
implements CommodityInformationService {
    private static final Logger log = LoggerFactory.getLogger(XiYuSpiderServiceImpl.class);
    @Resource
    private GoodsMapper goodsMapper;
    @Resource
    private XyOneLevelCategoryProcessor oneLevelCategoryProcessor;
    @Resource
    private XySecondaryCategoryProcessor secondaryCategoryProcessor;
    @Resource
    private XyProcessor xyProcessor;
    @Autowired
    private CategoryPipeline categoryPipeline;
    @Resource
    private GoodsDetailPipeline goodsDetailPipeline;
    @Resource
    public CategoryMapper categoryMapper;
    @Autowired
    private XyDescriptionProcessor xyDescriptionProcessor;

    public void addCategory() {
        String url = "https://www.ehsy.com/";
        Spider.create((PageProcessor)this.oneLevelCategoryProcessor).addUrl(new String[]{url}).addPipeline((Pipeline)this.categoryPipeline).run();
        List categoryPOList = this.categoryMapper.selectCategoryList(Integer.valueOf(1), "XY");
        Request request = new Request();
        request.putExtra("categoryPOList", (Object)categoryPOList);
        request.setUrl(((CategoryPO)categoryPOList.get(0)).getUrl());
        Spider.create((PageProcessor)this.secondaryCategoryProcessor).addRequest(new Request[]{request}).addPipeline((Pipeline)this.categoryPipeline).run();
    }

    public Rsp climbCommodityTabulate(SpiderBO parameter) {
        long startTime = System.currentTimeMillis();
        String categoryId = parameter.getCategoryId();
        String executionNumber = parameter.getExecutionNumber();
        try {
            StringBuilder url = new StringBuilder();
            url.append("https://www.ehsy.com/category-").append(categoryId);
            Request request = new Request(url.toString());
            request.putExtra("executionNumber", (Object)executionNumber);
            Spider.create((PageProcessor)this.xyProcessor).addRequest(new Request[]{request}).run();
        }
        catch (Exception e) {
            log.error("\u897f\u57df\u5546\u57ce\u5206\u7c7b{}\u5217\u8868\u722c\u53d6\u5931\u8d25", (Object)categoryId, (Object)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        long endTime = System.currentTimeMillis();
        log.info("\u897f\u57df\u5546\u57ce\u6267\u884c\u6b64\u6b21\u4efb\u52a1\u9700\u8981:{}ms", (Object)(endTime - startTime));
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    public Rsp climbProductDetailsWithCategoryId(SpiderBO spiderBO) {
        block5: {
            String categoryId = spiderBO.getCategoryId();
            String executionNumber = spiderBO.getExecutionNumber();
            try {
                List goodsList = this.goodsMapper.selectListByCategoryId(MallType.XiYu.getCode(), categoryId, executionNumber);
                if (CollectionUtils.isNotEmpty((Collection)goodsList)) {
                    int num;
                    int lastIndex = num = 100;
                    int i = 0;
                    while (i < goodsList.size()) {
                        if (lastIndex >= goodsList.size()) {
                            this.spiderDesc(goodsList.subList(i, goodsList.size()));
                            break block5;
                        }
                        this.spiderDesc(goodsList.subList(i, lastIndex));
                        i = lastIndex;
                        lastIndex = i + num;
                    }
                    break block5;
                }
                log.error("{}\u5206\u7c7b\u4e0b\u6ca1\u6709\u5546\u54c1\u6216\u5df2\u7ecf\u66f4\u65b0\u5b8c\u6bd5", (Object)categoryId);
            }
            catch (Exception e) {
                log.error("ehsy\u5206\u7c7b{}\u722c\u53d6\u8be6\u60c5\u5931\u8d25", (Object)categoryId, (Object)e);
                return BaseRspUtils.createErrorRsp((String)e.getMessage());
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    private void spiderDesc(List<Goods> goodsList) {
        long startTime = System.currentTimeMillis();
        Request request = new Request();
        HashMap hashMap = new HashMap();
        if (CollectionUtils.isNotEmpty(goodsList)) {
            goodsList.forEach(goods -> {
                try {
                    this.spiderDetail(hashMap, request, (Goods)goods, null);
                }
                catch (Exception e) {
                    log.error("\u897f\u57df\u5546\u57ce\u66f4\u65b0\u8be6\u60c5\u5546\u54c1\u7f16\u7801{}\u5931\u8d25", (Object)goods.getGoodsNo(), (Object)e);
                }
            });
            long endTime = System.currentTimeMillis();
            log.info("\u897f\u57df\u5546\u57ce\u66f4\u65b0\u8be6\u60c5\u9700\u8981:{}ms", (Object)(endTime - startTime));
        }
    }

    private void spiderDetail(HashMap<String, Object> hashMap, Request request, Goods goods, String keyword) {
        hashMap.put("goods", goods);
        request.setUrl(goods.getUrl());
        request.setExtras(hashMap);
        request.putExtra("keyword", (Object)keyword);
        Spider.create((PageProcessor)this.xyDescriptionProcessor).addRequest(new Request[]{request}).addPipeline((Pipeline)this.goodsDetailPipeline).run();
    }

    public Rsp climbProductDetailsByGoodsNo(GoodsBO goodsBO) {
        Request request = new Request();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            Goods goods = new Goods();
            BeanUtils.copyProperties((Object)goodsBO, (Object)goods);
            this.spiderDetail(hashMap, request, goods, null);
        }
        catch (Exception e) {
            log.error("\u897f\u57df\u5546\u57ce\u66f4\u65b0\u5355\u4e2a\u5546\u54c1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    public Rsp climbProductDetailsByKeyword(SpiderBO spiderBO) {
        String keyword = spiderBO.getKeyword().replace("\n", "");
        String executionNumber = spiderBO.getExecutionNumber();
        try {
            String url = "https://www.ehsy.com/search?k=" + keyword;
            URLEncoder.encode(url, "utf-8");
            Request request = new Request();
            request.putExtra("keyword", (Object)keyword);
            request.putExtra("executionNumber", (Object)executionNumber);
            request.setUrl(url);
            Spider.create((PageProcessor)this.xyProcessor).addRequest(new Request[]{request}).run();
        }
        catch (Exception e) {
            log.error("\u897f\u57df\u5546\u57ce\u5173\u952e\u8bcd\u641c\u7d22\u5f02\u5e38", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }
}

