/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.service.impl;

import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.spider.api.CommodityInformationService;
import com.tydic.nicc.spider.api.bo.GoodsBO;
import com.tydic.nicc.spider.api.bo.SpiderBO;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.CategoryPipeline;
import com.tydic.nicc.spider.compoent.pipeline.ProcessDataPipeline;
import com.tydic.nicc.spider.compoent.processor.category.YzhCategoryProcessor;
import com.tydic.nicc.spider.compoent.processor.description.YzhDescriptionProcessor;
import com.tydic.nicc.spider.compoent.processor.goods.GomeProcessor;
import com.tydic.nicc.spider.compoent.processor.goods.YzhProcessor;
import com.tydic.nicc.spider.config.factory.DriverFactory;
import com.tydic.nicc.spider.mapper.GoodsMapper;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import com.tydic.nicc.spider.mapper.po.GoodsDetailsWithBLOBs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.processor.PageProcessor;

@Component(value="haoxiny")
public class YzhSpiderServiceImpl
implements CommodityInformationService {
    private static final Logger log = LoggerFactory.getLogger(YzhSpiderServiceImpl.class);
    @Autowired
    private ProcessDataPipeline processDataPipeline;
    @Resource
    private GoodsMapper goodsMapper;
    @Autowired
    private YzhDescriptionProcessor yzhDescriptionProcessor;
    @Autowired
    private YzhCategoryProcessor yzhCategoryProcessor;
    @Autowired
    private CategoryPipeline categoryPipeline;
    @Autowired
    private YzhProcessor yzhProcessor;
    private static final ExecutorService executorService = Executors.newFixedThreadPool(2);

    public void addCategory() {
        String url = "https://www.haoxiny.com/";
        Spider.create((PageProcessor)this.yzhCategoryProcessor).addUrl(new String[]{url}).addPipeline((Pipeline)this.categoryPipeline).run();
    }

    public Rsp climbCommodityTabulate(SpiderBO parameter) {
        long startTime0 = System.currentTimeMillis();
        String categoryId = parameter.getCategoryId();
        try {
            String url = "https://www.haoxiny.com/";
            CategoryPO categoryPO = new CategoryPO();
            categoryPO.setUrl(url.toString());
            GomeProcessor.processor(categoryPO, this.processDataPipeline, parameter.getExecutionNumber());
        }
        catch (Exception e) {
            log.error("\u4e91\u4e2d\u9e64\u5546\u57ce\u5206\u7c7b{}\u5217\u8868\u722c\u53d6\u5931\u8d25", (Object)categoryId, (Object)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        long endTime0 = System.currentTimeMillis();
        log.info("\u4e91\u4e2d\u9e64\u5546\u57ce\u6267\u884c\u6b64\u6b21\u4efb\u52a1\u9700\u8981:{}ms", (Object)(endTime0 - startTime0));
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    public Rsp climbProductDetailsWithCategoryId(SpiderBO spiderBO) {
        String categoryId = spiderBO.getCategoryId();
        String executionNumber = spiderBO.getExecutionNumber();
        try {
            List goodsList = this.goodsMapper.selectListByCategoryId(MallType.Yzh.getCode(), categoryId, executionNumber);
            if (CollectionUtils.isNotEmpty((Collection)goodsList)) {
                this.spiderDescPro(goodsList, spiderBO.getKeyword());
            } else {
                log.error("{}\u5206\u7c7b\u4e0b\u6ca1\u6709\u5546\u54c1\u6216\u5df2\u7ecf\u66f4\u65b0\u5b8c\u6bd5", (Object)categoryId);
            }
        }
        catch (Exception e) {
            log.error("yzh{}\u722c\u53d6\u8be6\u60c5\u5931\u8d25", (Object)categoryId, (Object)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    private void spiderDescPro(List<Goods> goodsList, String keyword) {
        int num;
        int lastIndex = num = 100;
        int i = 0;
        while (i < goodsList.size()) {
            if (lastIndex >= goodsList.size()) {
                this.spiderDesc(goodsList.subList(i, goodsList.size()), keyword);
                break;
            }
            this.spiderDesc(goodsList.subList(i, lastIndex), keyword);
            i = lastIndex;
            lastIndex = i + num;
        }
    }

    private void spiderDesc(List<Goods> goodsList, String keyword) {
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("goodsList", goodsList);
        RemoteWebDriver driver = DriverFactory.createDiffDriver(PageLoadStrategy.EAGER);
        if (CollectionUtils.isNotEmpty(goodsList)) {
            for (Goods goods : goodsList) {
                try {
                    this.spiderDetail(hashMap, goods, keyword, driver);
                }
                catch (Exception e) {
                    driver = DriverFactory.createDiffDriver(PageLoadStrategy.EAGER);
                    log.error("\u4e91\u4e2d\u9e64\u5546\u57ce\u66f4\u65b0\u8be6\u60c5\u5546\u54c1\u7f16\u7801{}\u5931\u8d25", (Object)goods.getGoodsNo(), (Object)e);
                }
            }
            driver.quit();
            long endTime = System.currentTimeMillis();
            log.info("\u4e91\u4e2d\u9e64\u5546\u57ce\u66f4\u65b0\u8be6\u60c5\u9700\u8981:{}ms", (Object)(endTime - startTime));
        }
    }

    private void spiderDetail(HashMap<String, Object> map, Goods goods, String keyword, RemoteWebDriver driver) {
        ArrayList<Goods> goodList = new ArrayList<Goods>();
        ArrayList<GoodsDetailsWithBLOBs> goodsDetailsList = new ArrayList<GoodsDetailsWithBLOBs>();
        try {
            Map<String, Object> dataMap = this.yzhDescriptionProcessor.process(goods, driver);
            if (!Objects.isNull(dataMap)) {
                Goods goods1 = (Goods)dataMap.get("goods");
                GoodsDetailsWithBLOBs goodsDetailsWithBLOBs = (GoodsDetailsWithBLOBs)dataMap.get("goodsDetails");
                goodList.add(goods1);
                goodsDetailsList.add(goodsDetailsWithBLOBs);
            }
            map.put("goodsList", goodList);
            map.put("goodsDetailsList", goodsDetailsList);
            map.put("keyword", keyword);
            this.processDataPipeline.processDataMap(map);
        }
        catch (Exception e) {
            log.error("\u4e91\u4e2d\u9e64\u722c\u53d6\u5546\u54c1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw new DcBusinessException(e.getMessage());
        }
    }

    public Rsp climbProductDetailsByKeyword(SpiderBO spiderBO) {
        String keyword = spiderBO.getKeyword().replace("\n", "");
        String executionNumber = spiderBO.getExecutionNumber();
        CategoryPO categoryPO = new CategoryPO();
        try {
            String url = "https://www.haoxiny.com/";
            categoryPO.setUrl(url);
            categoryPO.setKeyword(keyword);
            YzhProcessor.processor(categoryPO, this.processDataPipeline, executionNumber);
        }
        catch (Exception e) {
            log.error("yzh\u722c\u53d6\u641c\u7d22\u8bcd{}\u5f02\u5e38", (Object)keyword, (Object)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rsp climbProductDetailsByGoodsNo(GoodsBO goodsBO) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        RemoteWebDriver driver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null).getDriver();
        try {
            Goods goods = new Goods();
            BeanUtils.copyProperties((Object)goodsBO, (Object)goods);
            this.spiderDetail(hashMap, goods, null, driver);
        }
        catch (Exception e) {
            log.error("\u4e91\u4e2d\u9e64\u722c\u53d6\u5355\u4e2a\u5546\u54c1\u5f02\u5e38", (Throwable)e);
            Rsp rsp = BaseRspUtils.createErrorRsp((String)e.getMessage());
            return rsp;
        }
        finally {
            if (driver != null) {
                try {
                    driver.quit();
                }
                catch (Exception e) {
                    log.error("\u5173\u95ed\u6d4f\u89c8\u5668\u5931\u8d25");
                }
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }
}

