/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.spider.service.impl;

import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.spider.api.CommodityInformationService;
import com.tydic.nicc.spider.api.bo.GoodsBO;
import com.tydic.nicc.spider.api.bo.SpiderBO;
import com.tydic.nicc.spider.compoent.eum.MallType;
import com.tydic.nicc.spider.compoent.pipeline.CategoryPipeline;
import com.tydic.nicc.spider.compoent.pipeline.GoodsDetailPipeline;
import com.tydic.nicc.spider.compoent.processor.category.ZkhCategoryProcessor;
import com.tydic.nicc.spider.compoent.processor.description.ZkhDescriptionProcessor;
import com.tydic.nicc.spider.compoent.processor.goods.ZkhProcessor;
import com.tydic.nicc.spider.config.factory.DriverFactory;
import com.tydic.nicc.spider.mapper.GoodsMapper;
import com.tydic.nicc.spider.mapper.po.CategoryPO;
import com.tydic.nicc.spider.mapper.po.Goods;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.processor.PageProcessor;

@Service(value="zkh")
public class ZkhSpiderServiceImpl
implements CommodityInformationService {
    private static final Logger log = LoggerFactory.getLogger(ZkhSpiderServiceImpl.class);
    @Resource
    private GoodsMapper goodsMapper;
    @Resource
    private ZkhCategoryProcessor processor;
    @Resource
    private ZkhProcessor zkhProcessor;
    @Resource
    private ZkhDescriptionProcessor zkhDescriptionProcessor;
    @Resource
    private CategoryPipeline pipeline;
    @Resource
    private GoodsDetailPipeline goodsDetailPipeline;

    public void addCategory() {
        Request request = new Request();
        request.setUrl("https://www.zkh.com/");
        Spider.create((PageProcessor)this.processor).addRequest(new Request[]{request}).addPipeline((Pipeline)this.pipeline).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rsp climbCommodityTabulate(SpiderBO parameter) {
        long startTime0 = System.currentTimeMillis();
        String categoryId = parameter.getCategoryId();
        String executionNumber = parameter.getExecutionNumber();
        RemoteWebDriver driver = null;
        try {
            driver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null).getDriver();
            StringBuilder url = new StringBuilder();
            url.append("https://www.zkh.com/list/c-").append(categoryId).append(".html");
            CategoryPO categoryPO = new CategoryPO();
            categoryPO.setUrl(url.toString());
            categoryPO.setCategoryId(categoryId);
            this.zkhProcessor.process(categoryPO, executionNumber, driver);
        }
        catch (Exception e) {
            log.error("\u9707\u5764\u884c\u5546\u57ce\u5206\u7c7b{}\u5217\u8868\u722c\u53d6\u5931\u8d25", (Object)categoryId, (Object)e);
            Rsp rsp = BaseRspUtils.createErrorRsp((String)e.getMessage());
            return rsp;
        }
        finally {
            try {
                driver.quit();
            }
            catch (Exception e) {
                log.error("\u5173\u95ed\u6d4f\u89c8\u5668\u5931\u8d25", (Throwable)e);
            }
        }
        long endTime0 = System.currentTimeMillis();
        log.info("\u9707\u5764\u884c\u5546\u57ce\u6267\u884c\u6b64\u6b21\u4efb\u52a1\u9700\u8981:{}ms", (Object)(endTime0 - startTime0));
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    public Rsp climbProductDetailsWithCategoryId(SpiderBO spiderBO) {
        block5: {
            String categoryId = spiderBO.getCategoryId();
            String executionNumber = spiderBO.getExecutionNumber();
            try {
                List goodsList = this.goodsMapper.selectListByCategoryId(MallType.ZKH.getCode(), categoryId, executionNumber);
                if (CollectionUtils.isNotEmpty((Collection)goodsList)) {
                    int num;
                    int lastIndex = num = 100;
                    int i = 0;
                    while (i < goodsList.size()) {
                        if (lastIndex >= goodsList.size()) {
                            this.spiderDesc(goodsList.subList(i, goodsList.size()));
                            break block5;
                        }
                        this.spiderDesc(goodsList.subList(i, lastIndex));
                        i = lastIndex;
                        lastIndex = i + num;
                    }
                    break block5;
                }
                log.error("{}\u5206\u7c7b\u4e0b\u6ca1\u6709\u5546\u54c1\u6216\u5df2\u7ecf\u66f4\u65b0\u5b8c\u6bd5", (Object)categoryId);
            }
            catch (Exception e) {
                log.error("zkh\u5206\u7c7b{}\u722c\u53d6\u8be6\u60c5\u5931\u8d25", (Object)categoryId, (Object)e);
                return BaseRspUtils.createErrorRsp((String)e.getMessage());
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    private void spiderDesc(List<Goods> goodsList) {
        long startTime = System.currentTimeMillis();
        HashMap hashMap = new HashMap();
        Request request = new Request();
        if (CollectionUtils.isNotEmpty(goodsList)) {
            goodsList.forEach(goods -> {
                try {
                    this.spiderDetail(hashMap, request, (Goods)goods, null);
                }
                catch (Exception e) {
                    log.error("\u897f\u57df\u5546\u57ce\u66f4\u65b0\u8be6\u60c5\u5546\u54c1\u7f16\u7801{}\u5931\u8d25", (Object)goods.getGoodsNo(), (Object)e);
                }
            });
            long endTime = System.currentTimeMillis();
            log.info("\u897f\u57df\u5546\u57ce\u66f4\u65b0\u8be6\u60c5\u9700\u8981:{}ms", (Object)(endTime - startTime));
        }
    }

    private void spiderDetail(HashMap<String, Object> hashMap, Request request, Goods goods, String keyword) {
        hashMap.put("goods", goods);
        request.setUrl(goods.getUrl());
        request.setExtras(hashMap);
        request.putExtra("keyword", (Object)keyword);
        Spider.create((PageProcessor)this.zkhDescriptionProcessor).addRequest(new Request[]{request}).addPipeline((Pipeline)this.goodsDetailPipeline).run();
    }

    public Rsp climbProductDetailsByGoodsNo(GoodsBO goodsBO) {
        Request request = new Request();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            Goods goods = new Goods();
            BeanUtils.copyProperties((Object)goodsBO, (Object)goods);
            this.spiderDetail(hashMap, request, goods, null);
        }
        catch (Exception e) {
            log.error("zkh\u5546\u57ce\u66f4\u65b0\u5355\u4e2a\u5546\u54c1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rsp climbProductDetailsByKeyword(SpiderBO spiderBO) {
        String keyword = spiderBO.getKeyword().replace("\n", "");
        String executionNumber = spiderBO.getExecutionNumber();
        RemoteWebDriver driver = null;
        try {
            driver = DriverFactory.createDiffDriverWithRandom(PageLoadStrategy.EAGER, null).getDriver();
            String encoder = URLEncoder.encode(keyword, "UTF-8");
            String url = "https://www.zkh.com/search.html?hasLinkWord=1&keywords=" + encoder + "";
            CategoryPO categoryPO = new CategoryPO();
            categoryPO.setUrl(url);
            categoryPO.setKeyword(keyword);
            this.zkhProcessor.process(categoryPO, executionNumber, driver);
            driver.quit();
        }
        catch (Exception e) {
            log.error("zkh\u5546\u57ce\u5173\u952e\u8bcd\u641c\u7d22\u5f02\u5e38", (Throwable)e);
            Rsp rsp = BaseRspUtils.createErrorRsp((String)e.getMessage());
            return rsp;
        }
        finally {
            try {
                driver.quit();
            }
            catch (Exception e) {
                log.error("\u5173\u95ed\u6d4f\u89c8\u5668\u5931\u8d25", (Throwable)e);
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }
}

