/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.osworkflow.approve.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.osworkflow.approve.ability.EacProjectAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspBO;
import com.tydic.osworkflow.approve.service.project.EacProjectService;
import com.tydic.osworkflow.approve.service.project.bo.EacStartProjectReqBO;
import com.tydic.osworkflow.approve.service.project.bo.EacStartProjectRspBO;
import com.tydic.osworkflow.engine.inside.OsworkflowMqProducerService;
import com.tydic.osworkflow.engine.runtime.MqInfo;
import com.tydic.osworkflow.engine.runtime.NextStepsResult;
import com.tydic.osworkflow.engine.runtime.Task;
import com.tydic.osworkflow.engine.utils.ExecutorProcessPool;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"osworkflow-rpc-service4/4.0.0/com.tydic.osworkflow.approve.ability.EacProjectAbilityService"})
public class EacProjectAbilityServiceImpl
implements EacProjectAbilityService {
    private static final Logger log = LoggerFactory.getLogger(EacProjectAbilityServiceImpl.class);
    @Value(value="${os.mqIntervalTime:1000}")
    private Long osMqIntervalTime;
    @Value(value="${osworkflow.backAutoStep:true}")
    private Boolean backAutoStep;
    @Value(value="${os.corePoolSize:50}")
    private Integer corePoolSize;
    @Value(value="${os.maximumPoolSize:100}")
    private Integer maximumPoolSize;
    @Autowired
    private EacProjectService eacProjectService;
    @Autowired
    private OsworkflowMqProducerService osworkflowMqProducerService;

    @PostMapping(value={"startProject"})
    public EacStartProjectAbilityRspBO startProject(@RequestBody EacStartProjectAbilityReqBO eacStartProjectAbilityReqBO) {
        EacStartProjectAbilityRspBO rspBO = new EacStartProjectAbilityRspBO();
        try {
            EacStartProjectReqBO eacStartProjectReqBO = new EacStartProjectReqBO();
            BeanUtils.copyProperties((Object)eacStartProjectAbilityReqBO, (Object)eacStartProjectReqBO);
            EacStartProjectRspBO eacStartProjectRspBO = this.eacProjectService.startProject(eacStartProjectReqBO);
            BeanUtils.copyProperties((Object)eacStartProjectRspBO, (Object)rspBO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5ba1\u6279\u65b9\u6848\u542f\u52a8\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
        }
        return rspBO;
    }

    @PostMapping(value={"startProjectByMq"})
    public EacStartProjectAbilityRspBO startProjectByMq(@RequestBody EacStartProjectAbilityReqBO eacStartProjectAbilityReqBO) {
        EacStartProjectAbilityRspBO rspBO = new EacStartProjectAbilityRspBO();
        try {
            EacStartProjectReqBO eacStartProjectReqBO = new EacStartProjectReqBO();
            BeanUtils.copyProperties((Object)eacStartProjectAbilityReqBO, (Object)eacStartProjectReqBO);
            EacStartProjectRspBO eacStartProjectRspBO = this.eacProjectService.startProjectByMq(eacStartProjectReqBO);
            Runnable run = () -> {
                if (eacStartProjectRspBO.getMqList() != null) {
                    ArrayList<NextStepsResult> afterNextStepsResultTemp = new ArrayList<NextStepsResult>();
                    for (MqInfo mqInfo : eacStartProjectRspBO.getMqList()) {
                        try {
                            Thread.sleep(this.osMqIntervalTime);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (!mqInfo.getTag().contains("OS_") && !this.backAutoStep.booleanValue()) {
                            ArrayList<Task> completedTaskList = new ArrayList<Task>();
                            ArrayList<Task> taskList = new ArrayList<Task>();
                            NextStepsResult nextStepsResultTemp = (NextStepsResult)JSON.parseObject((String)mqInfo.getContent(), NextStepsResult.class);
                            if (nextStepsResultTemp.getCompletedTaskList() != null) {
                                for (Task task : nextStepsResultTemp.getCompletedTaskList()) {
                                    if ("-998".equals(task.getUserId()) && "auto".equals(task.getUserName())) continue;
                                    completedTaskList.add(task);
                                }
                            }
                            nextStepsResultTemp.setCompletedTaskList(completedTaskList);
                            if (nextStepsResultTemp.getTaskList() != null) {
                                for (Task task : nextStepsResultTemp.getTaskList()) {
                                    if ("-998".equals(task.getUserId()) && "auto".equals(task.getUserName())) continue;
                                    taskList.add(task);
                                }
                            }
                            nextStepsResultTemp.setTaskList(taskList);
                            mqInfo.setContent(JSON.toJSONString((Object)nextStepsResultTemp));
                            if (nextStepsResultTemp.getIsfinish().booleanValue()) {
                                afterNextStepsResultTemp.add(nextStepsResultTemp);
                                continue;
                            }
                        }
                        this.osworkflowMqProducerService.sendMqMessage(mqInfo.getTag(), mqInfo.getContent());
                    }
                    if (afterNextStepsResultTemp != null && afterNextStepsResultTemp.size() > 0) {
                        for (NextStepsResult nextStepsResult : afterNextStepsResultTemp) {
                            this.osworkflowMqProducerService.sendMqMessage(nextStepsResult.getTag(), JSON.toJSONString((Object)nextStepsResult));
                        }
                    }
                }
            };
            ExecutorProcessPool.getInstance().executeByCustomThread(run);
            BeanUtils.copyProperties((Object)eacStartProjectRspBO, (Object)rspBO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5ba1\u6279\u65b9\u6848\u542f\u52a8\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
        }
        return rspBO;
    }
}

