/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.base.util;

import com.tydic.se.base.ability.bo.ManageCatalogListNestedFieldBO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NestedUtil {
    public static void parseFields(List<String> fields, List<String> normalFields, Map<String, List<ManageCatalogListNestedFieldBO>> nestedFieldsMap) {
        if (fields == null) {
            return;
        }
        for (String field : fields) {
            if (field.contains("$.[?(@.manageCatalogLevel==")) {
                NestedUtil.parseNestedField(field, nestedFieldsMap);
                continue;
            }
            normalFields.add(field);
        }
    }

    public static void parseEsFields(List<String> fields, List<String> normalFields, List<String> nestedFields) {
        if (fields == null) {
            return;
        }
        for (String field : fields) {
            String fieldWithoutWeight = field.split("\\^")[0];
            if (fieldWithoutWeight.contains(".")) {
                nestedFields.add(field);
                continue;
            }
            normalFields.add(field);
        }
    }

    public static void parseNestedField(String field, Map<String, List<ManageCatalogListNestedFieldBO>> nestedFieldsMap) {
        String path = "manageCatalogList";
        String levelPattern = "manageCatalogLevel=='(\\d+)'";
        Pattern pattern = Pattern.compile(levelPattern);
        Matcher matcher = pattern.matcher(field);
        if (matcher.find()) {
            String level = matcher.group(1);
            String[] parts = field.split("\\]\\.")[1].split("\\^");
            String fieldName = "manageCatalogList." + parts[0];
            Double boost = parts.length > 1 ? Double.parseDouble(parts[1]) : 1.0;
            ManageCatalogListNestedFieldBO nestedFieldInfo = new ManageCatalogListNestedFieldBO();
            nestedFieldInfo.setLevel(Integer.parseInt(level));
            nestedFieldInfo.setFieldName(fieldName);
            nestedFieldInfo.setBoost(boost);
            nestedFieldsMap.computeIfAbsent(path, k -> new ArrayList()).add(nestedFieldInfo);
        }
    }
}

