/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.es.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.se.es.ability.SeIndexResetAbilityService;
import com.tydic.se.es.ability.bo.SeIndexResetServiceReqBo;
import com.tydic.se.es.ability.bo.SeIndexServiceRspBo;
import com.tydic.se.es.async.SeAsyncIndexResetService;
import com.tydic.se.es.constants.SeEsConstant;
import com.tydic.se.es.data.SeAsyncIndexDataBo;
import com.tydic.se.es.util.ElasticsearchUtil;
import com.tydic.se.es.util.SeEsRspUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Service;

@EnableAsync
@Service(value="seIndexResetAbilityService")
public class SeIndexResetAbilityServiceImpl
implements SeIndexResetAbilityService {
    private static final Logger log = LoggerFactory.getLogger(SeIndexResetAbilityServiceImpl.class);
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private SeAsyncIndexResetService seAsyncIndexResetService;

    public SeIndexServiceRspBo resetIndex(SeIndexResetServiceReqBo reqBo) {
        if (log.isDebugEnabled()) {
            log.debug("============\u7d22\u5f15\u91cd\u7f6e\u5f00\u59cb\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        }
        SeIndexServiceRspBo retBo = SeEsRspUtil.getRspBo("1", "\u5931\u8d25", SeIndexServiceRspBo.class);
        if (this.elasticsearchUtil.isExistIndex(reqBo.getIndexName()).booleanValue()) {
            log.error("\u7d22\u5f15[{}]\u5df2\u5b58\u5728", (Object)reqBo.getIndexName());
            retBo.setMessage("\u7d22\u5f15[" + reqBo.getIndexName() + "]\u5df2\u5b58\u5728");
            return retBo;
        }
        if (this.elasticsearchUtil.isExistIndex(reqBo.getOriIndexName()).booleanValue()) {
            log.error("\u539f\u7d22\u5f15[{}]\u4e0d\u5b58\u5728", (Object)reqBo.getOriIndexName());
            retBo.setMessage("\u539f\u7d22\u5f15[" + reqBo.getOriIndexName() + "]\u4e0d\u5b58\u5728");
            return retBo;
        }
        if (!this.elasticsearchUtil.existsAlias(reqBo.getAlias()).booleanValue()) {
            log.error("\u522b\u540d[{}]\u4e0d\u5b58\u5728", (Object)reqBo.getAlias());
            retBo.setMessage("\u522b\u540d[" + reqBo.getAlias() + "]\u4e0d\u5b58\u5728");
            return retBo;
        }
        Boolean isSuccess = this.elasticsearchUtil.createIndex(reqBo.getIndexName(), reqBo.getIndexJsonStr());
        if (!isSuccess.booleanValue()) {
            log.error("ES\u7d22\u5f15\u521b\u5efa\u5931\u8d25", (Object)reqBo.getIndexName());
            retBo.setMessage("ES\u7d22\u5f15\u521b\u5efa\u5931\u8d25");
            return retBo;
        }
        if (SeEsConstant.INDEX_OPERATE_TYPE_COPY_FROM_ORIGINAL.equals(reqBo.getOperateDataType())) {
            log.info("\u672c\u6b21\u7684\u6570\u636e\u64cd\u4f5c\u7c7b\u578b\u4e3a\uff1a\u91cd\u65b0\u7d22\u5f15");
            this.elasticsearchUtil.reIndexAndMoveAliasIndexAsync(reqBo.getOriIndexName(), reqBo.getIndexName(), reqBo.getAlias());
        } else {
            log.info("\u672c\u6b21\u7684\u6570\u636e\u64cd\u4f5c\u7c7b\u578b\u4e3a\uff1a\u91cd\u65b0\u540c\u6b65\u6570\u636e");
            SeAsyncIndexDataBo asyncDataBo = new SeAsyncIndexDataBo();
            BeanUtils.copyProperties((Object)reqBo, (Object)asyncDataBo);
            this.seAsyncIndexResetService.reSyncData(asyncDataBo);
        }
        retBo.setCode("0");
        retBo.setMessage("\u7d22\u5f15\u91cd\u7f6e\uff0c\u6570\u636e\u64cd\u4f5c\u63d0\u4ea4\u6210\u529f");
        if (log.isDebugEnabled()) {
            log.debug("===========\u7d22\u5f15\u91cd\u7f6e\u7ed3\u675f\uff0c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)retBo));
        }
        return retBo;
    }
}

