/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.bo.system;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class ExpireCache<K, V> {
    private final ConcurrentMap<K, DelayValue<V>> map = new ConcurrentHashMap<K, DelayValue<V>>();
    private static final ScheduledExecutorService EXECUTOR = Executors.newScheduledThreadPool(7);
    public static final long DEFAULT_PERIOD_SECOND = 30L;

    public ExpireCache() {
        this(30L, TimeUnit.SECONDS);
    }

    public ExpireCache(long period, TimeUnit timeUnit) {
        EXECUTOR.scheduleAtFixedRate(this::scanClean, period, period, timeUnit);
    }

    public int size() {
        return this.map.size();
    }

    public void removeAll() {
        this.map.clear();
    }

    public void remove(K key) {
        this.map.remove(key);
    }

    public void put(K key, V value) {
        this.map.put(key, new DelayValue<V>(value));
    }

    public void put(K key, V value, long delay) {
        this.map.put(key, new DelayValue<V>(value, delay));
    }

    public V get(K key) {
        DelayValue v = (DelayValue)this.map.get(key);
        if (Objects.isNull(v)) {
            return null;
        }
        if (this.expired(v)) {
            this.map.remove(key);
            return null;
        }
        return v.data;
    }

    public JSONObject getAll() {
        JSONObject allData = new JSONObject();
        for (Map.Entry one : this.map.entrySet()) {
            allData.put((String)one.getKey(), ((DelayValue)one.getValue()).data);
        }
        return allData;
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends DelayValue<V>> function) {
        DelayValue<V> v = this.map.computeIfAbsent((K)key, (Function<? super K, DelayValue<? extends DelayValue<V>>>)function);
        if (Objects.isNull(v)) {
            return null;
        }
        if (this.expired(v)) {
            this.map.remove(key);
            return null;
        }
        return v.data;
    }

    public V computeIfAbsent(K key, long delay, Function<? super K, ? extends DelayValue<V>> function) {
        DelayValue v = (DelayValue)this.map.get(key);
        if (Objects.isNull(v)) {
            DelayValue<V> value = function.apply(key);
            DelayValue valueDelay = new DelayValue(value.data, delay);
            this.map.put(key, valueDelay);
            return valueDelay.data;
        }
        return v.data;
    }

    private void scanClean() {
        ArrayList canExpiredKeys = new ArrayList();
        for (Map.Entry entry : this.map.entrySet()) {
            if (!this.canExpired((DelayValue)entry.getValue())) continue;
            canExpiredKeys.add(entry.getKey());
        }
        Collections.shuffle(canExpiredKeys);
        int end = Math.min(canExpiredKeys.size(), 20);
        for (int i = 0; i < end; ++i) {
            Object key = canExpiredKeys.get(i);
            DelayValue v = (DelayValue)this.map.get(key);
            if (!Objects.nonNull(v) || !this.expired(v)) continue;
            this.map.remove(key);
        }
    }

    private boolean canExpired(DelayValue<V> v) {
        Objects.requireNonNull(v);
        return v.delay != -1L;
    }

    private boolean expired(DelayValue<V> v) {
        Objects.requireNonNull(v);
        return v.delay != -1L && System.currentTimeMillis() > v.delay + v.timestamp;
    }

    public static class DelayValue<V> {
        static final long FOREVER_FLAG = -1L;
        final V data;
        final long timestamp = System.currentTimeMillis();
        final long delay;

        public DelayValue(V data) {
            this.data = data;
            this.delay = -1L;
        }

        public DelayValue(V data, long delay) {
            this.data = data;
            this.delay = delay;
        }

        public String toString() {
            return "DelayValue [data=" + this.data + ", delay=" + this.delay + ", timestamp=" + this.timestamp + "]";
        }
    }
}

