/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.config;

import com.tydic.se.manage.api.ReportStatisticsService;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class AfterRunnerCheckTable
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(ApplicationRunner.class);
    @Autowired
    ReportStatisticsService reportStatisticsService;

    public void run(ApplicationArguments args) {
        this.checkTableStatus();
    }

    private void checkTableStatus() {
        LocalDateTime now = LocalDateTime.now();
        YearMonth yearMonth = YearMonth.from(now);
        int lastDayOfMonth = yearMonth.atEndOfMonth().getDayOfMonth();
        LocalDateTime endOfMonth = LocalDateTime.of(now.getYear(), now.getMonthValue(), lastDayOfMonth, 23, 50);
        Duration between = Duration.between(now, endOfMonth);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        LocalDate firstDayOfMonth = LocalDate.from(now.withDayOfMonth(1));
        String month = firstDayOfMonth.format(formatter);
        LocalDate ne = LocalDate.now().plusMonths(1L);
        LocalDate firstDayOfNeMonth = ne.withDayOfMonth(1);
        String nextMonth = firstDayOfNeMonth.format(formatter);
        LocalDate next = LocalDate.now().plusMonths(2L);
        LocalDate firstDayOfNextMonth = next.withDayOfMonth(1);
        String thirdMonth = firstDayOfNextMonth.format(formatter);
        if (between.toMinutes() > 10L || between.isNegative()) {
            log.info("\u5f53\u524d\u65f6\u95f4\u4e0d\u5728\u672c\u6708\u7684\u6700\u540e\u5341\u5206\u949f\uff0c\u521b\u5efa\u672c\u6708\u7684\u8868\u5206\u533a");
            this.reportStatisticsService.createBehaviorTable(month, nextMonth);
        } else {
            log.info("\u5f53\u524d\u65f6\u95f4\u5728\u672c\u6708\u7684\u6700\u540e\u5341\u5206\u949f\uff0c\u521b\u5efa\u4e0b\u4e2a\u6708\u7684\u8868\u5206\u533a");
            this.reportStatisticsService.createBehaviorTable(nextMonth, thirdMonth);
        }
    }
}

