/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.config;

import com.jfinal.plugin.activerecord.ActiveRecordPlugin;
import com.jfinal.plugin.activerecord.DbKit;
import com.jfinal.plugin.activerecord.IDataSourceProvider;
import com.jfinal.plugin.activerecord.dialect.Dialect;
import com.jfinal.plugin.activerecord.dialect.MysqlDialect;
import com.jfinal.plugin.hikaricp.HikariCpPlugin;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MuitDataSourceConfig {
    private static final Logger log = LoggerFactory.getLogger(MuitDataSourceConfig.class);
    @Value(value="${spring.datasource.url}")
    private String mainDbUrl;
    @Value(value="${spring.datasource.username}")
    private String mainDbUname;
    @Value(value="${spring.datasource.password}")
    private String mainDbPwd;
    @Value(value="${spring.datasource.databaseName:DYC_UCC}")
    private String databaseName;
    @Value(value="${spring.datasource.driver-class-name}")
    private String driverClassName;

    @Bean
    public ActiveRecordPlugin getActiveRecordPlugin() {
        try {
            if (DbKit.getConfig() != null && DbKit.getConfig().getConnection() != null) {
                return null;
            }
            HikariCpPlugin dp = new HikariCpPlugin(this.mainDbUrl, this.mainDbUname, this.mainDbPwd, this.driverClassName);
            dp.start();
            ActiveRecordPlugin arp = new ActiveRecordPlugin("DATAPLAT", (IDataSourceProvider)dp);
            arp.setDialect((Dialect)new MysqlDialect());
            arp.start();
            log.info("\u591a\u6570\u636e\u6e90\u8fde\u63a5\u6210\u529f!");
            return arp;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u591a\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff0c\u5e94\u7528\u5df2\u7ecf\u505c\u6b62\uff01");
            System.exit(-1);
            return null;
        }
    }

    @Bean
    public String getDatabaseName() {
        String[] parts;
        if (!StringUtils.isBlank((CharSequence)this.databaseName)) {
            return this.databaseName;
        }
        if (this.mainDbUrl != null && this.mainDbUrl.startsWith("jdbc:mysql://")) {
            String[] parts2 = this.mainDbUrl.split("/");
            if (parts2.length > 1) {
                this.databaseName = parts2[parts2.length - 1].split("\\?")[0];
            }
        } else if (this.mainDbUrl != null && this.mainDbUrl.startsWith("jdbc:dm://") && (parts = this.mainDbUrl.split("/")).length > 3) {
            String dbSegment = parts[3];
            this.databaseName = dbSegment.split("\\?")[0];
        }
        return this.databaseName;
    }
}

