/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.config;

import com.tydic.se.manage.util.CodeUtil;
import java.util.Locale;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class SearchClusterConfig
implements EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(SearchClusterConfig.class);
    private String name;
    private Environment environment;

    @Bean
    @PostConstruct
    public void initWebClusterConfigBean() {
        String osNameNow = System.getProperty("os.name").toLowerCase(Locale.US);
        String containerName = osNameNow.contains("linux") ? this.environment.getProperty("HOSTNAME", this.environment.getProperty("spring.application.name", "ability-container")) : this.environment.getProperty("USERDOMAIN_ROAMINGPROFILE", this.environment.getProperty("spring.application.name", "ability-container"));
        containerName = this.changeString(containerName);
        String name = "{SEARCH}_NODE_STATE-" + osNameNow + "-<" + containerName + ">-" + CodeUtil.generateTableCode();
        name = this.changeString(name);
        log.info("Search Node Ident:{}", (Object)name);
        this.name = name;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    private String changeString(String string) {
        return string.replace(":", "_").replace("-", "_").replace(".", "_").replace(" ", "_").toUpperCase(Locale.ROOT);
    }

    public String getName() {
        return this.name;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchClusterConfig)) {
            return false;
        }
        SearchClusterConfig other = (SearchClusterConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Environment this$environment = this.getEnvironment();
        Environment other$environment = other.getEnvironment();
        return !(this$environment == null ? other$environment != null : !this$environment.equals(other$environment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SearchClusterConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Environment $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        return result;
    }

    public String toString() {
        return "SearchClusterConfig(name=" + this.getName() + ", environment=" + this.getEnvironment() + ")";
    }
}

