/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.config;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.base.dao.SearchChannelConfigMapper;
import com.tydic.se.base.dao.po.SearchChannelConfigPO;
import com.tydic.se.manage.api.CacheUpdateService;
import com.tydic.se.manage.api.SearchConfigService;
import com.tydic.se.manage.config.SearchClusterConfig;
import com.tydic.se.search.ability.SeQueryService;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.util.SearchSortUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.util.ObjectUtils;

@Configuration
public class SearchFieldBuilderConfig {
    private static final Logger log = LoggerFactory.getLogger(SearchFieldBuilderConfig.class);
    @Value(value="${search.sync.time:10}")
    private Integer syncTimeInterval;
    @Autowired
    @Qualifier(value="searchProcessConfig")
    private SearchProcessConfig searchProcessConfig;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private CacheUpdateService cacheUpdateService;
    @Autowired
    private SeQueryService seQueryService;
    @Autowired
    ThreadPoolTaskScheduler threadPoolTaskScheduler;
    @Autowired
    private SearchClusterConfig searchClusterConfig;
    @Autowired
    private SearchConfigService searchConfigService;
    @Autowired
    private SearchChannelConfigMapper searchChannelConfigMapper;

    @PostConstruct
    public void configMonitor() {
        log.info("\u5f00\u59cb\u521d\u59cb\u5316search\u52a0\u8f7d\u914d\u7f6e");
        this.cacheUpdateService.initSyncCache(null);
        this.searchConfigService.autoCompleteConfig();
        log.info("search\u542f\u52a8\u52a0\u8f7d\u914d\u7f6e\u5b8c\u6210");
        String number = String.valueOf(this.syncTimeInterval);
        try {
            number = String.valueOf(SecureRandom.getInstance("SHA1PRNG").nextInt(Integer.parseInt(number)) + 10);
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        String cron = "0/" + number + " * * * * ?";
        log.info("search\u914d\u7f6e\u5fc3\u8df3\u76d1\u6d4bcron:" + cron);
        final String finalNumber = number;
        Runnable run = new Runnable(){

            @Override
            public void run() {
                Object exist = SearchFieldBuilderConfig.this.cacheClient.get(SearchFieldBuilderConfig.this.searchClusterConfig.getName());
                if (ObjectUtils.isEmpty((Object)exist)) {
                    SearchFieldBuilderConfig.this.cacheClient.set(SearchFieldBuilderConfig.this.searchClusterConfig.getName(), (Object)-1, Integer.parseInt(finalNumber) + 10);
                } else if (Objects.equals(exist, 1)) {
                    SearchFieldBuilderConfig.this.loadConfig();
                    SearchFieldBuilderConfig.this.cacheClient.set(SearchFieldBuilderConfig.this.searchClusterConfig.getName(), (Object)0, Integer.parseInt(finalNumber) + 10);
                    log.info("search\u66f4\u65b0\u914d\u7f6e\u5b8c\u6210\uff01");
                }
            }
        };
        run.run();
        this.threadPoolTaskScheduler.schedule(run, (Trigger)new CronTrigger(cron));
        log.info("\u521d\u59cb\u5316search\u914d\u7f6e\u5237\u65b0\u5b9a\u65f6\u4efb\u52a1\u5b8c\u6210");
    }

    public void loadConfig() {
        this.searchProcessConfig.refreshConfig(null);
        log.info("\u914d\u7f6e\u5168\u90e8\u5237\u65b0\u5b8c\u6bd5\uff01");
        SearchChannelConfigPO searchChannelConfigPO = new SearchChannelConfigPO();
        List searchChannelConfigPOS = this.searchChannelConfigMapper.selectByCondition(searchChannelConfigPO);
        if (!searchChannelConfigPOS.isEmpty()) {
            searchChannelConfigPOS.forEach(configPO -> {
                String esFields;
                String accurateFieldsStr;
                String longAccurateFieldsStr = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)configPO.getId())).esAccurateFields;
                if (StringUtils.isNotBlank((CharSequence)longAccurateFieldsStr)) {
                    log.info("\u9891\u9053 {}  relevanceFieldMatching \u7ef4\u62a4\uff01", (Object)configPO.getChannelName());
                    this.longAccurateFieldsStr2relevanceFieldMatching(configPO.getId(), longAccurateFieldsStr);
                }
                if (StringUtils.isNotBlank((CharSequence)(accurateFieldsStr = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)configPO.getId())).esAccurateChineseFields))) {
                    log.info("\u9891\u5230 {} relevanceChineseFieldMatching \u7ef4\u62a4\uff01", (Object)configPO.getChannelName());
                    this.accurateFieldsStr2relevanceChineseFieldMatching(configPO.getId(), accurateFieldsStr);
                }
                if (StringUtils.isNotBlank((CharSequence)(esFields = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)configPO.getId())).esFields))) {
                    log.info("\u9891\u9053 {} esFields \u7ef4\u62a4\uff01", (Object)configPO.getChannelName());
                    this.dealEsFields(configPO.getId(), esFields);
                }
            });
        }
        this.seQueryService.refreshCache();
    }

    private void dealEsFields(Long id, String str) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            Map<Object, Object> esNewFields;
            List<String> esFields = Arrays.asList(str.split(","));
            HashMap finalEsNewFields = esNewFields = new HashMap();
            esFields.forEach(esField -> {
                String[] parts = esField.split("\\^", 2);
                if (parts.length == 2) {
                    String field = SearchSortUtils.lineToHump((String)parts[0]);
                    try {
                        BigDecimal weight = new BigDecimal(parts[1].trim());
                        finalEsNewFields.put(field, weight);
                    }
                    catch (NumberFormatException e) {
                        log.error("\u65e0\u6cd5\u89e3\u6790\u6743\u91cd\u4e3a\u6570\u5b57: {}\uff0c\u5b57\u6bb5: {}", new Object[]{parts[1], field, e});
                    }
                } else {
                    log.error("\u5b57\u6bb5\u683c\u5f0f\u4e0d\u6b63\u786e: {}", esField);
                }
            });
            BigDecimal allWeight = finalEsNewFields.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            esNewFields = finalEsNewFields.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, weight -> ((BigDecimal)weight.getValue()).divide(allWeight, 4, RoundingMode.HALF_UP)));
            log.info("esFields\u66ff\u6362\u4e3a:{}", esNewFields);
            this.searchProcessConfig.getEsFields().put(id, esNewFields);
        }
    }

    private void longAccurateFieldsStr2relevanceFieldMatching(Long id, String str) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            List<String> esFields = Arrays.asList(str.split(","));
            ArrayList esNewFields = new ArrayList();
            esFields.forEach(esField -> {
                try {
                    esNewFields.add(SearchSortUtils.lineToHump((String)esField));
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            });
            log.info("relevanceFieldMatching\u66ff\u6362\u4e3a:" + String.join((CharSequence)",", esNewFields));
            this.searchProcessConfig.getRelevanceFieldMatching().put(id, String.join((CharSequence)",", esNewFields));
        }
    }

    private void accurateFieldsStr2relevanceChineseFieldMatching(Long id, String str) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            List<String> esFields = Arrays.asList(str.split(","));
            ArrayList esNewFields = new ArrayList();
            esFields.forEach(esField -> {
                esField = esField.replace(".keyword", "");
                esNewFields.add(SearchSortUtils.lineToHump((String)esField));
            });
            log.info("relevanceChineseFieldMatching\u66ff\u6362\u4e3a:" + String.join((CharSequence)",", esNewFields));
            this.searchProcessConfig.getRelevanceChineseFieldMatching().put(id, String.join((CharSequence)",", esNewFields));
        }
    }
}

