/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.constants;

import com.ohaotian.plugin.cache.CacheClient;
import java.util.Collections;
import java.util.Date;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.params.SetParams;

public class JedisHelper {
    private static final Logger log = LoggerFactory.getLogger(JedisHelper.class);
    private static final String requestId = JedisHelper.buildRequestId();
    private static ThreadLocal<Object[]> threadLocal = new ThreadLocal();

    public static boolean tryGetDistributedLock(CacheClient cacheClient, String lockKey2, Boolean wait, Integer expireTime) {
        String LOCK_SUCCESS = "OK";
        String SET_IF_NOT_EXIST = "NX";
        String SET_WITH_EXPIRE_TIME = "PX";
        if (!wait.booleanValue()) {
            expireTime = 43200;
            SetParams params = new SetParams().nx().px((long)expireTime.intValue());
            try {
                cacheClient.set(lockKey2, (Object)requestId, expireTime.intValue());
                return true;
            }
            catch (Exception e) {
                log.error("\u9501\u6dfb\u52a0\u5f02\u5e38\uff1a{},ex\uff1a", (Object)lockKey2, (Object)e);
                return false;
            }
        }
        long maxMillis = expireTime + 5000;
        long begin = System.currentTimeMillis();
        long now;
        while ((now = System.currentTimeMillis()) - begin <= maxMillis) {
            try {
                cacheClient.set(lockKey2, (Object)requestId, expireTime / 1000);
                return true;
            }
            catch (Exception e) {
                log.error("\u9501\u6dfb\u52a0\u5f02\u5e38\uff1a{},ex\uff1a", (Object)lockKey2, (Object)e);
                JedisHelper.sleep(10L);
                continue;
            }
            break;
        }
        return false;
    }

    public static void releaseDistributedLock(CacheClient cacheClient, String lockKey2, Long maxCloseMillis) {
        Jedis jedis = null;
        JedisCluster jedisCluster = null;
        if (cacheClient.isCluster()) {
            jedisCluster = cacheClient.getJedisCluster();
        } else {
            jedis = cacheClient.getJedisPool().getResource();
        }
        long begin = System.currentTimeMillis();
        long now;
        while ((now = System.currentTimeMillis()) - begin <= (maxCloseMillis == null ? 5000L : maxCloseMillis)) {
            Long RELEASE_SUCCESS;
            Object result;
            String script = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
            if (jedisCluster != null) {
                result = jedisCluster.eval(script, Collections.singletonList(lockKey2), Collections.singletonList(requestId));
                RELEASE_SUCCESS = 1L;
                if (RELEASE_SUCCESS.equals(result)) {
                    return;
                }
            }
            if (jedis != null) {
                result = jedis.eval(script, Collections.singletonList(lockKey2), Collections.singletonList(requestId));
                RELEASE_SUCCESS = 1L;
                if (RELEASE_SUCCESS.equals(result)) {
                    return;
                }
            }
            JedisHelper.sleep(10L);
        }
        return;
    }

    public static boolean tryGetThreadLocalDistributedLock(Jedis jedis, String lockKey2, Boolean wait, Integer expireTime) {
        String requestId = JedisHelper.buildRequestId();
        Object[] local = new Object[]{jedis, lockKey2, requestId};
        String LOCK_SUCCESS = "OK";
        String SET_IF_NOT_EXIST = "NX";
        String SET_WITH_EXPIRE_TIME = "PX";
        if (!wait.booleanValue()) {
            String result = null;
            result = expireTime == null ? jedis.set(lockKey2, requestId, SetParams.setParams().nx()) : jedis.set(lockKey2, requestId, SetParams.setParams().nx().px((long)expireTime.intValue()));
            if ("OK".equalsIgnoreCase(result)) {
                threadLocal.set(local);
                return true;
            }
            return false;
        }
        long maxMillis = (expireTime == null ? 0 : expireTime) + 5000;
        long begin = System.currentTimeMillis();
        long now;
        while ((now = System.currentTimeMillis()) - begin <= maxMillis) {
            String result = null;
            result = expireTime == null ? jedis.set(lockKey2, requestId, SetParams.setParams().nx()) : jedis.set(lockKey2, requestId, SetParams.setParams().nx().px((long)expireTime.intValue()));
            if ("OK".equalsIgnoreCase(result)) {
                threadLocal.set(local);
                return true;
            }
            JedisHelper.sleep(10L);
        }
        return false;
    }

    public static void releaseDistributedLock(Long maxCloseMillis) {
        Object[] local = threadLocal.get();
        if (local == null) {
            return;
        }
        threadLocal.remove();
        Jedis jedis = (Jedis)local[0];
        String lockKey2 = (String)local[1];
        String requestId = (String)local[2];
        try {
            long begin = System.currentTimeMillis();
            while (true) {
                long now;
                if ((now = System.currentTimeMillis()) - begin > (maxCloseMillis == null ? 5000L : maxCloseMillis)) {
                    return;
                }
                String script = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
                Object result = jedis.eval(script, Collections.singletonList(lockKey2), Collections.singletonList(requestId));
                Long RELEASE_SUCCESS = 1L;
                if (RELEASE_SUCCESS.equals(result)) {
                    return;
                }
                JedisHelper.sleep(10L);
            }
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
    }

    private static String buildRequestId() {
        return new Date().getTime() + "-" + UUID.randomUUID().toString();
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

