/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.constants;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.se.manage.constants.GenericsUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.util.WebUtils;
import sun.misc.BASE64Encoder;

public class XlsUtil {
    private static final Logger log = LoggerFactory.getLogger(XlsUtil.class);

    public static Workbook readXls(HttpServletRequest request) {
        HashMap result = new HashMap();
        String contentType = request.getContentType();
        HSSFWorkbook workbook = null;
        try {
            if (contentType != null && contentType.toLowerCase().startsWith("multipart/")) {
                MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)WebUtils.getNativeRequest((ServletRequest)request, MultipartHttpServletRequest.class);
                MultipartFile multipartFile = multipartRequest.getFile("file");
                String fileName = multipartFile.getOriginalFilename();
                String fileType = fileName.substring(fileName.lastIndexOf("."));
                if (".xls".equals(fileType)) {
                    workbook = new HSSFWorkbook(multipartFile.getInputStream());
                } else if (".xlsx".equals(fileType)) {
                    workbook = new XSSFWorkbook(multipartFile.getInputStream());
                } else {
                    workbook = null;
                    log.debug("\u6587\u4ef6\u4e0d\u662fexcel\u6587\u4ef6");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u8bfb\u53d6excel\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        return workbook;
    }

    public static List<List<String>> getBankListByExcel(Workbook work) throws Exception {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        Sheet sheet = null;
        Row row = null;
        Cell cell = null;
        for (int i = 0; i < work.getNumberOfSheets() && i <= 0; ++i) {
            sheet = work.getSheetAt(i);
            if (sheet == null) continue;
            boolean outStep = false;
            for (int j = sheet.getFirstRowNum() + 1; j <= sheet.getLastRowNum(); ++j) {
                row = sheet.getRow(j);
                if (row == null || row.getFirstCellNum() == j) continue;
                ArrayList<String> li = new ArrayList<String>();
                for (int y = 0; y < row.getLastCellNum() && y <= row.getLastCellNum(); ++y) {
                    cell = row.getCell(y);
                    if (cell == null || "".equals(cell.toString())) {
                        outStep = true;
                        li.add("");
                        continue;
                    }
                    String tstr = "";
                    if (cell.getCellType() == CellType.STRING) {
                        tstr = cell.getStringCellValue();
                    }
                    if (cell.getCellType() == CellType.NUMERIC) {
                        DecimalFormat df = new DecimalFormat("#");
                        tstr = df.format(cell.getNumericCellValue());
                    }
                    li.add(tstr);
                }
                list.add(li);
            }
        }
        work.close();
        return list;
    }

    public Workbook getWorkbook(File excelFile) {
        HSSFWorkbook workbook = null;
        try {
            FileInputStream inStr = new FileInputStream(excelFile);
            String fileName = excelFile.getName();
            String fileType = fileName.substring(fileName.lastIndexOf("."));
            if (".xls".equals(fileType)) {
                workbook = new HSSFWorkbook((InputStream)inStr);
            } else if (".xlsx".equals(fileType)) {
                workbook = new XSSFWorkbook((InputStream)inStr);
            } else {
                workbook = null;
                log.debug("\u6587\u4ef6\u4e0d\u662fexcel\u6587\u4ef6");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u8bfb\u53d6excel\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        return workbook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportJson(HttpServletResponse response, Object obj, String fileName) {
        ByteArrayInputStream is = null;
        OutputStream os = null;
        try {
            int len;
            String jsonString = JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
            response.setContentType("application/octet-stream; charset=utf-8");
            response.setCharacterEncoding("utf-8");
            response.setHeader("Content-Disposition", "attachment;fileName=" + fileName);
            is = new ByteArrayInputStream(jsonString.getBytes());
            os = response.getOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = is.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static <T> Object[][] toArray(List<T> data, String[] variable) {
        GenericsUtils<T> genericsUtils = new GenericsUtils<T>();
        Object[][] obj = new Object[data.size()][variable.length];
        for (int i = 0; i < data.size(); ++i) {
            T t = data.get(i);
            for (int j = 0; j < variable.length; ++j) {
                obj[i][j] = genericsUtils.getVariable(t, variable[j]);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String gzip(String primStr) {
        if (primStr == null || primStr.length() == 0) {
            return primStr;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = null;
        try {
            gzip = new GZIPOutputStream(out);
            gzip.write(primStr.getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (gzip != null) {
                try {
                    gzip.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return new BASE64Encoder().encode(out.toByteArray());
    }
}

