/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.util;

import com.jfinal.plugin.activerecord.Record;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommTools {
    private static final Logger logger = LoggerFactory.getLogger(CommTools.class);

    public static boolean strIsEmpty(String str) {
        if (str == null) {
            return true;
        }
        if ("".equals(str)) {
            return true;
        }
        if (str == "") {
            return true;
        }
        if ("null".equalsIgnoreCase(str)) {
            return true;
        }
        if (str.length() < 1) {
            return true;
        }
        return "undefined".equals(str);
    }

    public static boolean strIsEmpty(String ... value) {
        for (String str : value) {
            if (!CommTools.strIsEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public static <T> String listToStr(List<T> list, String sep) {
        if (list == null || list.size() == 0) {
            return "''";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null || CommTools.strIsEmpty(list.get(i).toString())) continue;
            sb.append("'" + list.get(i).toString() + "'");
            if (i >= list.size() - 1) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    public static boolean isNumeric(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String delHTMLTag(String htmlStr) {
        if (htmlStr == null || "".equals(htmlStr)) {
            return "";
        }
        String regEx_script = "<script[^>]*?>[\\s\\S]*?<\\/script>";
        String regEx_style = "<style[^>]*?>[\\s\\S]*?<\\/style>";
        String regEx_html = "<[^>]+>";
        Pattern p_script = Pattern.compile(regEx_script, 2);
        Matcher m_script = p_script.matcher(htmlStr);
        htmlStr = m_script.replaceAll("");
        Pattern p_style = Pattern.compile(regEx_style, 2);
        Matcher m_style = p_style.matcher(htmlStr);
        htmlStr = m_style.replaceAll("");
        Pattern p_html = Pattern.compile(regEx_html, 2);
        Matcher m_html = p_html.matcher(htmlStr);
        htmlStr = m_html.replaceAll("");
        return htmlStr.trim();
    }

    public static <T> List<T> getBeanList(List<Record> list, Class<T> clazz) throws InstantiationException, IllegalAccessException, ParseException {
        ArrayList<T> resultList = new ArrayList<T>();
        if (list == null || list.size() == 0) {
            return resultList;
        }
        for (Record r : list) {
            T t = CommTools.mapToObject(r.getColumns(), clazz);
            resultList.add(t);
        }
        return resultList;
    }

    public static <T> T mapToObject(Map map, Class<T> clazz) throws InstantiationException, IllegalAccessException, ParseException {
        if (map == null) {
            return null;
        }
        T t = clazz.newInstance();
        Field[] fields = t.getClass().getDeclaredFields();
        for (Field field : fields = CommTools.getSuperFields(clazz, Arrays.asList(fields))) {
            String value;
            String key = field.getName();
            if (map.get(key) == null || CommTools.strIsEmpty(value = map.get(key).toString())) continue;
            Boolean visiable = field.isAccessible();
            field.setAccessible(Boolean.TRUE);
            Object object = CommTools.getValueFormField(field, key, value);
            field.set(t, object);
            field.setAccessible(visiable);
        }
        return t;
    }

    public static Field[] getSuperFields(Class<?> subCls, List<Field> subFields) {
        Class<?> superClass = subCls.getSuperclass();
        subFields = new ArrayList<Field>(subFields);
        if (superClass != null && superClass != Object.class) {
            Field[] superFields = superClass.getDeclaredFields();
            subFields.addAll(Arrays.asList(superFields));
            if (superClass.getSuperclass() != Object.class) {
                CommTools.getSuperFields(superClass, subFields);
            }
        }
        return subFields.toArray(new Field[subFields.size()]);
    }

    public static Object getValueFormField(Field field, String name, String value) throws IllegalAccessException, ParseException {
        Object object = value;
        String type = field.getType().getSimpleName();
        if (CommTools.strIsEmpty(value) && "short,int,Integer,long,double,float".contains(type)) {
            value = "0";
        }
        if ("short".equalsIgnoreCase(type)) {
            object = Short.valueOf(value);
        } else if ("char".equals(type) || "Character".equals(type)) {
            if (!CommTools.strIsEmpty(value)) {
                object = Character.valueOf(value.charAt(0));
            }
        } else if ("int".equals(type) || "Integer".equals(type)) {
            object = Integer.valueOf(value);
        } else if ("long".equalsIgnoreCase(type)) {
            object = Long.valueOf(value);
        } else if ("byte".equalsIgnoreCase(type)) {
            object = Byte.valueOf(value);
        } else if ("float".equalsIgnoreCase(type)) {
            object = Float.valueOf(value);
        } else if ("double".equalsIgnoreCase(type)) {
            object = Double.valueOf(value);
        } else if ("boolean".equalsIgnoreCase(type)) {
            object = Boolean.valueOf(value);
        } else if ("Date".equals(type)) {
            value = value.replace('T', ' ');
            object = CommTools.parseDate(value);
        } else if ("byte[]".equalsIgnoreCase(type)) {
            object = CommTools.string2Bytes(value);
        }
        return object;
    }

    public static Date parseDate(String date) throws ParseException {
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int colonCount = 0;
        for (int i = 0; i < date.length(); ++i) {
            if (date.charAt(i) != ':') continue;
            ++colonCount;
        }
        if (colonCount == 0) {
            date = date + ":00:00";
        }
        if (colonCount == 1) {
            date = date + ":00";
        }
        return CommTools.strIsEmpty(date) ? null : dateformat.parse(date);
    }

    public static byte[] string2Bytes(String str) {
        byte[] bytes = new byte[str.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(str.substring(2 * i, 2 * i + 2), 16);
        }
        return bytes;
    }

    public static String getYesterday() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        String yesterday = new SimpleDateFormat("yyyy-MM-dd").format(calendar.getTime());
        return yesterday;
    }
}

