/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.util;

import com.tydic.se.manage.model.PoiModel;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtils {
    private static boolean isNumeric(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

    public static <T> List<T> castList(Object obj, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        if (obj instanceof List) {
            for (Object o : (List)obj) {
                result.add(clazz.cast(o));
            }
            return result;
        }
        return null;
    }

    public static XSSFWorkbook exportToExcelForXlsx(List<List> objData, InputStream fileInputStream, List mergeIndex, HttpServletResponse response) {
        XSSFWorkbook wb = null;
        try {
            wb = new XSSFWorkbook(fileInputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        XSSFSheet sheet1 = wb.getSheetAt(0);
        XSSFCellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        sheet1.createFreezePane(0, 2);
        int dataSatrtIndex = 2;
        boolean isMerge = false;
        if (mergeIndex != null && mergeIndex.size() != 0) {
            isMerge = true;
        }
        if (objData != null && objData.size() > 0) {
            int i;
            HashMap<Integer, PoiModel> poiModels = new HashMap<Integer, PoiModel>();
            for (i = 0; i < objData.size(); ++i) {
                XSSFRow row = sheet1.createRow((int)((short)(i + dataSatrtIndex)));
                List list = objData.get(i);
                DecimalFormat decimalFormat = new DecimalFormat("0.00");
                int j = 0;
                for (Object o : list) {
                    String content = "";
                    if (o != null) {
                        content = o.toString().contains(".") && ExcelUtils.isNumeric(o.toString()) ? decimalFormat.format(Float.valueOf(o.toString())) : (o.toString().contains("-") && o.toString().contains(":") ? String.valueOf(o).split("\\.")[0] : String.valueOf(o));
                    }
                    if (isMerge && mergeIndex.contains(j)) {
                        PoiModel poiModel = (PoiModel)poiModels.get(j);
                        if (poiModel == null) {
                            poiModel = new PoiModel();
                            poiModel.setContent(content);
                            poiModel.setRowIndex(i + dataSatrtIndex);
                            poiModel.setCellIndex(j);
                            poiModels.put(j, poiModel);
                        } else if (!poiModel.getContent().equals(content)) {
                            XSSFRow lastRow = sheet1.getRow(poiModel.getRowIndex());
                            XSSFCell lastCell = lastRow.createCell(poiModel.getCellIndex());
                            lastCell.setCellValue(poiModel.getContent());
                            if (poiModel.getRowIndex() != i + dataSatrtIndex - 1) {
                                sheet1.addMergedRegion(new CellRangeAddress(poiModel.getRowIndex(), i + dataSatrtIndex - 1, poiModel.getCellIndex(), poiModel.getCellIndex()));
                            }
                            poiModel.setContent(content);
                            poiModel.setRowIndex(i + dataSatrtIndex);
                            poiModel.setCellIndex(j);
                            poiModels.put(j, poiModel);
                        }
                        row.createCell(j);
                    } else {
                        XSSFCell cell = row.createCell(j);
                        cell.setCellValue(content);
                    }
                    ++j;
                }
            }
            if (poiModels != null && poiModels.size() != 0) {
                for (Integer key : poiModels.keySet()) {
                    PoiModel poiModel = (PoiModel)poiModels.get(key);
                    XSSFRow lastRow = sheet1.getRow(poiModel.getRowIndex());
                    XSSFCell lastCell = lastRow.getCell(poiModel.getCellIndex());
                    lastCell.setCellValue(poiModel.getContent());
                    if (poiModel.getRowIndex() == i + dataSatrtIndex - 1) continue;
                    sheet1.addMergedRegion(new CellRangeAddress(poiModel.getRowIndex(), i + dataSatrtIndex - 1, poiModel.getCellIndex(), poiModel.getCellIndex()));
                }
            }
        }
        return wb;
    }

    public static void main(String[] args) {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("\u76ee\u5f55");
        columns.add("\u76ee\u5f55");
        columns.add("\u76ee\u5f55");
        columns.add("\u5185\u5bb9");
        String fileName = "D:\\sofeware\\dingding\\download\\EvaluationRecordResults.xlsx";
        String sheetName = "\u53ec\u56de\u7ed3\u679c";
        ArrayList exportData = new ArrayList();
        ArrayList<String> rowData = new ArrayList<String>();
        rowData.add("\u7eff\u841d");
        rowData.add("1001");
        rowData.add("\u529e\u516c\u5ba4\u5927\u7eff\u841d");
        rowData.add("\u529e\u516c\u5ba4\u5927\u7eff\u841d");
        rowData.add("\u65e0");
        rowData.add("\u7eff\u822a");
        rowData.add("\u9707\u5764\u884c");
        exportData.add(rowData);
        ArrayList rowData2 = new ArrayList();
        rowData.add("\u7eff\u841d");
        rowData.add("1002");
        rowData.add("\u7eff\u822a\u5927\u7eff\u841d");
        rowData.add("\u7eff\u822a\u5927\u7eff\u841d");
        rowData.add("\u529e\u516c\u82b1\u5349");
        rowData.add("\u7eff\u822a");
        rowData.add("\u9707\u5764\u884c");
        exportData.add(rowData2);
        ArrayList rowData3 = new ArrayList();
        rowData.add("\u7eff\u841d");
        rowData.add("1003");
        rowData.add("\u529e\u516c\u82b1\u5349\u7eff\u841d");
        rowData.add("\u529e\u516c\u82b1\u5349\u7eff\u841d");
        rowData.add("\u529e\u516c\u82b1\u5349");
        rowData.add("\u65e0");
        rowData.add("\u9707\u5764\u884c");
        exportData.add(rowData3);
        ArrayList<Integer> mergeIndex = new ArrayList<Integer>();
        mergeIndex.add(0);
    }
}

