/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.se.base.bo.MilvusFieldInfoBO;
import com.tydic.se.base.bo.MilvusIndexDetailBO;
import io.milvus.client.MilvusServiceClient;
import io.milvus.grpc.CollectionSchema;
import io.milvus.grpc.DataType;
import io.milvus.grpc.DescribeCollectionResponse;
import io.milvus.grpc.DescribeIndexResponse;
import io.milvus.grpc.FieldSchema;
import io.milvus.grpc.GetIndexStateResponse;
import io.milvus.grpc.IndexDescription;
import io.milvus.grpc.KeyValuePair;
import io.milvus.param.IndexType;
import io.milvus.param.MetricType;
import io.milvus.param.R;
import io.milvus.param.collection.CreateCollectionParam;
import io.milvus.param.collection.DescribeCollectionParam;
import io.milvus.param.collection.DropCollectionParam;
import io.milvus.param.collection.FieldType;
import io.milvus.param.collection.LoadCollectionParam;
import io.milvus.param.index.CreateIndexParam;
import io.milvus.param.index.DescribeIndexParam;
import io.milvus.param.index.GetIndexStateParam;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class MilvusUtil {
    private static final Logger logger = LoggerFactory.getLogger(MilvusUtil.class);
    @Lazy
    @Autowired
    private MilvusServiceClient milvusServiceClient;
    private static MilvusServiceClient milvusClient;

    @PostConstruct
    public void init() {
        milvusClient = this.milvusServiceClient;
    }

    public static Boolean createCollect(String config, String collectName) {
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)config);
            JSONArray jsonArray = jsonObject.getJSONArray("fields");
            String pk = jsonObject.getString("primary_key");
            String index = jsonObject.getString("index_key");
            Integer shards = jsonObject.getInteger("number_of_shards");
            Boolean autoId = jsonObject.getBoolean("auto_id");
            Integer dimension = jsonObject.getInteger("dimension");
            CreateCollectionParam.Builder createCollectionReq = CreateCollectionParam.newBuilder().withCollectionName(collectName).withDescription("Test").withEnableDynamicField(true).withShardsNum(shards.intValue());
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject object = jsonArray.getJSONObject(i);
                String name = object.getString("name");
                String type = object.getString("type");
                FieldType.Builder fieldType = FieldType.newBuilder().withName(name);
                if ("string".equals(type)) {
                    fieldType.withDataType(DataType.VarChar).withMaxLength(Integer.valueOf(object.getInteger("maxLen") == null ? 256 : object.getInteger("maxLen")));
                } else if ("int64".equals(type)) {
                    fieldType.withDataType(DataType.Int64);
                } else if ("float_vector".equals(type)) {
                    fieldType.withDataType(DataType.FloatVector).withDimension(dimension);
                }
                if (pk.equals(name)) {
                    fieldType.withPrimaryKey(true).withAutoID(autoId.booleanValue());
                }
                createCollectionReq.addFieldType(fieldType.build());
            }
            milvusClient.createCollection(createCollectionReq.build());
            IndexType INDEX_TYPE = IndexType.IVF_FLAT;
            String INDEX_PARAM = "{\"nlist\":8000}";
            milvusClient.createIndex(CreateIndexParam.newBuilder().withCollectionName(collectName).withFieldName(index).withIndexType(INDEX_TYPE).withMetricType(MetricType.L2).withExtraParam(INDEX_PARAM).withSyncMode(Boolean.FALSE).build());
            milvusClient.loadCollection(LoadCollectionParam.newBuilder().withCollectionName(collectName).build());
            return true;
        }
        catch (Exception e) {
            logger.error("Milvus\u96c6\u5408\u521b\u5efa\u5931\u8d25");
            e.printStackTrace();
            return false;
        }
    }

    public static Boolean delCollect(String collectName) {
        try {
            milvusClient.dropCollection(DropCollectionParam.newBuilder().withCollectionName(collectName).build());
            return true;
        }
        catch (Exception e) {
            logger.error("Milvus\u96c6\u5408\u5220\u9664\u5931\u8d25");
            e.printStackTrace();
            return false;
        }
    }

    public static MilvusIndexDetailBO getCollectionDetail(String collectName) {
        try {
            GetIndexStateParam indexStateParam;
            R indexStateResponseWrapper;
            DescribeCollectionParam descParam = DescribeCollectionParam.newBuilder().withCollectionName(collectName).build();
            R responseWrapper = milvusClient.describeCollection(descParam);
            if (responseWrapper.getStatus().intValue() != R.Status.Success.getCode()) {
                throw new ZTBusinessException("\u83b7\u53d6\u96c6\u5408\u4fe1\u606f\u5931\u8d25: " + responseWrapper.getMessage());
            }
            DescribeCollectionResponse descResponse = (DescribeCollectionResponse)responseWrapper.getData();
            CollectionSchema schema = descResponse.getSchema();
            MilvusIndexDetailBO detail = new MilvusIndexDetailBO();
            detail.setDescription(schema.getDescription());
            detail.setShardsNum(Integer.valueOf(descResponse.getShardsNum()));
            ArrayList<MilvusFieldInfoBO> fields = new ArrayList<MilvusFieldInfoBO>();
            for (FieldSchema fieldSchema : schema.getFieldsList()) {
                MilvusFieldInfoBO field = new MilvusFieldInfoBO();
                field.setName(fieldSchema.getName());
                field.setType(fieldSchema.getDataType().name());
                field.setPrimaryKey(Boolean.valueOf(fieldSchema.getIsPrimaryKey()));
                if (fieldSchema.getDataType() == DataType.FloatVector) {
                    fieldSchema.getTypeParamsList().stream().filter(p -> "dim".equals(p.getKey())).findFirst().ifPresent(p -> field.setDimension(Integer.valueOf(Integer.parseInt(p.getValue()))));
                }
                fields.add(field);
            }
            detail.setFields(fields);
            DescribeIndexParam indexParam = DescribeIndexParam.newBuilder().withCollectionName(collectName).build();
            R indexResponseWrapper = milvusClient.describeIndex(indexParam);
            if (indexResponseWrapper.getStatus().intValue() != R.Status.Success.getCode()) {
                throw new ZTBusinessException("\u83b7\u53d6\u7d22\u5f15\u4fe1\u606f\u5931\u8d25: " + indexResponseWrapper.getMessage());
            }
            DescribeIndexResponse indexResponse = (DescribeIndexResponse)indexResponseWrapper.getData();
            int indexCount = indexResponse.getIndexDescriptionsCount();
            detail.setCount(Integer.valueOf(indexCount));
            if (indexCount > 0) {
                IndexDescription indexDesc = indexResponse.getIndexDescriptions(0);
                LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
                String metricType = "L2";
                for (KeyValuePair param : indexDesc.getParamsList()) {
                    paramsMap.put(param.getKey(), param.getValue());
                    if (!"metric_type".equals(param.getKey())) continue;
                    metricType = param.getValue();
                }
                detail.setMetricType(metricType);
                detail.setIndexParams(JSON.toJSONString(paramsMap));
            }
            if ((indexStateResponseWrapper = milvusClient.getIndexState(indexStateParam = GetIndexStateParam.newBuilder().withCollectionName(collectName).build())).getStatus().intValue() != R.Status.Success.getCode()) {
                throw new ZTBusinessException("\u83b7\u53d6\u7d22\u5f15\u72b6\u6001\u5931\u8d25: " + indexStateResponseWrapper.getMessage());
            }
            GetIndexStateResponse indexStateResponse = (GetIndexStateResponse)indexStateResponseWrapper.getData();
            detail.setState(indexStateResponse.getState().name());
            return detail;
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u64cd\u4f5c\u5931\u8d25: " + e.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
    }
}

