/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.base.bo.SearchSortConfigCacheBO;
import com.tydic.se.base.dao.EsIndexMapper;
import com.tydic.se.base.dao.SearchChannelConfigMapper;
import com.tydic.se.base.dao.SearchConfigNewDao;
import com.tydic.se.base.dao.po.SearchChannelConfigPO;
import com.tydic.se.manage.api.CacheUpdateService;
import com.tydic.se.manage.constants.Constants;
import com.tydic.se.manage.dao.SearchCatalogRecordMapper;
import com.tydic.se.manage.dao.SearchCommonWordsRecordDao;
import com.tydic.se.manage.dao.SearchExtCatalogRecordMapper;
import com.tydic.se.manage.dao.SearchFrequentUsedWordsMapper;
import com.tydic.se.manage.dao.SearchFrequentUsedWordsTypeMapper;
import com.tydic.se.manage.dao.SearchSynonymWordsMapper;
import com.tydic.se.manage.dao.po.SearchSynonymWords;
import com.tydic.se.manage.util.CommTools;
import com.tydic.se.nlp.bo.AnalysisFourLevelCatalogBO;
import com.tydic.se.nlp.bo.AnalysisFourLevelCatalogCacheBO;
import com.tydic.se.nlp.bo.AnalysisTypeFrequentBO;
import com.tydic.se.nlp.bo.AnalysisTypeFrequentCacheBO;
import com.tydic.se.nlp.bo.AnalysisWordCacheBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@DependsOn(value={"searchFieldBuilderConfig"})
public class CacheUpdateServiceImpl
implements CacheUpdateService {
    private static final Logger logger = LoggerFactory.getLogger(CacheUpdateServiceImpl.class);
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private SearchCatalogRecordMapper searchCatalogRecordDao;
    @Autowired
    private SearchFrequentUsedWordsMapper searchFrequentUsedWordsMapper;
    @Autowired
    private SearchConfigNewDao searchConfigNewDao;
    @Autowired
    private SearchCommonWordsRecordDao searchCommonWordsRecordDao;
    @Autowired
    private SearchFrequentUsedWordsTypeMapper searchFrequentUsedWordsTypeMapper;
    @Autowired
    private SearchExtCatalogRecordMapper searchExtCatalogRecordMapper;
    @Autowired
    private SearchSynonymWordsMapper searchSynonymWordsMapper;
    @Autowired
    private EsIndexMapper esIndexMapper;
    @Autowired
    private SearchChannelConfigMapper searchChannelConfigMapper;

    public void deleteFourCatalog(String cataName) {
        logger.debug("\u505c\u7528\u6216\u5220\u9664\u56db\u7ea7\u7c7b\u76ee:{}", (Object)cataName);
        if (!CommTools.strIsEmpty((String)cataName)) {
            List cIds = this.searchCatalogRecordDao.queryByCataName(cataName);
            if (cIds == null || cIds.size() < 1) {
                this.cacheClient.hdel("{SEARCH}_FOUR_LEVEL_CALALOG", new String[]{cataName.toLowerCase()});
            } else {
                String s = this.cacheClient.hget("{SEARCH}_FOUR_LEVEL_CALALOG", cataName.toLowerCase());
                if (!CommTools.strIsEmpty((String)s)) {
                    AnalysisFourLevelCatalogCacheBO f = (AnalysisFourLevelCatalogCacheBO)JSONObject.parseObject((String)s, AnalysisFourLevelCatalogCacheBO.class);
                    ArrayList<AnalysisFourLevelCatalogBO> list = null;
                    if (f.getCatalogList() != null && f.getCatalogList().size() > 0) {
                        list = new ArrayList<AnalysisFourLevelCatalogBO>();
                        for (AnalysisFourLevelCatalogBO c : f.getCatalogList()) {
                            if (!cIds.contains(c.getcId()) || c.getExtList() == null || c.getExtList().size() <= 0) continue;
                            list.add(c);
                        }
                    }
                    if (list != null && list.size() > 0) {
                        f.setCatalogList(list);
                        this.cacheClient.hset("{SEARCH}_FOUR_LEVEL_CALALOG", cataName.toLowerCase(), JSONObject.toJSONString((Object)f));
                    } else {
                        this.cacheClient.hdel("{SEARCH}_FOUR_LEVEL_CALALOG", new String[]{cataName.toLowerCase()});
                    }
                }
            }
        }
    }

    @Async
    public void bathDeleteFourCatalog(Set<String> cataList) {
        logger.debug("\u6279\u91cf\u505c\u7528\u6216\u5220\u9664\u56db\u7ea7\u7c7b\u76ee:{}", cataList);
        if (cataList != null && cataList.size() > 0) {
            cataList.forEach(cataName -> {
                try {
                    this.deleteFourCatalog((String)cataName);
                }
                catch (Exception e) {
                    logger.error("\u56db\u7ea7\u7c7b\u76ee:{}\u6e05\u7406\u7f13\u5b58\u5931\u8d25\uff0cerror:{}", cataName, (Object)e.getMessage());
                }
            });
        }
    }

    public void linkFourCatalog(String catelogName) {
        List fourLevelCatalogBOS = this.searchCatalogRecordDao.queryCacheInfo(catelogName);
        logger.info("list:{}", (Object)fourLevelCatalogBOS);
        if (fourLevelCatalogBOS != null && fourLevelCatalogBOS.size() > 0) {
            AnalysisFourLevelCatalogCacheBO fCacheBO = new AnalysisFourLevelCatalogCacheBO();
            fCacheBO.setcName(catelogName);
            fCacheBO.setCatalogList(new ArrayList());
            fourLevelCatalogBOS.forEach(f -> {
                if (f.getExtList() != null && f.getExtList().size() > 0) {
                    fCacheBO.getCatalogList().add(f);
                }
            });
            if (fCacheBO.getCatalogList().size() > 0) {
                this.cacheClient.hset("{SEARCH}_FOUR_LEVEL_CALALOG", catelogName.toLowerCase(), JSONObject.toJSONString((Object)fCacheBO));
            } else {
                this.cacheClient.hdel("{SEARCH}_FOUR_LEVEL_CALALOG", new String[]{catelogName.toLowerCase()});
            }
        } else {
            this.cacheClient.hdel("{SEARCH}_FOUR_LEVEL_CALALOG", new String[]{catelogName.toLowerCase()});
        }
    }

    @Async
    public void bathLinkFourCatalog(Set<String> cataList) {
        logger.debug("\u53d8\u66f4\u56db\u7ea7\u7c7b\u76ee\u7ed1\u5b9a\u5916\u90e8\u4e09\u7ea7\u7c7b\u76ee\u5173\u8054\u5173\u7cfb:{}", cataList);
        if (cataList != null && cataList.size() > 0) {
            cataList.forEach(cataName -> {
                try {
                    this.linkFourCatalog((String)cataName);
                }
                catch (Exception e) {
                    logger.error("\u56db\u7ea7\u7c7b\u76ee:{}\u540c\u6b65\u7f13\u5b58\u5931\u8d25\uff0cerror:{}", cataName, (Object)e.getMessage());
                }
            });
        }
    }

    public void syncExtThreeCatalog() {
        logger.info("=====\u540c\u6b65\u5916\u90e8\u4e09\u7ea7\u7c7b\u76ee\u5f00\u59cb=====");
        this.cacheClient.delete("{SEARCH}_EXT_THREE_CATALOG");
        List extThreeCatalogList = this.searchExtCatalogRecordMapper.queryCacheInfo();
        if (extThreeCatalogList != null && extThreeCatalogList.size() > 0) {
            this.cacheClient.set("{SEARCH}_EXT_THREE_CATALOG", (Object)extThreeCatalogList);
        }
        logger.info("===\u540c\u6b65\u5916\u90e8\u4e09\u7ea7\u7c7b\u76ee\u4fe1\u606f\u7ed3\u675f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e===", (Object)(extThreeCatalogList == null ? 0 : extThreeCatalogList.size()));
    }

    public void deleteTypeFrequent(String fWord) {
        logger.debug("\u505c\u7528\u6216\u5220\u9664\u6570\u636e\u7c7b\u76ee\u660e\u7ec6:{}", (Object)fWord);
        if (!CommTools.strIsEmpty((String)fWord)) {
            List wIds = this.searchFrequentUsedWordsMapper.queryByfWord(fWord);
            if (wIds == null || wIds.size() < 1) {
                this.cacheClient.hdel("{SEARCH}_TYPE_SKU_FREQUENT", new String[]{fWord.toLowerCase()});
                this.cacheClient.hdel("{SEARCH}_TYPE_MATERIAL_FREQUENT", new String[]{fWord.toLowerCase()});
            } else {
                String m;
                String s = this.cacheClient.hget("{SEARCH}_TYPE_SKU_FREQUENT", fWord.toLowerCase());
                if (!CommTools.strIsEmpty((String)s)) {
                    AnalysisTypeFrequentCacheBO tf = (AnalysisTypeFrequentCacheBO)JSONObject.parseObject((String)s, AnalysisTypeFrequentCacheBO.class);
                    this.deleteTypeFrequent(tf, wIds, fWord, "{SEARCH}_TYPE_SKU_FREQUENT");
                }
                if (!CommTools.strIsEmpty((String)(m = this.cacheClient.hget("{SEARCH}_TYPE_MATERIAL_FREQUENT", fWord.toLowerCase())))) {
                    AnalysisTypeFrequentCacheBO tf = (AnalysisTypeFrequentCacheBO)JSONObject.parseObject((String)m, AnalysisTypeFrequentCacheBO.class);
                    this.deleteTypeFrequent(tf, wIds, fWord, "{SEARCH}_TYPE_MATERIAL_FREQUENT");
                }
            }
        }
    }

    private void deleteTypeFrequent(AnalysisTypeFrequentCacheBO tf, List<Long> wIds, String fWord, String key) {
        ArrayList<AnalysisTypeFrequentBO> list = null;
        if (tf.getTypeFrequentList() != null && tf.getTypeFrequentList().size() > 0) {
            list = new ArrayList<AnalysisTypeFrequentBO>();
            for (AnalysisTypeFrequentBO f : tf.getTypeFrequentList()) {
                if (!wIds.contains(f.getId())) continue;
                list.add(f);
            }
            if (list != null && list.size() > 0) {
                tf.setTypeFrequentList(list);
                this.cacheClient.hset(key, fWord.toLowerCase(), JSONObject.toJSONString((Object)tf));
            } else {
                this.cacheClient.hdel(key, new String[]{fWord.toLowerCase()});
            }
        }
    }

    @Async
    public void bathDeleteTypeFrequent(Set<String> fWordList) {
        logger.debug("\u6279\u91cf\u505c\u7528\u6216\u5220\u9664\u6570\u636e\u7c7b\u76ee\u660e\u7ec6:{}", fWordList);
        if (fWordList != null && fWordList.size() > 0) {
            fWordList.forEach(fWord -> {
                try {
                    this.deleteTypeFrequent((String)fWord);
                }
                catch (Exception e) {
                    logger.error("\u505c\u7528\u6216\u5220\u9664\u6570\u636e\u7c7b\u76ee\u660e\u7ec6:{}\u6e05\u7406\u7f13\u5b58\u5931\u8d25\uff0cerror:{}", fWord, (Object)e.getMessage());
                }
            });
        }
    }

    public void addTypeFrequent(String fWord) {
        logger.debug("\u6dfb\u52a0\u6570\u636e\u7c7b\u76ee\u660e\u7ec6:{}", (Object)fWord);
        if (!CommTools.strIsEmpty((String)fWord)) {
            AnalysisTypeFrequentCacheBO tCacheBO;
            List list = this.searchFrequentUsedWordsMapper.queryCacheInfo(fWord);
            ArrayList<AnalysisTypeFrequentBO> skuTypeList = new ArrayList<AnalysisTypeFrequentBO>();
            ArrayList<AnalysisTypeFrequentBO> materialTypeList = new ArrayList<AnalysisTypeFrequentBO>();
            if (list != null && list.size() > 0) {
                for (AnalysisTypeFrequentBO bo : list) {
                    if (bo.getIndexType() != null && bo.getIndexType() == 6) {
                        materialTypeList.add(bo);
                        continue;
                    }
                    skuTypeList.add(bo);
                }
            }
            if (skuTypeList.size() > 0) {
                tCacheBO = new AnalysisTypeFrequentCacheBO();
                tCacheBO.setfWord(fWord);
                tCacheBO.setTypeFrequentList(skuTypeList);
                this.cacheClient.hset("{SEARCH}_TYPE_SKU_FREQUENT", fWord.toLowerCase(), JSONObject.toJSONString((Object)tCacheBO));
            }
            if (materialTypeList.size() > 0) {
                tCacheBO = new AnalysisTypeFrequentCacheBO();
                tCacheBO.setfWord(fWord);
                tCacheBO.setTypeFrequentList(materialTypeList);
                this.cacheClient.hset("{SEARCH}_TYPE_MATERIAL_FREQUENT", fWord.toLowerCase(), JSONObject.toJSONString((Object)tCacheBO));
            }
        }
    }

    @Async
    public void bathAddTypeFrequent(Set<String> fWordList) {
        logger.debug("\u6279\u91cf\u542f\u7528\u6570\u636e\u7c7b\u76ee\u660e\u7ec6:{}", fWordList);
        this.cacheClient.delete("{SEARCH}_TYPE_SKU");
        List searchFrequentUsedWordsTypeBOS = this.searchFrequentUsedWordsTypeMapper.queryAllUsedWordsTypeList();
        if (searchFrequentUsedWordsTypeBOS != null && searchFrequentUsedWordsTypeBOS.size() > 0) {
            searchFrequentUsedWordsTypeBOS.forEach(t -> {
                if (t.getIndexType() == 6) {
                    this.cacheClient.hset("{SEARCH}_TYPE_MATERIAL", t.getIndexField(), t.getTWeight() == null ? "1" : t.getTWeight().toString());
                } else {
                    this.cacheClient.hset("{SEARCH}_TYPE_SKU", t.getIndexField(), t.getTWeight() == null ? "1" : t.getTWeight().toString());
                }
            });
        }
        if (fWordList != null && fWordList.size() > 0) {
            fWordList.forEach(fWord -> {
                try {
                    this.addTypeFrequent((String)fWord);
                }
                catch (Exception e) {
                    logger.error("\u542f\u7528\u6570\u636e\u7c7b\u76ee\u660e\u7ec6:{}\u6dfb\u52a0\u7f13\u5b58\u5931\u8d25\uff0cerror:{}", fWord, (Object)e.getMessage());
                }
            });
        }
    }

    public void syncSearchConfig() {
        this.initSyncSearchConfig();
    }

    public void updateRewriteWord(String wordName) {
        logger.info("\u6539\u5199\u914d\u7f6e\u540c\u6b65:{}", (Object)wordName);
        if (!CommTools.strIsEmpty((String)wordName)) {
            AnalysisWordCacheBO wordCacheBO = this.searchCommonWordsRecordDao.queryCacheInfo(wordName);
            if (wordCacheBO != null) {
                this.cacheClient.hset("{SEARCH}_REWRITE_WORD", wordCacheBO.getwName().toLowerCase(), JSONObject.toJSONString((Object)wordCacheBO));
            } else {
                this.cacheClient.hdel("{SEARCH}_REWRITE_WORD", new String[]{wordName.toLowerCase()});
            }
        }
    }

    @Async
    public void bathUpdateRewriteWord(Set<String> wordList) {
        logger.info("\u6279\u91cf\u6539\u5199\u914d\u7f6e\u540c\u6b65:{}", wordList);
        if (wordList != null && wordList.size() > 0) {
            wordList.forEach(wordName -> {
                try {
                    this.updateRewriteWord((String)wordName);
                }
                catch (Exception e) {
                    logger.error("\u6539\u5199\u914d\u7f6e\u540c\u6b65:{}\u5931\u8d25\uff0cerror:{}", wordName, (Object)e.getMessage());
                }
            });
        }
    }

    public void updateSynonymWord(Long synonymId) {
        SearchSynonymWords searchSynonymWordsPO;
        logger.info("\u540c\u4e49\u8bcd\u540c\u6b65:{}", (Object)synonymId);
        if (synonymId != null && ((searchSynonymWordsPO = this.searchSynonymWordsMapper.selectByPrimaryKey(synonymId)) != null && !CommTools.strIsEmpty((String)searchSynonymWordsPO.getMainWord()) || !CommTools.strIsEmpty((String)searchSynonymWordsPO.getSimWords()))) {
            ArrayList<String> words = new ArrayList<String>();
            if (!CommTools.strIsEmpty((String)searchSynonymWordsPO.getMainWord())) {
                words.add(searchSynonymWordsPO.getMainWord());
            }
            if (!CommTools.strIsEmpty((String)searchSynonymWordsPO.getSimWords())) {
                words.addAll(Arrays.asList(searchSynonymWordsPO.getSimWords().split(",")));
            }
            this.updateSynonymWord(words);
        }
    }

    public void updateSynonymWord(List<String> words) {
        logger.info("\u66f4\u65b0\u540c\u4e49\u8bcd:{}", words);
        if (words != null && words.size() > 0) {
            words.forEach(word -> this.cacheClient.hdel("{SEARCH}_SYNONYM_WORD", new String[]{word.toLowerCase()}));
            HashMap<String, Set> synonymWordMap = new HashMap<String, Set>();
            List list = this.searchSynonymWordsMapper.queryByWordList(words);
            if (list != null && list.size() > 0) {
                for (SearchSynonymWords synonymPO : list) {
                    if (!synonymWordMap.containsKey(synonymPO.getMainWord().toLowerCase())) {
                        synonymWordMap.put(synonymPO.getMainWord().toLowerCase(), new HashSet());
                    }
                    ((Set)synonymWordMap.get(synonymPO.getMainWord().toLowerCase())).addAll(Arrays.asList(synonymPO.getSimWords().toLowerCase().split(",")));
                    if (synonymPO.getType() != 1) continue;
                    for (String word2 : synonymPO.getSimWords().toLowerCase().split(",")) {
                        if (!synonymWordMap.containsKey(word2)) {
                            synonymWordMap.put(word2, new HashSet());
                        }
                        ((Set)synonymWordMap.get(word2)).add(synonymPO.getMainWord().toLowerCase());
                        ((Set)synonymWordMap.get(word2)).addAll(Arrays.asList(synonymPO.getSimWords().toLowerCase().split(",")));
                        ((Set)synonymWordMap.get(word2)).remove(word2);
                    }
                }
            }
            if (synonymWordMap.size() > 0) {
                synonymWordMap.forEach((word, synonymWords) -> {
                    if (synonymWords != null && synonymWords.size() > 0) {
                        this.cacheClient.hset("{SEARCH}_SYNONYM_WORD", word, synonymWords.stream().collect(Collectors.joining(",")));
                    }
                });
            }
        }
    }

    public void syncESIndex(Byte type, String esName) {
        logger.info("\u540c\u6b65ES\u7d22\u5f15,type:{},esName:{}", (Object)type, (Object)esName);
        if (type == null) {
            return;
        }
        String esNameKey = (String)Constants.INDEX_NAME_KEY_MAP.get(type);
        if (!CommTools.strIsEmpty((String)esNameKey)) {
            if (!CommTools.strIsEmpty((String)esName)) {
                this.cacheClient.hset("{SEARCH}_INDEX", esNameKey, esName);
            } else {
                this.cacheClient.hdel("{SEARCH}_INDEX", new String[]{esNameKey});
            }
        }
    }

    @Async(value="threadPoolTaskExecutor")
    public void initSyncCache(Integer initSyncType) {
        logger.info("\u521d\u59cb\u5316\u7f13\u5b58\u7c7b\u578b:{}", (Object)initSyncType);
        if (initSyncType != null) {
            if (initSyncType.equals(1)) {
                Constants.SyncStatus.commondWordStatus = true;
                this.initSyncCommondWord();
                Constants.SyncStatus.commondWordStatus = false;
            } else if (initSyncType.equals(2)) {
                Constants.SyncStatus.catalogStatus = true;
                this.initSyncCatalog();
                Constants.SyncStatus.catalogStatus = false;
            } else if (initSyncType.equals(3)) {
                Constants.SyncStatus.typeFrequentStatus = true;
                this.initSyncTypeFrequent();
                Constants.SyncStatus.typeFrequentStatus = false;
            } else if (initSyncType.equals(4)) {
                Constants.SyncStatus.searchConfigStatus = true;
                this.initSyncSearchConfig();
                Constants.SyncStatus.searchConfigStatus = false;
            } else if (initSyncType.equals(5)) {
                Constants.SyncStatus.extThreeCatalogStatus = true;
                this.syncExtThreeCatalog();
                Constants.SyncStatus.extThreeCatalogStatus = false;
            } else if (initSyncType.equals(6)) {
                Constants.SyncStatus.synonymWordStatus = true;
                this.initSyncSynonymWord();
                Constants.SyncStatus.synonymWordStatus = false;
            } else if (initSyncType.equals(7)) {
                Constants.SyncStatus.indexStatus = true;
                this.initIndex();
                Constants.SyncStatus.indexStatus = false;
            }
        } else {
            Constants.SyncStatus.allStatus = true;
            this.initSyncCommondWord();
            this.initSyncCatalog();
            this.initSyncTypeFrequent();
            this.initSyncSearchConfig();
            this.syncExtThreeCatalog();
            this.initIndex();
            Constants.SyncStatus.allStatus = false;
        }
    }

    private void initSyncCommondWord() {
        logger.info("===\u521d\u59cb\u5316\u540c\u6b65\u5e38\u89c1\u5355\u8bcd\u6539\u5199\u4fe1\u606f\u5f00\u59cb===");
        this.cacheClient.delete("{SEARCH}_REWRITE_WORD");
        List wordCacheBOS = this.searchCommonWordsRecordDao.queryInitCacheInfo();
        if (wordCacheBOS != null && wordCacheBOS.size() > 0) {
            wordCacheBOS.forEach(wordCacheBO -> this.cacheClient.hset("{SEARCH}_REWRITE_WORD", wordCacheBO.getwName().toLowerCase(), JSONObject.toJSONString((Object)wordCacheBO)));
        }
        logger.info("===\u521d\u59cb\u5316\u540c\u6b65\u5e38\u89c1\u5355\u8bcd\u6539\u5199\u4fe1\u606f\u7ed3\u675f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e===", (Object)(wordCacheBOS == null ? 0 : wordCacheBOS.size()));
    }

    private void initSyncCatalog() {
        logger.info("===\u521d\u59cb\u5316\u540c\u6b65\u56db\u7ea7\u7c7b\u76ee\u53ca\u7ed1\u5b9a\u5916\u90e8\u4e09\u7ea7\u7c7b\u76ee\u4fe1\u606f\u5f00\u59cb===");
        this.cacheClient.delete("{SEARCH}_FOUR_LEVEL_CALALOG");
        List fourLevelCatalogBOS = this.searchCatalogRecordDao.queryCacheInfo(null);
        HashMap<String, AnalysisFourLevelCatalogCacheBO> fourLevelCatalogMap = new HashMap<String, AnalysisFourLevelCatalogCacheBO>();
        if (fourLevelCatalogBOS != null && fourLevelCatalogBOS.size() > 0) {
            for (AnalysisFourLevelCatalogBO f : fourLevelCatalogBOS) {
                if (f.getExtList() == null || f.getExtList().size() <= 0) continue;
                AnalysisFourLevelCatalogCacheBO fCacheBO2 = (AnalysisFourLevelCatalogCacheBO)fourLevelCatalogMap.get(f.getcName().toLowerCase());
                if (fCacheBO2 == null) {
                    fCacheBO2 = new AnalysisFourLevelCatalogCacheBO();
                    fCacheBO2.setcName(f.getcName());
                    ArrayList catalogList = new ArrayList();
                    fCacheBO2.setCatalogList(catalogList);
                }
                fCacheBO2.getCatalogList().add(f);
                fourLevelCatalogMap.put(f.getcName().toLowerCase(), fCacheBO2);
            }
            fourLevelCatalogMap.forEach((cName, fCacheBO) -> this.cacheClient.hset("{SEARCH}_FOUR_LEVEL_CALALOG", cName.toLowerCase(), JSONObject.toJSONString((Object)fCacheBO)));
        }
        logger.info("===\u521d\u59cb\u5316\u540c\u6b65\u56db\u7ea7\u7c7b\u76ee\u53ca\u7ed1\u5b9a\u5916\u90e8\u4e09\u7ea7\u7c7b\u76ee\u4fe1\u606f\u7ed3\u675f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e===", (Object)(fourLevelCatalogBOS == null ? 0 : fourLevelCatalogBOS.size()));
    }

    private void initSyncTypeFrequent() {
        logger.info("===\u521d\u59cb\u5316\u540c\u6b65\u6570\u636e\u7c7b\u76ee\u4fe1\u606f\u5f00\u59cb===");
        this.cacheClient.delete("{SEARCH}_TYPE_SKU");
        this.cacheClient.delete("{SEARCH}_TYPE_MATERIAL");
        List searchFrequentUsedWordsTypeBOS = this.searchFrequentUsedWordsTypeMapper.queryAllUsedWordsTypeList();
        if (searchFrequentUsedWordsTypeBOS != null && searchFrequentUsedWordsTypeBOS.size() > 0) {
            searchFrequentUsedWordsTypeBOS.stream().filter(Objects::nonNull).filter(t -> t.getIndexType() != null).filter(t -> t.getIndexField() != null).forEach(t -> {
                String key = t.getIndexType() == 6 ? "{SEARCH}_TYPE_MATERIAL" : "{SEARCH}_TYPE_SKU";
                String value = t.getTWeight() != null ? t.getTWeight().toString() : "1";
                this.cacheClient.hset(key, t.getIndexField(), value);
            });
        }
        this.cacheClient.delete("{SEARCH}_TYPE_SKU_FREQUENT");
        this.cacheClient.delete("{SEARCH}_TYPE_MATERIAL_FREQUENT");
        List typeFrequentBOS = this.searchFrequentUsedWordsMapper.queryCacheInfo(null);
        HashMap<String, AnalysisTypeFrequentCacheBO> typeSkuFrequentMap = new HashMap<String, AnalysisTypeFrequentCacheBO>();
        HashMap<String, AnalysisTypeFrequentCacheBO> typeMaterialFrequentMap = new HashMap<String, AnalysisTypeFrequentCacheBO>();
        if (typeFrequentBOS != null && typeFrequentBOS.size() > 0) {
            for (AnalysisTypeFrequentBO t2 : typeFrequentBOS) {
                AnalysisTypeFrequentCacheBO tCacheBO2 = null;
                tCacheBO2 = t2.getIndexType() != null && t2.getIndexType() == 6 ? (AnalysisTypeFrequentCacheBO)typeMaterialFrequentMap.get(t2.getfWord().toLowerCase()) : (AnalysisTypeFrequentCacheBO)typeSkuFrequentMap.get(t2.getfWord().toLowerCase());
                if (tCacheBO2 == null) {
                    tCacheBO2 = new AnalysisTypeFrequentCacheBO();
                    tCacheBO2.setfWord(t2.getfWord());
                    ArrayList typeFrequentList = new ArrayList();
                    tCacheBO2.setTypeFrequentList(typeFrequentList);
                }
                tCacheBO2.getTypeFrequentList().add(t2);
                if (t2.getIndexType() != null && t2.getIndexType() == 6) {
                    typeMaterialFrequentMap.put(t2.getfWord().toLowerCase(), tCacheBO2);
                    continue;
                }
                typeSkuFrequentMap.put(t2.getfWord().toLowerCase(), tCacheBO2);
            }
            typeSkuFrequentMap.forEach((fName, tCacheBO) -> this.cacheClient.hset("{SEARCH}_TYPE_SKU_FREQUENT", fName, JSONObject.toJSONString((Object)tCacheBO)));
            typeMaterialFrequentMap.forEach((fName, tCacheBO) -> this.cacheClient.hset("{SEARCH}_TYPE_MATERIAL_FREQUENT", fName, JSONObject.toJSONString((Object)tCacheBO)));
        }
        logger.info("===\u521d\u59cb\u5316\u540c\u6b65\u6570\u636e\u7c7b\u76ee\u4fe1\u606f\u7ed3\u675f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e===", (Object)(typeFrequentBOS == null ? 0 : typeFrequentBOS.size()));
    }

    private void initSyncSearchConfig() {
        logger.info("===\u521d\u59cb\u5316\u540c\u6b65\u641c\u7d22\u914d\u7f6e\u4fe1\u606f\u5f00\u59cb===");
        this.cacheClient.delete("{SEARCH}_CONFIG");
        this.cacheClient.delete("{SEARCH}_COMPLEX_SORT_CONFIG");
        this.cacheClient.delete("{SEARCH}_DEFAULT_CHANNEL_TYPE");
        List searchSortConfigCacheBOList = this.searchConfigNewDao.queryAllChannelCacheInfo();
        Map<String, List<SearchSortConfigCacheBO>> groupedByConfName = searchSortConfigCacheBOList.stream().collect(Collectors.groupingBy(SearchSortConfigCacheBO::getConfName));
        for (Map.Entry<String, List<SearchSortConfigCacheBO>> entry : groupedByConfName.entrySet()) {
            String confName = entry.getKey();
            List<SearchSortConfigCacheBO> configList = entry.getValue();
            this.cacheClient.hset("{SEARCH}_CONFIG", confName, JSON.toJSONString(configList));
        }
        SearchChannelConfigPO searchChannelConfigPO = new SearchChannelConfigPO();
        searchChannelConfigPO.setIsDefaultConfig(Integer.valueOf(0));
        List searchChannelConfigPOS = this.searchChannelConfigMapper.selectByCondition(searchChannelConfigPO);
        if (!searchChannelConfigPOS.isEmpty()) {
            this.cacheClient.set("{SEARCH}_DEFAULT_CHANNEL_TYPE", (Object)((SearchChannelConfigPO)searchChannelConfigPOS.get(0)).getId());
        }
        logger.info("===\u521d\u59cb\u5316\u540c\u6b65\u641c\u7d22\u914d\u7f6e\u4fe1\u606f\u7ed3\u675f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e===", (Object)(searchSortConfigCacheBOList == null ? 0 : searchSortConfigCacheBOList.size()));
        this.clearSearchCache();
    }

    private void initSyncSynonymWord() {
        logger.info("===\u521d\u59cb\u5316\u540c\u6b65\u540c\u4e49\u8bcd\u4fe1\u606f\u5f00\u59cb===");
        this.cacheClient.delete("{SEARCH}_SYNONYM_WORD");
        HashMap<String, Set> synonymWordMap = new HashMap<String, Set>();
        List searchSynonymWords = this.searchSynonymWordsMapper.queryCacheInfo();
        if (searchSynonymWords != null && searchSynonymWords.size() > 0) {
            searchSynonymWords.forEach(searchSynonymWord -> {
                if (!CommTools.strIsEmpty((String)searchSynonymWord.getSimWords())) {
                    if (!synonymWordMap.containsKey(searchSynonymWord.getMainWord().toLowerCase())) {
                        synonymWordMap.put(searchSynonymWord.getMainWord().toLowerCase(), new HashSet());
                    }
                    ((Set)synonymWordMap.get(searchSynonymWord.getMainWord().toLowerCase())).addAll(Arrays.asList(searchSynonymWord.getSimWords().toLowerCase().split(",")));
                    if (searchSynonymWord.getType() == 1) {
                        for (String word : searchSynonymWord.getSimWords().toLowerCase().split(",")) {
                            if (!synonymWordMap.containsKey(word)) {
                                synonymWordMap.put(word, new HashSet());
                            }
                            ((Set)synonymWordMap.get(word)).addAll(Arrays.asList(searchSynonymWord.getSimWords().toLowerCase().split(",")));
                            ((Set)synonymWordMap.get(word)).add(searchSynonymWord.getMainWord().toLowerCase());
                            ((Set)synonymWordMap.get(word)).remove(word);
                        }
                    }
                }
            });
        }
        if (synonymWordMap.size() > 0) {
            synonymWordMap.forEach((word, synonymWords) -> this.cacheClient.hset("{SEARCH}_SYNONYM_WORD", word, synonymWords.stream().collect(Collectors.joining(","))));
        }
        logger.info("===\u521d\u59cb\u5316\u540c\u6b65\u5e38\u89c1\u5355\u8bcd\u6539\u5199\u4fe1\u606f\u7ed3\u675f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e===", (Object)(synonymWordMap == null ? 0 : synonymWordMap.size()));
    }

    private void initIndex() {
        this.cacheClient.delete("{SEARCH}_INDEX");
        List esIndexPOS = this.esIndexMapper.queryEnableIndex();
        if (esIndexPOS != null && esIndexPOS.size() > 0) {
            esIndexPOS.forEach(esIndexPO -> {
                if (!CommTools.strIsEmpty((String)esIndexPO.getIndexSName()) && esIndexPO.getiType() != null && Constants.INDEX_NAME_KEY_MAP.get(esIndexPO.getiType()) != null) {
                    this.cacheClient.hset("{SEARCH}_INDEX", (String)Constants.INDEX_NAME_KEY_MAP.get(esIndexPO.getiType()), esIndexPO.getIndexSName());
                }
            });
        }
    }

    private void clearSearchCache() {
        try {
            Set keys = this.cacheClient.getkeys("{SEARCH}_ES_*");
            logger.info("\u641c\u7d22\u7f13\u5b58\u6e05\u7406\u5f00\u59cb\uff0c\u5171{}\u6761\u8bb0\u5f55", (Object)(keys == null ? 0 : keys.size()));
            if (keys != null && keys.size() > 0) {
                keys.forEach(key -> this.cacheClient.delete(key));
            }
            logger.info("\u641c\u7d22\u7f13\u5b58\u6e05\u7406\u7ed3\u675f");
            logger.info("\u6807\u8bb0\u914d\u7f6e\u66f4\u65b0\u72b6\u6001");
            Set searchNodes = this.cacheClient.getkeys("{SEARCH}_NODE_STATE*");
            for (String searchNode : searchNodes) {
                this.cacheClient.set(searchNode, (Object)1);
                logger.info("\u8282\u70b9:{}\uff0c\u6807\u8bb0\u52a0\u8f7d\u914d\u7f6e\uff01", (Object)searchNode);
            }
        }
        catch (Exception e) {
            logger.error("\u641c\u7d22\u7f13\u5b58\u6e05\u7406\u5931\u8d25!err:{}", (Object)e.getMessage());
        }
    }
}

