/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Record;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.base.constant.ToOdpsCommConstant;
import com.tydic.se.base.dao.EsIndexMapper;
import com.tydic.se.base.dao.po.EsIndex;
import com.tydic.se.es.util.ElasticsearchUtil;
import com.tydic.se.manage.api.ESIndexSyncService;
import com.tydic.se.manage.bo.FlushEsIndexRsqBO;
import com.tydic.se.manage.bo.ModelDataToEsReqBO;
import com.tydic.se.manage.bo.cache.VectorRspBO;
import com.tydic.se.manage.config.PauseException;
import com.tydic.se.manage.constants.CONST;
import com.tydic.se.manage.constants.HttpRequestUtils;
import com.tydic.se.manage.constants.JedisHelper;
import com.tydic.se.manage.dao.EsIndexModelDao;
import com.tydic.se.manage.dao.EsSyncRecordMapper;
import com.tydic.se.manage.dao.po.EsIndexLogPO;
import com.tydic.se.manage.dao.po.EsIndexModel;
import com.tydic.se.manage.dao.po.EsSyncRecord;
import com.tydic.se.manage.util.CodeUtil;
import com.tydic.se.manage.util.CommTools;
import com.tydic.se.manage.util.DateUtil;
import com.tydic.se.search.config.SearchProcessConfig;
import io.milvus.client.MilvusServiceClient;
import io.milvus.param.R;
import io.milvus.param.dml.DeleteParam;
import io.milvus.param.dml.InsertParam;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;

@Service
public class ESIndexSyncServiceImpl
implements ESIndexSyncService {
    private static final Logger log = LoggerFactory.getLogger(ESIndexSyncServiceImpl.class);
    @Autowired
    private EsIndexModelDao esIndexModelDao;
    @Autowired
    private EsSyncRecordMapper esSyncRecordMapper;
    @Autowired
    private EsIndexMapper esIndexMapper;
    @Autowired
    private CacheClient cacheClient;
    @Lazy
    @Autowired
    private MilvusServiceClient milvusServiceClient;
    @Autowired
    @Qualifier(value="taskExecutor")
    private ThreadPoolTaskExecutor taskExecutor;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private SearchProcessConfig searchProcessConfig;

    public Map<String, String> modelDataToEsSynchronizer(ModelDataToEsReqBO reqBO) throws ZTBusinessException {
        log.info("\u6570\u636e\u540c\u6b65\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        this.validParams(reqBO);
        String taskId = reqBO.getIndexSName() + "_" + UUID.randomUUID().toString();
        Long id = CodeUtil.generateTableCode();
        String syncDate = DateUtil.getYesterdayDate();
        Boolean flag = JedisHelper.tryGetDistributedLock((CacheClient)this.cacheClient, (String)("synch_esindex_lock_" + reqBO.getIndexSName()), (Boolean)false, null);
        if (!flag.booleanValue()) {
            log.error("\u7d22\u5f15\u540c\u6b65\u4efb\u52a1\u8fdb\u884c\u4e2d\uff0c\u76f4\u63a5\u8fd4\u56de");
            throw new ZTBusinessException("\u7d22\u5f15\u540c\u6b65\u4efb\u52a1\u8fdb\u884c\u4e2d\uff0c\u8bf7\u67e5\u770b\u540c\u6b65\u8fdb\u5ea6\u540e\u91cd\u8bd5\uff01");
        }
        try {
            EsIndexModel esIndexModel = this.esIndexModelDao.selectByPrimaryKey(reqBO.getmId());
            if (esIndexModel == null || StringUtils.isEmpty((CharSequence)esIndexModel.getmName())) {
                throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u6a21\u578b\u4fe1\u606f");
            }
            int all = Db.use((String)"DATAPLAT").queryInt("SELECT COUNT(*) FROM " + esIndexModel.getmName());
            if (all == 0) {
                throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u6a21\u578b\u6570\u636e\uff0c\u8bf7\u624b\u52a8\u786e\u8ba4\u8868\u6570\u636e");
            }
            this.doRecordInsert(id, reqBO);
            return this.doSyncIndexData(taskId, reqBO, all, id, esIndexModel, syncDate);
        }
        catch (Exception e) {
            log.info("-------\u540c\u6b65\u5931\u8d25,\u91ca\u653e\u9501-------\u5931\u8d25\u539f\u56e0:{}", (Object)e.getMessage());
            JedisHelper.releaseDistributedLock((CacheClient)this.cacheClient, (String)("synch_esindex_lock_" + reqBO.getIndexSName()), null);
            return null;
        }
    }

    private void doRecordInsert(Long id, ModelDataToEsReqBO reqBO) {
        if (!StringUtils.isEmpty((CharSequence)reqBO.getTaskId())) {
            EsSyncRecord recordPO = this.esSyncRecordMapper.selectExRecordByTaskId(reqBO.getTaskId());
            if (recordPO == null) {
                throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u4e0a\u6b21\u5931\u8d25\u8bb0\u5f55\uff0c\u8bf7\u91cd\u8dd1\u4efb\u52a1");
            }
            EsIndexLogPO logPO = new EsIndexLogPO(id, reqBO.getIndexSName(), CONST.OP_INDEX_TYPE_6, new Date(), reqBO.getUserId(), reqBO.getUsername());
            this.esSyncRecordMapper.insertEsIndexLogSelective(logPO);
        } else if (reqBO.getFlag() != null && reqBO.getFlag() == 1) {
            EsIndexLogPO logPO = new EsIndexLogPO(id, reqBO.getIndexSName(), CONST.OP_INDEX_TYPE_7, new Date(), reqBO.getUserId(), reqBO.getUsername());
            this.esSyncRecordMapper.insertEsIndexLogSelective(logPO);
        } else {
            EsIndexLogPO logPO = new EsIndexLogPO(id, reqBO.getIndexSName(), CONST.OP_INDEX_TYPE_4, new Date(), reqBO.getUserId(), reqBO.getUsername());
            this.esSyncRecordMapper.insertEsIndexLogSelective(logPO);
        }
    }

    private Map<String, String> doSyncIndexData(String taskId, ModelDataToEsReqBO reqBO, int all, Long id, EsIndexModel esIndexModel, String date) {
        HashMap<String, String> rMap = new HashMap<String, String>();
        Long seChannelType = (Long)this.cacheClient.get("{SEARCH}_DEFAULT_CHANNEL_TYPE");
        Future taskFuture = this.taskExecutor.submit(() -> {
            int syncedRecords = 0;
            int syncedRecordsFact = 0;
            Long maxId = 0L;
            String process = "0";
            String syncDate = "";
            log.info("-------\u540c\u6b65\u5f00\u59cb");
            long begin = System.currentTimeMillis();
            try {
                EsSyncRecord po;
                int allRecords;
                if (StringUtils.isEmpty((CharSequence)reqBO.getTaskId())) {
                    allRecords = all;
                    syncDate = date;
                } else {
                    po = this.esSyncRecordMapper.selectExRecordByTaskId(reqBO.getTaskId());
                    if (po == null) {
                        throw new ZTBusinessException("\u672a\u67e5\u8be2\u4e0a\u6b21\u5931\u8d25\u8bb0\u5f55\uff0c\u8bf7\u91cd\u8dd1\u4efb\u52a1");
                    }
                    allRecords = po.getTotal();
                    syncedRecords = po.getExTotal();
                    syncedRecordsFact = po.getCompleted();
                    maxId = po.getMaxSkuId();
                    process = po.getProgress();
                    syncDate = po.getSyncDate();
                }
                po = new EsSyncRecord(id, reqBO.getIndexSName(), Integer.valueOf(allRecords), Integer.valueOf(syncedRecordsFact), Integer.valueOf(syncedRecords), process, new Date(), new Date(), new Date(), taskId, maxId, syncDate);
                this.esSyncRecordMapper.insertSelective(po);
                EsIndex esIndexPO1 = new EsIndex(reqBO.getIndexSName(), ToOdpsCommConstant.syncStatus.STATUS_1);
                this.esIndexMapper.updateByPrimaryKeySelective(esIndexPO1);
                String batchSize = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)seChannelType)).elasticsearchBatchSize;
                int numBatches = (int)Math.ceil((double)(allRecords - syncedRecords) / (double)Integer.parseInt(batchSize));
                Boolean nerOpen = Objects.equals("1", ((SearchProcessConfig.VectorConfig)this.searchProcessConfig.getVector().get((Object)seChannelType)).searchUseRaner);
                String vectorOpen = ((SearchProcessConfig.VectorConfig)this.searchProcessConfig.getVector().get((Object)seChannelType)).searchUseVector;
                if (Objects.equals("0", vectorOpen) && (ToOdpsCommConstant.esType.TYPE_3.equals(reqBO.getiType()) || ToOdpsCommConstant.esType.TYPE_5.equals(reqBO.getiType()))) {
                    throw new ZTBusinessException("\u5411\u91cf\u672a\u5f00\u542f\uff0c\u4e0d\u5141\u8bb8\u540c\u6b65\u5411\u91cf\u7d22\u5f15\uff01");
                }
                for (int i = 0; i < numBatches; ++i) {
                    if (this.isLocked(this.cacheClient.getJedisPool().getResource(), reqBO.getIndexSName())) {
                        List list = null;
                        List<Record> list1 = null;
                        if (ToOdpsCommConstant.esType.TYPE_3.equals(reqBO.getiType())) {
                            list = Db.use((String)"DATAPLAT").find("SELECT commodity_id,sku_name as commodity_name,l3_category_id ,l3_category_name,sku_id  FROM " + esIndexModel.getmName() + " where sku_id> " + maxId + " ORDER BY sku_id limit  " + Integer.parseInt(batchSize));
                            if (list != null && list.size() > 0) {
                                maxId = ((Record)list.get(list.size() - 1)).getLong("sku_id");
                                list1 = this.handerVectorIndexData(list);
                                log.info("========\u5411\u91cf\u7d22\u5f15\u6570\u636e\u5199\u5165es========");
                                this.elasticsearchUtil.addAllTypeData(reqBO.getIndexSName(), list1);
                            }
                        } else if (ToOdpsCommConstant.esType.TYPE_5.equals(reqBO.getiType())) {
                            list = Db.use((String)"DATAPLAT").find("SELECT commodity_id,sku_name as commodity_name,l3_category_id ,l3_category_name,sku_id  FROM " + esIndexModel.getmName() + " where sku_id> " + maxId + " ORDER BY sku_id limit " + Integer.parseInt(batchSize));
                            if (list != null && list.size() > 0) {
                                maxId = ((Record)list.get(list.size() - 1)).getLong("sku_id");
                                list1 = this.handerVectorIndexData(list);
                                log.info("========\u6570\u636e\u5199\u5165milvus========");
                                this.writeMilvus(reqBO.getIndexSName(), list1);
                            }
                        } else if (ToOdpsCommConstant.esType.TYPE_6.equals(reqBO.getiType())) {
                            list = Db.use((String)"DATAPLAT").find("SELECT codeId, materialName, code, descLong,spec,model,unit,l1_category_id,l1_category_name,l2_category_id,l2_category_name,l3_category_id,l3_category_name,category_mark FROM " + esIndexModel.getmName() + " where codeId > " + maxId + " ORDER BY codeId limit  " + Integer.parseInt(batchSize));
                            if (list != null && list.size() > 0) {
                                maxId = ((Record)list.get(list.size() - 1)).getLong("codeId");
                                list.forEach(record -> {
                                    String formula = record.getStr("descLong");
                                    record.set("descLongFineTerm", (Object)formula);
                                    record.set("descLongPretreatMin", (Object)formula);
                                    if (!CommTools.strIsEmpty((String)formula)) {
                                        Pattern pattern = Pattern.compile("[\\d.]+\\w*(/[sht])*+(\\^\\d)*\\s*[xX]\\s*[\\d.]+\\w*(/[sht])*+(\\^\\d)*");
                                        Matcher matcher = pattern.matcher(formula);
                                        while (matcher.find()) {
                                            String subStr = matcher.group();
                                            formula = formula.replace(subStr, subStr.replaceAll("x", " ").replaceAll("X", " "));
                                        }
                                    }
                                    record.set("descLongPretreatMax", (Object)formula);
                                    record.set("l1_category_id", this.StrToList(record.getStr("l1_category_id")));
                                    record.set("l2_category_id", this.StrToList(record.getStr("l2_category_id")));
                                    record.set("l3_category_id", this.StrToList(record.getStr("l3_category_id")));
                                    record.set("l1_category_name", this.StrToList(record.getStr("l1_category_name")));
                                    record.set("l2_category_name", this.StrToList(record.getStr("l2_category_name")));
                                    record.set("l3_category_name", this.StrToList(record.getStr("l3_category_name")));
                                    record.set("category_mark", this.StrToList(record.getStr("category_mark")));
                                });
                                log.info("========\u7269\u6599\u7d22\u5f15\u6570\u636e\u5199\u5165es========" + i);
                                this.elasticsearchUtil.addAllTypeData(reqBO.getIndexSName(), list);
                            }
                        } else {
                            list = Db.use((String)"DATAPLAT").find("SELECT * FROM " + esIndexModel.getmName() + " where sku_id> " + maxId + " ORDER BY sku_id limit " + Integer.parseInt(batchSize));
                            if (list != null && list.size() > 0) {
                                maxId = ((Record)list.get(list.size() - 1)).getLong("sku_id");
                                this.handerSkuIndexData(list, nerOpen);
                                log.info("========\u5355\u54c1\u7d22\u5f15\u6570\u636e\u5199\u5165es========" + i);
                                this.elasticsearchUtil.addAllTypeData(reqBO.getIndexSName(), list);
                            }
                        }
                        if (list != null) {
                            syncedRecordsFact = list1 != null ? (syncedRecordsFact += list1.size()) : (syncedRecordsFact += list.size());
                            syncedRecords += list.size();
                        }
                    } else {
                        log.info("-------\u540c\u6b65\u4e2d\u65ad,\u672a\u83b7\u53d6\u5230\u9501\u6807\u8bc6");
                        throw new PauseException("\u540c\u6b65\u4e2d\u65ad");
                    }
                    long end = System.currentTimeMillis();
                    log.info("\u672c\u6b21\u8017\u65f6:{} ms", (Object)(end - begin));
                    int progress = (int)((double)syncedRecords / (double)allRecords * 100.0);
                    EsSyncRecord update = new EsSyncRecord(id, Integer.valueOf(syncedRecordsFact), Integer.valueOf(syncedRecords), progress + "%", new Date(), new Date(), maxId, Long.valueOf(end - begin));
                    this.esSyncRecordMapper.updateByPrimaryKeySelective(update);
                }
                EsIndex esIndexPO = new EsIndex(reqBO.getIndexSName(), ToOdpsCommConstant.syncStatus.STATUS_2);
                this.esIndexMapper.updateByPrimaryKeySelective(esIndexPO);
                log.info("-------\u540c\u6b65\u5b8c\u6210,\u91ca\u653e\u9501-------");
                JedisHelper.releaseDistributedLock((CacheClient)this.cacheClient, (String)("synch_esindex_lock_" + reqBO.getIndexSName()), null);
            }
            catch (PauseException e) {
                log.info("-------\u540c\u6b65\u4e2d\u65ad-----");
                EsIndex esIndexPO = new EsIndex(reqBO.getIndexSName(), ToOdpsCommConstant.syncStatus.STATUS_5);
                this.esIndexMapper.updateByPrimaryKeySelective(esIndexPO);
            }
            catch (Exception e) {
                e.printStackTrace();
                long end = System.currentTimeMillis();
                log.info("\u540c\u6b65\u5931\u8d25\uff0c\u672c\u6b21\u8017\u65f6:{} ms", (Object)(end - begin));
                EsSyncRecord update = new EsSyncRecord(id, Long.valueOf(end - begin), e.getMessage(), new Date(), new Date());
                this.esSyncRecordMapper.updateByPrimaryKeySelective(update);
                EsIndex esIndexPO = new EsIndex(reqBO.getIndexSName(), ToOdpsCommConstant.syncStatus.STATUS_3);
                this.esIndexMapper.updateByPrimaryKeySelective(esIndexPO);
                log.info("-------\u540c\u6b65\u5931\u8d25,\u91ca\u653e\u9501-------\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)e.getMessage());
                JedisHelper.releaseDistributedLock((CacheClient)this.cacheClient, (String)("synch_esindex_lock_" + reqBO.getIndexSName()), null);
            }
        });
        rMap.put("code", "0");
        rMap.put("msg", "success");
        return rMap;
    }

    private void validParams(ModelDataToEsReqBO reqBO) {
        if (reqBO.getmId() == null) {
            throw new ZTBusinessException("\u4e3b\u9898\u6a21\u578bid\u5fc5\u4f20");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getIndexSName())) {
            throw new ZTBusinessException("\u7d22\u5f15\u82f1\u6587\u540d\u79f0\u5fc5\u4f20");
        }
        if (reqBO.getiType() == null) {
            throw new ZTBusinessException("\u7d22\u5f15\u7c7b\u578b\u5fc5\u4f20");
        }
    }

    public void pauseSyncTask(ModelDataToEsReqBO reqBO) throws ZTBusinessException {
        if (StringUtils.isEmpty((CharSequence)reqBO.getTaskId())) {
            throw new ZTBusinessException("\u6682\u505c\u4efb\u52a1\u5931\u8d25\uff0c\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!this.isLocked(this.cacheClient.getJedisPool().getResource(), reqBO.getIndexSName())) {
            throw new ZTBusinessException("\u4efb\u52a1\u5df2\u6682\u505c\uff0c\u53ef\u80fd\u4f1a\u6709\u5ef6\u8fdf\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5\uff01");
        }
        log.info("-------\u6682\u505c\u540c\u6b65\u4efb\u52a1,\u91ca\u653e\u9501-------");
        JedisHelper.releaseDistributedLock((CacheClient)this.cacheClient, (String)("synch_esindex_lock_" + reqBO.getIndexSName()), null);
        EsIndex esIndexPO = new EsIndex(reqBO.getIndexSName(), ToOdpsCommConstant.syncStatus.STATUS_4);
        this.esIndexMapper.updateByPrimaryKeySelective(esIndexPO);
        EsIndexLogPO logPO = new EsIndexLogPO(reqBO.getIndexSName(), CONST.OP_INDEX_TYPE_5, new Date(), reqBO.getUserId(), reqBO.getUsername());
        this.esSyncRecordMapper.insertEsIndexLogSelective(logPO);
    }

    private boolean isLocked(Jedis jedis, String indexName) {
        boolean isLocked = jedis.exists("synch_esindex_lock_" + indexName);
        jedis.close();
        return isLocked;
    }

    public void flushEsIndex(final ModelDataToEsReqBO reqBO) throws ZTBusinessException {
        if (StringUtils.isEmpty((CharSequence)reqBO.getIndexSName())) {
            throw new ZTBusinessException("\u7d22\u5f15\u82f1\u6587\u540d\u79f0\u5fc5\u4f20");
        }
        Boolean flag = JedisHelper.tryGetDistributedLock((CacheClient)this.cacheClient, (String)("flush_esindex_lock_" + reqBO.getIndexSName()), (Boolean)false, null);
        if (!flag.booleanValue()) {
            log.error("\u7d22\u5f15\u5237\u65b0\u4efb\u52a1\u8fdb\u884c\u4e2d\uff0c\u76f4\u63a5\u8fd4\u56de");
            throw new ZTBusinessException("\u7d22\u5f15\u5237\u65b0\u4efb\u52a1\u8fdb\u884c\u4e2d\uff0c\u8bf7\u67e5\u770b\u5237\u65b0\u8fdb\u5ea6\u540e\u91cd\u8bd5\uff01");
        }
        final String taskId = this.elasticsearchUtil.flushIndex(reqBO.getIndexSName());
        Long id = CodeUtil.generateTableCode();
        final EsSyncRecord esSyncRecordPO = new EsSyncRecord(id, reqBO.getIndexSName(), taskId, new Date(), new Date(), new Date(), ToOdpsCommConstant.esTaskType.STATUS_1);
        esSyncRecordPO.setTotal(Integer.valueOf(1));
        esSyncRecordPO.setCompleted(Integer.valueOf(0));
        esSyncRecordPO.setProgress("0%");
        this.esSyncRecordMapper.insertSelective(esSyncRecordPO);
        EsIndexLogPO logPO = new EsIndexLogPO(id, reqBO.getIndexSName(), CONST.OP_INDEX_TYPE_8, new Date(), reqBO.getUserId(), reqBO.getUsername());
        this.esSyncRecordMapper.insertEsIndexLogSelective(logPO);
        CompletableFuture<Void> future = CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
                int firstFlushCount = 0;
                Boolean flag = true;
                while (flag.booleanValue()) {
                    Map map = ESIndexSyncServiceImpl.this.elasticsearchUtil.getFlushIndexStatus(taskId);
                    log.info("\u67e5\u8be2\u7d22\u5f15\u5237\u65b0\u8fdb\u5ea6\u51fa\u53c2\uff1a{}", (Object)map);
                    if (map != null) {
                        if (map.get("completed") != null && Boolean.parseBoolean(map.get("completed").toString())) {
                            flag = false;
                            esSyncRecordPO.setFinishTime(new Date());
                        }
                        if (map.get("total") != null) {
                            esSyncRecordPO.setTotal(Integer.valueOf(Integer.parseInt(map.get("total").toString())));
                        }
                        Integer completed = 0;
                        if (map.get("updated") != null) {
                            completed = completed + Integer.parseInt(map.get("updated").toString());
                        }
                        if (map.get("created") != null) {
                            completed = completed + Integer.parseInt(map.get("created").toString());
                        }
                        if (map.get("deleted") != null) {
                            completed = completed + Integer.parseInt(map.get("deleted").toString());
                        }
                        if (firstFlushCount < 1) {
                            firstFlushCount = completed;
                        }
                        esSyncRecordPO.setCompleted(completed);
                        if (!flag.booleanValue() && esSyncRecordPO.getTotal() != null && completed < esSyncRecordPO.getTotal()) {
                            esSyncRecordPO.setExMessage("es\u6267\u884c\u5931\u8d25\uff01");
                        }
                        if (esSyncRecordPO.getTotal() != null) {
                            DecimalFormat decimalFormat = new DecimalFormat();
                            decimalFormat.applyPattern("0.00");
                            decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
                            esSyncRecordPO.setProgress(decimalFormat.format((float)completed.intValue() * 100.0f / (float)esSyncRecordPO.getTotal().intValue()) + "%");
                        }
                    } else {
                        flag = false;
                        esSyncRecordPO.setFinishTime(new Date());
                        if (esSyncRecordPO.getTotal() != null && esSyncRecordPO.getCompleted() != null) {
                            if (firstFlushCount * 2 < esSyncRecordPO.getTotal() - esSyncRecordPO.getCompleted()) {
                                esSyncRecordPO.setExMessage("es\u6267\u884c\u5931\u8d25\uff01");
                            } else {
                                esSyncRecordPO.setProgress("100%");
                                esSyncRecordPO.setCompleted(esSyncRecordPO.getTotal());
                            }
                        } else {
                            esSyncRecordPO.setExMessage("es\u6267\u884c\u5931\u8d25\uff01");
                        }
                        if (CommTools.strIsEmpty((String)esSyncRecordPO.getProgress())) {
                            esSyncRecordPO.setProgress("0.00%");
                        }
                    }
                    esSyncRecordPO.setUpdateTime(new Date());
                    if (!flag.booleanValue() && esSyncRecordPO.getStartTime() != null && esSyncRecordPO.getFinishTime() != null) {
                        esSyncRecordPO.setExTime(DateUtil.getDatePoor((Date)esSyncRecordPO.getStartTime(), (Date)esSyncRecordPO.getFinishTime(), (Integer)4));
                    }
                    ESIndexSyncServiceImpl.this.esSyncRecordMapper.updateByPrimaryKeySelective(esSyncRecordPO);
                    if (flag.booleanValue()) {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (Exception e) {
                            log.error(e.getMessage());
                        }
                        continue;
                    }
                    JedisHelper.releaseDistributedLock((CacheClient)ESIndexSyncServiceImpl.this.cacheClient, (String)("flush_esindex_lock_" + reqBO.getIndexSName()), null);
                }
            }
        });
    }

    public FlushEsIndexRsqBO getFlushEsIndexProgress(ModelDataToEsReqBO reqBO) throws ZTBusinessException {
        FlushEsIndexRsqBO rsqBO = new FlushEsIndexRsqBO();
        if (StringUtils.isEmpty((CharSequence)reqBO.getIndexSName())) {
            throw new ZTBusinessException("\u7d22\u5f15\u82f1\u6587\u540d\u79f0\u5fc5\u4f20");
        }
        EsSyncRecord recordPO = this.esSyncRecordMapper.getTaskId(reqBO.getIndexSName());
        if (recordPO == null || CommTools.strIsEmpty((String)recordPO.getTaskId())) {
            rsqBO.setStatus(Integer.valueOf(3));
        } else {
            rsqBO.setTaskId(recordPO.getTaskId());
            if (recordPO.getTotal() != null) {
                rsqBO.setTotal(recordPO.getTotal());
                rsqBO.setStatus(Integer.valueOf(0));
            }
            if (recordPO.getCompleted() != null) {
                rsqBO.setUpdated(recordPO.getCompleted());
                if (recordPO.getCompleted() < recordPO.getTotal()) {
                    if (!CommTools.strIsEmpty((String)recordPO.getExMessage())) {
                        rsqBO.setStatus(Integer.valueOf(2));
                    }
                } else {
                    rsqBO.setStatus(Integer.valueOf(1));
                }
            }
        }
        rsqBO.setCode("0");
        rsqBO.setMessage("\u67e5\u8be2\u6210\u529f\uff01");
        return rsqBO;
    }

    private List<Record> handerVectorIndexData(List<Record> list) throws Exception {
        ArrayList<Record> finalList = new ArrayList();
        Long seChannelType = (Long)this.cacheClient.get("{SEARCH}_DEFAULT_CHANNEL_TYPE");
        try {
            String sentencesMaxSize = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)seChannelType)).elasticsearchVectorSentencesMaxSize;
            if (list.size() <= Integer.parseInt(sentencesMaxSize)) {
                finalList = this.syncVector(list);
            } else {
                for (int i = 0; i < list.size(); i += Integer.parseInt(sentencesMaxSize)) {
                    int end = Math.min(i + Integer.parseInt(sentencesMaxSize), list.size());
                    List<Record> subList = list.subList(i, end);
                    List<Record> fList = this.syncVector(subList);
                    finalList.addAll(fList);
                }
            }
        }
        catch (Exception e) {
            throw new Exception("\u6570\u636e\u5411\u91cf\u5316\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
        }
        return finalList;
    }

    private void handerSkuIndexData(List<Record> list, Boolean nerOpen) {
        int end = 0;
        int start = 0;
        Long seChannelType = (Long)this.cacheClient.get("{SEARCH}_DEFAULT_CHANNEL_TYPE");
        String sentencesMaxSize = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)seChannelType)).elasticsearchVectorSentencesMaxSize;
        while (end < list.size()) {
            start = end;
            end = end + Integer.parseInt(sentencesMaxSize) > list.size() ? list.size() : (end += Integer.parseInt(sentencesMaxSize));
            List<Record> subList = list.subList(start, end);
            try {
                ArrayList<String> skuNameList = new ArrayList<String>();
                for (Record record : subList) {
                    skuNameList.add(record.getStr("sku_name"));
                }
                List<Set<String>> nerCatelogList = null;
                if (nerOpen.booleanValue()) {
                    nerCatelogList = this.getNerCatelog(skuNameList);
                }
                for (int i = 0; i < subList.size(); ++i) {
                    Record record = subList.get(i);
                    record.set("l1_category_id", this.StrToList(record.getStr("l1_category_id")));
                    record.set("l2_category_id", this.StrToList(record.getStr("l2_category_id")));
                    record.set("l3_category_id", this.StrToList(record.getStr("l3_category_id")));
                    record.set("channel_id", this.StrToLongList(record.getStr("channel_id")));
                    record.set("l1_category_name", this.StrToList(record.getStr("l1_category_name")));
                    record.set("l2_category_name", this.StrToList(record.getStr("l2_category_name")));
                    record.set("l3_category_name", this.StrToList(record.getStr("l3_category_name")));
                    record.set("channel_Name", this.StrToList(record.getStr("channel_Name")));
                    try {
                        record.set("ner_category_name", (Object)(nerCatelogList == null || nerCatelogList.get(i) == null || nerCatelogList.get(i).size() < 1 ? "" : nerCatelogList.get(i).stream().collect(Collectors.joining(","))));
                        continue;
                    }
                    catch (Exception e) {
                        log.error("RaNER\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff0cerr:{}", (Object)e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ZTBusinessException("\u5355\u54c1\u7d22\u5f15\u6570\u636e\u8f6c\u6570\u7ec4\u5931\u8d25");
            }
        }
    }

    private List<Long> StrToLongList(String str) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (!CommTools.strIsEmpty((String)str)) {
            String[] strArr;
            for (String s : strArr = str.split(",")) {
                list.add(Long.valueOf(s));
            }
        }
        return list;
    }

    private List<String> StrToList(String str) {
        List<String> list = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)str)) {
            list = Arrays.asList(str.split(","));
        }
        return list;
    }

    private List<Record> syncVector(List<Record> list) throws Exception {
        ArrayList vectorStrList = new ArrayList();
        list.forEach(esVectorBO -> vectorStrList.add(esVectorBO.getStr("commodity_name")));
        JSONObject param = new JSONObject();
        param.put("sentences", vectorStrList);
        String url = null;
        Long seChannelType = (Long)this.cacheClient.get("{SEARCH}_DEFAULT_CHANNEL_TYPE");
        try {
            url = ((SearchProcessConfig.VectorConfig)this.searchProcessConfig.getVector().get((Object)seChannelType)).searchVectorUrl;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5546\u54c1\u53d8\u66f4\u4fe1\u606f\u5411\u91cf\u5316url\u5931\u8d25\uff0cerr:{}", (Object)e.getMessage());
        }
        if (CommTools.strIsEmpty((String)url)) {
            log.error("\u5546\u54c1\u53d8\u66f4\u4fe1\u606f\u5411\u91cf\u5316url\u672a\u914d\u7f6e");
            return null;
        }
        log.info("=====\u5546\u54c1\u53d8\u66f4\u4fe1\u606f\u5411\u91cf\u5316\u8bf7\u6c42\u5f00\u59cb======url\uff1a" + url);
        String result = HttpRequestUtils.doPost((String)url, (String)param.toJSONString());
        log.debug("======\u5546\u54c1\u53d8\u66f4\u4fe1\u606f\u5411\u91cf\u5316\u8bf7\u6c42\u7ed3\u675f=======");
        if (!CommTools.strIsEmpty((String)result)) {
            VectorRspBO vectorRspBO = (VectorRspBO)JSONObject.parseObject((String)result, VectorRspBO.class);
            if ("0".equals(vectorRspBO.getCode()) && vectorRspBO.getData() != null && vectorRspBO.getData().getEmbeddings() != null && vectorRspBO.getData().getEmbeddings().size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    List vectorList = (List)vectorRspBO.getData().getEmbeddings().get(i);
                    List floats = vectorList.stream().map(Float::parseFloat).collect(Collectors.toList());
                    list.get(i).set("commodity_name_emberdding", floats);
                    list.get(i).set("ner_category_name", (Object)"");
                }
                return list;
            }
            log.error("\u5546\u54c1\u53d8\u66f4\u4fe1\u606f\u5411\u91cf\u5316\u8bf7\u6c42\u5931\u8d25\uff0cresult:{}", (Object)result);
            throw new Exception("\u5546\u54c1\u53d8\u66f4\u4fe1\u606f\u5411\u91cf\u5316\u8bf7\u6c42\u5931\u8d25");
        }
        log.error("\u5546\u54c1\u53d8\u66f4\u4fe1\u606f\u5411\u91cf\u5316\u8bf7\u6c42\u8fd4\u56de\u4e3a\u7a7a\uff01");
        throw new Exception("\u5546\u54c1\u53d8\u66f4\u4fe1\u606f\u5411\u91cf\u5316\u8bf7\u6c42\u8fd4\u56de\u4e3a\u7a7a\uff01");
    }

    private void writeMilvus(String indexSName, List<Record> list) throws Exception {
        ArrayList<Long> updateCommodityIdList = new ArrayList<Long>();
        ArrayList<String> updateL3CatelogIdList = new ArrayList<String>();
        ArrayList<String> updateCommodityNameList = new ArrayList<String>();
        ArrayList<String> updateL3CatelogNameList = new ArrayList<String>();
        ArrayList<String> updateNerCategoryNameList = new ArrayList<String>();
        ArrayList<List> updateCommodityNameEmberddingList = new ArrayList<List>();
        ArrayList<Long> updateSkuIdList = new ArrayList<Long>();
        for (Record record : list) {
            updateSkuIdList.add(record.getLong("sku_id"));
            updateCommodityIdList.add(record.getLong("commodity_id"));
            updateCommodityNameList.add(record.getStr("commodity_name"));
            if (!CommTools.strIsEmpty((String)record.getStr("l3_category_id"))) {
                updateL3CatelogIdList.add(record.getStr("l3_category_id"));
            } else {
                updateL3CatelogIdList.add("");
            }
            if (!CommTools.strIsEmpty((String)record.getStr("l3_category_name"))) {
                updateL3CatelogNameList.add(record.getStr("l3_category_name"));
            } else {
                updateL3CatelogNameList.add("");
            }
            if (!CommTools.strIsEmpty((String)record.getStr("ner_category_name"))) {
                updateNerCategoryNameList.add(record.getStr("ner_category_name"));
            } else {
                updateNerCategoryNameList.add("");
            }
            List floatList = (List)record.get("commodity_name_emberdding");
            updateCommodityNameEmberddingList.add(floatList);
        }
        if (updateSkuIdList != null && updateSkuIdList.size() > 0) {
            String expr = " sku_id in [" + updateSkuIdList.stream().map(Object::toString).collect(Collectors.joining(",")) + "]";
            R resultR = this.milvusServiceClient.delete(DeleteParam.newBuilder().withCollectionName(indexSName).withExpr(expr).build());
            if (resultR.getStatus() != 0 && !resultR.getMessage().contains("Thread interrupted")) {
                throw new Exception("\u6279\u91cf\u5220\u9664milvus\u6570\u636e\u5931\u8d25\uff1a" + resultR.getMessage());
            }
            log.info("\u5220\u9664milvus\u5411\u91cf\u5e93\u6570\u636e\u72b6\u6001\u7801:{}", (Object)resultR.getStatus());
        }
        ArrayList<InsertParam.Field> fields = new ArrayList<InsertParam.Field>();
        fields.add(new InsertParam.Field("sku_id", updateSkuIdList));
        fields.add(new InsertParam.Field("commodity_id", updateCommodityIdList));
        fields.add(new InsertParam.Field("commodity_name", updateCommodityNameList));
        fields.add(new InsertParam.Field("l3_category_id", updateL3CatelogIdList));
        fields.add(new InsertParam.Field("l3_category_name", updateL3CatelogNameList));
        fields.add(new InsertParam.Field("ner_category_name", updateNerCategoryNameList));
        fields.add(new InsertParam.Field("commodity_name_emberdding", updateCommodityNameEmberddingList));
        InsertParam insertParam = InsertParam.newBuilder().withCollectionName(indexSName).withFields(fields).build();
        R resultR = this.milvusServiceClient.insert(insertParam);
        if (resultR.getStatus() != 0 && !resultR.getMessage().contains("Thread interrupted")) {
            throw new Exception("\u6279\u91cf\u6dfb\u52a0milvus\u6570\u636e\u5931\u8d25\uff1a" + resultR.getMessage());
        }
        log.info("\u6570\u636e\u5199\u5165milvus\u5411\u91cf\u5e93\u72b6\u6001\u7801:{}", (Object)resultR.getStatus());
    }

    private List<Set<String>> getNerCatelog(List<String> skuNameList) {
        try {
            ArrayList<Set<String>> nerCatelogList = new ArrayList<Set<String>>();
            Long seChannelType = (Long)this.cacheClient.get("{SEARCH}_DEFAULT_CHANNEL_TYPE");
            String url = ((SearchProcessConfig.VectorConfig)this.searchProcessConfig.getVector().get((Object)seChannelType)).searchRanerUrl;
            if (!CommTools.strIsEmpty((String)url)) {
                JSONObject output;
                int j;
                JSONObject result;
                JSONObject params = new JSONObject();
                params.put("prompt", skuNameList);
                params.put("batch", (Object)(skuNameList.size() == 1 ? 2 : skuNameList.size()));
                log.info("RaNER\u7c97\u7c92\u5ea6\u63a5\u53e3\u8bf7\u6c42\u5f00\u59cb\uff1aurl:{},params:{}", (Object)url, (Object)params);
                String coarseGrainedStr = HttpRequestUtils.doPost((String)url, (String)params.toJSONString());
                log.info("RaNER\u7c97\u7c92\u5ea6\u63a5\u53e3\u8bf7\u6c42\u7ed3\u675f\uff1aresult:{}", (Object)coarseGrainedStr);
                if (!CommTools.strIsEmpty((String)coarseGrainedStr) && "0".equals((result = JSONObject.parseObject((String)coarseGrainedStr)).getString("code")) && !"{}".equals(result.getString("data")) && result.getJSONArray("data") != null && result.getJSONArray("data").size() > 0) {
                    JSONArray data = result.getJSONArray("data");
                    for (int i = 0; i < data.size(); ++i) {
                        JSONObject d = data.getJSONObject(i);
                        HashSet<String> dataSet = new HashSet<String>();
                        if (d.getJSONArray("output") != null && d.getJSONArray("output").size() > 0) {
                            for (j = 0; j < d.getJSONArray("output").size(); ++j) {
                                output = d.getJSONArray("output").getJSONObject(j);
                                if (!"HC".equals(output.getString("type"))) continue;
                                dataSet.add(output.getString("span"));
                            }
                        }
                        nerCatelogList.add(dataSet);
                    }
                }
                if (url.endsWith("january")) {
                    JSONObject result2;
                    url = url.replace("january", "february");
                    log.info("RaNER\u7ec6\u7c92\u5ea6\u63a5\u53e3\u8bf7\u6c42\u5f00\u59cb\uff1aurl:{},params:{}", (Object)url, (Object)params);
                    String fineGrainedStr = HttpRequestUtils.doPost((String)url, (String)params.toJSONString());
                    log.info("RaNER\u7ec6\u7c92\u5ea6\u63a5\u53e3\u8bf7\u6c42\u7ed3\u675f\uff1aresult:{}", (Object)fineGrainedStr);
                    if (!CommTools.strIsEmpty((String)fineGrainedStr) && "0".equals((result2 = JSONObject.parseObject((String)fineGrainedStr)).getString("code")) && !"{}".equals(result2.getString("data")) && result2.getJSONArray("data") != null && result2.getJSONArray("data").size() > 0) {
                        JSONArray data = result2.getJSONArray("data");
                        for (int i = 0; i < data.size(); ++i) {
                            JSONObject d = data.getJSONObject(i);
                            if (d.getJSONArray("output") == null || d.getJSONArray("output").size() <= 0) continue;
                            for (j = 0; j < d.getJSONArray("output").size(); ++j) {
                                output = d.getJSONArray("output").getJSONObject(j);
                                if (!"\u4ea7\u54c1_\u6838\u5fc3\u4ea7\u54c1".equals(output.getString("type"))) continue;
                                ((Set)nerCatelogList.get(i)).add(output.getString("span"));
                            }
                        }
                    }
                }
            }
            return nerCatelogList;
        }
        catch (Exception e) {
            log.error("ner\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff0cerr:{}", (Object)e.getMessage());
            return null;
        }
    }

    @PreDestroy
    public void onShutdown() {
        Set synchLockKeys;
        Set lockKeys = this.cacheClient.getkeys("flush_esindex_lock*");
        if (lockKeys != null && lockKeys.size() > 0) {
            lockKeys.forEach(lockKey2 -> JedisHelper.releaseDistributedLock((CacheClient)this.cacheClient, (String)lockKey2, null));
        }
        if ((synchLockKeys = this.cacheClient.getkeys("synch_esindex_lock*")) != null && synchLockKeys.size() > 0) {
            synchLockKeys.forEach(lockKey2 -> JedisHelper.releaseDistributedLock((CacheClient)this.cacheClient, (String)lockKey2, null));
        }
    }
}

