/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.base.constant.ToOdpsCommConstant;
import com.tydic.se.base.dao.EsIndexTemplateMapper;
import com.tydic.se.base.dao.po.EsIndexTemplate;
import com.tydic.se.es.util.ElasticsearchUtil;
import com.tydic.se.manage.api.ESIndexSyncService;
import com.tydic.se.manage.api.ESIndexTemplateService;
import com.tydic.se.manage.bo.CreateEsIndexReqBO;
import com.tydic.se.manage.bo.ESIndexTemplateReqBO;
import com.tydic.se.manage.bo.ESIndexTemplateRspBO;
import com.tydic.se.manage.bo.ModelDataToEsReqBO;
import com.tydic.se.manage.bo.SyncTaskReTryReqBO;
import com.tydic.se.manage.util.MilvusUtil;
import com.tydic.se.search.config.SearchProcessConfig;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;

@Service
public class ESIndexTemplateServiceImpl
implements ESIndexTemplateService {
    private static final Logger log = LoggerFactory.getLogger(ESIndexTemplateServiceImpl.class);
    @Autowired
    private EsIndexTemplateMapper esIndexTemplateMapper;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private ESIndexSyncService esIndexSyncService;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private SearchProcessConfig searchProcessConfig;

    public ESIndexTemplateRspBO selectESIndexTemplate(ESIndexTemplateReqBO reqBO) throws ZTBusinessException {
        if (reqBO.getTType() == null) {
            throw new ZTBusinessException("\u67e5\u8be2\u7d22\u5f15\u6a21\u677f\u5931\u8d25");
        }
        ESIndexTemplateRspBO rspBO = new ESIndexTemplateRspBO();
        EsIndexTemplate po = this.esIndexTemplateMapper.selectBytType(reqBO.getTType(), reqBO.getSeChannelType());
        BeanUtils.copyProperties((Object)po, (Object)rspBO);
        return rspBO;
    }

    public void createEsIndex(CreateEsIndexReqBO reqBO) throws ZTBusinessException {
        this.validParams(reqBO);
    }

    public void syncTaskReTry(SyncTaskReTryReqBO reqBO) throws ZTBusinessException {
        log.info("\u6570\u636e\u540c\u6b65\u91cd\u8dd1\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        if (reqBO.getmId() == null) {
            throw new ZTBusinessException("\u4e3b\u9898\u6a21\u578bid\u5fc5\u4f20");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getIndexSName())) {
            throw new ZTBusinessException("\u7d22\u5f15\u82f1\u6587\u540d\u79f0\u5fc5\u4f20");
        }
        if (reqBO.getiType() == null) {
            throw new ZTBusinessException("\u7d22\u5f15\u7c7b\u578b\u5fc5\u4f20");
        }
        EsIndexTemplate bo = this.esIndexTemplateMapper.selectBytType(reqBO.getiType(), reqBO.getSeChannelType());
        if (bo == null || StringUtils.isEmpty((CharSequence)bo.getIndexConfig())) {
            throw new ZTBusinessException("\u7d22\u5f15\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        boolean synchLocked = this.isLocked(this.cacheClient.getJedisPool().getResource(), "synch_esindex_lock", reqBO.getIndexSName());
        if (synchLocked) {
            throw new ZTBusinessException("\u6709\u6b63\u5728\u8fd0\u884c\u4e2d\u7684\u540c\u6b65\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
        boolean flushLocked = this.isLocked(this.cacheClient.getJedisPool().getResource(), "flush_esindex_lock", reqBO.getIndexSName());
        if (flushLocked) {
            throw new ZTBusinessException("\u6709\u6b63\u5728\u8fd0\u884c\u4e2d\u7684\u5237\u65b0\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
        if (ToOdpsCommConstant.esType.TYPE_5.equals(reqBO.getiType())) {
            Boolean isMiSuccess = MilvusUtil.delCollect((String)reqBO.getIndexSName());
            if (!isMiSuccess.booleanValue()) {
                throw new ZTBusinessException("\u5220\u9664milvus\u96c6\u5408\u5931\u8d25\uff01");
            }
            Boolean createMiSuccess = MilvusUtil.createCollect((String)bo.getIndexConfig(), (String)reqBO.getIndexSName());
            if (!createMiSuccess.booleanValue()) {
                throw new ZTBusinessException("\u521b\u5efamilvus\u96c6\u5408\u5931\u8d25\uff01");
            }
        } else {
            Boolean isSuccess = this.elasticsearchUtil.delIndex(reqBO.getIndexSName());
            if (!isSuccess.booleanValue()) {
                throw new ZTBusinessException("\u5220\u9664es\u7d22\u5f15\u5931\u8d25\uff01");
            }
            Long seChannelType = (Long)this.cacheClient.get("{SEARCH}_DEFAULT_CHANNEL_TYPE");
            String httpUrl = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)seChannelType)).httpDomain;
            bo.setIndexConfig(StringUtils.isEmpty((CharSequence)bo.getIndexConfig()) ? "" : bo.getIndexConfig().replace("${url}", httpUrl));
            Boolean createSuccess = this.elasticsearchUtil.createIndex(reqBO.getIndexSName(), bo.getIndexConfig());
            if (!createSuccess.booleanValue()) {
                throw new ZTBusinessException("\u521b\u5efaes\u7d22\u5f15\u5931\u8d25\uff01");
            }
        }
        ModelDataToEsReqBO toEsReqBO = new ModelDataToEsReqBO();
        toEsReqBO.setIndexSName(reqBO.getIndexSName());
        toEsReqBO.setiType(reqBO.getiType());
        toEsReqBO.setmId(reqBO.getmId());
        toEsReqBO.setFlag(Integer.valueOf(1));
        toEsReqBO.setUserId(reqBO.getUserId());
        toEsReqBO.setUsername(reqBO.getUsername());
        toEsReqBO.setAppId(reqBO.getAppId());
        toEsReqBO.setComFlag(reqBO.getComFlag());
        this.esIndexSyncService.modelDataToEsSynchronizer(toEsReqBO);
    }

    private boolean isLocked(Jedis jedis, String lockkey, String indexName) {
        boolean isLocked = jedis.exists(lockkey + "_" + indexName);
        jedis.close();
        return isLocked;
    }

    private void validParams(CreateEsIndexReqBO reqBO) {
    }
}

