/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.se.manage.api.EffectEvaluationService;
import com.tydic.se.manage.bo.EffectEvaluationRecordBO;
import com.tydic.se.manage.bo.EffectEvaluationRecordProgressRspBO;
import com.tydic.se.manage.bo.EffectEvaluationRecordReqBO;
import com.tydic.se.manage.bo.EffectEvaluationRecordRspBO;
import com.tydic.se.manage.bo.EffectEvaluationWordRecordReqBO;
import com.tydic.se.manage.bo.EffectEvaluationWordRecordRspBO;
import com.tydic.se.manage.dao.SearchEvaluationRecordMapper;
import com.tydic.se.manage.dao.SearchEvaluationWordRecordMapper;
import com.tydic.se.manage.dao.po.SearchEvaluationRecord;
import com.tydic.se.manage.dao.po.SearchEvaluationWordRecord;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EffectEvaluationServiceImpl
implements EffectEvaluationService {
    private static final Logger log = LoggerFactory.getLogger(EffectEvaluationServiceImpl.class);
    @Autowired
    private SearchEvaluationRecordMapper searchEvaluationRecordMapper;
    @Autowired
    private SearchEvaluationWordRecordMapper searchEvaluationWordRecordMapper;

    public EffectEvaluationRecordRspBO queryEffectEvaluationRecordList(EffectEvaluationRecordReqBO reqBO) throws ZTBusinessException {
        List rspList;
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        EffectEvaluationRecordRspBO rspBO = new EffectEvaluationRecordRspBO();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        try {
            rspList = this.searchEvaluationRecordMapper.queryEffectEvaluationRecordList(page, reqBO);
            if (rspList != null && rspList.size() > 0) {
                for (EffectEvaluationRecordBO bo : rspList) {
                    if (bo.getEvalWTotal() == null) {
                        bo.setProgress("\u65e0");
                        continue;
                    }
                    if (bo.getEvalCompleteTotal() == null || bo.getEvalWTotal() == 0) {
                        bo.setProgress("0%");
                        continue;
                    }
                    BigDecimal bia = new BigDecimal(bo.getEvalWTotal());
                    BigDecimal bib = new BigDecimal(bo.getEvalCompleteTotal());
                    String res = bib.divide(bia, 2, 4).multiply(new BigDecimal(100)).toString() + "%";
                    bo.setProgress(res);
                }
            }
        }
        catch (Exception e) {
            log.error("queryEffectEvaluationRecordList========>qry\u67e5\u8be2\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u67e5\u8be2\u5217\u8868\u5931\u8d25");
        }
        rspBO.setRows(rspList);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        return rspBO;
    }

    public EffectEvaluationRecordProgressRspBO queryEvaluationProgress(EffectEvaluationRecordReqBO reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        EffectEvaluationRecordProgressRspBO rspBO = new EffectEvaluationRecordProgressRspBO();
        if (reqBO.getEvalId() == null) {
            throw new ZTBusinessException("evalId\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        try {
            SearchEvaluationRecord bo = this.searchEvaluationRecordMapper.selectByPrimaryKey(reqBO.getEvalId());
            if (bo != null) {
                if (bo.getEvalWTotal() == null || bo.getEvalCompleteTotal() == null) {
                    rspBO.setProgress(Integer.valueOf(0));
                } else if (bo.getEvalWTotal() == 0) {
                    rspBO.setProgress(Integer.valueOf(0));
                } else {
                    BigDecimal bia = new BigDecimal(bo.getEvalWTotal());
                    BigDecimal bib = new BigDecimal(bo.getEvalCompleteTotal());
                    Integer res = bib.divide(bia, 2, 4).multiply(new BigDecimal(100)).intValue();
                    rspBO.setEvalCompleteTotal(bo.getEvalCompleteTotal());
                    rspBO.setEvalWTotal(bo.getEvalWTotal());
                    rspBO.setProgress(res);
                }
            }
        }
        catch (Exception e) {
            log.error("queryEffectEvaluationRecordList========>qry\u67e5\u8be2\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u67e5\u8be2\u8fdb\u5ea6\u5931\u8d25");
        }
        return rspBO;
    }

    public EffectEvaluationWordRecordRspBO queryEvaluationWordInfoList(EffectEvaluationWordRecordReqBO reqBO) throws ZTBusinessException {
        List rspList;
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        EffectEvaluationWordRecordRspBO rspBO = new EffectEvaluationWordRecordRspBO();
        if (reqBO.getEvalId() == null) {
            throw new ZTBusinessException("evalId\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        try {
            SearchEvaluationWordRecord record = new SearchEvaluationWordRecord();
            record.setEvalId(reqBO.getEvalId());
            record.setEvalWord(reqBO.getEvalWord());
            rspList = this.searchEvaluationWordRecordMapper.queryEvaluationWordList(record);
        }
        catch (Exception e) {
            log.error("queryEvaluationWordInfoList========>qry\u67e5\u8be2\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u67e5\u8be2\u8be6\u60c5\u5931\u8d25");
        }
        rspBO.setBoList(rspList);
        return rspBO;
    }

    public EffectEvaluationWordRecordRspBO queryWResponseJsonStr(EffectEvaluationWordRecordReqBO reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        EffectEvaluationWordRecordRspBO rspBO = new EffectEvaluationWordRecordRspBO();
        if (reqBO.getEvalWId() == null) {
            throw new ZTBusinessException("evalWId\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        try {
            SearchEvaluationWordRecord record = this.searchEvaluationWordRecordMapper.selectByPrimaryKey(reqBO.getEvalWId());
            if (record != null) {
                rspBO.setEvalWResponse((Object)JSONObject.parseObject((String)record.getEvalWResponse()));
            }
        }
        catch (Exception e) {
            log.error("queryEvaluationWordInfoList========>qry\u67e5\u8be2\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u67e5\u8be2\u6d4b\u8bc4\u8bb0\u5f55\u7ed3\u679c\u5931\u8d25");
        }
        return rspBO;
    }
}

