/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.impl;

import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.se.manage.api.MaterialService;
import com.tydic.se.manage.bo.MaterialBatchReqBO;
import com.tydic.se.manage.bo.MaterialBatchSearchRecordBO;
import com.tydic.se.manage.bo.MaterialSearchInfoBO;
import com.tydic.se.manage.dao.SearchMaterialBatchRecordMapper;
import com.tydic.se.manage.dao.SearchMaterialBatchWordRecordMapper;
import com.tydic.se.manage.dao.po.SearchMaterialBatchRecord;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MaterialServiceImpl
implements MaterialService {
    private static final Logger log = LoggerFactory.getLogger(MaterialServiceImpl.class);
    @Autowired
    private SearchMaterialBatchRecordMapper searchMaterialBatchRecordDao;
    @Autowired
    private SearchMaterialBatchWordRecordMapper searchMaterialBatchWordRecordDao;

    public RspPage<MaterialBatchSearchRecordBO> queryBatchRecordList(MaterialBatchReqBO reqBO) throws ZTBusinessException {
        List rspList;
        log.info("\u67e5\u8be2\u7269\u6599\u6279\u91cf\u641c\u7d22\u8bb0\u5f55\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO);
        RspPage rspBO = new RspPage();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        try {
            rspList = this.searchMaterialBatchRecordDao.queryPage(page, reqBO);
            if (rspList != null && rspList.size() > 0) {
                for (MaterialBatchSearchRecordBO bo : rspList) {
                    if (bo.getBatchWTotal() == null) {
                        bo.setProgress("\u65e0");
                        continue;
                    }
                    if (bo.getBatchCompleteTotal() == null || bo.getBatchWTotal() == 0) {
                        bo.setProgress("0%");
                        continue;
                    }
                    BigDecimal bia = new BigDecimal(bo.getBatchWTotal());
                    BigDecimal bib = new BigDecimal(bo.getBatchCompleteTotal());
                    String res = bib.divide(bia, 2, 4).multiply(new BigDecimal(100)) + "%";
                    bo.setProgress(res);
                }
            }
        }
        catch (Exception e) {
            log.error("queryBatchRecordList========>qry\u67e5\u8be2\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u67e5\u8be2\u5217\u8868\u5931\u8d25");
        }
        rspBO.setRows(rspList);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        return rspBO;
    }

    public MaterialBatchSearchRecordBO queryBatchProgress(MaterialBatchReqBO reqBO) throws ZTBusinessException {
        log.info("\u67e5\u8be2\u7269\u6599\u6279\u91cf\u641c\u7d22\u8fdb\u5ea6\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO);
        if (reqBO.getBatchId() == null) {
            throw new ZTBusinessException("batchId\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SearchMaterialBatchRecord searchMaterialBatchRecord = this.searchMaterialBatchRecordDao.selectByPrimaryKey(reqBO.getBatchId());
        if (searchMaterialBatchRecord == null) {
            throw new ZTBusinessException("\u6279\u91cf\u641c\u7d22\u4efb\u52a1\u4e0d\u5b58\u5728\uff01");
        }
        MaterialBatchSearchRecordBO rspBO = new MaterialBatchSearchRecordBO();
        BeanUtils.copyProperties((Object)searchMaterialBatchRecord, (Object)rspBO);
        if (rspBO.getBatchWTotal() == null || rspBO.getBatchCompleteTotal() == null) {
            rspBO.setProgress("0");
        } else {
            BigDecimal bia = new BigDecimal(rspBO.getBatchWTotal());
            BigDecimal bib = new BigDecimal(rspBO.getBatchCompleteTotal());
            Integer res = bib.divide(bia, 2, 4).multiply(new BigDecimal(100)).intValue();
            rspBO.setProgress(res + "");
        }
        return rspBO;
    }

    public RspPage<MaterialSearchInfoBO> queryBatchInfo(MaterialBatchReqBO reqBO) throws ZTBusinessException {
        List rspList;
        log.info("\u67e5\u8be2\u7269\u6599\u6279\u91cf\u641c\u7d22\u7269\u6599\u4fe1\u606f\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO);
        if (reqBO.getBatchId() == null) {
            throw new ZTBusinessException("batchId\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        RspPage rspBO = new RspPage();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        try {
            rspList = this.searchMaterialBatchWordRecordDao.queryPage(page, reqBO);
        }
        catch (Exception e) {
            log.error("queryBatchInfo========>qry\u67e5\u8be2\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u67e5\u8be2\u6279\u91cf\u641c\u7d22\u8be6\u60c5\u5931\u8d25");
        }
        rspBO.setRows(rspList);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        return rspBO;
    }
}

