/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.se.base.ability.bo.OperLogPO;
import com.tydic.se.manage.api.OperLogService;
import com.tydic.se.manage.bo.SwapInsertOperLogReqBO;
import com.tydic.se.manage.bo.SwapInsertOperLogRspBO;
import com.tydic.se.manage.dao.OperLogDao;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OperLogServiceImpl
implements OperLogService {
    private static final Logger log = LoggerFactory.getLogger(OperLogServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(OperLogServiceImpl.class);
    @Autowired
    private OperLogDao operLogDao;

    public SwapInsertOperLogRspBO insertOperLog(SwapInsertOperLogReqBO reqBO) {
        try {
            logger.info("\u65e5\u5fd7\u5165\u53c2\u4fe1\u606f" + reqBO.toString());
            this.validateArg(reqBO);
            SwapInsertOperLogRspBO rspBO = new SwapInsertOperLogRspBO();
            OperLogPO operLogPO = new OperLogPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)operLogPO);
            if (null != reqBO.getUserId()) {
                operLogPO.setOperId(String.valueOf(reqBO.getUserId()));
            }
            if (null != reqBO.getOrgId()) {
                operLogPO.setOperDeptNo(String.valueOf(reqBO.getOrgId()));
            }
            operLogPO.setOperName(reqBO.getName());
            operLogPO.setOperDeptName(reqBO.getOrgName());
            if (StringUtils.isNotEmpty((CharSequence)reqBO.getRequestDate())) {
                operLogPO.setRequestDate(DateUtils.strToDate((String)reqBO.getRequestDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            operLogPO.setResponseDate(new Date());
            operLogPO.setOperMode(reqBO.getOperMode());
            int insert = this.operLogDao.insert(operLogPO);
            if (insert < 1) {
                rspBO.setCode("1");
                rspBO.setMessage("\u4e1a\u52a1\u5bf9\u8c61\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25\uff01");
                return rspBO;
            }
            rspBO.setCode("0");
            rspBO.setMessage("\u4e1a\u52a1\u5bf9\u8c61\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u6210\u529f\uff01");
            return rspBO;
        }
        catch (Exception e) {
            logger.error("\u4e1a\u52a1\u5bf9\u8c61\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25\uff01", (Throwable)e);
            throw new ZTBusinessException("\u4e1a\u52a1\u5bf9\u8c61\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25\uff01");
        }
    }

    private void validateArg(SwapInsertOperLogReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u4e1a\u52a1\u5bf9\u8c61\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5bf9\u8c61[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOperMode())) {
            throw new ZTBusinessException("\u4e1a\u52a1\u5bf9\u8c61\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u539f\u5b50\u670d\u52a1\u5165\u53c2\u64cd\u4f5c\u6a21\u5757[OperMode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperType()) {
            throw new ZTBusinessException("\u4e1a\u52a1\u5bf9\u8c61\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u539f\u5b50\u670d\u52a1\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b[OperType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperContent()) {
            throw new ZTBusinessException("\u4e1a\u52a1\u5bf9\u8c61\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u539f\u5b50\u670d\u52a1\u5165\u53c2\u64cd\u4f5c\u5185\u5bb9[OperContent]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

