/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jfinal.plugin.activerecord.Db;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.se.manage.api.CacheUpdateService;
import com.tydic.se.manage.api.OptimizeDataService;
import com.tydic.se.manage.bo.DealOptimizeRecordReqBO;
import com.tydic.se.manage.bo.OptimizeRecordBO;
import com.tydic.se.manage.bo.QryOptimizeRecordReqBO;
import com.tydic.se.manage.bo.RaNERMateResultBO;
import com.tydic.se.manage.bo.SeOptimizeRecordRspBO;
import com.tydic.se.manage.bo.SeReportStatisticsBO;
import com.tydic.se.manage.constants.Constants;
import com.tydic.se.manage.constants.HttpRequestUtils;
import com.tydic.se.manage.dao.SeOptimizeRecordDao;
import com.tydic.se.manage.dao.SearchCatalogRecordMapper;
import com.tydic.se.manage.dao.SearchFrequentUsedWordsMapper;
import com.tydic.se.manage.dao.SearchFrequentUsedWordsTypeMapper;
import com.tydic.se.manage.dao.po.SeOptimizeRecord;
import com.tydic.se.manage.dao.po.SearchCatalogRecord;
import com.tydic.se.manage.dao.po.SearchFrequentUsedWordsPO;
import com.tydic.se.manage.dao.po.SearchFrequentUsedWordsTypePO;
import com.tydic.se.manage.util.DateUtil;
import com.tydic.se.nlp.bo.AnalysisTypeFrequentBO;
import com.tydic.se.nlp.bo.AnalysisTypeFrequentCacheBO;
import com.tydic.se.search.config.SearchProcessConfig;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OptimizeDataServiceImpl
implements OptimizeDataService {
    private static final Logger log = LoggerFactory.getLogger(OptimizeDataServiceImpl.class);
    @Autowired
    private SeOptimizeRecordDao seOptimizeRecordDao;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private CacheUpdateService cacheUpdateService;
    @Autowired
    private SearchFrequentUsedWordsMapper searchFrequentUsedWordsMapper;
    @Autowired
    private SearchFrequentUsedWordsTypeMapper searchFrequentUsedWordsTypeMapper;
    @Autowired
    private SearchCatalogRecordMapper searchCatalogRecordDao;
    @Autowired
    private SearchProcessConfig searchProcessConfig;
    @Value(value="${spring.datasource.driver-class-name}")
    private String driverName;

    @Transactional
    public RaNERMateResultBO getRaNerResult() {
        SeReportStatisticsBO reqBO = new SeReportStatisticsBO();
        try {
            String dayConfig = this.getConfig("dataSelfInspectionCycle");
            if (StringUtils.isEmpty((CharSequence)dayConfig)) {
                return null;
            }
            Long day = Long.valueOf(dayConfig);
            String startTime = (String)this.cacheClient.get("{SEARCH}_OPTIMIZE_END_TIME");
            String endTime = DateUtil.getYesterday();
            if (!StringUtils.isEmpty((CharSequence)startTime)) {
                Long hours;
                Long days = DateUtil.getDatePoor((String)startTime, (String)endTime, (Integer)1);
                if (days < day) {
                    log.info("\u672a\u5230\u7edf\u8ba1\u65f6\u95f4\uff0c\u4e0a\u6b21\u6267\u884c\u65f6\u95f4\uff1a{},\u76f8\u5dee\u5929\u6570:{}", (Object)startTime, (Object)days);
                    return null;
                }
                if (days.equals(day) && (hours = DateUtil.getDatePoor((String)startTime, (String)endTime, (Integer)2)) >= 1L) {
                    log.info("\u672a\u5230\u7edf\u8ba1\u65f6\u95f4\uff0c\u4e0a\u6b21\u6267\u884c\u65f6\u95f4\uff1a{},\u76f8\u5dee\u5929\u6570:{},\u76f8\u5dee\u5c0f\u65f6:{}", new Object[]{startTime, days, hours});
                    return null;
                }
            }
            reqBO.setStartTime(startTime);
            reqBO.setEndTime(endTime);
            this.cacheClient.set("{SEARCH}_OPTIMIZE_END_TIME", (Object)endTime);
            String enable = this.getConfig("enableAutomaticOptimization");
            String topWordLimit = this.getConfig("topWordLimit");
            String topWordClickCount = this.getConfig("topWordClickCount");
            String lowFrequencyPer = this.getConfig("lowFrequencyPer");
            NumberFormat nf = NumberFormat.getPercentInstance();
            Number m = null;
            try {
                m = nf.parse(lowFrequencyPer + "%");
            }
            catch (ParseException e) {
                throw new ZTBusinessException(e.getMessage());
            }
            String timeSql = "";
            timeSql = startTime == null ? (this.driverName.contains("dm") ? "SYNC_DATE>=" + endTime : "sync_date>=" + endTime) : (this.driverName.contains("dm") ? " '" + startTime + "' <SYNC_DATE<= '" + endTime + "'" : " '" + startTime + "' <sync_date<= '" + endTime + "'");
            String lowWordSql = "";
            lowWordSql = this.driverName.contains("dm") ? "SELECT     tableAS.\"query_str\" FROM (    SELECT         tableAS.\"query_str\",        tableAS.\"searchTotal\",        tableAS.\"clickPv\"     FROM (        SELECT             QUERY_STR AS \"query_str\",            SUM(SEARCH_TOTAL) AS \"searchTotal\",            SUM(CLICK_TOTAL) AS \"clickPv\"         FROM STAND_SE_WORD_STATISTICS a         WHERE " + timeSql + "          AND WORD_TYPE = 0         GROUP BY QUERY_STR     ) AS tableAS     WHERE         tableAS.\"searchTotal\" > " + topWordClickCount + "    ORDER BY         tableAS.\"searchTotal\" DESC     FETCH FIRST " + topWordLimit + " ROWS ONLY ) AS tableAS WHERE     (CASE WHEN tableAS.\"searchTotal\" != 0 THEN ROUND((tableAS.\"clickPv\" / tableAS.\"searchTotal\"), 2) ELSE 0 END) <= " + m.floatValue() : "SELECT tableAS.query_str\nfrom (\nSELECT\ntableAS.query_str,\ntableAS.searchTotal,\ntableAS.clickPv \nFROM\n( SELECT query_str, SUM( search_total ) AS searchTotal, SUM( click_total ) AS clickPv  FROM stand_se_word_statistics a  WHERE " + timeSql + " AND word_type = 0  GROUP BY query_str  ) AS tableAS  \n WHERE\n tableAS.`searchTotal` > " + topWordClickCount + " ORDER BY\n tableAS.`searchTotal` DESC \n LIMIT " + topWordLimit + " ) as tableAS \n  WHERE (CASE WHEN tableAS.`searchTotal` !=0 THEN truncate((tableAS.clickPv/tableAS.`searchTotal`),2) ELSE 0 END )<=" + m.floatValue();
            List lowClickWord = Db.use((String)"DATAPLAT").query(lowWordSql);
            String minimumSearchResults = this.getConfig("minimumSearchResults");
            String resWordSql = "";
            resWordSql = this.driverName.contains("dm") ? "SELECT QUERY_STR\n FROM STAND_SE_WORD_STATISTICS A\n WHERE " + timeSql + " AND RECORDS_TOTAL <= " + minimumSearchResults + " GROUP BY QUERY_STR" : "SELECT query_str\n FROM stand_se_word_statistics a\n WHERE " + timeSql + " AND records_total <= " + minimumSearchResults + " GROUP BY query_str";
            List resWord = Db.use((String)"DATAPLAT").query(resWordSql);
            log.info("\u5c11\u7ed3\u679c\u8bcd \u65e0\u7ed3\u679c\u8bcd:{}", (Object)resWord);
            log.info("\u4f4e\u70b9\u51fb\u7387\u8bcd:{}", (Object)lowClickWord);
            HashSet wordList = new HashSet(lowClickWord);
            wordList.addAll(resWord);
            log.info("\u53bb\u91cd\u4e4b\u540e:{}", wordList);
            this.judegCategoryExists();
            if (wordList != null && wordList.size() > 0) {
                Long seChannelType = (Long)this.cacheClient.get("{SEARCH}_DEFAULT_CHANNEL_TYPE");
                String url = ((SearchProcessConfig.VectorConfig)this.searchProcessConfig.getVector().get((Object)seChannelType)).searchRanerUrl;
                List fourWords = this.searchFrequentUsedWordsMapper.querFourWordList();
                Map mapList = this.cacheClient.hgetAll("{SEARCH}_TYPE_SKU_FREQUENT");
                ArrayList freUsedWords = new ArrayList();
                for (Map.Entry entry : mapList.entrySet()) {
                    AnalysisTypeFrequentCacheBO obj = (AnalysisTypeFrequentCacheBO)JSONObject.parseObject((String)((String)entry.getValue()), AnalysisTypeFrequentCacheBO.class);
                    for (AnalysisTypeFrequentBO bo : obj.getTypeFrequentList()) {
                        SearchFrequentUsedWordsTypePO brandId = this.searchFrequentUsedWordsTypeMapper.selectCheckIndexField("brand_name");
                        if (!bo.getTypeId().equals(brandId.getTypeId())) continue;
                        freUsedWords.add(entry.getKey());
                    }
                }
                ArrayList<SeOptimizeRecord> list = new ArrayList<SeOptimizeRecord>();
                ArrayList<SearchFrequentUsedWordsPO> usedWordList = new ArrayList<SearchFrequentUsedWordsPO>();
                ArrayList newHPList = new ArrayList();
                ArrayList newHCList = new ArrayList();
                ArrayList<String> catCIdList = new ArrayList<String>();
                ArrayList<SearchCatalogRecord> catWordList = new ArrayList<SearchCatalogRecord>();
                List strList = this.seOptimizeRecordDao.selectQueryStrList();
                for (String queryStr : wordList) {
                    if (strList.contains(queryStr)) continue;
                    JSONArray data = null;
                    if (!StringUtils.isEmpty((CharSequence)url)) {
                        JSONObject result;
                        JSONObject params = new JSONObject();
                        params.put("prompt", (Object)queryStr);
                        log.info("RaNER\u63a5\u53e3\u8bf7\u6c42\u5f00\u59cb\uff1aurl:{},params:{}", (Object)url, (Object)params);
                        String str = HttpRequestUtils.doPost((String)url, (String)params.toJSONString());
                        log.info("RaNER\u63a5\u53e3\u8bf7\u6c42\u7ed3\u675f\uff1aresult:{}", (Object)str);
                        if (!StringUtils.isEmpty((CharSequence)str) && "0".equals((result = JSONObject.parseObject((String)str)).getString("code")) && !"{}".equals(result.getString("data")) && result.getJSONArray("data") != null && result.getJSONArray("data").size() > 0) {
                            data = result.getJSONArray("data");
                        }
                    }
                    if (data == null || data.size() <= 0) continue;
                    SeOptimizeRecord po = new SeOptimizeRecord();
                    String recognizeResult = "";
                    String resolution = "";
                    HashMap<String, String> typeMap = new HashMap<String, String>();
                    String resHp = "";
                    String resHc = "";
                    for (int i = 0; i < data.size(); ++i) {
                        boolean bool2;
                        boolean bool;
                        JSONObject d = data.getJSONObject(i);
                        if ("HC".equals(d.getString("type"))) {
                            resHc = !StringUtils.isEmpty((CharSequence)resHc) ? resHc + "," + d.getString("span") : resHc + "\u7c7b\u76ee:" + d.getString("span");
                            bool = fourWords.contains(d.getString("span"));
                            bool2 = newHCList.contains(d.getString("span"));
                            if (!bool && !bool2) {
                                typeMap.put(d.getString("type"), d.getString("span"));
                            }
                        }
                        if (!"HP".equals(d.getString("type"))) continue;
                        resHp = !StringUtils.isEmpty((CharSequence)resHp) ? resHp + "," + d.getString("span") : resHp + "\u54c1\u724c:" + d.getString("span");
                        bool = freUsedWords.contains(d.getString("span"));
                        bool2 = newHPList.contains(d.getString("span"));
                        if (bool || bool2) continue;
                        typeMap.put(d.getString("type"), d.getString("span"));
                    }
                    if (!StringUtils.isEmpty((CharSequence)resHc)) {
                        resolution = "HC";
                        recognizeResult = resHc;
                    }
                    if (!StringUtils.isEmpty((CharSequence)resHp)) {
                        if (!StringUtils.isEmpty((CharSequence)resolution)) {
                            resolution = resolution + "|";
                            recognizeResult = recognizeResult + ";";
                        }
                        resolution = resolution + "HP";
                        recognizeResult = recognizeResult + resHp;
                    }
                    if (typeMap == null || typeMap.size() <= 0) continue;
                    if (!StringUtils.isEmpty((CharSequence)enable) && enable.equals("1")) {
                        for (String key : typeMap.keySet()) {
                            if (key.equals("HP")) {
                                SearchFrequentUsedWordsPO po1 = new SearchFrequentUsedWordsPO();
                                Sequence sequence = Sequence.getInstance();
                                long id = sequence.nextId();
                                po1.setId(Long.valueOf(id));
                                po1.setfWord((String)typeMap.get(key));
                                po1.setfStatus(Constants.WORDS_STATE_1);
                                SearchFrequentUsedWordsTypePO brandId = this.searchFrequentUsedWordsTypeMapper.selectCheckIndexField("brand_name");
                                if (brandId != null) {
                                    po1.setTypeId(brandId.getTypeId());
                                }
                                usedWordList.add(po1);
                                newHPList.add(typeMap.get(key));
                            }
                            if (!key.equals("HC")) continue;
                            String cId = this.getcId(catCIdList);
                            catCIdList.add(cId);
                            SearchCatalogRecord po1 = new SearchCatalogRecord();
                            po1.setCId(cId);
                            po1.setCName((String)typeMap.get(key));
                            po1.setCDesc((String)typeMap.get(key));
                            po1.setCLevel(Integer.valueOf(4));
                            po1.setPCId("C0001");
                            po1.setCStatus(Constants.WORDS_STATE_1);
                            po1.setUpdateTime(new Date());
                            po1.setUpdateTime(new Date());
                            catWordList.add(po1);
                            newHCList.add(typeMap.get(key));
                        }
                    }
                    Sequence sequence = Sequence.getInstance();
                    long id = sequence.nextId();
                    po.setOptimizeId(Long.valueOf(id));
                    po.setQueryStr(queryStr);
                    po.setRecognizeResult(recognizeResult);
                    po.setResolution(resolution);
                    po.setCreateTime(new Date());
                    if (!StringUtils.isEmpty((CharSequence)enable) && !enable.equals("1")) {
                        po.setResStatus(Integer.valueOf(0));
                    } else {
                        po.setResStatus(Integer.valueOf(4));
                    }
                    list.add(po);
                }
                if (!StringUtils.isEmpty((CharSequence)enable) && enable.equals("1")) {
                    if (usedWordList != null && usedWordList.size() > 0) {
                        this.searchFrequentUsedWordsMapper.batchInsert(usedWordList);
                        HashSet set = new HashSet(newHPList);
                        this.cacheUpdateService.bathAddTypeFrequent(set);
                    }
                    if (catWordList != null && catWordList.size() > 0) {
                        this.searchCatalogRecordDao.batchInsert(catWordList);
                    }
                }
                if (list != null && list.size() > 0) {
                    log.error("\u4f18\u5316\u6570\u636e\u603b\u6570:{}", (Object)list.size());
                    this.seOptimizeRecordDao.batchInsert(list);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("RaNER\u63a5\u53e3\u8bc6\u522b\u5931\u8d25\uff0cerror:{}", (Object)e.getMessage());
        }
        return null;
    }

    @NotNull
    private String getcId(List<String> catCIdList) {
        String cId = "";
        String hisId = "";
        if (catCIdList != null && catCIdList.size() > 0) {
            hisId = catCIdList.get(catCIdList.size() - 1);
            if (hisId != null) {
                hisId = hisId.substring(5);
            }
        } else {
            hisId = Db.use((String)"DATAPLAT").queryStr("SELECT substring(c_id,6) AS cId FROM stand_se_catalog_record WHERE p_c_id=\"C0001\" ORDER BY CAST(substring(c_id,6) as UNSIGNED) desc limit 1");
        }
        if (hisId != null) {
            Integer newId = Integer.valueOf(hisId) + 1;
            cId = "C0001" + newId;
        } else {
            cId = "C00011";
        }
        return cId;
    }

    public String getConfig(String configName) {
        String configSql = "";
        configSql = this.driverName.contains("dm") ? "SELECT CONF_VALUE FROM STAND_SE_OPTIMIZE_CONFIG WHERE CONF_NAME = '" + configName + "'" : " select conf_value from stand_se_optimize_config where conf_name ='" + configName + "'";
        return Db.use((String)"DATAPLAT").queryStr(configSql);
    }

    private void judegCategoryExists() {
        SearchCatalogRecord ext = this.searchCatalogRecordDao.selectByPrimaryKey("C00");
        if (ext == null) {
            SearchCatalogRecord ext1 = new SearchCatalogRecord();
            ext1.setCId("C00");
            ext1.setCName("\u901a\u7528\u7c7b\u76ee");
            ext1.setCDesc("\u901a\u7528\u7c7b\u76ee");
            ext1.setCLevel(Integer.valueOf(1));
            ext1.setPCId("-1");
            ext1.setCStatus(Constants.WORDS_STATE_1);
            ext1.setUpdateTime(new Date());
            ext1.setUpdateTime(new Date());
            this.searchCatalogRecordDao.insert(ext1);
            SearchCatalogRecord ext2 = new SearchCatalogRecord();
            ext2.setCId("C001");
            ext2.setCName("\u901a\u7528\u7c7b\u76ee");
            ext2.setCDesc("\u901a\u7528\u7c7b\u76ee");
            ext2.setCLevel(Integer.valueOf(2));
            ext2.setPCId("C00");
            ext2.setCStatus(Constants.WORDS_STATE_1);
            ext2.setUpdateTime(new Date());
            ext2.setUpdateTime(new Date());
            this.searchCatalogRecordDao.insert(ext2);
            SearchCatalogRecord ext3 = new SearchCatalogRecord();
            ext3.setCId("C0001");
            ext3.setCName("\u901a\u7528\u7c7b\u76ee");
            ext3.setCDesc("\u901a\u7528\u7c7b\u76ee");
            ext3.setCLevel(Integer.valueOf(3));
            ext3.setPCId("C001");
            ext3.setCStatus(Constants.WORDS_STATE_1);
            ext3.setUpdateTime(new Date());
            ext3.setUpdateTime(new Date());
            this.searchCatalogRecordDao.insert(ext3);
        }
    }

    public SeOptimizeRecordRspBO getUnauditedOptimizeRecord(QryOptimizeRecordReqBO reqBO) {
        List list;
        SeOptimizeRecordRspBO rspBO = new SeOptimizeRecordRspBO();
        log.info("\u672a\u5ba1\u6838\u5217\u8868\u67e5\u8be2\u5165\u53c2:{}", (Object)reqBO.toString());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        try {
            list = this.seOptimizeRecordDao.getUnauditedOptimizeRecordList(page, reqBO);
        }
        catch (Exception e) {
            log.error("getUnauditedOptimizeRecord========>\u67e5\u8be2\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u67e5\u8be2\u5217\u8868\u5931\u8d25");
        }
        rspBO.setRows(list);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        return rspBO;
    }

    public SeOptimizeRecordRspBO getAuditedOptimizeRecord(QryOptimizeRecordReqBO reqBO) {
        List list;
        SeOptimizeRecordRspBO rspBO = new SeOptimizeRecordRspBO();
        log.info("\u5df2\u5ba1\u6838\u5217\u8868\u67e5\u8be2\u5165\u53c2:{}", (Object)reqBO.toString());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        try {
            list = this.seOptimizeRecordDao.getAuditedOptimizeRecordList(page, reqBO);
        }
        catch (Exception e) {
            log.error("getAuditedOptimizeRecord========>\u67e5\u8be2\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u67e5\u8be2\u5217\u8868\u5931\u8d25");
        }
        rspBO.setRows(list);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        return rspBO;
    }

    public SeOptimizeRecordRspBO getAutoOptimizeRecordList(QryOptimizeRecordReqBO reqBO) {
        List list;
        SeOptimizeRecordRspBO rspBO = new SeOptimizeRecordRspBO();
        log.info("\u672a\u5ba1\u6838\u5217\u8868\u67e5\u8be2\u5165\u53c2:{}", (Object)reqBO.toString());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        try {
            list = this.seOptimizeRecordDao.getAutoOptimizeRecordList(page, reqBO);
        }
        catch (Exception e) {
            log.error("getUnauditedOptimizeRecord========>\u67e5\u8be2\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u67e5\u8be2\u5217\u8868\u5931\u8d25");
        }
        rspBO.setRows(list);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        return rspBO;
    }

    public void dealOptimizeRecord(DealOptimizeRecordReqBO reqBO) {
        log.info("\u624b\u52a8\u4f18\u5316\u5904\u7406\u5165\u53c2:{}", (Object)reqBO.toString());
        try {
            ArrayList<SeOptimizeRecord> rsp = new ArrayList<SeOptimizeRecord>();
            HashSet<String> fWordList = new HashSet<String>();
            List infoList = JSON.parseArray((String)reqBO.getDealDataList(), OptimizeRecordBO.class);
            List fourWords = this.searchFrequentUsedWordsMapper.querFourWordList();
            Map mapList = this.cacheClient.hgetAll("{SEARCH}_TYPE_SKU_FREQUENT");
            ArrayList freUsedWords = new ArrayList();
            for (Map.Entry entry : mapList.entrySet()) {
                AnalysisTypeFrequentCacheBO obj = (AnalysisTypeFrequentCacheBO)JSONObject.parseObject((String)((String)entry.getValue()), AnalysisTypeFrequentCacheBO.class);
                for (AnalysisTypeFrequentBO bo : obj.getTypeFrequentList()) {
                    SearchFrequentUsedWordsTypePO brandId = this.searchFrequentUsedWordsTypeMapper.selectCheckIndexField("brand_name");
                    if (!bo.getTypeId().equals(brandId.getTypeId())) continue;
                    freUsedWords.add(entry.getKey());
                }
            }
            this.judegCategoryExists();
            ArrayList<String> newHPList = new ArrayList<String>();
            ArrayList<String> newHCList = new ArrayList<String>();
            for (OptimizeRecordBO data : infoList) {
                SeOptimizeRecord po = new SeOptimizeRecord();
                po.setOptimizeId(data.getOptimizeId());
                po.setReviewResult(data.getReviewResult());
                po.setReviewTime(new Date());
                po.setResStatus(reqBO.getResStatus());
                rsp.add(po);
                if (reqBO.getResStatus() == 2) {
                    log.info("\u4e22\u5f03:{}");
                    continue;
                }
                SeOptimizeRecord seOptimizeRecord = this.seOptimizeRecordDao.selectByPrimaryKey(data.getOptimizeId());
                if (seOptimizeRecord == null) continue;
                String[] res = seOptimizeRecord.getRecognizeResult().split("\\;");
                for (int i = 0; i < res.length; ++i) {
                    SearchFrequentUsedWordsTypePO brandId;
                    boolean bool2;
                    boolean bool;
                    String[] tag = res[i].split("\\:");
                    String key = tag[0].equals("\u7c7b\u76ee") ? "HC" : "HP";
                    String value = tag[1];
                    if (reqBO.getResStatus() == 3 && !data.getReviewResult().equals(key)) {
                        log.info("\u90e8\u5206\u4e22\u5f03");
                        continue;
                    }
                    String[] resList = value.split(",");
                    String target = resList[resList.length - 1];
                    if (StringUtils.isEmpty((CharSequence)target)) continue;
                    if (key.equals("HC")) {
                        bool = fourWords.contains(target);
                        bool2 = newHCList.contains(target);
                        if (bool || bool2) continue;
                        String cId = this.getcId(null);
                        SearchCatalogRecord po1 = new SearchCatalogRecord();
                        po1.setCId(cId);
                        po1.setCName(target);
                        po1.setCDesc(target);
                        po1.setCLevel(Integer.valueOf(4));
                        po1.setPCId("C0001");
                        po1.setCStatus(Constants.WORDS_STATE_1);
                        po1.setUpdateTime(new Date());
                        po1.setUpdateTime(new Date());
                        this.searchCatalogRecordDao.insert(po1);
                        newHCList.add(target);
                        continue;
                    }
                    bool = freUsedWords.contains(target);
                    bool2 = newHPList.contains(target);
                    if (bool || bool2) continue;
                    SearchFrequentUsedWordsPO po1 = new SearchFrequentUsedWordsPO();
                    Sequence sequence = Sequence.getInstance();
                    long id = sequence.nextId();
                    po1.setId(Long.valueOf(id));
                    po1.setfWord(target);
                    po1.setUpdateTime(new Date());
                    po1.setfStatus(Constants.WORDS_STATE_1);
                    if (key.equals("HP") && (brandId = this.searchFrequentUsedWordsTypeMapper.selectCheckIndexField("brand_name")) != null) {
                        po1.setTypeId(brandId.getTypeId());
                    }
                    fWordList.add(target);
                    newHPList.add(target);
                    this.searchFrequentUsedWordsMapper.insertSelective(po1);
                }
            }
            this.seOptimizeRecordDao.batchUpdate(rsp);
            this.cacheUpdateService.bathAddTypeFrequent(fWordList);
        }
        catch (Exception e) {
            log.error("\u81ea\u4f18\u5316\u5904\u7406\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u81ea\u4f18\u5316\u5904\u7406\u5931\u8d25");
        }
    }

    public void dealAutoOptimizeRecord(DealOptimizeRecordReqBO reqBO) {
        log.info("\u53d6\u6d88\u81ea\u4f18\u5316\u5904\u7406\u5165\u53c2:{}", (Object)reqBO.toString());
        try {
            ArrayList<SeOptimizeRecord> rsp = new ArrayList<SeOptimizeRecord>();
            HashSet<String> set = new HashSet<String>();
            List infoList = JSON.parseArray((String)reqBO.getDealDataList(), OptimizeRecordBO.class);
            for (OptimizeRecordBO data : infoList) {
                SeOptimizeRecord po = new SeOptimizeRecord();
                po.setOptimizeId(data.getOptimizeId());
                if (!StringUtils.isEmpty((CharSequence)data.getReviewResult())) {
                    po.setReviewResult(data.getReviewResult().equals("HP") ? "HC" : "HP");
                }
                po.setReviewTime(new Date());
                po.setResStatus(reqBO.getResStatus());
                rsp.add(po);
                String[] res = data.getRecognizeResult().split("\\;");
                for (int i = 0; i < res.length; ++i) {
                    String[] tag = res[i].split("\\:");
                    String key = tag[0].equals("\u7c7b\u76ee") ? "HC" : "HP";
                    String value = tag[1];
                    if (reqBO.getResStatus() == 3 && !data.getReviewResult().equals(key)) {
                        log.info("\u4fdd\u7559:{}", (Object)key);
                        continue;
                    }
                    String[] resList = value.split(",");
                    String target = resList[resList.length - 1];
                    if (StringUtils.isEmpty((CharSequence)target)) continue;
                    if (key.equals("HC")) {
                        this.searchCatalogRecordDao.deleteByNameAndPId("C0001", target);
                        this.cacheUpdateService.deleteFourCatalog(target);
                        continue;
                    }
                    SearchFrequentUsedWordsTypePO brandId = this.searchFrequentUsedWordsTypeMapper.selectCheckIndexField("brand_name");
                    if (brandId == null) continue;
                    this.searchFrequentUsedWordsMapper.deleteByFWord(target, brandId.getTypeId());
                    set.add(target);
                }
            }
            this.seOptimizeRecordDao.batchUpdate(rsp);
            if (set.size() > 0) {
                this.cacheUpdateService.bathDeleteTypeFrequent(set);
            }
        }
        catch (Exception e) {
            log.error("\u81ea\u4f18\u5316\u5904\u7406\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u81ea\u4f18\u5316\u5904\u7406\u5931\u8d25");
        }
    }

    public static void main(String[] args) {
        String cId = "C00019";
        Integer result = Integer.valueOf(cId.substring(5));
        Integer newId = result + 1;
        String cId1 = "C0001" + newId;
        System.out.println(newId);
        System.out.println(cId1);
    }
}

