/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.impl;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.base.bo.EsIndexDetailBO;
import com.tydic.se.base.bo.MilvusIndexDetailBO;
import com.tydic.se.base.bo.QueryESIndexManageBO;
import com.tydic.se.base.constant.ToOdpsCommConstant;
import com.tydic.se.base.dao.EsIndexMapper;
import com.tydic.se.base.dao.EsIndexTemplateMapper;
import com.tydic.se.base.dao.po.EsIndex;
import com.tydic.se.base.dao.po.EsIndexTemplate;
import com.tydic.se.es.util.ElasticsearchUtil;
import com.tydic.se.manage.api.CacheUpdateService;
import com.tydic.se.manage.api.QueryESIndexManageService;
import com.tydic.se.manage.bo.AddEsIndexReqBO;
import com.tydic.se.manage.bo.ESIndexTemplateReqBO;
import com.tydic.se.manage.bo.ESIndexTemplateRspBO;
import com.tydic.se.manage.bo.IndexDetailRespBO;
import com.tydic.se.manage.bo.IndexInfoReqBO;
import com.tydic.se.manage.bo.QueryESIndexManageReqBO;
import com.tydic.se.manage.bo.QueryESIndexManageRspBO;
import com.tydic.se.manage.bo.QueryIndexTypeRspBO;
import com.tydic.se.manage.bo.QueryThemeModelByThemeIdRspBO;
import com.tydic.se.manage.constants.CONST;
import com.tydic.se.manage.dao.EsIndexModelDao;
import com.tydic.se.manage.dao.EsSyncRecordMapper;
import com.tydic.se.manage.dao.po.EsIndexLogPO;
import com.tydic.se.manage.util.CodeUtil;
import com.tydic.se.manage.util.MilvusUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexResponse;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.settings.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QueryESIndexManageServiceImpl
implements QueryESIndexManageService {
    private static final Logger log = LoggerFactory.getLogger(QueryESIndexManageServiceImpl.class);
    @Autowired
    private EsIndexMapper esIndexMapper;
    @Autowired
    private EsIndexTemplateMapper esIndexTemplateMapper;
    @Autowired
    private EsIndexModelDao esIndexModelDao;
    @Autowired
    private EsSyncRecordMapper esSyncRecordMapper;
    @Autowired
    private CacheUpdateService cacheUpdateService;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private CacheClient cacheClient;
    @Qualifier(value="restHighLevelClient")
    @Autowired
    private RestHighLevelClient client;

    public QueryESIndexManageRspBO queryESIndexManageList(QueryESIndexManageReqBO reqBO) throws ZTBusinessException {
        List<QueryESIndexManageBO> rspList;
        if (reqBO.getPageNo() < 1) {
            reqBO.setPageNo(1);
        }
        if (reqBO.getPageSize() < 1) {
            reqBO.setPageSize(10);
        }
        log.info("\u5165\u53c2:", (Object)reqBO.toString());
        QueryESIndexManageRspBO rspBO = new QueryESIndexManageRspBO();
        PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize());
        EsIndex po = new EsIndex();
        po.setFlag(reqBO.getFlag());
        po.setSyncStatus(reqBO.getSyncStatus());
        po.setIndexSName(reqBO.getIndexSName());
        po.setiType(reqBO.getIType());
        po.setSeChannelType(reqBO.getSeChannelType());
        try {
            rspList = this.esIndexMapper.queryEsIndexList(po);
        }
        catch (Exception e) {
            log.error("queryESIndexManageList========>qry\u67e5\u8be2\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u67e5\u8be2\u5217\u8868\u5931\u8d25");
        }
        if (reqBO.getMark() == 0) {
            rspList = rspList.stream().filter(indexManageBO -> indexManageBO.getIType() == 1 || indexManageBO.getIType() == 2 || indexManageBO.getIType() == 4).collect(Collectors.toList());
        } else if (reqBO.getMark() == 1) {
            rspList = rspList.stream().filter(indexManageBO -> indexManageBO.getIType() == 1 || indexManageBO.getIType() == 3 || indexManageBO.getIType() == 5).collect(Collectors.toList());
        }
        rspList.forEach(queryESIndexManageBO -> {
            if (Objects.equals(queryESIndexManageBO.getIType(), ToOdpsCommConstant.esType.TYPE_3) || Objects.equals(queryESIndexManageBO.getIType(), ToOdpsCommConstant.esType.TYPE_2)) {
                EsIndexDetailBO esIndexDetailBO = this.getIndexDetail(queryESIndexManageBO.getIndexSName());
                queryESIndexManageBO.setEsDetail(esIndexDetailBO);
                queryESIndexManageBO.setDocCount(esIndexDetailBO.getDocCount());
                queryESIndexManageBO.setState(esIndexDetailBO.getState());
            }
            if (Objects.equals(queryESIndexManageBO.getIType(), ToOdpsCommConstant.esType.TYPE_5)) {
                MilvusIndexDetailBO collectionDetail = MilvusUtil.getCollectionDetail((String)queryESIndexManageBO.getIndexSName());
                queryESIndexManageBO.setMilvusDetail(collectionDetail);
                queryESIndexManageBO.setDocCount(Long.valueOf(collectionDetail.getCount().intValue()));
                queryESIndexManageBO.setState(collectionDetail.getState());
            }
        });
        PageInfo pageInfo = new PageInfo(rspList);
        rspBO.setRows(rspList);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal((int)pageInfo.getTotal());
        rspBO.setTotal(pageInfo.getPages());
        return rspBO;
    }

    @Transactional(rollbackFor={Exception.class})
    public void addEsIndex(AddEsIndexReqBO reqBO) throws ZTBusinessException {
        log.info("\u65b0\u589e\u7d22\u5f15\u5165\u53c2:", (Object)reqBO.toString());
        this.checkParams(reqBO);
        try {
            EsIndex esIndex = this.esIndexMapper.selectByPrimaryKey(reqBO.getIndexSName(), reqBO.getSeChannelType());
            if (esIndex != null) {
                throw new ZTBusinessException("\u7d22\u5f15\u5df2\u5b58\u5728\uff01");
            }
            EsIndex esIndexPO = new EsIndex();
            esIndexPO.setIndexSName(reqBO.getIndexSName());
            esIndexPO.setIndexCName(reqBO.getIndexCName());
            esIndexPO.setiType(reqBO.getIType());
            esIndexPO.setThemeId(reqBO.getThemeId());
            esIndexPO.setmId(reqBO.getMId());
            esIndexPO.setRemark(reqBO.getRemark());
            esIndexPO.setFlag(CONST.ES_INDEX_FLAG_STOP);
            esIndexPO.setCreateTime(new Date());
            esIndexPO.setUpdateTime(new Date());
            esIndexPO.setSyncStatus(CONST.ES_INDEX_ONLY_CREATE);
            esIndexPO.setSeChannelType(reqBO.getSeChannelType());
            esIndexPO.setId(CodeUtil.generateTableCode());
            this.esIndexMapper.insertSelective(esIndexPO);
            EsIndexTemplate templatePO = new EsIndexTemplate();
            templatePO.settType(reqBO.getIType());
            templatePO.setIndexConfig(reqBO.getIndexConfig());
            templatePO.setUpdateTime(new Date());
            templatePO.setSeChannelType(reqBO.getSeChannelType());
            this.esIndexTemplateMapper.updateByTTypeSelective(templatePO);
            if (reqBO.getIType() == 5) {
                Boolean isMiSuccess = MilvusUtil.createCollect((String)reqBO.getIndexConfig(), (String)reqBO.getIndexSName());
                if (!isMiSuccess.booleanValue()) {
                    throw new ZTBusinessException("\u65b0\u589e\u7d22\u5f15\u5931\u8d25\uff01");
                }
            } else {
                if (reqBO.getOpenSynonym() == 1 && reqBO.getSynonymsPath() != null) {
                    reqBO.setIndexConfig(StringUtils.isEmpty((CharSequence)reqBO.getIndexConfig()) ? "" : reqBO.getIndexConfig().replace("${url}", reqBO.getSynonymsPath()));
                } else {
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode root = mapper.readTree(reqBO.getIndexConfig());
                    ((ObjectNode)root.get("settings").get("index")).remove("analysis");
                    String cleanedJson = mapper.writeValueAsString((Object)root);
                    reqBO.setIndexConfig(cleanedJson);
                }
                Boolean isSuccess = this.elasticsearchUtil.createIndex(reqBO.getIndexSName(), reqBO.getIndexConfig());
                if (!isSuccess.booleanValue()) {
                    throw new ZTBusinessException("\u65b0\u589e\u7d22\u5f15\u5931\u8d25\uff01");
                }
            }
            EsIndexLogPO logPO = new EsIndexLogPO(reqBO.getIndexSName(), CONST.OP_INDEX_TYPE_0, new Date(), reqBO.getUserId(), reqBO.getUsername());
            this.esSyncRecordMapper.insertEsIndexLogSelective(logPO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException("\u65b0\u589e\u7d22\u5f15\u5931\u8d25");
        }
    }

    public void updateEsIndex(AddEsIndexReqBO reqBO) throws ZTBusinessException {
        log.info("\u7f16\u8f91\u7d22\u5f15\u5165\u53c2:", (Object)reqBO.toString());
        if (StringUtils.isEmpty((CharSequence)reqBO.getIndexSName())) {
            throw new ZTBusinessException("\u53c2\u6570\u672a\u4f20\u9012,\u7f16\u8f91\u5931\u8d25");
        }
        EsIndex po = new EsIndex();
        po.setIndexSName(reqBO.getIndexSName());
        po.setIndexCName(reqBO.getIndexCName());
        po.setThemeId(reqBO.getThemeId());
        po.setmId(reqBO.getMId());
        po.setRemark(reqBO.getRemark());
        po.setUpdateTime(new Date());
        po.setSeChannelType(reqBO.getSeChannelType());
        if (reqBO.getOnlyCreate().booleanValue()) {
            po.setSyncStatus(CONST.ES_INDEX_ONLY_CREATE);
        }
        try {
            this.esIndexMapper.updateByPrimaryKeySelective(po);
        }
        catch (Exception e) {
            log.error("updateEsIndex========>\u7f16\u8f91\u7d22\u5f15\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u7f16\u8f91\u7d22\u5f15\u5931\u8d25");
        }
        EsIndexLogPO logPO = new EsIndexLogPO(reqBO.getIndexSName(), CONST.OP_INDEX_TYPE_3, new Date(), reqBO.getUserId(), reqBO.getUsername());
        this.esSyncRecordMapper.insertEsIndexLogSelective(logPO);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteEsIndex(AddEsIndexReqBO reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2:", (Object)reqBO.toString());
        if (StringUtils.isEmpty((CharSequence)reqBO.getIndexSName())) {
            throw new ZTBusinessException("\u53c2\u6570\u4e3a\u4f20\u9012,\u5220\u9664\u7d22\u5f15\u5931\u8d25!");
        }
        try {
            Boolean isSuccess;
            Boolean isMiSuccess;
            this.esIndexMapper.deleteByPrimaryKey(reqBO.getIndexSName());
            this.esSyncRecordMapper.deleteByIndexSName(reqBO.getIndexSName());
            if (!reqBO.getOnlyCreate().booleanValue() && (reqBO.getIType() == 5 ? (isMiSuccess = MilvusUtil.delCollect((String)reqBO.getIndexSName())) == false : (isSuccess = this.elasticsearchUtil.delIndex(reqBO.getIndexSName())) == false)) {
                throw new ZTBusinessException("\u5220\u9664\u7d22\u5f15\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            log.error("deleteEsIndex========>\u5220\u9664\u7d22\u5f15\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u5220\u9664\u7d22\u5f15\u5931\u8d25");
        }
        EsIndexLogPO logPO = new EsIndexLogPO(reqBO.getIndexSName(), CONST.OP_INDEX_TYPE_9, new Date(), reqBO.getUserId(), reqBO.getUsername());
        this.esSyncRecordMapper.insertEsIndexLogSelective(logPO);
    }

    public void startEsIndex(AddEsIndexReqBO reqBO) throws ZTBusinessException {
        QueryESIndexManageBO withBO;
        log.info("\u5165\u53c2:", (Object)reqBO.toString());
        if (StringUtils.isEmpty((CharSequence)reqBO.getIType().toString())) {
            throw new ZTBusinessException("\u53c2\u6570\u672a\u4f20\u9012,\u64cd\u4f5c\u5931\u8d25!");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getIndexSName())) {
            throw new ZTBusinessException("\u53c2\u6570\u672a\u4f20\u9012,\u64cd\u4f5c\u5931\u8d25!");
        }
        EsIndex queryNum = new EsIndex();
        queryNum.setiType(reqBO.getIType());
        QueryESIndexManageBO bo = this.esIndexMapper.queryIndexStartNumByType(queryNum);
        if (bo.getStartNum() > 0) {
            throw new ZTBusinessException("\u6b64\u7c7b\u7d22\u5f15\u4e0b\u6709\u5df2\u7ecf\u542f\u7528\u7684\u7d22\u5f15,\u542f\u7528\u5931\u8d25");
        }
        if ((reqBO.getIType().toString().equals("3") || reqBO.getIType().toString().equals("5")) && (withBO = this.esIndexMapper.queryIndexStartTypeWithMilOrEs()).getStartNum() > 0) {
            throw new ZTBusinessException("\u5df2\u7ecf\u6709\u5411\u91cf\u7d22\u5f15\u88ab\u542f\u7528,\u542f\u7528\u5931\u8d25");
        }
        EsIndex po = new EsIndex();
        po.setIndexSName(reqBO.getIndexSName());
        po.setFlag(CONST.ES_INDEX_FLAG_START);
        try {
            this.esIndexMapper.updateByPrimaryKeySelective(po);
            this.cacheUpdateService.syncESIndex(reqBO.getIType(), reqBO.getIndexSName());
        }
        catch (Exception e) {
            log.error("startEsIndex========>\u7d22\u5f15\u542f\u7528\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u7d22\u5f15\u542f\u7528\u5931\u8d25");
        }
        EsIndexLogPO logPO = new EsIndexLogPO(reqBO.getIndexSName(), CONST.OP_INDEX_TYPE_1, new Date(), reqBO.getUserId(), reqBO.getUsername());
        this.esSyncRecordMapper.insertEsIndexLogSelective(logPO);
    }

    public void stopEsIndex(AddEsIndexReqBO reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2:", (Object)reqBO.toString());
        if (StringUtils.isEmpty((CharSequence)reqBO.getIType().toString())) {
            throw new ZTBusinessException("\u53c2\u6570\u672a\u4f20\u9012,\u64cd\u4f5c\u5931\u8d25!");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getIndexSName())) {
            throw new ZTBusinessException("\u53c2\u6570\u672a\u4f20\u9012,\u64cd\u4f5c\u5931\u8d25!");
        }
        EsIndex po = new EsIndex();
        po.setFlag(CONST.ES_INDEX_FLAG_STOP);
        po.setIndexSName(reqBO.getIndexSName());
        try {
            this.esIndexMapper.updateByPrimaryKeySelective(po);
            this.cacheUpdateService.syncESIndex(reqBO.getIType(), null);
        }
        catch (Exception e) {
            log.error("startEsIndex========>\u7d22\u5f15\u505c\u7528\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u7d22\u5f15\u505c\u7528\u5931\u8d25");
        }
        EsIndexLogPO logPO = new EsIndexLogPO(reqBO.getIndexSName(), CONST.OP_INDEX_TYPE_2, new Date(), reqBO.getUserId(), reqBO.getUsername());
        this.esSyncRecordMapper.insertEsIndexLogSelective(logPO);
    }

    public ESIndexTemplateRspBO queryIndexTemplateByType(ESIndexTemplateReqBO reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2:", (Object)reqBO.toString());
        ESIndexTemplateRspBO rspBO = new ESIndexTemplateRspBO();
        if (reqBO.getTType() == null) {
            throw new ZTBusinessException("\u53c2\u6570\u672a\u4f20\u9012\u67e5\u8be2\u5931\u8d25");
        }
        EsIndexTemplate bo = this.esIndexTemplateMapper.selectBytType(reqBO.getTType(), reqBO.getSeChannelType());
        rspBO.setIndexConfig(bo.getIndexConfig());
        return rspBO;
    }

    public QueryThemeModelByThemeIdRspBO queryIndexModel() throws ZTBusinessException {
        QueryThemeModelByThemeIdRspBO rspBO = new QueryThemeModelByThemeIdRspBO();
        List boList = this.esIndexModelDao.selectModelList();
        rspBO.setBoList(boList);
        return rspBO;
    }

    public void createESIndexTemplate(ESIndexTemplateReqBO reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2:", (Object)reqBO.toString());
        if (reqBO.getTId() == null) {
            throw new ZTBusinessException("\u53c2\u6570\u672a\u4f20\u9012\u521b\u5efa\u5931\u8d25");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getIndexConfig())) {
            throw new ZTBusinessException("\u53c2\u6570\u672a\u4f20\u9012\u521b\u5efa\u5931\u8d25");
        }
        EsIndexTemplate po = new EsIndexTemplate();
        po.settId(reqBO.getTId());
        po.setIndexConfig(reqBO.getIndexConfig());
        po.settStatus(CONST.ES_INDEX_TEMPLATE_EXECUTED);
        po.setUpdateTime(new Date());
        po.setSeChannelType(reqBO.getSeChannelType());
        try {
            this.esIndexTemplateMapper.updateByPrimaryKeySelective(po);
        }
        catch (Exception e) {
            log.error("createESIndexTemplate========>\u7d22\u5f15\u6a21\u677f\u521b\u5efa\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u7d22\u5f15\u6a21\u677f\u521b\u5efa\u5931\u8d25");
        }
    }

    public QueryIndexTypeRspBO queryIndexType(QueryESIndexManageReqBO reqBO) throws ZTBusinessException {
        QueryIndexTypeRspBO rsp = new QueryIndexTypeRspBO();
        List indexTypeBOList = null;
        if (reqBO.getMark() == 0) {
            indexTypeBOList = this.esIndexTemplateMapper.queryESIndexType(reqBO.getSeChannelType());
        } else if (reqBO.getMark() == 1) {
            indexTypeBOList = this.esIndexTemplateMapper.queryVectorIndexType(reqBO.getSeChannelType());
        }
        if (indexTypeBOList.size() > 0) {
            indexTypeBOList = indexTypeBOList.stream().filter(item -> item.getValue() != 1).collect(Collectors.toList());
            rsp.setIndexTypeList(indexTypeBOList);
        }
        return rsp;
    }

    public IndexDetailRespBO getIndexInfo(IndexInfoReqBO reqBO) {
        EsIndex esIndex = this.esIndexMapper.selectByPrimaryKey(reqBO.getIndexSName(), reqBO.getSeChannelType());
        if (esIndex == null) {
            throw new ZTBusinessException("\u7d22\u5f15\u4e0d\u5b58\u5728");
        }
        IndexDetailRespBO respBO = new IndexDetailRespBO();
        respBO.setIndexSName(esIndex.getIndexSName());
        respBO.setIndexCName(esIndex.getIndexCName());
        if (Objects.equals(esIndex.getiType(), ToOdpsCommConstant.esType.TYPE_5)) {
            MilvusIndexDetailBO milvusIndexDetailBO = MilvusUtil.getCollectionDetail((String)reqBO.getIndexSName());
            respBO.setDocCount(Long.valueOf(milvusIndexDetailBO.getCount().intValue()));
            respBO.setShardsNum(milvusIndexDetailBO.getShardsNum());
            respBO.setState(milvusIndexDetailBO.getState());
            respBO.setVectorFields(JSON.toJSONString((Object)milvusIndexDetailBO.getFields()));
        } else if (Objects.equals(esIndex.getiType(), ToOdpsCommConstant.esType.TYPE_3) || Objects.equals(esIndex.getiType(), ToOdpsCommConstant.esType.TYPE_2)) {
            EsIndexDetailBO esIndexDetailBO = this.getIndexDetail(reqBO.getIndexSName());
            respBO.setDocCount(esIndexDetailBO.getDocCount());
            respBO.setShardsNum(esIndexDetailBO.getShardsTotal());
            respBO.setState(esIndexDetailBO.getState());
            respBO.setMappings(esIndexDetailBO.getMappings());
            respBO.setSettings(esIndexDetailBO.getSettings());
            respBO.setVectorFields(esIndexDetailBO.getVectorFields());
        }
        return respBO;
    }

    public void checkParams(AddEsIndexReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getIndexSName())) {
            throw new ZTBusinessException("\u53c2\u6570\u672a\u4f20\u9012\u65b0\u589e\u5931\u8d25");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getIndexCName())) {
            throw new ZTBusinessException("\u53c2\u6570\u672a\u4f20\u9012\u65b0\u589e\u5931\u8d25");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getIType().toString())) {
            throw new ZTBusinessException("\u53c2\u6570\u672a\u4f20\u9012\u65b0\u589e\u5931\u8d25");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getSeChannelType().toString())) {
            throw new ZTBusinessException("\u53c2\u6570\u672a\u4f20\u9012\u65b0\u589e\u5931\u8d25");
        }
    }

    private EsIndexDetailBO getIndexDetail(String indexSName) {
        try {
            Map mappings;
            GetIndexRequest request = new GetIndexRequest(new String[]{indexSName});
            GetIndexResponse response = this.client.indices().get(request, RequestOptions.DEFAULT);
            EsIndexDetailBO detail = new EsIndexDetailBO();
            if (response.getMappings() != null && response.getMappings().containsKey(response.getIndices()[0])) {
                detail.setMappings(JSON.toJSONString((Object)((MappingMetadata)response.getMappings().get(response.getIndices()[0])).sourceAsMap()));
            } else {
                detail.setMappings(null);
            }
            if (response.getSettings() != null && response.getSettings().containsKey(response.getIndices()[0])) {
                detail.setSettings(((Settings)response.getSettings().get(response.getIndices()[0])).toDelimitedString(','));
                String shardsStr = ((Settings)response.getSettings().get(response.getIndices()[0])).get("index.number_of_shards");
                if (shardsStr != null) {
                    Integer shardsTotal = Integer.parseInt(shardsStr);
                    detail.setShardsTotal(shardsTotal);
                } else {
                    detail.setShardsTotal(Integer.valueOf(0));
                }
            } else {
                detail.setSettings(null);
            }
            CountRequest countRequest = new CountRequest(new String[]{indexSName});
            CountResponse countResponse = this.client.count(countRequest, RequestOptions.DEFAULT);
            if (countResponse != null) {
                detail.setDocCount(Long.valueOf(countResponse.getCount()));
            } else {
                detail.setDocCount(Long.valueOf(0L));
            }
            ClusterHealthRequest healthRequest = new ClusterHealthRequest(new String[]{indexSName});
            ClusterHealthResponse healthResponse = this.client.cluster().health(healthRequest, RequestOptions.DEFAULT);
            detail.setState(healthResponse.getStatus().toString());
            int vectorFieldCount = 0;
            ArrayList vectorFields = new ArrayList();
            if (response.getMappings() != null && (mappings = ((MappingMetadata)response.getMappings().get(response.getIndices()[0])).sourceAsMap()) != null && mappings.containsKey("properties")) {
                Map properties = (Map)mappings.get("properties");
                for (Map.Entry entry : properties.entrySet()) {
                    Map fieldInfo = (Map)entry.getValue();
                    if (!"dense_vector".equals(fieldInfo.get("type"))) continue;
                    ++vectorFieldCount;
                    HashMap<String, Object> vectorField = new HashMap<String, Object>();
                    vectorField.put("name", entry.getKey());
                    vectorField.put("dims", fieldInfo.get("dims"));
                    vectorFields.add(vectorField);
                }
            }
            detail.setVectorFieldCount(Integer.valueOf(vectorFieldCount));
            detail.setVectorFields(JSON.toJSONString(vectorFields));
            return detail;
        }
        catch (IOException e) {
            throw new ZTBusinessException("\u83b7\u53d6ES\u7d22\u5f15\u4fe1\u606f\u5931\u8d25");
        }
    }
}

