/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.impl;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Record;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.se.manage.api.ReportStatisticsService;
import com.tydic.se.manage.bo.ActionRecordBO;
import com.tydic.se.manage.bo.CommonPageRspBO;
import com.tydic.se.manage.bo.DynamicReportDataReqBO;
import com.tydic.se.manage.bo.SeConfigureRecordRspBO;
import com.tydic.se.manage.bo.SeLeftNameBO;
import com.tydic.se.manage.bo.SePVStatisticsBO;
import com.tydic.se.manage.bo.SeRateStatisticsBO;
import com.tydic.se.manage.bo.SeReportStatisticsBO;
import com.tydic.se.manage.bo.SeReportStatisticsRspBO;
import com.tydic.se.manage.bo.SeReportSubBO;
import com.tydic.se.manage.bo.SeTabNameBO;
import com.tydic.se.manage.bo.SeWordCloudBO;
import com.tydic.se.manage.bo.SeWordCloudRspBO;
import com.tydic.se.manage.bo.TableHeadInfo;
import com.tydic.se.manage.config.MuitDataSourceConfig;
import com.tydic.se.manage.util.CommTools;
import com.tydic.se.manage.util.DateUtil;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReportStatisticsServiceImpl
implements ReportStatisticsService {
    @Value(value="${spring.datasource.driver-class-name}")
    private String driverName;
    @Autowired
    private MuitDataSourceConfig config;
    private static final Logger log = LoggerFactory.getLogger(ReportStatisticsServiceImpl.class);

    public SeReportStatisticsRspBO selectReportStatistics(SeReportStatisticsBO reqBO) throws ZTBusinessException {
        Record rows;
        Record row;
        Record noResrow;
        List avgPVrow;
        String avgPVSql;
        Long uv;
        List uvrow;
        String sumUVSql;
        String groupUVSql;
        Long pv;
        List rowPV;
        String sumPVSql;
        String groupPVSql;
        SeReportStatisticsRspBO rspBO = new SeReportStatisticsRspBO();
        log.info("\u8fd0\u8425\u62a5\u8868\u67e5\u8be2\u5165\u53c2:{}", (Object)reqBO.toString());
        SePVStatisticsBO sePVStatisticsBO = new SePVStatisticsBO();
        SePVStatisticsBO seUVStatisticsBO = new SePVStatisticsBO();
        SePVStatisticsBO seAVGUVStatisticsBO = new SePVStatisticsBO();
        ArrayList<SeReportSubBO> groupPV = new ArrayList<SeReportSubBO>();
        ArrayList<SeReportSubBO> groupUV = new ArrayList<SeReportSubBO>();
        ArrayList<SeReportSubBO> avgPV = new ArrayList<SeReportSubBO>();
        String start = reqBO.getStartTime() + " 00:00:00";
        String end = reqBO.getEndTime() + " 23:59:59";
        String month = DateUtil.getSearchMonthOfFirstDay((String)reqBO.getStartTime());
        if (reqBO.getStartTime().equals(reqBO.getEndTime())) {
            groupPVSql = null;
            sumPVSql = null;
            if (this.driverName.contains("dm")) {
                groupPVSql = "SELECT     TO_CHAR(CREATE_TIME, 'HH24') || ':00:00' AS \"time\",     COUNT(DISTINCT SEARCH_ID) AS \"countNum\" FROM STAND_SE_IN_LOG WHERE CREATE_TIME BETWEEN     TO_DATE('" + start + "', 'YYYY-MM-DD HH24:MI:SS')     AND TO_DATE('" + end + "', 'YYYY-MM-DD HH24:MI:SS') GROUP BY TO_CHAR(CREATE_TIME, 'HH24') ORDER BY TO_CHAR(CREATE_TIME, 'HH24')";
                sumPVSql = "SELECT COUNT(DISTINCT SEARCH_ID) FROM STAND_SE_IN_LOG WHERE CREATE_TIME BETWEEN     TO_DATE('" + start + "', 'YYYY-MM-DD HH24:MI:SS')     AND TO_DATE('" + end + "', 'YYYY-MM-DD HH24:MI:SS')";
            } else {
                groupPVSql = "select DATE_FORMAT(CREATE_TIME, '%H:00:00') AS time,COUNT(DISTINCT(SEARCH_ID)) AS countNum from stand_se_in_log where CREATE_TIME BETWEEN '" + start + "' AND '" + end + "' GROUP BY time ORDER BY time";
                sumPVSql = "select COUNT(DISTINCT(SEARCH_ID)) from stand_se_in_log where CREATE_TIME BETWEEN '" + start + "' AND '" + end + "'";
            }
            rowPV = Db.use((String)"DATAPLAT").find(groupPVSql);
            if (rowPV != null && rowPV.size() > 0) {
                try {
                    groupPV.addAll(CommTools.getBeanList((List)rowPV, SeReportSubBO.class));
                }
                catch (Exception e) {
                    log.error("\u641c\u7d22PV\u67e5\u8be2\u5931\u8d25", (Throwable)e);
                }
            }
            pv = Db.use((String)"DATAPLAT").queryLong(sumPVSql);
            groupUVSql = null;
            sumUVSql = null;
            if (this.driverName.contains("dm")) {
                groupUVSql = "SELECT     TO_CHAR(CREATE_TIME, 'HH24') || ':00:00' AS \"time\",     COUNT(DISTINCT USER_ID) AS \"countNum\" FROM STAND_SE_IN_LOG WHERE CREATE_TIME BETWEEN     TO_DATE('" + start + "', 'YYYY-MM-DD HH24:MI:SS')     AND TO_DATE('" + end + "', 'YYYY-MM-DD HH24:MI:SS') GROUP BY TO_CHAR(CREATE_TIME, 'HH24') ORDER BY TO_CHAR(CREATE_TIME, 'HH24')";
                sumUVSql = "SELECT COUNT(DISTINCT USER_ID) FROM STAND_SE_IN_LOG WHERE CREATE_TIME BETWEEN     TO_DATE('" + start + "', 'YYYY-MM-DD HH24:MI:SS')     AND TO_DATE('" + end + "', 'YYYY-MM-DD HH24:MI:SS')";
            } else {
                groupUVSql = "select DATE_FORMAT(CREATE_TIME, '%H:00:00') AS time,COUNT(DISTINCT `USER_ID`) AS countNum from stand_se_in_log where CREATE_TIME BETWEEN '" + start + "' AND '" + end + "' GROUP BY time ORDER BY time";
                sumUVSql = "select COUNT(DISTINCT `USER_ID`) from stand_se_in_log where CREATE_TIME BETWEEN '" + start + "' AND '" + end + "'";
            }
            uvrow = Db.use((String)"DATAPLAT").find(groupUVSql);
            if (uvrow != null && uvrow.size() > 0) {
                try {
                    groupUV.addAll(CommTools.getBeanList((List)uvrow, SeReportSubBO.class));
                }
                catch (Exception e) {
                    log.error("\u641c\u7d22PV\u67e5\u8be2\u5931\u8d25", (Throwable)e);
                }
            }
            uv = Db.use((String)"DATAPLAT").queryLong(sumUVSql);
            avgPVSql = null;
            avgPVSql = this.driverName.contains("dm") ? "SELECT     tableAS.\"time\",    ROUND((tableAS.PV / tableAS.UV), 2) AS \"countNum\" FROM (    SELECT         TO_CHAR(CREATE_TIME, 'HH24') || ':00:00' AS \"time\",        COUNT(DISTINCT SEARCH_ID) AS \"PV\",        COUNT(DISTINCT \"USER_ID\") AS \"UV\"    FROM STAND_SE_IN_LOG     WHERE CREATE_TIME BETWEEN         TO_DATE('" + start + "', 'YYYY-MM-DD HH24:MI:SS')         AND TO_DATE('" + end + "', 'YYYY-MM-DD HH24:MI:SS')     GROUP BY TO_CHAR(CREATE_TIME, 'HH24')  ) AS tableAS" : "SELECT tableAS.time, truncate((tableAS.PV/tableAS.UV),2) as countNum from( SELECT DATE_FORMAT(CREATE_TIME, '%H:00:00') AS time, COUNT(DISTINCT SEARCH_ID) AS PV, COUNT(DISTINCT `USER_ID`) AS UV FROM stand_se_in_log WHERE CREATE_TIME BETWEEN '" + start + "' AND '" + end + "' GROUP BY time) as tableAS";
            avgPVrow = Db.use((String)"DATAPLAT").find(avgPVSql);
            if (avgPVrow != null && avgPVrow.size() > 0) {
                try {
                    avgPV.addAll(CommTools.getBeanList((List)avgPVrow, SeReportSubBO.class));
                }
                catch (Exception e) {
                    log.error("\u641c\u7d22PV\u67e5\u8be2\u5931\u8d25", (Throwable)e);
                }
            }
        } else {
            groupPVSql = null;
            sumPVSql = null;
            if (this.driverName.contains("dm")) {
                groupPVSql = "SELECT     SYNC_DATE AS \"time\",    SEARCH_PV AS \"countNum\" FROM STAND_SE_INCREMENT_STATISTICS WHERE SYNC_DATE BETWEEN     TO_DATE('" + reqBO.getStartTime() + "', 'YYYY-MM-DD HH24:MI:SS')     AND TO_DATE('" + reqBO.getEndTime() + "', 'YYYY-MM-DD HH24:MI:SS') ORDER BY SYNC_DATE ASC";
                sumPVSql = "SELECT SUM(SEARCH_PV) FROM STAND_SE_INCREMENT_STATISTICS WHERE SYNC_DATE BETWEEN '" + reqBO.getStartTime() + "' AND '" + reqBO.getEndTime() + "'";
            } else {
                groupPVSql = "select sync_date as time,search_pv as countNum from stand_se_increment_statistics where `sync_date` BETWEEN '" + reqBO.getStartTime() + "' AND '" + reqBO.getEndTime() + "' order by sync_date asc";
                sumPVSql = "select sum(search_pv) from stand_se_increment_statistics where sync_date BETWEEN '" + reqBO.getStartTime() + "' AND '" + reqBO.getEndTime() + "'";
            }
            rowPV = Db.use((String)"DATAPLAT").find(groupPVSql);
            if (rowPV != null && rowPV.size() > 0) {
                try {
                    groupPV.addAll(CommTools.getBeanList((List)rowPV, SeReportSubBO.class));
                }
                catch (Exception e) {
                    log.error("\u641c\u7d22PV\u67e5\u8be2\u5931\u8d25", (Throwable)e);
                }
            }
            pv = Db.use((String)"DATAPLAT").queryLong(sumPVSql);
            groupUVSql = null;
            sumUVSql = null;
            if (this.driverName.contains("dm")) {
                groupUVSql = "SELECT     SYNC_DATE AS \"time\",    SEARCH_UV AS \"countNum\" FROM STAND_SE_INCREMENT_STATISTICS WHERE SYNC_DATE BETWEEN     TO_DATE('" + reqBO.getStartTime() + "', 'YYYY-MM-DD HH24:MI:SS')     AND TO_DATE('" + reqBO.getEndTime() + "', 'YYYY-MM-DD HH24:MI:SS') ORDER BY SYNC_DATE ASC";
                sumUVSql = "SELECT SUM(SEARCH_UV) FROM STAND_SE_INCREMENT_STATISTICS WHERE SYNC_DATE BETWEEN '" + reqBO.getStartTime() + "' AND '" + reqBO.getEndTime() + "'";
            } else {
                groupUVSql = "select sync_date as time,search_uv as countNum from stand_se_increment_statistics where `sync_date` BETWEEN '" + reqBO.getStartTime() + "' AND '" + reqBO.getEndTime() + "' order by sync_date asc";
                sumUVSql = "select sum(search_uv) from stand_se_increment_statistics where sync_date BETWEEN '" + reqBO.getStartTime() + "' AND '" + reqBO.getEndTime() + "' order by sync_date asc";
            }
            uvrow = Db.use((String)"DATAPLAT").find(groupUVSql);
            if (uvrow != null && uvrow.size() > 0) {
                try {
                    groupUV.addAll(CommTools.getBeanList((List)uvrow, SeReportSubBO.class));
                }
                catch (Exception e) {
                    log.error("\u641c\u7d22PV\u67e5\u8be2\u5931\u8d25", (Throwable)e);
                }
            }
            uv = Db.use((String)"DATAPLAT").queryLong(sumUVSql);
            avgPVSql = null;
            avgPVSql = this.driverName.contains("dm") ? "SELECT     SYNC_DATE AS \"time\",    AVG_PV AS \"countNum\" FROM STAND_SE_INCREMENT_STATISTICS WHERE SYNC_DATE BETWEEN     TO_DATE('" + reqBO.getStartTime() + "', 'YYYY-MM-DD HH24:MI:SS')     AND TO_DATE('" + reqBO.getEndTime() + "', 'YYYY-MM-DD HH24:MI:SS') ORDER BY SYNC_DATE ASC" : "select sync_date as time,avg_pv as countNum from stand_se_increment_statistics where sync_date BETWEEN '" + reqBO.getStartTime() + "' AND '" + reqBO.getEndTime() + "' order by sync_date asc";
            avgPVrow = Db.use((String)"DATAPLAT").find(avgPVSql);
            if (avgPVrow != null && avgPVrow.size() > 0) {
                try {
                    avgPV.addAll(CommTools.getBeanList((List)avgPVrow, SeReportSubBO.class));
                }
                catch (Exception e) {
                    log.error("\u641c\u7d22PV\u67e5\u8be2\u5931\u8d25", (Throwable)e);
                }
            }
        }
        List<List<String>> data = this.getLists(groupPV);
        sePVStatisticsBO.setTotal(pv);
        sePVStatisticsBO.setGroupTotal(data);
        List<List<String>> data1 = this.getLists(groupUV);
        seUVStatisticsBO.setTotal(uv);
        seUVStatisticsBO.setGroupTotal(data1);
        Long avg_pv_total = 0L;
        if (uv != null && uv > 0L && pv != null) {
            BigDecimal result = BigDecimal.valueOf(pv).divide(BigDecimal.valueOf(uv), 2, 4);
            avg_pv_total = result.longValue();
        }
        List<List<String>> data2 = this.getLists(avgPV);
        seAVGUVStatisticsBO.setTotal(avg_pv_total);
        seAVGUVStatisticsBO.setGroupTotal(data2);
        Long totalPV = 0L;
        if (reqBO.getStartTime().equals(reqBO.getEndTime())) {
            String totalPVSql = null;
            totalPVSql = this.driverName.contains("dm") ? "SELECT COUNT(DISTINCT SEARCH_ID) AS \"totalPV\" FROM STAND_SE_IN_LOG WHERE CREATE_TIME BETWEEN '" + start + "' AND '" + end + "' AND USER_PERMISSION IN ('tenant:10000:geticaigou', '22', 'tenant:10000:extenterprisecaigouqiyecaigouyuan', '2')" : "select count(DISTINCT(SEARCH_ID)) as totalPV FROM stand_se_in_log WHERE `CREATE_TIME` BETWEEN '" + start + "' AND '" + end + "' AND user_permission IN('tenant:10000:geticaigou','22','tenant:10000:extenterprisecaigouqiyecaigouyuan','2')";
            totalPV = Db.use((String)"DATAPLAT").queryLong(totalPVSql);
        }
        String pageSql = "";
        pageSql = reqBO.getStartTime().equals(reqBO.getEndTime()) ? (this.driverName.contains("dm") ? "SELECT     SUM(BEHAVIOR_PV) AS \"total_behavior_pv\",     SUM(PAGE_TOTAL) AS \"total_page_total\",     (CASE WHEN SUM(BEHAVIOR_PV) != 0 THEN ROUND((SUM(PAGE_TOTAL) / SUM(BEHAVIOR_PV)), 2) ELSE '0' END) AS \"rate\" FROM (    SELECT COUNT(SEARCH_ID) AS BEHAVIOR_PV, SUM(MIN_PAGE_NO) AS PAGE_TOTAL     FROM (        SELECT tableAS.SEARCH_ID, MIN(tableAS.PAGE_NO) AS MIN_PAGE_NO         FROM (            SELECT s.SEARCH_ID, s.PAGE_NO             FROM STAND_SE_ADD_PURCHASE_IN_LOG p             LEFT JOIN STAND_SE_IN_LOG s ON p.TRACE_ID = s.TRACE_ID             WHERE p.CREATE_TIME BETWEEN TO_DATE('" + start + "', 'YYYY-MM-DD HH24:MI:SS')               AND TO_DATE('" + end + "', 'YYYY-MM-DD HH24:MI:SS')             AND p.USER_PERMISSION IN ('tenant:10000:geticaigou', '22', 'tenant:10000:extenterprisecaigouqiyecaigouyuan', '2')             UNION ALL             SELECT s.SEARCH_ID, s.PAGE_NO             FROM STAND_SE_COLLECTION_IN_LOG p             LEFT JOIN STAND_SE_IN_LOG s ON p.TRACE_ID = s.TRACE_ID             WHERE p.CREATE_TIME BETWEEN TO_DATE('" + start + "', 'YYYY-MM-DD HH24:MI:SS')               AND TO_DATE('" + end + "', 'YYYY-MM-DD HH24:MI:SS')             AND p.USER_PERMISSION IN ('tenant:10000:geticaigou', '22', 'tenant:10000:extenterprisecaigouqiyecaigouyuan', '2')             UNION ALL             SELECT s.SEARCH_ID, s.PAGE_NO             FROM STAND_SE_COMM_DETAIL_IN_LOG p             LEFT JOIN STAND_SE_IN_LOG s ON p.TRACE_ID = s.TRACE_ID             WHERE p.CREATE_TIME BETWEEN TO_DATE('" + start + "', 'YYYY-MM-DD HH24:MI:SS')               AND TO_DATE('" + end + "', 'YYYY-MM-DD HH24:MI:SS')             AND p.USER_PERMISSION IN ('tenant:10000:geticaigou', '22', 'tenant:10000:extenterprisecaigouqiyecaigouyuan', '2')         ) AS tableAS         GROUP BY tableAS.SEARCH_ID     ) AS subquery ) AS tableAS1" : "SELECT SUM(behavior_pv) AS total_behavior_pv, SUM(page_total) AS total_page_total, (CASE WHEN SUM(behavior_pv) != 0 THEN TRUNCATE((SUM(page_total) / SUM(behavior_pv)), 2) ELSE '0' END) AS rate FROM (    SELECT COUNT(SEARCH_ID) AS behavior_pv, SUM(min_pageNO) AS page_total FROM (        SELECT tableAS.SEARCH_ID, MIN(tableAS.PAGE_NO) AS min_pageNO         FROM (            SELECT s.SEARCH_ID, s.PAGE_NO             FROM stand_se_add_purchase_in_log p             LEFT JOIN stand_se_in_log s ON p.TRACE_ID = s.TRACE_ID             WHERE p.CREATE_TIME BETWEEN '" + start + "' AND '" + end + "'             AND p.user_permission IN ('tenant:10000:geticaigou', '22', 'tenant:10000:extenterprisecaigouqiyecaigouyuan', '2')             UNION ALL             SELECT s.SEARCH_ID, s.PAGE_NO             FROM stand_se_collection_in_log p             LEFT JOIN stand_se_in_log s ON p.TRACE_ID = s.TRACE_ID             WHERE p.CREATE_TIME BETWEEN '" + start + "' AND '" + end + "'             AND p.user_permission IN ('tenant:10000:geticaigou', '22', 'tenant:10000:extenterprisecaigouqiyecaigouyuan', '2')             UNION ALL             SELECT s.SEARCH_ID, s.PAGE_NO             FROM stand_se_comm_detail_in_log p             LEFT JOIN stand_se_in_log s ON p.TRACE_ID = s.TRACE_ID             WHERE p.CREATE_TIME BETWEEN '" + start + "' AND '" + end + "'             AND p.user_permission IN ('tenant:10000:geticaigou', '22', 'tenant:10000:extenterprisecaigouqiyecaigouyuan', '2')         ) AS tableAS         GROUP BY tableAS.SEARCH_ID     ) AS subquery ) AS tableAS1") : (this.driverName.contains("dm") ? "SELECT     SUM(BEHAVIOR_PV) AS \"behavior_pv\",    SUM(PAGE_TOTAL) AS \"page_total\",    (CASE WHEN SUM(BEHAVIOR_PV) != 0 THEN ROUND((SUM(PAGE_TOTAL) / SUM(BEHAVIOR_PV)), 2) ELSE '0' END) AS \"rate\" FROM STAND_SE_INCREMENT_STATISTICS WHERE SYNC_DATE BETWEEN     TO_DATE('" + reqBO.getStartTime() + "', 'YYYY-MM-DD HH24:MI:SS')     AND TO_DATE('" + reqBO.getEndTime() + "', 'YYYY-MM-DD HH24:MI:SS')" : "select sum(behavior_pv) as behavior_pv,sum(page_total) as page_total,(CASE WHEN sum(behavior_pv) !=0 THEN truncate((sum(page_total)/sum(behavior_pv)),2) ELSE '0' END ) as rate from stand_se_increment_statistics where sync_date BETWEEN '" + reqBO.getStartTime() + "' AND '" + reqBO.getEndTime() + "'");
        Record pagerow = Db.use((String)"DATAPLAT").findFirst(pageSql);
        SeRateStatisticsBO pageBo = new SeRateStatisticsBO();
        if (pagerow != null) {
            pageBo.setTotal1(pagerow.getLong("page_total"));
            pageBo.setTotal2(pagerow.getLong("behavior_pv"));
            String rate = pagerow.getStr("rate");
            if (rate != null) {
                if (rate.endsWith(".00")) {
                    rate = rate.substring(0, rate.length() - 3);
                }
            } else {
                rate = "0";
            }
            pageBo.setRate(rate);
        }
        String noResSql = "";
        SeRateStatisticsBO noResBo = new SeRateStatisticsBO();
        if (reqBO.getStartTime().equals(reqBO.getEndTime())) {
            String noResSql1 = null;
            noResSql1 = this.driverName.contains("dm") ? "SELECT COUNT(DISTINCT a.SEARCH_ID) AS \"noRes\" FROM STAND_SE_IN_LOG a, STAND_SE_OUT_LOG b WHERE a.TRACE_ID = b.TRACE_ID AND (a.QUERY_FILTER_LIST IS NULL OR a.QUERY_FILTER_LIST = ''      AND a.QUERY_PROPERTY_LIST = '' OR a.QUERY_PROPERTY_LIST IS NULL) AND a.CREATE_TIME BETWEEN '" + start + "' AND '" + end + "' AND b.RECORDS_TOTAL = 0" : "SELECT        count(DISTINCT a.SEARCH_ID) as noRes        FROM        stand_se_in_log a,stand_se_out_log b        WHERE a.`trace_id` = b.`trace_id`        AND (a.QUERY_FILTER_LIST is null OR a.QUERY_FILTER_LIST=''         AND a.QUERY_PROPERTY_LIST='' OR a.QUERY_PROPERTY_LIST is null)        AND a.CREATE_TIME BETWEEN '" + start + "' AND '" + end + "'        AND b.RECORDS_TOTAL=0";
            Long noRes = Db.use((String)"DATAPLAT").queryLong(noResSql1);
            noResBo.setTotal1(noRes);
            noResBo.setTotal2(totalPV);
            if (totalPV != null && totalPV > 0L) {
                BigDecimal result = BigDecimal.valueOf(noRes * 100L).divide(BigDecimal.valueOf(totalPV), 2, 4);
                noResBo.setRate(result.toString() + "%");
            }
        } else {
            noResSql = this.driverName.contains("dm") ? "SELECT     SUM(BUYER_PV) AS \"buyerPv\",    SUM(NO_RESULT_NUM) AS \"noRes\",    (CASE WHEN SUM(BUYER_PV) != 0 THEN CONCAT(ROUND((SUM(NO_RESULT_NUM) * 100 / SUM(BUYER_PV)), 2), '%') ELSE '0%' END) AS \"rate\" FROM STAND_SE_INCREMENT_STATISTICS WHERE SYNC_DATE BETWEEN     TO_DATE('" + reqBO.getStartTime() + "', 'YYYY-MM-DD HH24:MI:SS')     AND TO_DATE('" + reqBO.getEndTime() + "', 'YYYY-MM-DD HH24:MI:SS')" : "select sum(buyer_pv) as buyerPv,sum(no_result_num) as noRes,(CASE WHEN sum(buyer_pv) !=0 THEN CONCAT(truncate((sum(no_result_num) * 100/sum(buyer_pv)),2),'%') ELSE '0%' END ) as rate from stand_se_increment_statistics where sync_date BETWEEN '" + reqBO.getStartTime() + "' AND '" + reqBO.getEndTime() + "'";
        }
        if (!noResSql.isEmpty() && (noResrow = Db.use((String)"DATAPLAT").findFirst(noResSql)) != null) {
            noResBo.setTotal1(noResrow.getLong("noRes"));
            noResBo.setTotal2(noResrow.getLong("buyerPv"));
            noResBo.setRate(noResrow.getStr("rate"));
        }
        String clickRateSql = "";
        SeRateStatisticsBO clickRateBo = new SeRateStatisticsBO();
        if (reqBO.getStartTime().equals(reqBO.getEndTime())) {
            String sql = null;
            sql = this.driverName.contains("dm") ? "SELECT COUNT(1) AS \"behaviorPv\" FROM (    SELECT s.SEARCH_ID     FROM STAND_SE_ADD_PURCHASE_IN_LOG p     LEFT JOIN STAND_SE_IN_LOG s ON p.TRACE_ID = s.TRACE_ID     WHERE s.CREATE_TIME BETWEEN TO_DATE('" + start + "', 'YYYY-MM-DD HH24:MI:SS')       AND TO_DATE('" + end + "', 'YYYY-MM-DD HH24:MI:SS')     AND p.USER_PERMISSION IN ('tenant:10000:geticaigou', '22', 'tenant:10000:extenterprisecaigouqiyecaigouyuan', '2')     UNION     SELECT s.SEARCH_ID     FROM STAND_SE_COLLECTION_IN_LOG p     LEFT JOIN STAND_SE_IN_LOG s ON p.TRACE_ID = s.TRACE_ID     WHERE s.CREATE_TIME BETWEEN TO_DATE('" + start + "', 'YYYY-MM-DD HH24:MI:SS')       AND TO_DATE('" + end + "', 'YYYY-MM-DD HH24:MI:SS')     AND p.USER_PERMISSION IN ('tenant:10000:geticaigou', '22', 'tenant:10000:extenterprisecaigouqiyecaigouyuan', '2')     UNION     SELECT s.SEARCH_ID     FROM STAND_SE_COMM_DETAIL_IN_LOG p     LEFT JOIN STAND_SE_IN_LOG s ON p.TRACE_ID = s.TRACE_ID     WHERE s.CREATE_TIME BETWEEN TO_DATE('" + start + "', 'YYYY-MM-DD HH24:MI:SS')       AND TO_DATE('" + end + "', 'YYYY-MM-DD HH24:MI:SS')     AND p.USER_PERMISSION IN ('tenant:10000:geticaigou', '22', 'tenant:10000:extenterprisecaigouqiyecaigouyuan', '2') ) AS tableAS" : "select count(1) as behaviorPv from( select s.SEARCH_ID from stand_se_add_purchase_in_log p left join stand_se_in_log s on p.TRACE_ID=s.TRACE_ID  WHERE s.`CREATE_TIME` BETWEEN '" + start + "' AND '" + end + "' AND p.user_permission IN('tenant:10000:geticaigou','22','tenant:10000:extenterprisecaigouqiyecaigouyuan','2') union  select s.SEARCH_ID from stand_se_collection_in_log p left join stand_se_in_log s on p.TRACE_ID=s.TRACE_ID  WHERE s.`CREATE_TIME` BETWEEN '" + start + "' AND '" + end + "' AND p.user_permission IN('tenant:10000:geticaigou','22','tenant:10000:extenterprisecaigouqiyecaigouyuan','2') union  select s.SEARCH_ID from stand_se_comm_detail_in_log p left join stand_se_in_log s on p.TRACE_ID=s.TRACE_ID  WHERE s.`CREATE_TIME` BETWEEN '" + start + "' AND '" + end + "' AND p.user_permission IN('tenant:10000:geticaigou','22','tenant:10000:extenterprisecaigouqiyecaigouyuan','2') ) as tableAS ";
            Long behaviorPv = Db.use((String)"DATAPLAT").queryLong(sql);
            clickRateBo.setTotal1(behaviorPv);
            clickRateBo.setTotal2(totalPV);
            if (totalPV != null && totalPV > 0L) {
                BigDecimal result = BigDecimal.valueOf(behaviorPv * 100L).divide(BigDecimal.valueOf(totalPV), 2, 4);
                clickRateBo.setRate(result.toString() + "%");
            }
        } else {
            clickRateSql = this.driverName.contains("dm") ? "SELECT     SUM(BEHAVIOR_PV) AS \"behaviorPv\",    SUM(BUYER_PV) AS \"buyerPv\",    (CASE WHEN SUM(BUYER_PV) != 0 THEN CONCAT(ROUND((SUM(BEHAVIOR_PV) * 100 / SUM(BUYER_PV)), 2), '%') ELSE '0%' END) AS \"rate\" FROM STAND_SE_INCREMENT_STATISTICS WHERE SYNC_DATE BETWEEN     TO_DATE('" + reqBO.getStartTime() + "', 'YYYY-MM-DD HH24:MI:SS')     AND TO_DATE('" + reqBO.getEndTime() + "', 'YYYY-MM-DD HH24:MI:SS')" : "select sum(behavior_pv) as behaviorPv,sum(buyer_pv) as buyerPv,(CASE WHEN sum(buyer_pv) !=0 THEN CONCAT(truncate((sum(behavior_pv) * 100/sum(buyer_pv)),2),'%') ELSE '0%' END ) as rate from stand_se_increment_statistics where `sync_date` BETWEEN '" + reqBO.getStartTime() + "' AND '" + reqBO.getEndTime() + "'";
        }
        if (!clickRateSql.isEmpty() && (row = Db.use((String)"DATAPLAT").findFirst(clickRateSql)) != null) {
            clickRateBo.setTotal1(row.getLong("behaviorPv"));
            clickRateBo.setTotal2(row.getLong("buyerPv"));
            clickRateBo.setRate(row.getStr("rate"));
        }
        String searchAgainSql = "";
        SeRateStatisticsBO searchAgain = new SeRateStatisticsBO();
        if (reqBO.getStartTime().equals(reqBO.getEndTime())) {
            Long search_again_total;
            Long search_again_user;
            Record record = new Record();
            this.getSearchAgainNumber(record, month, reqBO.getStartTime());
            if (this.driverName.contains("dm")) {
                search_again_user = record.getLong("SEARCH_AGAIN_USER");
                search_again_total = record.getLong("SEARCH_AGAIN_TOTAL");
            } else {
                search_again_user = record.getLong("search_again_user");
                search_again_total = record.getLong("search_again_total");
            }
            searchAgain.setTotal1(search_again_total);
            searchAgain.setTotal2(search_again_user);
            if (search_again_user != null && search_again_user > 0L) {
                BigDecimal result = BigDecimal.valueOf(search_again_total).divide(BigDecimal.valueOf(search_again_user), 2, 4);
                searchAgain.setRate(result.toString());
            }
        } else {
            searchAgainSql = this.driverName.contains("dm") ? "SELECT     SUM(SEARCH_AGAIN_USER) AS \"user\",    SUM(SEARCH_AGAIN_TOTAL) AS \"total\",    (CASE WHEN SUM(SEARCH_AGAIN_USER) != 0 THEN ROUND((SUM(SEARCH_AGAIN_TOTAL) / SUM(SEARCH_AGAIN_USER)), 2) ELSE '0' END) AS \"rate\" FROM STAND_SE_INCREMENT_STATISTICS WHERE SYNC_DATE BETWEEN     TO_DATE('" + reqBO.getStartTime() + "', 'YYYY-MM-DD HH24:MI:SS')     AND TO_DATE('" + reqBO.getEndTime() + "', 'YYYY-MM-DD HH24:MI:SS')" : "select sum(search_again_user) as user,sum(search_again_total) as total,(CASE WHEN sum(search_again_user) !=0 THEN truncate((sum(search_again_total)/sum(search_again_user)),2) ELSE '0' END ) as rate from stand_se_increment_statistics where `sync_date` BETWEEN '" + reqBO.getStartTime() + "' AND '" + reqBO.getEndTime() + "'";
        }
        if (!searchAgainSql.isEmpty() && (rows = Db.use((String)"DATAPLAT").findFirst(searchAgainSql)) != null) {
            searchAgain.setTotal1(rows.getLong("total"));
            searchAgain.setTotal2(rows.getLong("user"));
            String rate = rows.getStr("rate");
            if (rate != null) {
                if (rate.endsWith(".00")) {
                    rate = rate.substring(0, rate.length() - 3);
                }
            } else {
                rate = "0";
            }
            searchAgain.setRate(rate);
        }
        rspBO.setPv(sePVStatisticsBO);
        rspBO.setUv(seUVStatisticsBO);
        rspBO.setPerCapitaPV(seAVGUVStatisticsBO);
        rspBO.setPagePV(pageBo);
        rspBO.setNoResult(noResBo);
        rspBO.setPvCTR(clickRateBo);
        rspBO.setSearchAgain(searchAgain);
        return rspBO;
    }

    private List<List<String>> getLists(List<SeReportSubBO> groupPV) {
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        for (SeReportSubBO bo : groupPV) {
            ArrayList<String> subList = new ArrayList<String>();
            subList.add(bo.getTime());
            subList.add(bo.getCountNum());
            data.add(subList);
        }
        return data;
    }

    public SeWordCloudRspBO selectWordCloudData(SeReportStatisticsBO reqBO) throws ZTBusinessException {
        SeWordCloudRspBO rspBO = new SeWordCloudRspBO();
        log.info("\u8bcd\u4e91\u67e5\u8be2\u5165\u53c2:{}", (Object)reqBO.toString());
        if (StringUtils.isEmpty((CharSequence)reqBO.getFlag())) {
            throw new ZTBusinessException("flag\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String start = reqBO.getStartTime() + " 00:00:00";
        String end = reqBO.getEndTime() + " 23:59:59";
        ArrayList topWord = new ArrayList();
        ArrayList lowClickWord = new ArrayList();
        ArrayList lowResWord = new ArrayList();
        ArrayList noResWord = new ArrayList();
        NumberFormat nf = NumberFormat.getPercentInstance();
        String topWordLimit = this.getConfig("topWordLimit");
        String topWordClickCount = this.getConfig("topWordClickCount");
        switch (reqBO.getFlag()) {
            case "1": {
                String topWordSql = "";
                topWordSql = reqBO.getStartTime().equals(reqBO.getEndTime()) ? (this.driverName.contains("dm") ? "SELECT     tableAS.\"name\",    tableAS.\"value\",    tableAS.\"clickPv\",    (CASE WHEN tableAS.\"value\" != 0 THEN CONCAT(ROUND((tableAS.\"clickPv\" * 100 / tableAS.\"value\"), 2), '%') ELSE '0%' END) AS \"clickPvRate\" FROM (    SELECT         a.QUERY_STR AS \"name\",        COUNT(DISTINCT a.SEARCH_ID) AS \"value\",        (SELECT COUNT(DISTINCT search_id)          FROM STAND_SE_IN_LOG          WHERE CREATE_TIME BETWEEN TO_DATE('" + start + "', 'YYYY-MM-DD HH24:MI:SS')            AND TO_DATE('" + end + "', 'YYYY-MM-DD HH24:MI:SS')            AND QUERY_STR = a.QUERY_STR            AND search_id IN (                SELECT SEARCH_ID FROM STAND_SE_COLLECTION_IN_LOG                UNION                SELECT SEARCH_ID FROM STAND_SE_ADD_PURCHASE_IN_LOG                UNION                SELECT SEARCH_ID FROM STAND_SE_COMM_DETAIL_IN_LOG            )        ) AS \"clickPv\"     FROM STAND_SE_IN_LOG a     WHERE a.CREATE_TIME BETWEEN TO_DATE('" + start + "', 'YYYY-MM-DD HH24:MI:SS')       AND TO_DATE('" + end + "', 'YYYY-MM-DD HH24:MI:SS')       AND (a.QUERY_FILTER_LIST IS NULL OR a.QUERY_FILTER_LIST = ''            OR a.QUERY_PROPERTY_LIST = '' OR a.QUERY_PROPERTY_LIST IS NULL)     GROUP BY a.QUERY_STR ) AS tableAS WHERE tableAS.\"value\" > " + topWordClickCount + " ORDER BY tableAS.\"value\" DESC FETCH FIRST " + topWordLimit + " ROWS ONLY" : "SELECT tableAS.name,tableAS.`value`,tableAS.clickPv,    (CASE WHEN tableAS.`value` !=0 THEN CONCAT(truncate((tableAS.clickPv * 100/tableAS.`value`),2),'%') ELSE '0%' END ) as clickPvRate from( SELECT a.`QUERY_STR` as name, count(DISTINCT a.SEARCH_ID) AS `value`, (SELECT count( DISTINCT search_id ) FROM stand_se_in_log WHERE  CREATE_TIME BETWEEN '" + start + "' AND '" + end + "' AND QUERY_STR = a.QUERY_STR  AND search_id IN ( SELECT SEARCH_ID FROM stand_se_collection_in_log UNION SELECT SEARCH_ID FROM stand_se_add_purchase_in_log UNION SELECT SEARCH_ID FROM stand_se_comm_detail_in_log )) AS clickPv \n FROM stand_se_in_log a WHERE a.CREATE_TIME BETWEEN '" + start + "' AND '" + end + "' AND (a.QUERY_FILTER_LIST is null OR a.QUERY_FILTER_LIST=''  AND a.QUERY_PROPERTY_LIST='' OR a.QUERY_PROPERTY_LIST is null) GROUP BY a.`QUERY_STR`) as tableAS WHERE tableAS.`value`> " + topWordClickCount + " ORDER BY tableAS.`value` DESC LIMIT " + topWordLimit) : (this.driverName.contains("dm") ? "SELECT     tableAS.\"query_str\" AS \"name\",    tableAS.\"searchTotal\" AS \"value\",    tableAS.\"clickPv\",    (CASE WHEN tableAS.\"searchTotal\" != 0 THEN CONCAT(ROUND((tableAS.\"clickPv\" * 100 / tableAS.\"searchTotal\"), 2), '%') ELSE '0%' END) AS \"clickPvRate\" FROM (    SELECT         QUERY_STR AS \"query_str\",        SUM(SEARCH_TOTAL) AS \"searchTotal\",        SUM(CLICK_TOTAL) AS \"clickPv\"     FROM STAND_SE_WORD_STATISTICS     WHERE SYNC_DATE BETWEEN TO_DATE('" + reqBO.getStartTime() + "', 'YYYY-MM-DD HH24:MI:SS')       AND TO_DATE('" + reqBO.getEndTime() + "', 'YYYY-MM-DD HH24:MI:SS')       AND WORD_TYPE = 0     GROUP BY QUERY_STR ) AS tableAS WHERE tableAS.\"searchTotal\" > " + topWordClickCount + " ORDER BY tableAS.\"searchTotal\" DESC FETCH FIRST " + topWordLimit + " ROWS ONLY" : "SELECT tableAS.query_str as name, tableAS.searchTotal as `value`, tableAS.clickPv, ( CASE WHEN tableAS.`searchTotal` != 0 THEN CONCAT( TRUNCATE (( tableAS.clickPv * 100 / tableAS.`searchTotal` ), 2 ), '%' ) ELSE '0%' END ) AS clickPvRate  FROM ( SELECT query_str, SUM( search_total ) AS searchTotal, SUM( click_total ) AS clickPv  FROM stand_se_word_statistics WHERE `sync_date` BETWEEN '" + reqBO.getStartTime() + "' AND '" + reqBO.getEndTime() + "' AND word_type = 0 GROUP BY query_str  ) AS tableAS  WHERE tableAS.`searchTotal` > " + topWordClickCount + " ORDER BY tableAS.`searchTotal` DESC LIMIT " + topWordLimit);
                List topWordRow = Db.use((String)"DATAPLAT").find(topWordSql);
                if (topWordRow == null || topWordRow.size() <= 0) break;
                try {
                    topWord.addAll(CommTools.getBeanList((List)topWordRow, SeWordCloudBO.class));
                }
                catch (Exception e) {
                    log.error("\u9ad8\u9891\u8bcd\u67e5\u8be2\u5931\u8d25", (Throwable)e);
                }
                break;
            }
            case "2": {
                String lowFrequencyPer = this.getConfig("lowFrequencyPer");
                Number m = null;
                try {
                    m = nf.parse(lowFrequencyPer + "%");
                    reqBO.setConfValue(m.floatValue() + "");
                }
                catch (ParseException e) {
                    throw new ZTBusinessException(e.getMessage());
                }
                String lowWordSql = "";
                lowWordSql = reqBO.getStartTime().equals(reqBO.getEndTime()) ? (this.driverName.contains("dm") ? "SELECT     tableAS.\"name\",    tableAS.\"value\",    tableAS.\"clickPv\",    (CASE WHEN tableAS.\"value\" != 0 THEN CONCAT(ROUND((tableAS.\"clickPv\" * 100 / tableAS.\"value\"), 2), '%') ELSE '0%' END) AS \"clickPvRate\" FROM (    SELECT         tableAS1.\"name\",        tableAS1.\"value\",        tableAS1.\"clickPv\"     FROM (        SELECT             a.QUERY_STR AS \"name\",            COUNT(DISTINCT a.SEARCH_ID) AS \"value\",            (SELECT COUNT(DISTINCT search_id)              FROM STAND_SE_IN_LOG              WHERE CREATE_TIME BETWEEN TO_DATE('" + start + "', 'YYYY-MM-DD HH24:MI:SS')                AND TO_DATE('" + end + "', 'YYYY-MM-DD HH24:MI:SS')                AND QUERY_STR = a.QUERY_STR                AND search_id IN (                    SELECT SEARCH_ID FROM STAND_SE_COLLECTION_IN_LOG                    UNION                    SELECT SEARCH_ID FROM STAND_SE_ADD_PURCHASE_IN_LOG                    UNION                    SELECT SEARCH_ID FROM STAND_SE_COMM_DETAIL_IN_LOG                )            ) AS \"clickPv\"         FROM STAND_SE_IN_LOG a         WHERE a.CREATE_TIME BETWEEN TO_DATE('" + start + "', 'YYYY-MM-DD HH24:MI:SS')           AND TO_DATE('" + end + "', 'YYYY-MM-DD HH24:MI:SS')           AND (a.QUERY_FILTER_LIST IS NULL OR a.QUERY_FILTER_LIST = ''                OR a.QUERY_PROPERTY_LIST = '' OR a.QUERY_PROPERTY_LIST IS NULL)         GROUP BY a.QUERY_STR     ) AS tableAS1     WHERE tableAS1.\"value\" > " + topWordClickCount + "    ORDER BY tableAS1.\"value\" DESC     FETCH FIRST " + topWordLimit + " ROWS ONLY ) AS tableAS WHERE (CASE WHEN tableAS.\"value\" != 0 THEN ROUND((tableAS.\"clickPv\" / tableAS.\"value\"), 2) ELSE 0 END) <= " + m.floatValue() : "SELECT tableAS.name,tableAS.`value`,tableAS.clickPv,   (CASE WHEN tableAS.`value` !=0 THEN CONCAT(truncate((tableAS.clickPv * 100/tableAS.`value`),2),'%') ELSE '0%' END ) as clickPvRate from ( SELECT tableAS1.name,tableAS1.value,tableAS1.clickPv from( SELECT a.`QUERY_STR` as name, count(DISTINCT a.SEARCH_ID) AS `value`, (SELECT count( DISTINCT search_id ) FROM stand_se_in_log WHERE  CREATE_TIME BETWEEN '" + start + "' AND '" + end + "' AND QUERY_STR = a.QUERY_STR  AND search_id IN ( SELECT SEARCH_ID FROM stand_se_collection_in_log UNION SELECT SEARCH_ID FROM stand_se_add_purchase_in_log UNION SELECT SEARCH_ID FROM stand_se_comm_detail_in_log )) AS clickPv \n FROM stand_se_in_log a WHERE a.CREATE_TIME BETWEEN '" + start + "' AND '" + end + "' AND (a.QUERY_FILTER_LIST is null OR a.QUERY_FILTER_LIST=''  AND a.QUERY_PROPERTY_LIST='' OR a.QUERY_PROPERTY_LIST is null) GROUP BY a.`QUERY_STR` ) as tableAS1 WHERE tableAS1.`value`> " + topWordClickCount + " ORDER BY tableAS1.`value` DESC LIMIT " + topWordLimit + " ) as tableAS WHERE (CASE WHEN tableAS.`value` !=0 THEN truncate((tableAS.clickPv/tableAS.`value`),2) ELSE 0 END )  <=" + m.floatValue()) : (this.driverName.contains("dm") ? "SELECT     tableAS.\"query_str\" AS \"name\",    tableAS.\"searchTotal\" AS \"value\",    tableAS.\"clickPv\",    (CASE WHEN tableAS.\"searchTotal\" != 0 THEN CONCAT(ROUND((tableAS.\"clickPv\" * 100 / tableAS.\"searchTotal\"), 2), '%') ELSE '0%' END) AS \"clickPvRate\" FROM (    SELECT         tableAS.\"query_str\",        tableAS.\"searchTotal\",        tableAS.\"clickPv\"     FROM (        SELECT             QUERY_STR AS \"query_str\",            SUM(SEARCH_TOTAL) AS \"searchTotal\",            SUM(CLICK_TOTAL) AS \"clickPv\"         FROM STAND_SE_WORD_STATISTICS         WHERE SYNC_DATE BETWEEN TO_DATE('" + reqBO.getStartTime() + "', 'YYYY-MM-DD HH24:MI:SS')           AND TO_DATE('" + reqBO.getEndTime() + "', 'YYYY-MM-DD HH24:MI:SS')           AND WORD_TYPE = 0         GROUP BY QUERY_STR     ) AS tableAS     WHERE tableAS.\"searchTotal\" > " + topWordClickCount + "    ORDER BY tableAS.\"searchTotal\" DESC     FETCH FIRST " + topWordLimit + " ROWS ONLY ) AS tableAS WHERE (CASE WHEN tableAS.\"searchTotal\" != 0 THEN ROUND((tableAS.\"clickPv\" / tableAS.\"searchTotal\"), 2) ELSE 0 END) <= " + m.floatValue() : "SELECT tableAS.query_str as name,tableAS.searchTotal as `value`,tableAS.clickPv,   (CASE WHEN tableAS.`searchTotal` !=0 THEN CONCAT(truncate((tableAS.clickPv * 100/tableAS.`searchTotal`),2),'%') ELSE '0%' END ) as clickPvRate from ( SELECT tableAS.query_str, tableAS.searchTotal, tableAS.clickPv FROM ( SELECT query_str, SUM( search_total ) AS searchTotal, SUM( click_total ) AS clickPv  FROM stand_se_word_statistics WHERE `sync_date` BETWEEN '" + reqBO.getStartTime() + "' AND '" + reqBO.getEndTime() + "' AND word_type = 0 GROUP BY query_str  ) AS tableAS  WHERE  tableAS.`searchTotal` > " + topWordClickCount + " ORDER BY tableAS.`searchTotal` DESC LIMIT " + topWordLimit + " ) as tableAS   WHERE (CASE WHEN tableAS.`searchTotal` !=0 THEN truncate((tableAS.clickPv/tableAS.`searchTotal`),2) ELSE 0 END )  <=" + m.floatValue());
                List lowClickWordRow = Db.use((String)"DATAPLAT").find(lowWordSql);
                if (lowClickWordRow == null || lowClickWordRow.size() <= 0) break;
                try {
                    lowClickWord.addAll(CommTools.getBeanList((List)lowClickWordRow, SeWordCloudBO.class));
                }
                catch (Exception e) {
                    log.error("\u4f4e\u70b9\u51fb\u7387\u8bcd\u67e5\u8be2\u5931\u8d25", (Throwable)e);
                }
                break;
            }
            case "3": {
                String minimumSearchResults = this.getConfig("minimumSearchResults");
                if (!StringUtils.isEmpty((CharSequence)minimumSearchResults)) {
                    reqBO.setLimitValue(Integer.valueOf(minimumSearchResults));
                }
                String lowResSql = "";
                lowResSql = reqBO.getStartTime().equals(reqBO.getEndTime()) ? (this.driverName.contains("dm") ? "SELECT     tableAS.\"name\",    tableAS.\"value\",    tableAS.\"clickPv\",    (CASE WHEN tableAS.\"value\" != 0 THEN CONCAT(ROUND((tableAS.\"clickPv\" * 100 / tableAS.\"value\"), 2), '%') ELSE '0%' END) AS \"clickPvRate\" FROM (    SELECT         a.QUERY_STR AS \"name\",        COUNT(1) AS \"value\",        SUM(CASE WHEN a.SEARCH_ID IN (             SELECT SEARCH_ID FROM STAND_SE_COLLECTION_IN_LOG             UNION             SELECT SEARCH_ID FROM STAND_SE_ADD_PURCHASE_IN_LOG             UNION             SELECT SEARCH_ID FROM STAND_SE_COMM_DETAIL_IN_LOG         ) THEN 1 ELSE 0 END) AS \"clickPv\"     FROM         STAND_SE_IN_LOG a     JOIN         STAND_SE_OUT_LOG b     ON         a.TRACE_ID = b.TRACE_ID     WHERE         a.CREATE_TIME BETWEEN TO_DATE('" + start + "', 'YYYY-MM-DD HH24:MI:SS')         AND TO_DATE('" + end + "', 'YYYY-MM-DD HH24:MI:SS')         AND (a.QUERY_FILTER_LIST IS NULL OR a.QUERY_FILTER_LIST = ''              OR a.QUERY_PROPERTY_LIST = '' OR a.QUERY_PROPERTY_LIST IS NULL)         AND b.RECORDS_TOTAL > 0         AND b.RECORDS_TOTAL <= " + minimumSearchResults + "    GROUP BY         a.QUERY_STR ) AS tableAS" : "SELECT tableAS.name,tableAS.`value`,tableAS.clickPv, (CASE WHEN tableAS.`value` !=0 THEN CONCAT(truncate((tableAS.clickPv * 100/tableAS.`value`),2),'%') ELSE '0%' END ) as clickPvRate from ( SELECT a.`QUERY_STR` as name, count(1) as `value`, SUM(a.SEARCH_ID in(SELECT SEARCH_ID FROM stand_se_collection_in_log   UNION SELECT SEARCH_ID FROM stand_se_add_purchase_in_log   UNION SELECT SEARCH_ID FROM stand_se_comm_detail_in_log )) AS clickPv  FROM  stand_se_in_log a ,stand_se_out_log b  WHERE a.CREATE_TIME BETWEEN '" + start + "' AND '" + end + "' AND a.`trace_id` = b.`trace_id`  AND (a.QUERY_FILTER_LIST is null OR a.QUERY_FILTER_LIST=''  AND a.QUERY_PROPERTY_LIST='' OR a.QUERY_PROPERTY_LIST is null) AND b.RECORDS_TOTAL > 0  AND b.RECORDS_TOTAL <= " + Integer.valueOf(minimumSearchResults) + " GROUP BY a.`QUERY_STR` ) as tableAS ") : (this.driverName.contains("dm") ? "SELECT     tableAS.\"query_str\" AS \"name\",    tableAS.\"searchTotal\" AS \"value\",    tableAS.\"clickPv\",    (CASE WHEN tableAS.\"searchTotal\" != 0 THEN CONCAT(ROUND((tableAS.\"clickPv\" * 100 / tableAS.\"searchTotal\"), 2), '%') ELSE '0%' END) AS \"clickPvRate\" FROM (    SELECT         QUERY_STR AS \"query_str\",        SUM(SEARCH_TOTAL) AS \"searchTotal\",        SUM(CLICK_TOTAL) AS \"clickPv\"     FROM         STAND_SE_WORD_STATISTICS     WHERE         SYNC_DATE BETWEEN TO_DATE('" + reqBO.getStartTime() + "', 'YYYY-MM-DD HH24:MI:SS')         AND TO_DATE('" + reqBO.getEndTime() + "', 'YYYY-MM-DD HH24:MI:SS')         AND WORD_TYPE = 0         AND RECORDS_TOTAL > 0         AND RECORDS_TOTAL <= " + minimumSearchResults + "    GROUP BY         QUERY_STR ) AS tableAS" : "SELECT tableAS.query_str as name,tableAS.`searchTotal` as `value`,tableAS.clickPv,   (CASE WHEN tableAS.`searchTotal` !=0 THEN CONCAT(truncate((tableAS.clickPv * 100/tableAS.`searchTotal`),2),'%') ELSE '0%' END ) as clickPvRate from ( SELECT query_str, SUM( search_total ) AS searchTotal, SUM( click_total ) AS clickPv  FROM stand_se_word_statistics WHERE `sync_date` BETWEEN '" + reqBO.getStartTime() + "' AND '" + reqBO.getEndTime() + "' AND word_type = 0 AND records_total >0 AND records_total <= " + Integer.valueOf(minimumSearchResults) + " GROUP BY query_str) as tableAS ");
                List lowWordRow = Db.use((String)"DATAPLAT").find(lowResSql);
                if (lowWordRow == null || lowWordRow.size() <= 0) break;
                try {
                    lowResWord.addAll(CommTools.getBeanList((List)lowWordRow, SeWordCloudBO.class));
                }
                catch (Exception e) {
                    log.error("\u65e0\u7ed3\u679c\u8bcd\u67e5\u8be2\u5931\u8d25", (Throwable)e);
                }
                break;
            }
            case "4": {
                String noResSql = "";
                noResSql = reqBO.getStartTime().equals(reqBO.getEndTime()) ? (this.driverName.contains("dm") ? "SELECT     a.QUERY_STR AS \"name\",    COUNT(1) AS \"value\" FROM     STAND_SE_IN_LOG a JOIN     STAND_SE_OUT_LOG b ON     a.TRACE_ID = b.TRACE_ID WHERE     a.CREATE_TIME BETWEEN TO_DATE('" + start + "', 'YYYY-MM-DD HH24:MI:SS')     AND TO_DATE('" + end + "', 'YYYY-MM-DD HH24:MI:SS')     AND (a.QUERY_FILTER_LIST IS NULL OR a.QUERY_FILTER_LIST = ''          OR a.QUERY_PROPERTY_LIST = '' OR a.QUERY_PROPERTY_LIST IS NULL)     AND b.RECORDS_TOTAL = 0 GROUP BY     a.QUERY_STR" : "SELECT a.`QUERY_STR` as name, count(1) as `value` FROM stand_se_in_log a ,stand_se_out_log b WHERE a.CREATE_TIME BETWEEN '" + start + "' AND '" + end + "' AND a.`trace_id` = b.`trace_id` AND (a.QUERY_FILTER_LIST is null OR a.QUERY_FILTER_LIST=''  AND a.QUERY_PROPERTY_LIST='' OR a.QUERY_PROPERTY_LIST is null) AND b.RECORDS_TOTAL = 0 GROUP BY a.`QUERY_STR`") : (this.driverName.contains("dm") ? "SELECT     QUERY_STR AS \"name\",    SUM(SEARCH_TOTAL) AS \"value\" FROM     STAND_SE_WORD_STATISTICS WHERE     SYNC_DATE BETWEEN TO_DATE('" + reqBO.getStartTime() + "', 'YYYY-MM-DD HH24:MI:SS')     AND TO_DATE('" + reqBO.getEndTime() + "', 'YYYY-MM-DD HH24:MI:SS')     AND WORD_TYPE = 1 GROUP BY     QUERY_STR" : "SELECT query_str as name, SUM( search_total ) as `value` FROM stand_se_word_statistics WHERE `sync_date` BETWEEN '" + reqBO.getStartTime() + "' AND '" + reqBO.getEndTime() + "' AND word_type = 1 GROUP BY query_str  ");
                List noWordRow = Db.use((String)"DATAPLAT").find(noResSql);
                if (noWordRow == null || noWordRow.size() <= 0) break;
                try {
                    noResWord.addAll(CommTools.getBeanList((List)noWordRow, SeWordCloudBO.class));
                    break;
                }
                catch (Exception e) {
                    log.error("\u65e0\u7ed3\u679c\u8bcd\u67e5\u8be2\u5931\u8d25", (Throwable)e);
                }
            }
        }
        rspBO.setTopWord(topWord);
        rspBO.setLowClickWord(lowClickWord);
        rspBO.setLowResultWord(lowResWord);
        rspBO.setNoResultWord(noResWord);
        return rspBO;
    }

    public String getConfig(String configName) {
        String configSql = "";
        configSql = this.driverName.contains("dm") ? "SELECT CONF_VALUE FROM STAND_SE_OPTIMIZE_CONFIG WHERE CONF_NAME = '" + configName + "'" : " select conf_value from stand_se_optimize_config where conf_name ='" + configName + "'";
        return Db.use((String)"DATAPLAT").queryStr(configSql);
    }

    public SeConfigureRecordRspBO selectConfigureReportTabName() throws ZTBusinessException {
        SeConfigureRecordRspBO rspBO = new SeConfigureRecordRspBO();
        ArrayList<SeTabNameBO> row = new ArrayList<SeTabNameBO>();
        String nameSql = "";
        nameSql = this.driverName.contains("dm") ? "SELECT A.TAB_ID AS \"tabId\", A.TAB_NAME AS \"tabName\", (SELECT '[' || LISTAGG(     '{' ||     '\"leftId\":' || B.LEFT_ID || ',' ||     '\"leftName\":\"' || REPLACE(B.LEFT_NAME, '\"', '\\\"') || '\"'     || '}',     ',' ) WITHIN GROUP(ORDER BY B.LEFT_ID) || ']' FROM STAND_SE_CONFIGURE_REPORT B WHERE B.TAB_ID = A.TAB_ID) AS \"tabContent\" FROM STAND_SE_CONFIGURE_REPORT A GROUP BY A.TAB_ID, A.TAB_NAME" : "SELECT tab_id AS tabId, tab_name AS tabName,    (SELECT JSON_ARRAYAGG(JSON_OBJECT('leftId', left_id, 'leftName', left_name)) \n     FROM stand_se_configure_report b  \n     WHERE b.tab_id = a.tab_id) AS tabContent  \nFROM  stand_se_configure_report a  GROUP BY tab_id, tab_name";
        List nameRow = Db.use((String)"DATAPLAT").find(nameSql);
        if (nameRow != null && nameRow.size() > 0) {
            try {
                for (Record record : nameRow) {
                    SeTabNameBO bo = new SeTabNameBO();
                    bo.setTabName((String)record.get("tabName"));
                    bo.setTabId(record.getLong("tabId") + "");
                    ObjectMapper objectMapper = new ObjectMapper();
                    CollectionType collectionType = TypeFactory.defaultInstance().constructCollectionType(List.class, SeLeftNameBO.class);
                    List employeeList = (List)objectMapper.readValue(record.getStr("tabContent"), (JavaType)collectionType);
                    bo.setTabContent(employeeList);
                    row.add(bo);
                }
            }
            catch (Exception e) {
                log.error("\u52a8\u6001\u8868\u540d\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            }
        }
        rspBO.setRows(row);
        return rspBO;
    }

    private String getReplaceStr(String tableName1, String tableName2, String tableAs) {
        if (tableAs.isEmpty()) {
            return "(select * from " + tableName1 + " union all select * from " + tableName2 + ")";
        }
        return "(select * from " + tableName1 + " union all select * from " + tableName2 + ") as " + tableAs;
    }

    public static String getFormattedMonth(int month) {
        return String.format("%02d", month);
    }

    public CommonPageRspBO<Object> getDynamicReportData(DynamicReportDataReqBO reqBO) throws ZTBusinessException {
        log.debug("\u751f\u6210\u52a8\u6001\u6570\u636e\u5165\u53c2\uff1a{}", (Object)reqBO.toString());
        String oneMonth = "";
        String twoMonth = "";
        LocalDate startTime = LocalDate.parse(reqBO.getStartTime());
        oneMonth = startTime.getYear() + "" + ReportStatisticsServiceImpl.getFormattedMonth(startTime.getMonthValue());
        if (!reqBO.getStartTime().equals(reqBO.getEndTime())) {
            LocalDate endTime = LocalDate.parse(reqBO.getEndTime());
            if (startTime.getMonth() != endTime.getMonth()) {
                twoMonth = endTime.getYear() + "" + ReportStatisticsServiceImpl.getFormattedMonth(endTime.getMonthValue());
            }
        }
        String configSql = "";
        configSql = this.driverName.contains("dm") ? "SELECT * FROM STAND_SE_CONFIGURE_REPORT WHERE LEFT_ID = " + reqBO.getLeftId() : "select * from stand_se_configure_report where left_id = " + reqBO.getLeftId();
        Record rsp = Db.use((String)"DATAPLAT").findFirst(configSql);
        String oldSql = null;
        if (rsp != null) {
            String selectSql = null;
            selectSql = this.driverName.contains("dm") ? (String)rsp.get("SELECT_SQL") : (String)rsp.get("select_sql");
            if (selectSql != null && !selectSql.isEmpty()) {
                oldSql = selectSql;
            }
        }
        String sql5 = oldSql;
        String fromSql = "select * ";
        String selectSql = " from (" + sql5 + ") as tableAsFinal";
        CommonPageRspBO<Object> commonPageRspBO = null;
        if (!StringUtils.isEmpty((CharSequence)sql5)) {
            ArrayList<String> pList = new ArrayList<String>();
            pList.add(reqBO.getStartTime() + " 00:00:00");
            pList.add(reqBO.getEndTime() + " 23:59:59");
            Object[] a = pList.toArray(new Object[pList.size()]);
            log.info("{} {} {} {} {}", new Object[]{reqBO.getPageNo(), reqBO.getPageSize(), fromSql, selectSql, a});
            Page aa = Db.use((String)"DATAPLAT").paginate(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue(), fromSql, selectSql, a);
            commonPageRspBO = ReportStatisticsServiceImpl.getPageInfo((Page<Record>)aa);
            String[] dataIndex = null;
            String[] title = null;
            if (this.driverName.contains("dm")) {
                dataIndex = rsp.getStr("DATA_INDEX").split("\\|");
                title = rsp.getStr("TITLE").split("\\|");
            } else {
                dataIndex = rsp.getStr("data_index").split("\\|");
                title = rsp.getStr("title").split("\\|");
            }
            ArrayList<TableHeadInfo> tableHeadInfos = new ArrayList<TableHeadInfo>();
            for (int i = 0; i < title.length; ++i) {
                TableHeadInfo tableHeadInfo1 = new TableHeadInfo();
                tableHeadInfo1.setTitle(title[i]);
                tableHeadInfo1.setDataIndex(dataIndex[i]);
                tableHeadInfos.add(tableHeadInfo1);
            }
            commonPageRspBO.setTitle(tableHeadInfos);
        }
        return commonPageRspBO;
    }

    public static CommonPageRspBO<Object> getPageInfo(Page<Record> rp) {
        CommonPageRspBO resultPageInfo = new CommonPageRspBO();
        resultPageInfo.setRecordsTotal(rp.getTotalRow());
        resultPageInfo.setTotal(rp.getTotalPage());
        resultPageInfo.setPageNo(rp.getPageNumber());
        ArrayList<Map> rows = new ArrayList<Map>();
        if (rp.getList() != null && rp.getList().size() > 0) {
            try {
                for (Record r : rp.getList()) {
                    rows.add(r.getColumns());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return resultPageInfo;
            }
        }
        resultPageInfo.setRows(rows);
        return resultPageInfo;
    }

    public void getSearchAgainNumber(Record po, String month, String yesterday) {
        String start = yesterday + " 00:00:00";
        String end = yesterday + " 23:59:59";
        log.info("\u83b7\u53d6\u518d\u6b21\u641c\u7d22\u6b21\u6570=============start");
        String sql = "";
        sql = this.driverName.contains("dm") ? "SELECT     s.USER_ID AS \"userId\",    s.SEARCH_ID AS \"searchId\",    MAX(s.CREATE_TIME) AS \"searchTime\",    MIN(p.CREATE_TIME) AS \"actionTime\" FROM     STAND_SE_IN_LOG s LEFT JOIN (    SELECT         tableAS.SEARCH_ID,        tableAS.TRACE_ID,        MIN(tableAS.CREATE_TIME) AS CREATE_TIME     FROM (        SELECT SEARCH_ID, TRACE_ID, CREATE_TIME         FROM STAND_SE_COLLECTION_IN_LOG         WHERE CREATE_TIME BETWEEN TO_DATE('" + start + "', 'YYYY-MM-DD HH24:MI:SS')           AND TO_DATE('" + end + "', 'YYYY-MM-DD HH24:MI:SS')         UNION ALL         SELECT SEARCH_ID, TRACE_ID, CREATE_TIME         FROM STAND_SE_ADD_PURCHASE_IN_LOG         WHERE CREATE_TIME BETWEEN TO_DATE('" + start + "', 'YYYY-MM-DD HH24:MI:SS')           AND TO_DATE('" + end + "', 'YYYY-MM-DD HH24:MI:SS')         UNION ALL         SELECT SEARCH_ID, TRACE_ID, CREATE_TIME         FROM STAND_SE_COMM_DETAIL_IN_LOG         WHERE CREATE_TIME BETWEEN TO_DATE('" + start + "', 'YYYY-MM-DD HH24:MI:SS')           AND TO_DATE('" + end + "', 'YYYY-MM-DD HH24:MI:SS')     ) AS tableAS     GROUP BY tableAS.SEARCH_ID, tableAS.TRACE_ID ) p ON p.TRACE_ID = s.TRACE_ID WHERE     s.USER_ID != ''     AND s.CREATE_TIME BETWEEN TO_DATE('" + start + "', 'YYYY-MM-DD HH24:MI:SS')     AND TO_DATE('" + end + "', 'YYYY-MM-DD HH24:MI:SS') GROUP BY     s.USER_ID, s.SEARCH_ID" : "SELECT s.USER_ID AS userId, s.SEARCH_ID AS searchId, MAX(s.CREATE_TIME) AS searchTime, MIN(p.CREATE_TIME) AS actionTime FROM stand_se_in_log s LEFT JOIN (   SELECT   tableAS.SEARCH_ID,   tableAS.trace_id,   MIN(tableAS.CREATE_TIME) AS CREATE_TIME   FROM (       SELECT SEARCH_ID, trace_id, CREATE_TIME FROM stand_se_collection_in_log       WHERE CREATE_TIME BETWEEN '" + start + "' AND '" + end + "'       UNION ALL       SELECT SEARCH_ID, trace_id, CREATE_TIME FROM stand_se_add_purchase_in_log       WHERE CREATE_TIME BETWEEN '" + start + "' AND '" + end + "'       UNION ALL       SELECT SEARCH_ID, trace_id, CREATE_TIME FROM stand_se_comm_detail_in_log       WHERE CREATE_TIME BETWEEN '" + start + "' AND '" + end + "'   ) AS tableAS   GROUP BY tableAS.SEARCH_ID, tableAS.trace_id ) p ON p.trace_id = s.trace_id WHERE s.USER_ID != '' AND s.CREATE_TIME BETWEEN '" + start + "' AND '" + end + "' GROUP BY s.USER_ID, s.SEARCH_ID";
        List actionList = Db.use((String)"DATAPLAT").find(sql);
        log.info("\u67e5\u8be2\u51fa\u6570\u636e\u603b\u91cf:{}", (Object)actionList.size());
        if (this.driverName.contains("dm")) {
            po.set("SEARCH_AGAIN_TOTAL", (Object)0);
            po.set("SEARCH_AGAIN_USER", (Object)0);
        } else {
            po.set("search_again_total", (Object)0);
            po.set("search_again_user", (Object)0);
        }
        if (actionList != null && actionList.size() > 0) {
            ArrayList actionPoList = new ArrayList();
            try {
                actionPoList.addAll(CommTools.getBeanList((List)actionList, ActionRecordBO.class));
                Map<String, List<ActionRecordBO>> userActionMap = actionPoList.stream().collect(Collectors.groupingBy(ActionRecordBO::getUserId));
                userActionMap.values().forEach(userList1 -> userList1.sort(Comparator.comparing(ActionRecordBO::getSearchTime).reversed()));
                log.info("\u8f93\u51fa\u8f6c\u6362\u540e\u7684\u7ed3\u679c:{}", userActionMap);
                HashMap<String, List<Integer>> searchCountMap = new HashMap<String, List<Integer>>();
                for (Map.Entry<String, List<ActionRecordBO>> entry : userActionMap.entrySet()) {
                    String userId = entry.getKey();
                    List<ActionRecordBO> actionRecords = entry.getValue();
                    ActionRecordBO startPoint = null;
                    int searchCount = 0;
                    for (int j = 0; j < actionRecords.size(); ++j) {
                        ActionRecordBO record = actionRecords.get(j);
                        if (startPoint == null) {
                            if (record.getActionTime() == null) continue;
                            startPoint = record;
                            continue;
                        }
                        long timeDifferenceInMinutes = (startPoint.getSearchTime().getTime() - record.getSearchTime().getTime()) / 60000L;
                        if (timeDifferenceInMinutes >= 15L) {
                            startPoint = null;
                            if (searchCount > 0) {
                                this.extractedCount(searchCountMap, userId, searchCount);
                            }
                            searchCount = 0;
                            continue;
                        }
                        if (record.getActionTime() == null) {
                            ++searchCount;
                            if (j != actionRecords.size() - 1) continue;
                            this.extractedCount(searchCountMap, userId, searchCount);
                            continue;
                        }
                        startPoint = record;
                        if (searchCount > 0) {
                            this.extractedCount(searchCountMap, userId, searchCount);
                        }
                        searchCount = 0;
                    }
                }
                if (searchCountMap.size() > 0) {
                    int totalUserCount = 0;
                    double totalSearchCount = 0.0;
                    for (Map.Entry countEntry : searchCountMap.entrySet()) {
                        Long useTotalSearchCount = 0L;
                        List rows = (List)countEntry.getValue();
                        for (Integer row : rows) {
                            useTotalSearchCount = useTotalSearchCount + (long)row.intValue();
                        }
                        totalSearchCount += (double)useTotalSearchCount.longValue();
                        totalUserCount += rows.size();
                    }
                    if (this.driverName.contains("dm")) {
                        po.set("SEARCH_AGAIN_TOTAL", (Object)totalSearchCount);
                        po.set("SEARCH_AGAIN_USER", (Object)totalUserCount);
                    } else {
                        po.set("search_again_total", (Object)totalSearchCount);
                        po.set("search_again_user", (Object)totalUserCount);
                    }
                }
            }
            catch (Exception e) {
                log.error("\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private void extractedCount(Map<String, List<Integer>> searchCountMap, String userId, int searchCount) {
        List<Integer> count = new ArrayList<Integer>();
        if (searchCountMap.get(userId) != null) {
            count = searchCountMap.get(userId);
        }
        count.add(searchCount);
        searchCountMap.put(userId, count);
    }

    @Transactional
    public void incrementStatistics(String month, String yesterday) {
        String start = yesterday + " 00:00:00";
        String end = yesterday + " 23:59:59";
        Date sqlYesterday = Date.valueOf(yesterday);
        String repeat = "";
        repeat = this.driverName.contains("dm") ? "SELECT STATISTICS_ID FROM STAND_SE_INCREMENT_STATISTICS WHERE SYNC_DATE = '" + sqlYesterday + "'" : "select statistics_id    from stand_se_increment_statistics    where sync_date = '" + sqlYesterday + "'";
        Long satisId = Db.use((String)"DATAPLAT").queryLong(repeat);
        if (satisId != null) {
            log.info("\u4eca\u5929\u5df2\u7ecf\u7edf\u8ba1\u8fc7\uff0c\u4e0d\u518d\u91cd\u590d\u7edf\u8ba1:{}", (Object)satisId);
            return;
        }
        Long sId = Sequence.getInstance().nextId();
        Record record = new Record();
        if (this.driverName.contains("dm")) {
            record.set("STATISTICS_ID", (Object)sId);
            record.set("CREATE_TIME", (Object)new java.util.Date());
            record.set("SYNC_DATE", (Object)sqlYesterday);
        } else {
            record.set("statistics_id", (Object)sId);
            record.set("create_time", (Object)new java.util.Date());
            record.set("sync_date", (Object)sqlYesterday);
        }
        String sql = "";
        sql = this.driverName.contains("dm") ? "SELECT     (CASE WHEN tableAS.UV != 0 THEN ROUND((tableAS.PV / tableAS.UV), 2) ELSE 0 END) AS \"countNum\",    tableAS.PV,    tableAS.UV FROM (    SELECT         COUNT(DISTINCT SEARCH_ID) AS PV,        COUNT(DISTINCT USER_ID) AS UV     FROM STAND_SE_IN_LOG     WHERE CREATE_TIME BETWEEN TO_DATE('" + start + "', 'YYYY-MM-DD HH24:MI:SS')       AND TO_DATE('" + end + "', 'YYYY-MM-DD HH24:MI:SS')     GROUP BY " + yesterday + " ) AS tableAS" : "SELECT (CASE WHEN tableAS.UV != 0 THEN TRUNCATE (( tableAS.PV / tableAS.UV ), 2 ) ELSE 0 END) AS countNum,tableAS.PV,tableAS.UV        from(                SELECT                COUNT(DISTINCT SEARCH_ID) AS PV,                COUNT(DISTINCT `USER_ID`) AS UV                FROM stand_se_in_log                where CREATE_TIME BETWEEN '" + start + "' AND '" + end + "'                GROUP BY " + yesterday + "        ) as tableAS";
        Record row = Db.use((String)"DATAPLAT").findFirst(sql);
        log.info("\u67e5\u8be2\u51fa\u6570\u636e\u603b\u91cf:{}", (Object)row);
        if (this.driverName.contains("dm")) {
            if (row != null) {
                record.set("SEARCH_PV", (Object)row.getLong("PV"));
                record.set("SEARCH_UV", (Object)row.getLong("UV"));
                record.set("AVG_PV", (Object)row.getDouble("countNum"));
            } else {
                record.set("SEARCH_PV", (Object)0);
                record.set("SEARCH_UV", (Object)0);
                record.set("AVG_PV", (Object)0);
            }
        } else if (row != null) {
            record.set("search_pv", (Object)row.getLong("PV"));
            record.set("search_uv", (Object)row.getLong("UV"));
            record.set("avg_Pv", (Object)row.getDouble("countNum"));
        } else {
            record.set("search_pv", (Object)0);
            record.set("search_uv", (Object)0);
            record.set("avg_Pv", (Object)0);
        }
        String noResSql = "";
        noResSql = this.driverName.contains("dm") ? "SELECT COUNT(1) AS \"noResCount\" FROM STAND_SE_IN_LOG A, STAND_SE_OUT_LOG B WHERE A.TRACE_ID = B.TRACE_ID AND (A.QUERY_FILTER_LIST IS NULL OR A.QUERY_FILTER_LIST='' AND A.QUERY_PROPERTY_LIST='' OR A.QUERY_PROPERTY_LIST IS NULL) AND A.CREATE_TIME BETWEEN '" + start + "' AND '" + end + "' AND B.RECORDS_TOTAL=0" : "SELECT        count(1) as noResCount        FROM        stand_se_in_log a,stand_se_out_log b        WHERE a.`trace_id` = b.`trace_id`        AND (a.QUERY_FILTER_LIST is null OR a.QUERY_FILTER_LIST=''         AND a.QUERY_PROPERTY_LIST='' OR a.QUERY_PROPERTY_LIST is null)        AND a.CREATE_TIME BETWEEN '" + start + "' AND '" + end + "'        AND b.RECORDS_TOTAL=0";
        Long noResRow = Db.use((String)"DATAPLAT").queryLong(noResSql);
        if (this.driverName.contains("dm")) {
            if (noResRow != null) {
                record.set("NO_RESULT_NUM", (Object)noResRow);
            } else {
                record.set("NO_RESULT_NUM", (Object)0);
            }
        } else if (noResRow != null) {
            record.set("no_result_num", (Object)noResRow);
        } else {
            record.set("no_result_num", (Object)0);
        }
        String actionSql = "";
        actionSql = this.driverName.contains("dm") ? "SELECT     COUNT(1) AS \"behaviorPv\",    SUM(min_pageNO) AS \"pageTotal\" FROM (    SELECT         tableAS.SEARCH_ID,        MIN(tableAS.PAGE_NO) AS min_pageNO     FROM (        SELECT             s.SEARCH_ID,            s.PAGE_NO         FROM STAND_SE_ADD_PURCHASE_IN_LOG p         LEFT JOIN STAND_SE_IN_LOG s ON p.TRACE_ID = s.TRACE_ID         WHERE p.CREATE_TIME BETWEEN TO_DATE('" + start + "', 'YYYY-MM-DD HH24:MI:SS')           AND TO_DATE('" + end + "', 'YYYY-MM-DD HH24:MI:SS')           AND p.USER_PERMISSION IN ('tenant:10000:geticaigou', '22', 'tenant:10000:extenterprisecaigouqiyecaigouyuan', '2')         UNION ALL         SELECT             s.SEARCH_ID,            s.PAGE_NO         FROM STAND_SE_COLLECTION_IN_LOG p         LEFT JOIN STAND_SE_IN_LOG s ON p.TRACE_ID = s.TRACE_ID         WHERE p.CREATE_TIME BETWEEN TO_DATE('" + start + "', 'YYYY-MM-DD HH24:MI:SS')           AND TO_DATE('" + end + "', 'YYYY-MM-DD HH24:MI:SS')           AND p.USER_PERMISSION IN ('tenant:10000:geticaigou', '22', 'tenant:10000:extenterprisecaigouqiyecaigouyuan', '2')         UNION ALL         SELECT             s.SEARCH_ID,            s.PAGE_NO         FROM STAND_SE_COMM_DETAIL_IN_LOG p         LEFT JOIN STAND_SE_IN_LOG s ON p.TRACE_ID = s.TRACE_ID         WHERE p.CREATE_TIME BETWEEN TO_DATE('" + start + "', 'YYYY-MM-DD HH24:MI:SS')           AND TO_DATE('" + end + "', 'YYYY-MM-DD HH24:MI:SS')           AND p.USER_PERMISSION IN ('tenant:10000:geticaigou', '22', 'tenant:10000:extenterprisecaigouqiyecaigouyuan', '2')     ) AS tableAS     GROUP BY tableAS.SEARCH_ID ) AS subquery" : "SELECT count(1) as behaviorPv,sum(min_pageNO) as pageTotal FROM ( select tableAS.SEARCH_ID,MIN(tableAS.PAGE_NO) AS min_pageNO from( select s.SEARCH_ID,s.PAGE_NO from stand_se_add_purchase_in_log p left join stand_se_in_log s on p.TRACE_ID=s.TRACE_ID where p.CREATE_TIME BETWEEN '" + start + "' AND '" + end + "' AND p.user_permission IN('tenant:10000:geticaigou','22','tenant:10000:extenterprisecaigouqiyecaigouyuan','2') union ALL select s.SEARCH_ID,s.PAGE_NO from stand_se_collection_in_log p left join stand_se_in_log s on p.TRACE_ID=s.TRACE_ID where p.CREATE_TIME BETWEEN '" + start + "' AND '" + end + "' AND p.user_permission IN('tenant:10000:geticaigou','22','tenant:10000:extenterprisecaigouqiyecaigouyuan','2') union ALL select s.SEARCH_ID,s.PAGE_NO from stand_se_comm_detail_in_log p left join stand_se_in_log s on p.TRACE_ID=s.TRACE_ID where p.CREATE_TIME BETWEEN '" + start + "' AND '" + end + "' AND p.user_permission IN('tenant:10000:geticaigou','22','tenant:10000:extenterprisecaigouqiyecaigouyuan','2')) as tableAS group by tableAS.SEARCH_ID) AS subquery";
        Record actionRes = Db.use((String)"DATAPLAT").findFirst(actionSql);
        if (this.driverName.contains("dm")) {
            if (actionRes != null) {
                record.set("BEHAVIOR_PV", (Object)actionRes.getLong("behaviorPv"));
                record.set("PAGE_TOTAL", (Object)(actionRes.getLong("pageTotal") == null ? 0L : actionRes.getLong("pageTotal")));
            } else {
                record.set("PAGE_TOTAL", (Object)0);
                record.set("BEHAVIOR_PV", (Object)0);
            }
        } else if (actionRes != null) {
            record.set("behavior_pv", (Object)actionRes.getLong("behaviorPv"));
            record.set("page_total", (Object)(actionRes.getLong("pageTotal") == null ? 0L : actionRes.getLong("pageTotal")));
        } else {
            record.set("page_total", (Object)0);
            record.set("behavior_pv", (Object)0);
        }
        String searchPv = "";
        searchPv = this.driverName.contains("dm") ? "SELECT COUNT(DISTINCT SEARCH_ID) AS \"searchCount\" FROM STAND_SE_IN_LOG WHERE USER_PERMISSION IN('tenant:10000:geticaigou','22','tenant:10000:extenterprisecaigouqiyecaigouyuan','2') AND CREATE_TIME BETWEEN '" + start + "' AND '" + end + "'" : "select count(DISTINCT(SEARCH_ID)) as searchCount FROM stand_se_in_log WHERE user_permission IN('tenant:10000:geticaigou','22','tenant:10000:extenterprisecaigouqiyecaigouyuan','2')  AND CREATE_TIME BETWEEN '" + start + "' AND '" + end + "'";
        Long searchPvRow = Db.use((String)"DATAPLAT").queryLong(searchPv);
        if (this.driverName.contains("dm")) {
            if (searchPvRow != 0L) {
                record.set("BUYER_PV", (Object)searchPvRow);
            } else {
                record.set("BUYER_PV", (Object)0);
            }
        } else if (searchPvRow != 0L) {
            record.set("buyer_pv", (Object)searchPvRow);
        } else {
            record.set("buyer_pv", (Object)0);
        }
        this.getSearchAgainNumber(record, month, yesterday);
        if (this.driverName.contains("dm")) {
            Db.use((String)"DATAPLAT").save(this.config.getDatabaseName() + "`.`STAND_SE_INCREMENT_STATISTICS", record);
        } else {
            Db.use((String)"DATAPLAT").save("stand_se_increment_statistics", record);
        }
        String resWordSql = "";
        resWordSql = this.driverName.contains("dm") ? "SELECT     a.QUERY_STR AS \"name\",    COUNT(DISTINCT a.SEARCH_ID) AS \"searchCount\",    MAX(b.RECORDS_TOTAL) AS \"recordTotal\",    (SELECT COUNT(DISTINCT search_id)      FROM STAND_SE_IN_LOG      WHERE CREATE_TIME BETWEEN TO_DATE('" + start + "', 'YYYY-MM-DD HH24:MI:SS')        AND TO_DATE('" + end + "', 'YYYY-MM-DD HH24:MI:SS')        AND QUERY_STR = a.QUERY_STR        AND search_id IN (            SELECT SEARCH_ID FROM STAND_SE_COLLECTION_IN_LOG            UNION            SELECT SEARCH_ID FROM STAND_SE_ADD_PURCHASE_IN_LOG            UNION            SELECT SEARCH_ID FROM STAND_SE_COMM_DETAIL_IN_LOG        )    ) AS \"clickPv\" FROM     STAND_SE_IN_LOG a JOIN     STAND_SE_OUT_LOG b ON     a.TRACE_ID = b.TRACE_ID WHERE     a.CREATE_TIME BETWEEN TO_DATE('" + start + "', 'YYYY-MM-DD HH24:MI:SS')     AND TO_DATE('" + end + "', 'YYYY-MM-DD HH24:MI:SS')     AND (a.QUERY_FILTER_LIST IS NULL OR a.QUERY_FILTER_LIST = ''          OR a.QUERY_PROPERTY_LIST = '' OR a.QUERY_PROPERTY_LIST IS NULL)     AND b.RECORDS_TOTAL > 0 GROUP BY     a.QUERY_STR ORDER BY     MAX(b.RECORDS_TOTAL) DESC" : "SELECT a.QUERY_STR as name, count(DISTINCT a.SEARCH_ID) AS searchCount, max(b.RECORDS_TOTAL) as recordTotal,(SELECT count( DISTINCT search_id )  FROM stand_se_in_log WHERE  CREATE_TIME BETWEEN '" + start + "' AND '" + end + "' AND QUERY_STR = a.QUERY_STR  AND search_id IN ( SELECT SEARCH_ID FROM stand_se_collection_in_log UNION SELECT SEARCH_ID FROM stand_se_add_purchase_in_log UNION SELECT SEARCH_ID FROM stand_se_comm_detail_in_log )) AS clickPv \n FROM stand_se_in_log a,stand_se_out_log b WHERE a.CREATE_TIME BETWEEN '" + start + "' AND '" + end + "' AND a.TRACE_ID = b.TRACE_ID AND (a.QUERY_FILTER_LIST is null OR a.QUERY_FILTER_LIST=''  AND a.QUERY_PROPERTY_LIST='' OR a.QUERY_PROPERTY_LIST is null) AND b.RECORDS_TOTAL > 0 GROUP BY a.`QUERY_STR` order by max(b.RECORDS_TOTAL) desc";
        List resWordRow = Db.use((String)"DATAPLAT").find(resWordSql);
        ArrayList<Record> poList = new ArrayList<Record>();
        if (resWordRow != null && resWordRow.size() > 0) {
            for (Record rows : resWordRow) {
                Record record1 = new Record();
                if (this.driverName.contains("dm")) {
                    record1.set("WORD_ID", (Object)Sequence.getInstance().nextId());
                    record1.set("CREATE_TIME", (Object)new java.util.Date());
                    record1.set("SYNC_DATE", (Object)sqlYesterday);
                    record1.set("WORD_TYPE", (Object)"0");
                    record1.set("QUERY_STR", (Object)rows.getStr("name"));
                    record1.set("CLICK_TOTAL", (Object)rows.getLong("clickPv"));
                    record1.set("SEARCH_TOTAL", (Object)rows.getLong("searchCount"));
                    record1.set("RECORDS_TOTAL", (Object)Long.valueOf(rows.getStr("recordTotal")));
                } else {
                    record1.set("word_id", (Object)Sequence.getInstance().nextId());
                    record1.set("create_time", (Object)new java.util.Date());
                    record1.set("sync_date", (Object)sqlYesterday);
                    record1.set("word_type", (Object)"0");
                    record1.set("query_str", (Object)rows.getStr("name"));
                    record1.set("click_total", (Object)rows.getLong("clickPv"));
                    record1.set("search_total", (Object)rows.getLong("searchCount"));
                    record1.set("records_total", (Object)Long.valueOf(rows.getStr("recordTotal")));
                }
                poList.add(record1);
            }
        }
        String noResWord = "";
        noResWord = this.driverName.contains("dm") ? "SELECT A.QUERY_STR AS \"name\", COUNT(DISTINCT A.SEARCH_ID) AS \"value\" FROM STAND_SE_IN_LOG A, STAND_SE_OUT_LOG B WHERE A.CREATE_TIME BETWEEN '" + start + "' AND '" + end + "' AND A.TRACE_ID = B.TRACE_ID AND (A.QUERY_FILTER_LIST IS NULL OR A.QUERY_FILTER_LIST = ''     AND A.QUERY_PROPERTY_LIST = '' OR A.QUERY_PROPERTY_LIST IS NULL) AND B.RECORDS_TOTAL = 0 GROUP BY A.QUERY_STR" : "SELECT a.QUERY_STR as name, count(DISTINCT a.SEARCH_ID) as `value` FROM stand_se_in_log a ,stand_se_out_log b WHERE a.CREATE_TIME BETWEEN '" + start + "' AND '" + end + "' AND a.TRACE_ID = b.TRACE_ID AND (a.QUERY_FILTER_LIST is null OR a.QUERY_FILTER_LIST=''  AND a.QUERY_PROPERTY_LIST='' OR a.QUERY_PROPERTY_LIST is null) AND b.RECORDS_TOTAL = 0 GROUP BY a.`QUERY_STR`";
        List noResWordRow = Db.use((String)"DATAPLAT").find(noResWord);
        if (noResWordRow != null && noResWordRow.size() > 0) {
            for (Record rows : noResWordRow) {
                Record record2 = new Record();
                if (this.driverName.contains("dm")) {
                    record2.set("WORD_ID", (Object)Sequence.getInstance().nextId());
                    record2.set("CREATE_TIME", (Object)new java.util.Date());
                    record2.set("SYNC_DATE", (Object)sqlYesterday);
                    record2.set("WORD_TYPE", (Object)"1");
                    record2.set("QUERY_STR", (Object)rows.getStr("name"));
                    record2.set("SEARCH_TOTAL", (Object)rows.getLong("value"));
                } else {
                    record2.set("word_id", (Object)Sequence.getInstance().nextId());
                    record2.set("create_time", (Object)new java.util.Date());
                    record2.set("sync_date", (Object)sqlYesterday);
                    record2.set("word_type", (Object)"1");
                    record2.set("query_str", (Object)rows.getStr("name"));
                    record2.set("search_total", (Object)rows.getLong("value"));
                }
                poList.add(record2);
            }
        }
        if (poList != null && poList.size() > 0 && this.driverName.contains("dm")) {
            Db.use((String)"DATAPLAT").batchSave(this.config.getDatabaseName() + "`.`STAND_SE_WORD_STATISTICS", poList, poList.size());
        } else if (poList != null && poList.size() > 0) {
            Db.use((String)"DATAPLAT").batchSave("stand_se_word_statistics", poList, poList.size());
        }
    }

    public void createBehaviorTable(String start, String end) {
        try {
            if (this.driverName.contains("postgresql")) {
                log.info("\u521b\u5efa\u7528\u6237\u884c\u4e3a\u8868\u5206\u533a\u5f00\u59cb----");
                String searchInTableName = "stand_se_in_log";
                String searchOutTableName = "stand_se_out_log";
                String detailInTableName = "stand_se_comm_detail_in_log";
                String detailOutTableName = "stand_se_comm_detail_out_log";
                ArrayList<String> resList = new ArrayList<String>();
                resList.add(searchInTableName);
                resList.add(searchOutTableName);
                resList.add(detailInTableName);
                resList.add(detailOutTableName);
                for (String tableName : resList) {
                    String sql = "SELECT * FROM information_schema.tables WHERE table_name = ?";
                    List tables = Db.use((String)"DATAPLAT").find(sql, new Object[]{tableName});
                    if (tables.isEmpty()) {
                        switch (tableName) {
                            case "stand_se_in_log": {
                                String createSearchInTableSql = "CREATE TABLE " + tableName + "(TRACE_ID BIGINT NOT NULL PRIMARY KEY,SEARCH_ID BIGINT NOT NULL,CREATE_TIME TIMESTAMP DEFAULT NULL,PAGE_NO VARCHAR(16),PAGE_SIZE VARCHAR(16),QUERY_STR VARCHAR(128),QUERY_CHANNEL_ID VARCHAR(128),CATEGORY_ID VARCHAR(128),LEVEL VARCHAR(128),BRAND_ID VARCHAR(128),SUPPLIER_SHOP_ID VARCHAR(128),ORDER_BY_COLUMN VARCHAR(16),ORDER_TYPE VARCHAR(16),QUERY_FILTER_LIST TEXT,QUERY_PROPERTY_LIST TEXT,MIN_SALE_PRICE VARCHAR(128),MAX_SALE_PRICE VARCHAR(128),MUST_TERMS_LIST VARCHAR(512),MUST_NOT_TERMS_LIST VARCHAR(512),SHOULD_LIST VARCHAR(512),SHOULD_NOT_LIST VARCHAR(512),AGREEMENT_ID VARCHAR(128),ORG_PATH VARCHAR(128),ORG_ID_IN VARCHAR(128),USER_ID VARCHAR(128),USER_PERMISSION VARCHAR(128),ACTIVITY_ID VARCHAR(128),COMPANY_ID VARCHAR(128),COMMODITY_TYPE_IDS TEXT,ACCURACY_FLAG VARCHAR(16)) PARTITION BY RANGE (CREATE_TIME)";
                                Db.use((String)"DATAPLAT").update(createSearchInTableSql);
                                String createSearchInTablePartitionSql = "ALTER TABLE " + tableName + " ADD PARTITION " + tableName + '_' + start + " FOR VALUES FROM (to_date('" + start + "', 'yyyyMMdd')) TO (to_date('" + end + "', 'yyyyMMdd') + INTERVAL '1 day'))";
                                Db.use((String)"DATAPLAT").update(createSearchInTablePartitionSql);
                                break;
                            }
                            case "stand_se_out_log": {
                                String createSearchOutTableSql = "CREATE TABLE " + tableName + "(TRACE_ID BIGINT NOT NULL PRIMARY KEY,SEARCH_ID BIGINT NOT NULL,CREATE_TIME TIMESTAMP DEFAULT NULL,PAGE_NO VARCHAR(16),PAGE_SIZE VARCHAR(16),RECORDS_TOTAL VARCHAR(16),TOTAL VARCHAR(16),RESULT TEXT) PARTITION BY RANGE (CREATE_TIME)";
                                Db.use((String)"DATAPLAT").update(createSearchOutTableSql);
                                String createSearchOutTablePartitionSql = "ALTER TABLE " + tableName + " ADD PARTITION " + tableName + '_' + start + " FOR VALUES FROM (to_date('" + start + "', 'yyyyMMdd')) TO (to_date('" + end + "', 'yyyyMMdd') + INTERVAL '1 day'))";
                                Db.use((String)"DATAPLAT").update(createSearchOutTablePartitionSql);
                                break;
                            }
                            case "stand_se_comm_detail_in_log": {
                                String createCommDetailInTableSql = "CREATE TABLE " + tableName + "(DETAIL_ID BIGINT NOT NULL PRIMARY KEY,TRACE_ID BIGINT NOT NULL,SEARCH_ID BIGINT NOT NULL,CREATE_TIME TIMESTAMP DEFAULT NULL,USER_ID VARCHAR(128),USER_PERMISSION VARCHAR(128),SKU_ID VARCHAR(128),SUPPLIER_SHOP_ID VARCHAR(128),PROVINCE VARCHAR(128),CITY VARCHAR(128),COUNTY VARCHAR(128),TOWN VARCHAR(128),NUM VARCHAR(16),COMPANY_ID VARCHAR(128),RECORDS_TOTAL VARCHAR(16),TOTAL VARCHAR(16)) PARTITION BY RANGE (CREATE_TIME)";
                                Db.use((String)"DATAPLAT").update(createCommDetailInTableSql);
                                String createCommDetailInTablePartitionSql = "ALTER TABLE " + tableName + " ADD PARTITION " + tableName + '_' + start + " FOR VALUES FROM (to_date('" + start + "', 'yyyyMMdd')) TO (to_date('" + end + "', 'yyyyMMdd') + INTERVAL '1 day'))";
                                Db.use((String)"DATAPLAT").update(createCommDetailInTablePartitionSql);
                                break;
                            }
                            case "stand_se_comm_detail_out_log": {
                                String createCommDetailOutTableSql = "CREATE TABLE " + tableName + "(DETAIL_ID BIGINT NOT NULL PRIMARY KEY,TRACE_ID BIGINT NOT NULL,SEARCH_ID BIGINT NOT NULL,CREATE_TIME TIMESTAMP DEFAULT NULL,COMMD_DETAILS_INFO TEXT,SKU_INFO_SALE_NUM TEXT,ENT_AGREEMENT_CODE VARCHAR(128)) PARTITION BY RANGE (CREATE_TIME)";
                                Db.use((String)"DATAPLAT").update(createCommDetailOutTableSql);
                                String createCommDetailOutTablePartitionSql = "ALTER TABLE " + tableName + " ADD PARTITION " + tableName + '_' + start + " FOR VALUES FROM (to_date('" + start + "', 'yyyyMMdd')) TO (to_date('" + end + "', 'yyyyMMdd') + INTERVAL '1 day'))";
                                Db.use((String)"DATAPLAT").update(createCommDetailOutTablePartitionSql);
                            }
                        }
                        continue;
                    }
                    log.info("\u7528\u6237\u884c\u4e3a\u8868:{}\u5df2\u5b58\u5728,\u521b\u5efa\u4e0b\u4e00\u4e2a\u6708\u8868\u5206\u533a", (Object)tableName);
                    String createTablePartitionSql = "ALTER TABLE " + tableName + " ADD PARTITION " + tableName + '_' + start + " FOR VALUES FROM (to_date('" + start + "', 'yyyyMMdd')) TO (to_date('" + end + "', 'yyyyMMdd') + INTERVAL '1 day'))";
                    Db.use((String)"DATAPLAT").update(createTablePartitionSql);
                }
            } else if (this.driverName.contains("mysql")) {
                log.info("\u521b\u5efa\u7528\u6237\u884c\u4e3a\u8868\u5206\u533a\u5f00\u59cb----");
                String searchInTableName = "stand_se_in_log";
                String searchOutTableName = "stand_se_out_log";
                String detailInTableName = "stand_se_comm_detail_in_log";
                String detailOutTableName = "stand_se_comm_detail_out_log";
                String addInTableName = "stand_se_add_purchase_in_log";
                String addOutTableName = "stand_se_add_purchase_out_log";
                String collectionInTableName = "stand_se_collection_in_log";
                ArrayList<String> resList = new ArrayList<String>();
                resList.add(searchInTableName);
                resList.add(searchOutTableName);
                resList.add(detailInTableName);
                resList.add(detailOutTableName);
                resList.add(addInTableName);
                resList.add(addOutTableName);
                resList.add(collectionInTableName);
                for (String tableName : resList) {
                    String sql = "SHOW TABLES LIKE ?";
                    List tables = Db.use((String)"DATAPLAT").find(sql, new Object[]{tableName});
                    if (tables.isEmpty()) {
                        switch (tableName) {
                            case "stand_se_in_log": {
                                String createSearchInTableSql = "CREATE TABLE " + tableName + "(`TRACE_ID` bigint NOT NULL COMMENT '\u8bb0\u5f55 id',`SEARCH_ID` bigint NOT NULL COMMENT '\u641c\u7d22id',`CREATE_TIME` datetime NOT NULL COMMENT '\u521b\u5efa\u65f6\u95f4',`PAGE_NO` varchar(16) COLLATE utf8_bin DEFAULT NULL COMMENT '\u9875\u7801',`PAGE_SIZE` varchar(16) COLLATE utf8_bin DEFAULT NULL COMMENT '\u6bcf\u9875\u6570',`QUERY_STR` varchar(128) COLLATE utf8_bin DEFAULT NULL COMMENT '\u641c\u7d22\u680f',`QUERY_CHANNEL_ID` varchar(128) COLLATE utf8_bin DEFAULT NULL COMMENT '\u641c\u7d22\u9891\u9053ID',`CATEGORY_ID` varchar(128) COLLATE utf8_bin DEFAULT NULL COMMENT '\u7c7b\u76eeID',`LEVEL` varchar(128) COLLATE utf8_bin DEFAULT NULL COMMENT '\u7c7b\u76ee\u5c42\u7ea7',`BRAND_ID` varchar(128) COLLATE utf8_bin DEFAULT NULL COMMENT '\u54c1\u724cID',`SUPPLIER_SHOP_ID` varchar(128) COLLATE utf8_bin DEFAULT NULL COMMENT '\u5e97\u94faID',`ORDER_BY_COLUMN` varchar(16) COLLATE utf8_bin DEFAULT NULL COMMENT '\u6392\u5e8f\u680f\u4f4d',`ORDER_TYPE` varchar(16) COLLATE utf8_bin DEFAULT NULL COMMENT '\u5347\u964d\u5e8f',`QUERY_FILTER_LIST` text COLLATE utf8_bin COMMENT '\u67e5\u8be2\u54c1\u7c7b(\u4e09\u7ea7\u7c7b\u76ee\u3001\u54c1\u724c\u3001\u4f9b\u5e94\u5546)',`QUERY_PROPERTY_LIST` text COLLATE utf8_bin COMMENT '\u67e5\u8be2\u5c5e\u6027',`MIN_SALE_PRICE` varchar(128) COLLATE utf8_bin DEFAULT NULL COMMENT '\u6700\u4f4e\u4ef7',`MAX_SALE_PRICE` varchar(128) COLLATE utf8_bin DEFAULT NULL COMMENT '\u6700\u9ad8\u4ef7',`MUST_TERMS_LIST` varchar(512) COLLATE utf8_bin DEFAULT NULL COMMENT '\u5fc5\u8981\u5b58\u5728\u6761\u4ef6',`MUST_NOT_TERMS_LIST` varchar(512) COLLATE utf8_bin DEFAULT NULL COMMENT '\u5fc5\u8981\u4e0d\u5b58\u5728\u6761\u4ef6',`SHOULD_LIST` varchar(512) COLLATE utf8_bin DEFAULT NULL COMMENT '\u6ee1\u8db3\u5176\u4e00\u6761\u4ef6',`SHOULD_NOT_LIST` varchar(512) COLLATE utf8_bin DEFAULT NULL COMMENT '\u4e0d\u6ee1\u8db3\u5176\u4e00\u6761\u4ef6',`AGREEMENT_ID` varchar(128) COLLATE utf8_bin DEFAULT NULL COMMENT '\u534f\u8baeID',`ORG_PATH` varchar(128) COLLATE utf8_bin DEFAULT NULL COMMENT '\u673a\u6784\u6811',`ORG_ID_IN` varchar(128) COLLATE utf8_bin DEFAULT NULL COMMENT '\u673a\u6784ID',`USER_ID` varchar(128) COLLATE utf8_bin DEFAULT NULL COMMENT '\u7528\u6237ID',`USER_PERMISSION` varchar(128) COLLATE utf8_bin DEFAULT NULL COMMENT '\u6743\u9650\u6807\u8bc6',`ACTIVITY_ID` varchar(128) COLLATE utf8_bin DEFAULT NULL COMMENT '\u6d3b\u52a8ID',`COMPANY_ID` varchar(128) COLLATE utf8_bin DEFAULT NULL COMMENT '\u516c\u53f8ID',`COMMODITY_TYPE_IDS` text COLLATE utf8_bin COMMENT '\u5546\u54c1\u7c7b\u578bID',`ACCURACY_FLAG` varchar(16) COLLATE utf8_bin DEFAULT NULL COMMENT '\u51c6\u786e\u6807\u5fd7',PRIMARY KEY (`TRACE_ID`, `CREATE_TIME`),KEY `index_search_id` (`SEARCH_ID`) USING BTREE,KEY `index_create_time` (`CREATE_TIME`) USING BTREE) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_bin ROW_FORMAT=DYNAMIC COMMENT='\u8be5\u8868\u7528\u4e8e\u5b58\u50a8\u5546\u54c1\u641c\u7d22\u884c\u4e3a\u76f8\u5173\u7684\u6570\u636e' PARTITION BY RANGE (TO_DAYS(CREATE_TIME))(PARTITION " + tableName + '_' + start + " VALUES LESS THAN (TO_DAYS('" + end + "')))";
                                Db.use((String)"DATAPLAT").update(createSearchInTableSql);
                                break;
                            }
                            case "stand_se_out_log": {
                                String createSearchOutTableSql = "CREATE TABLE " + tableName + "(`TRACE_ID` bigint NOT NULL COMMENT '\u8bb0\u5f55id',`SEARCH_ID` bigint NOT NULL COMMENT '\u641c\u7d22id',`CREATE_TIME` datetime NOT NULL COMMENT '\u521b\u5efa\u65f6\u95f4',`PAGE_NO` varchar(16) COLLATE utf8_bin DEFAULT NULL COMMENT '\u9875\u7801',`PAGE_SIZE` varchar(16) COLLATE utf8_bin DEFAULT NULL COMMENT '\u6bcf\u9875\u6570',`RECORDS_TOTAL` varchar(16) COLLATE utf8_bin DEFAULT NULL COMMENT '\u603b\u9875\u6570',`TOTAL` varchar(16) COLLATE utf8_bin DEFAULT NULL COMMENT '\u603b\u9875\u6570',`RESULT` mediumtext COLLATE utf8_bin COMMENT '\u7ed3\u679c\u96c6',PRIMARY KEY (`TRACE_ID`, `CREATE_TIME`),KEY `index_search_id` (`SEARCH_ID`) USING BTREE,KEY `index_create_time` (`CREATE_TIME`) USING BTREE) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_bin  ROW_FORMAT=DYNAMIC COMMENT='\u8be5\u8868\u7528\u4e8e\u5b58\u50a8\u5546\u54c1\u641c\u7d22\u884c\u4e3a\u76f8\u5173\u7684\u6570\u636e'PARTITION BY RANGE (TO_DAYS(CREATE_TIME))(PARTITION " + tableName + '_' + start + " VALUES LESS THAN (TO_DAYS('" + end + "')))";
                                Db.use((String)"DATAPLAT").update(createSearchOutTableSql);
                                break;
                            }
                            case "stand_se_comm_detail_in_log": {
                                String createCommDetailTableSql = "CREATE TABLE " + tableName + "        (            `DETAIL_ID` bigint NOT NULL COMMENT '\u8be6\u60c5ID',            `TRACE_ID` bigint NOT NULL COMMENT '\u8bb0\u5f55 id',            `SEARCH_ID` bigint NOT NULL COMMENT '\u8ffd\u8e2aid',            `CREATE_TIME` datetime NOT NULL COMMENT '\u521b\u5efa\u65f6\u95f4',            `USER_ID` varchar(128) COLLATE utf8_bin DEFAULT NULL COMMENT '\u7528\u6237ID',            `USER_PERMISSION` varchar(128) COLLATE utf8_bin DEFAULT NULL COMMENT '\u6743\u9650\u6807\u8bc6',            `SKU_ID` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u5355\u54c1ID',            `SUPPLIER_SHOP_ID` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u5e97\u94faID',            `PROVINCE` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u4e00\u7ea7\u5730\u5740',            `CITY` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u4e8c\u7ea7\u5730\u5740',            `COUNTY` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u4e09\u7ea7\u5730\u5740',            `TOWN` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u56db\u7ea7\u5730\u5740',            `NUM` varchar(16) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u5e93\u5b58',            `COMPANY_ID` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u516c\u53f8ID',            `RECORDS_TOTAL` varchar(16) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u603b\u8bb0\u5f55\u6570',            `TOTAL` varchar(16) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u603b\u9875\u6570',            PRIMARY KEY (`DETAIL_ID`,`CREATE_TIME`),            KEY `index_search_id` (`SEARCH_ID`) USING BTREE,            KEY `index_create_time` (`CREATE_TIME`) USING BTREE        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_bin ROW_FORMAT=DYNAMIC COMMENT='\u8be5\u8868\u7528\u4e8e\u5b58\u50a8\u67e5\u770b\u5546\u54c1\u8be6\u60c5\u884c\u4e3a\u76f8\u5173\u7684\u6570\u636e'       PARTITION BY RANGE (TO_DAYS(CREATE_TIME))       (       PARTITION " + tableName + '_' + start + " VALUES LESS THAN (TO_DAYS('" + end + "'))       )";
                                Db.use((String)"DATAPLAT").update(createCommDetailTableSql);
                                break;
                            }
                            case "stand_se_comm_detail_out_log": {
                                String createCommDetailOutTableSql = "CREATE TABLE " + tableName + "        (            `DETAIL_ID` bigint NOT NULL COMMENT '\u8be6\u60c5ID',            `TRACE_ID` bigint NOT NULL COMMENT '\u8bb0\u5f55 id',            `SEARCH_ID` bigint NOT NULL COMMENT '\u8ffd\u8e2aid',            `CREATE_TIME` datetime NOT NULL COMMENT '\u521b\u5efa\u65f6\u95f4',            `COMMD_DETAILS_INFO` text CHARACTER SET utf8mb3 COLLATE utf8mb3_bin COMMENT '\u5546\u54c1\u8be6\u60c5\u96c6\u5408',            `SKU_INFO_SALE_NUM` text CHARACTER SET utf8mb3 COLLATE utf8mb3_bin COMMENT '\u5546\u54c1\u6570\u91cf\u96c6\u5408',            `ENT_AGREEMENT_CODE` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u4f01\u4e1a\u534f\u8bae\u7f16\u7801',            PRIMARY KEY (`DETAIL_ID`,`CREATE_TIME`),            KEY `index_search_id` (`SEARCH_ID`) USING BTREE,            KEY `index_create_time` (`CREATE_TIME`) USING BTREE        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_bin ROW_FORMAT=DYNAMIC COMMENT='\u8be5\u8868\u7528\u4e8e\u5b58\u50a8\u67e5\u770b\u5546\u54c1\u8be6\u60c5\u884c\u4e3a\u76f8\u5173\u7684\u6570\u636e'PARTITION BY RANGE (TO_DAYS(CREATE_TIME))(PARTITION " + tableName + '_' + start + " VALUES LESS THAN (TO_DAYS('" + end + "')))";
                                Db.use((String)"DATAPLAT").update(createCommDetailOutTableSql);
                                break;
                            }
                            case "stand_se_add_purchase_in_log": {
                                String createAddInTableSql = "CREATE TABLE " + tableName + "        (            `ADD_ID` bigint NOT NULL COMMENT '\u52a0\u8d2dID',            `TRACE_ID` bigint NOT NULL COMMENT '\u8bb0\u5f55id',            `SEARCH_ID` bigint NOT NULL COMMENT '\u8ffd\u8e2aid',            `CREATE_TIME` datetime NOT NULL COMMENT '\u521b\u5efa\u65f6\u95f4',            `USER_ID` varchar(128) COLLATE utf8_bin DEFAULT NULL COMMENT '\u7528\u6237ID',            `USER_PERMISSION` varchar(128) COLLATE utf8_bin DEFAULT NULL COMMENT '\u6743\u9650\u6807\u8bc6',            `ORG_PATH` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u673a\u6784\u6811',            `ORG_ID_IN` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u673a\u6784ID',            `USER_ID_IN` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u7528\u6237ID',            `ADD_GOODS` text CHARACTER SET utf8mb3 COLLATE utf8mb3_bin COMMENT '\u5546\u54c1\u96c6\u5408',            `PROVINCE` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u4e00\u7ea7\u5730\u5740',            `CITY` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u4e8c\u7ea7\u5730\u5740',            `COUNTY` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u4e09\u7ea7\u5730\u5740',            `TOWN` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u56db\u7ea7\u5730\u5740',            `SKU_ID` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u5355\u54c1ID',            PRIMARY KEY (`ADD_ID`,`CREATE_TIME`),            KEY `index_search_id` (`SEARCH_ID`) USING BTREE,            KEY `index_create_time` (`CREATE_TIME`) USING BTREE        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_bin ROW_FORMAT=DYNAMIC COMMENT='\u8be5\u8868\u7528\u4e8e\u5b58\u50a8\u52a0\u8d2d\u884c\u4e3a\u76f8\u5173\u7684\u6570\u636e'PARTITION BY RANGE (TO_DAYS(CREATE_TIME))(PARTITION " + tableName + '_' + start + " VALUES LESS THAN (TO_DAYS('" + end + "')))";
                                Db.use((String)"DATAPLAT").update(createAddInTableSql);
                                break;
                            }
                            case "stand_se_add_purchase_out_log": {
                                String createAddOutTableSql = "CREATE TABLE " + tableName + "        (            `ADD_ID` bigint NOT NULL COMMENT '\u52a0\u8d2dID',            `TRACE_ID` bigint NOT NULL COMMENT '\u8bb0\u5f55id',            `SEARCH_ID` bigint NOT NULL COMMENT '\u8ffd\u8e2aid',            `CREATE_TIME` datetime NOT NULL COMMENT '\u521b\u5efa\u65f6\u95f4',            `TIP_SUCCES_FLAG` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u6210\u529f\u6807\u8bc6',            `SKU_ID_MAP` text CHARACTER SET utf8mb3 COLLATE utf8mb3_bin COMMENT '\u5546\u54c1ID\u6620\u5c04',            PRIMARY KEY (`ADD_ID`,`CREATE_TIME`),            KEY `index_search_id` (`SEARCH_ID`) USING BTREE,            KEY `index_create_time` (`CREATE_TIME`) USING BTREE        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_bin ROW_FORMAT=DYNAMIC COMMENT='\u8be5\u8868\u7528\u4e8e\u5b58\u50a8\u52a0\u8d2d\u884c\u4e3a\u76f8\u5173\u7684\u6570\u636e'PARTITION BY RANGE (TO_DAYS(CREATE_TIME))(PARTITION " + tableName + '_' + start + " VALUES LESS THAN (TO_DAYS('" + end + "')))";
                                Db.use((String)"DATAPLAT").update(createAddOutTableSql);
                                break;
                            }
                            case "stand_se_collection_in_log": {
                                String createCollectionInTableSql = "CREATE TABLE " + tableName + "(`COLLECTION_ID` bigint NOT NULL COMMENT '\u6536\u85cfID',`TRACE_ID` bigint NOT NULL COMMENT '\u8bb0\u5f55 id',`SEARCH_ID` bigint NOT NULL COMMENT '\u8ffd\u8e2aid',`CREATE_TIME` datetime NOT NULL COMMENT '\u521b\u5efa\u65f6\u95f4',`USER_ID` varchar(128) COLLATE utf8_bin DEFAULT NULL COMMENT '\u7528\u6237ID',`USER_PERMISSION` varchar(128) COLLATE utf8_bin DEFAULT NULL COMMENT '\u6743\u9650\u6807\u8bc6',`MEM_ID_IN` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u4f1a\u5458ID',`SKU_ID` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u5355\u54c1ID',`SKU_NAME` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u5355\u54c1\u540d\u79f0',`SHOP_CODE` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u5e97\u94fa\u7f16\u7801',`SKU_IMG_URL` varchar(256) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u5355\u54c1\u56fe\u7247\u5730\u5740',`SKU_SOURCE` varchar(16) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u5355\u54c1\u6765\u6e90',`SUPPLIER_NAME` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u4f9b\u5e94\u5546\u540d\u79f0',`SUPPLIER_SHOP_ID` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u4f9b\u5e94\u5546\u5e97\u94fa\u7f16\u7801',`SUPPLIER_SHOP_NAME` varchar(128) CHARACTER SET utf8mb3 COLLATE utf8mb3_bin DEFAULT NULL COMMENT '\u4f9b\u5e94\u5546\u5e97\u94fa\u540d\u79f0',PRIMARY KEY (`COLLECTION_ID`,`CREATE_TIME`),KEY `index_search_id` (`SEARCH_ID`) USING BTREE,KEY `index_create_time` (`CREATE_TIME`) USING BTREE) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_bin ROW_FORMAT=DYNAMIC COMMENT='\u8be5\u8868\u7528\u4e8e\u5b58\u50a8\u5546\u54c1\u6536\u85cf\u884c\u4e3a\u76f8\u5173\u7684\u6570\u636e'PARTITION BY RANGE (TO_DAYS(CREATE_TIME))(PARTITION " + tableName + '_' + start + " VALUES LESS THAN (TO_DAYS('" + end + "')))";
                                Db.use((String)"DATAPLAT").update(createCollectionInTableSql);
                            }
                        }
                        continue;
                    }
                    String partitionName = tableName + '_' + start;
                    String checkPartitionSql = "SELECT COUNT(*) FROM INFORMATION_SCHEMA.PARTITIONS WHERE TABLE_SCHEMA = '" + this.config.getDatabaseName() + "' AND TABLE_NAME = '" + tableName + "' AND PARTITION_NAME = '" + partitionName + "'";
                    int partitionExists = Db.use((String)"DATAPLAT").queryInt(checkPartitionSql);
                    if (partitionExists == 0) {
                        log.info("\u7528\u6237\u884c\u4e3a\u8868:{}\u5df2\u5b58\u5728,\u521b\u5efa\u4e0b\u4e2a\u6708\u8868\u5206\u533a", (Object)tableName);
                        String createTablePartitionSql = "ALTER TABLE " + tableName + " ADD PARTITION (PARTITION " + tableName + '_' + start + " VALUES LESS THAN (TO_DAYS('" + end + "')))";
                        log.info("\u7528\u6237\u884c\u4e3a\u8868\u521b\u5efa\u5206\u533a:{}", (Object)createTablePartitionSql);
                        Db.use((String)"DATAPLAT").update(createTablePartitionSql);
                    }
                    log.info("\u7528\u6237\u884c\u4e3a\u8868:{}\u7684\u5206\u533a{}\u5df2\u5b58\u5728", (Object)tableName, (Object)partitionName);
                }
            } else if (this.driverName.contains("dm")) {
                log.info("\u521b\u5efa\u8fbe\u68a6\u6570\u636e\u5e93\u7528\u6237\u884c\u4e3a\u8868\u5206\u533a\u5f00\u59cb----");
                String searchInTableName = "STAND_SE_IN_LOG";
                String searchOutTableName = "STAND_SE_OUT_LOG";
                String detailInTableName = "STAND_SE_COMM_DETAIL_IN_LOG";
                String detailOutTableName = "STAND_SE_COMM_DETAIL_OUT_LOG";
                String addInTableName = "STAND_SE_ADD_PURCHASE_IN_LOG";
                String addOutTableName = "STAND_SE_ADD_PURCHASE_OUT_LOG";
                String collectionInTableName = "STAND_SE_COLLECTION_IN_LOG";
                ArrayList<String> resList = new ArrayList<String>();
                resList.add(searchInTableName);
                resList.add(searchOutTableName);
                resList.add(detailInTableName);
                resList.add(detailOutTableName);
                resList.add(addInTableName);
                resList.add(addOutTableName);
                resList.add(collectionInTableName);
                for (String tableName : resList) {
                    String sql = "SELECT * FROM USER_TABLES WHERE TABLE_NAME = ?";
                    List tables = Db.use((String)"DATAPLAT").find(sql, new Object[]{tableName});
                    if (tables.isEmpty()) {
                        switch (tableName) {
                            case "STAND_SE_IN_LOG": {
                                String createSearchInTableSql = "CREATE TABLE " + this.config.getDatabaseName() + "." + tableName + "(TRACE_ID BIGINT NOT NULL PRIMARY KEY,SEARCH_ID BIGINT NOT NULL,CREATE_TIME TIMESTAMP DEFAULT NULL,PAGE_NO VARCHAR(16),PAGE_SIZE VARCHAR(16),QUERY_STR VARCHAR(128),QUERY_CHANNEL_ID VARCHAR(128),CATEGORY_ID VARCHAR(128),LEVEL VARCHAR(128),BRAND_ID VARCHAR(128),SUPPLIER_SHOP_ID VARCHAR(128),ORDER_BY_COLUMN VARCHAR(16),ORDER_TYPE VARCHAR(16),QUERY_FILTER_LIST CLOB,QUERY_PROPERTY_LIST CLOB,MIN_SALE_PRICE VARCHAR(128),MAX_SALE_PRICE VARCHAR(128),MUST_TERMS_LIST VARCHAR(512),MUST_NOT_TERMS_LIST VARCHAR(512),SHOULD_LIST VARCHAR(512),SHOULD_NOT_LIST VARCHAR(512),AGREEMENT_ID VARCHAR(128),ORG_PATH VARCHAR(128),ORG_ID_IN VARCHAR(128),USER_ID VARCHAR(128),USER_PERMISSION VARCHAR(128),ACTIVITY_ID VARCHAR(128),COMPANY_ID VARCHAR(128),COMMODITY_TYPE_IDS CLOB,ACCURACY_FLAG VARCHAR(16)) PARTITION BY RANGE(CREATE_TIME)(PARTITION " + tableName + "_" + start + " VALUES LESS THAN (TO_TIMESTAMP('" + end + "', 'YYYYMMDD')))";
                                Db.use((String)"DATAPLAT").update(createSearchInTableSql);
                                break;
                            }
                            case "STAND_SE_OUT_LOG": {
                                String createSearchOutTableSql = "CREATE TABLE " + this.config.getDatabaseName() + "." + tableName + "(TRACE_ID BIGINT NOT NULL PRIMARY KEY,SEARCH_ID BIGINT NOT NULL,CREATE_TIME TIMESTAMP DEFAULT NULL,PAGE_NO VARCHAR(16),PAGE_SIZE VARCHAR(16),RECORDS_TOTAL VARCHAR(16),TOTAL VARCHAR(16),RESULT CLOB) PARTITION BY RANGE(CREATE_TIME)(PARTITION " + tableName + "_" + start + " VALUES LESS THAN (TO_TIMESTAMP('" + end + "', 'YYYYMMDD')))";
                                Db.use((String)"DATAPLAT").update(createSearchOutTableSql);
                                break;
                            }
                            case "STAND_SE_COMM_DETAIL_IN_LOG": {
                                String createCommDetailInTableSql = "CREATE TABLE " + this.config.getDatabaseName() + "." + tableName + "(DETAIL_ID BIGINT NOT NULL PRIMARY KEY,TRACE_ID BIGINT NOT NULL,SEARCH_ID BIGINT NOT NULL,CREATE_TIME TIMESTAMP DEFAULT NULL,USER_ID VARCHAR(128),USER_PERMISSION VARCHAR(128),SKU_ID VARCHAR(128),SUPPLIER_SHOP_ID VARCHAR(128),PROVINCE VARCHAR(128),CITY VARCHAR(128),COUNTY VARCHAR(128),TOWN VARCHAR(128),NUM VARCHAR(16),COMPANY_ID VARCHAR(128),RECORDS_TOTAL VARCHAR(16),TOTAL VARCHAR(16)) PARTITION BY RANGE(CREATE_TIME)(PARTITION " + tableName + "_" + start + " VALUES LESS THAN (TO_TIMESTAMP('" + end + "', 'YYYYMMDD')))";
                                Db.use((String)"DATAPLAT").update(createCommDetailInTableSql);
                                break;
                            }
                            case "STAND_SE_COMM_DETAIL_OUT_LOG": {
                                String createCommDetailOutTableSql = "CREATE TABLE " + this.config.getDatabaseName() + "." + tableName + "(DETAIL_ID BIGINT NOT NULL PRIMARY KEY,TRACE_ID BIGINT NOT NULL,SEARCH_ID BIGINT NOT NULL,CREATE_TIME TIMESTAMP DEFAULT NULL,COMMD_DETAILS_INFO CLOB,SKU_INFO_SALE_NUM CLOB,ENT_AGREEMENT_CODE VARCHAR(128)) PARTITION BY RANGE(CREATE_TIME)(PARTITION " + tableName + "_" + start + " VALUES LESS THAN (TO_TIMESTAMP('" + end + "', 'YYYYMMDD')))";
                                Db.use((String)"DATAPLAT").update(createCommDetailOutTableSql);
                                break;
                            }
                            case "STAND_SE_ADD_PURCHASE_IN_LOG": {
                                String createAddInTableSql = "CREATE TABLE " + this.config.getDatabaseName() + "." + tableName + "(ADD_ID BIGINT NOT NULL PRIMARY KEY,TRACE_ID BIGINT NOT NULL,SEARCH_ID BIGINT NOT NULL,CREATE_TIME TIMESTAMP DEFAULT NULL,USER_ID VARCHAR(128),USER_PERMISSION VARCHAR(128),ORG_PATH VARCHAR(128),ORG_ID_IN VARCHAR(128),USER_ID_IN VARCHAR(128),ADD_GOODS CLOB,PROVINCE VARCHAR(128),CITY VARCHAR(128),COUNTY VARCHAR(128),TOWN VARCHAR(128),SKU_ID VARCHAR(128)) PARTITION BY RANGE(CREATE_TIME)(PARTITION " + tableName + "_" + start + " VALUES LESS THAN (TO_TIMESTAMP('" + end + "', 'YYYYMMDD')))";
                                Db.use((String)"DATAPLAT").update(createAddInTableSql);
                                break;
                            }
                            case "STAND_SE_ADD_PURCHASE_OUT_LOG": {
                                String createAddOutTableSql = "CREATE TABLE " + this.config.getDatabaseName() + "." + tableName + "(ADD_ID BIGINT NOT NULL PRIMARY KEY,TRACE_ID BIGINT NOT NULL,SEARCH_ID BIGINT NOT NULL,CREATE_TIME TIMESTAMP DEFAULT NULL,TIP_SUCCES_FLAG VARCHAR(128),SKU_ID_MAP CLOB) PARTITION BY RANGE(CREATE_TIME)(PARTITION " + tableName + "_" + start + " VALUES LESS THAN (TO_TIMESTAMP('" + end + "', 'YYYYMMDD')))";
                                Db.use((String)"DATAPLAT").update(createAddOutTableSql);
                                break;
                            }
                            case "STAND_SE_COLLECTION_IN_LOG": {
                                String createCollectionInTableSql = "CREATE TABLE " + this.config.getDatabaseName() + "." + tableName + "(COLLECTION_ID BIGINT NOT NULL PRIMARY KEY,TRACE_ID BIGINT NOT NULL,SEARCH_ID BIGINT NOT NULL,CREATE_TIME TIMESTAMP DEFAULT NULL,USER_ID VARCHAR(128),USER_PERMISSION VARCHAR(128),MEM_ID_IN VARCHAR(128),SKU_ID VARCHAR(128),SKU_NAME VARCHAR(500),SHOP_CODE VARCHAR(128),SKU_IMG_URL VARCHAR(256),SKU_SOURCE VARCHAR(16),SUPPLIER_NAME VARCHAR(128),SUPPLIER_SHOP_ID VARCHAR(128),SUPPLIER_SHOP_NAME VARCHAR(128)) PARTITION BY RANGE(CREATE_TIME)(PARTITION " + tableName + "_" + start + " VALUES LESS THAN (TO_TIMESTAMP('" + end + "', 'YYYYMMDD')))";
                                Db.use((String)"DATAPLAT").update(createCollectionInTableSql);
                            }
                        }
                        continue;
                    }
                    String partitionName = tableName + "_" + start;
                    String checkPartitionSql = "SELECT COUNT(*) FROM USER_TAB_PARTITIONS WHERE TABLE_NAME = '" + tableName + "' AND PARTITION_NAME = '" + partitionName + "'";
                    int partitionExists = Db.use((String)"DATAPLAT").queryInt(checkPartitionSql);
                    if (partitionExists == 0) {
                        log.info("\u7528\u6237\u884c\u4e3a\u8868:{}\u5df2\u5b58\u5728,\u521b\u5efa\u4e0b\u4e00\u4e2a\u6708\u8868\u5206\u533a", (Object)tableName);
                        String createTablePartitionSql = "ALTER TABLE " + this.config.getDatabaseName() + "." + tableName + " ADD PARTITION " + partitionName + " VALUES LESS THAN (TO_TIMESTAMP('" + end + "', 'YYYYMMDD'))";
                        log.info("\u7528\u6237\u884c\u4e3a\u8868\u521b\u5efa\u5206\u533a:{}", (Object)createTablePartitionSql);
                        Db.use((String)"DATAPLAT").update(createTablePartitionSql);
                        continue;
                    }
                    log.info("\u7528\u6237\u884c\u4e3a\u8868:{}\u7684\u5206\u533a{}\u5df2\u5b58\u5728", (Object)tableName, (Object)partitionName);
                }
            }
        }
        catch (Exception e) {
            log.error("\u884c\u4e3a\u65e5\u5fd7\u8868\u521b\u5efa\u5931\u8d25\uff01ex:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void deleteWordStatistic(String formatted30Date) {
        String sql = "";
        sql = this.driverName.contains("dm") ? "DELETE FROM STAND_SE_INCREMENT_STATISTICS WHERE SYNC_DATE < '" + formatted30Date + "'" : "delete from stand_se_increment_statistics where sync_date < '" + formatted30Date + "'";
        int count = Db.use((String)"DATAPLAT").delete(sql);
        log.info("\u5220\u966430\u5929\u524d\u7684\u8bcd\u7edf\u8ba1\u6761\u6570\u4e3a:{}", (Object)count);
    }

    public void cleanOldBehaviorTable(String month) {
        block7: {
            String[] tableNames;
            block8: {
                String[] tableNames2;
                block6: {
                    String[] tableNames3;
                    if (!this.driverName.contains("postgresql")) break block6;
                    for (String tableName : tableNames3 = new String[]{"stand_se_in_log", "stand_se_out_log", "stand_se_comm_detail_in_log", "stand_se_comm_detail_out_log"}) {
                        String partitionName = tableName + "_" + month;
                        String checkPartitionSql = "SELECT COUNT(*) FROM " + this.config.getDatabaseName() + " WHERE tablename = '" + tableName + "' AND partitionname = '" + partitionName + "'";
                        int partitionExists = Db.use((String)"DATAPLAT").queryInt(checkPartitionSql);
                        if (partitionExists != 0) {
                            String dropTableSql = "ALTER TABLE " + tableName + " DROP PARTITION " + partitionName;
                            Db.use((String)"DATAPLAT").update(dropTableSql);
                            log.info("\u5220\u9664\u7528\u6237\u884c\u4e3a\u5206\u533a\u8868:{}\u6210\u529f", (Object)tableName);
                            continue;
                        }
                        log.info("\u5206\u533a\u8868:{}\u7684\u5206\u533a{}\u4e0d\u5b58\u5728", (Object)tableName, (Object)partitionName);
                    }
                    break block7;
                }
                if (!this.driverName.contains("mysql")) break block8;
                for (String tableName : tableNames2 = new String[]{"stand_se_in_log", "stand_se_out_log", "stand_se_comm_detail_in_log", "stand_se_comm_detail_out_log", "stand_se_add_purchase_in_log", "stand_se_add_purchase_out_log", "stand_se_collection_in_log"}) {
                    String partitionName = tableName + '_' + month;
                    String checkPartitionSql = "SELECT COUNT(*) FROM INFORMATION_SCHEMA.PARTITIONS WHERE TABLE_SCHEMA = '" + this.config.getDatabaseName() + "' AND TABLE_NAME = '" + tableName + "' AND PARTITION_NAME = '" + partitionName + "'";
                    int partitionExists = Db.use((String)"DATAPLAT").queryInt(checkPartitionSql);
                    if (partitionExists != 0) {
                        String dropTableSql = "ALTER TABLE " + tableName + " DROP PARTITION " + partitionName;
                        Db.use((String)"DATAPLAT").update(dropTableSql);
                        log.info("\u5220\u9664\u7528\u6237\u884c\u4e3a\u5206\u533a\u8868:{}\u6210\u529f", (Object)tableName);
                        continue;
                    }
                    log.info("\u5206\u533a\u8868:{}\u7684\u5206\u533a{}\u4e0d\u5b58\u5728", (Object)tableName, (Object)partitionName);
                }
                break block7;
            }
            if (!this.driverName.contains("dm")) break block7;
            for (String tableName : tableNames = new String[]{"STAND_SE_IN_LOG", "STAND_SE_OUT_LOG", "STAND_SE_COMM_DETAIL_IN_LOG", "STAND_SE_COMM_DETAIL_OUT_LOG", "STAND_SE_ADD_PURCHASE_IN_LOG", "STAND_SE_ADD_PURCHASE_OUT_LOG", "STAND_SE_COLLECTION_IN_LOG"}) {
                String partitionName = tableName + "_" + month;
                String checkPartitionSql = "SELECT COUNT(*) FROM USER_TAB_PARTITIONS WHERE TABLE_NAME = '" + tableName + "' AND PARTITION_NAME = '" + partitionName + "'";
                int partitionExists = Db.use((String)"DATAPLAT").queryInt(checkPartitionSql);
                if (partitionExists != 0) {
                    String dropTableSql = "ALTER TABLE " + this.config.getDatabaseName() + "." + tableName + " DROP PARTITION " + partitionName;
                    Db.use((String)"DATAPLAT").update(dropTableSql);
                    log.info("\u5220\u9664\u7528\u6237\u884c\u4e3a\u5206\u533a\u8868:{}\u6210\u529f", (Object)tableName);
                    continue;
                }
                log.info("\u5206\u533a\u8868:{}\u7684\u5206\u533a{}\u4e0d\u5b58\u5728", (Object)tableName, (Object)partitionName);
            }
        }
    }
}

