/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.base.SeBusinessException;
import com.tydic.se.base.dao.EsFiledObjConfigMapper;
import com.tydic.se.base.dao.EsIndexMapper;
import com.tydic.se.base.dao.EsIndexTemplateMapper;
import com.tydic.se.base.dao.SearchChannelConfigMapper;
import com.tydic.se.base.dao.SearchConfigNewDao;
import com.tydic.se.base.dao.StandSeEntityCacheMapper;
import com.tydic.se.base.dao.po.EsFiledObjConfigPo;
import com.tydic.se.base.dao.po.EsIndex;
import com.tydic.se.base.dao.po.EsIndexTemplate;
import com.tydic.se.base.dao.po.SearchChannelConfigPO;
import com.tydic.se.base.dao.po.SearchConfigNew;
import com.tydic.se.base.dao.po.StandSeEntityCachePo;
import com.tydic.se.manage.api.SearchChannelConfigService;
import com.tydic.se.manage.bo.SearchChannelConfigReqBO;
import com.tydic.se.manage.bo.SearchChannelConfigRspBO;
import com.tydic.se.manage.util.CodeUtil;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SearchChannelConfigServiceImpl
implements SearchChannelConfigService {
    private static final Logger log = LoggerFactory.getLogger(SearchChannelConfigServiceImpl.class);
    @Autowired
    private SearchChannelConfigMapper searchChannelConfigMapper;
    @Autowired
    private SearchConfigNewDao searchConfigNewDao;
    @Autowired
    private EsIndexMapper esIndexMapper;
    @Autowired
    private EsIndexTemplateMapper esIndexTemplateMapper;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private StandSeEntityCacheMapper standSeEntityCacheMapper;
    @Autowired
    private EsFiledObjConfigMapper esFiledObjConfigMapper;

    public RspPage<SearchChannelConfigPO> querySearchChannelConfigList(SearchChannelConfigReqBO reqBO) {
        int totalPages;
        int totalRecords;
        List resultList;
        if (reqBO.getPageSize() < 1) {
            reqBO.setPageSize(10);
        }
        SearchChannelConfigPO queryPo = new SearchChannelConfigPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)queryPo);
        if (reqBO.getPageNo() == -1) {
            resultList = this.searchChannelConfigMapper.selectByCondition(queryPo);
            totalRecords = resultList.size();
            totalPages = 1;
        } else {
            Page page = PageMethod.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.searchChannelConfigMapper.selectByCondition(queryPo));
            resultList = page.getResult();
            totalPages = page.getPages();
            totalRecords = (int)page.getTotal();
        }
        RspPage rspPage = new RspPage();
        rspPage.setPageNo(reqBO.getPageNo() == -1 ? 1 : reqBO.getPageNo());
        rspPage.setRows(resultList);
        rspPage.setTotal(totalPages);
        rspPage.setRecordsTotal(totalRecords);
        return rspPage;
    }

    public SearchChannelConfigPO querySearchChannelConfigById(SearchChannelConfigReqBO reqBO) {
        if (reqBO.getId() == null) {
            throw new IllegalArgumentException("ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            SearchChannelConfigPO po = this.searchChannelConfigMapper.selectByPrimaryKey(reqBO.getId());
            if (po == null) {
                return null;
            }
            return po;
        }
        catch (Exception e) {
            throw new SeBusinessException("\u6839\u636eID\u67e5\u8be2\u641c\u7d22\u9891\u9053\u914d\u7f6e\u8be6\u60c5\u5931\u8d25");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public SearchChannelConfigRspBO addSearchChannelConfig(SearchChannelConfigReqBO reqBO) {
        SearchChannelConfigRspBO rspBO = new SearchChannelConfigRspBO();
        if (reqBO == null) {
            throw new IllegalArgumentException("\u9891\u9053\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            SearchChannelConfigPO channelConfigPO = new SearchChannelConfigPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)channelConfigPO);
            channelConfigPO.setId(CodeUtil.generateTableCode());
            channelConfigPO.setCreateTime(new Date());
            channelConfigPO.setUpdateTime(new Date());
            channelConfigPO.setIsDefaultConfig(Integer.valueOf(1));
            int result = this.searchChannelConfigMapper.insert(channelConfigPO);
            if (result == 1) {
                this.insertCopy(channelConfigPO.getId());
                rspBO.setData(channelConfigPO);
                rspBO.setMessage("\u6210\u529f");
                rspBO.setCode("0");
            } else {
                rspBO.setMessage("\u5931\u8d25");
                rspBO.setCode("1");
            }
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u641c\u7d22\u9891\u9053\u914d\u7f6e\u5931\u8d25", (Throwable)e);
        }
        return rspBO;
    }

    private void insertCopy(Long newChannelId) {
        try {
            log.info("\u5f00\u59cb\u6267\u884c\u590d\u6742\u65b0\u589e\u903b\u8f91, newChannelId: {}", (Object)newChannelId);
            List originalConfigs = this.searchConfigNewDao.queryBySeChannelType(Long.valueOf(1L));
            if (!CollectionUtils.isEmpty((Collection)originalConfigs)) {
                this.copySearchConfig(originalConfigs, newChannelId);
            }
            this.performEsIndexCopy(newChannelId);
            this.performEsIndexTemplateCopy(newChannelId);
            this.performEntityCacheCopy(newChannelId);
            this.performEsObjCacheCopy(newChannelId);
            log.info("\u590d\u6742\u65b0\u589e\u903b\u8f91\u6267\u884c\u5b8c\u6210, newChannelId: {}", (Object)newChannelId);
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u590d\u6742\u65b0\u589e\u903b\u8f91\u5931\u8d25, newChannelId: {}", (Object)newChannelId, (Object)e);
        }
    }

    private void copySearchConfig(List<SearchConfigNew> originalConfigs, Long newChannelId) {
        HashMap<Integer, Integer> idMappings = new HashMap<Integer, Integer>();
        List topLevelConfigs = originalConfigs.stream().filter(config -> config.getPId() == null).collect(Collectors.toList());
        for (SearchConfigNew originalConfig : topLevelConfigs) {
            SearchConfigNew newConfig = this.createNewSearchConfig(originalConfig, newChannelId, null);
            this.searchConfigNewDao.insert(newConfig);
            idMappings.put(originalConfig.getId(), newConfig.getId());
        }
        this.processChildNodes(originalConfigs, idMappings, newChannelId);
    }

    private void processChildNodes(List<SearchConfigNew> originalConfigs, Map<Integer, Integer> idMappings, Long newChannelId) {
        boolean hasNewNodes;
        do {
            hasNewNodes = false;
            for (SearchConfigNew originalConfig : originalConfigs) {
                if (idMappings.containsKey(originalConfig.getId()) || originalConfig.getPId() == null || !idMappings.containsKey(originalConfig.getPId())) continue;
                Integer newParentId = idMappings.get(originalConfig.getPId());
                SearchConfigNew newConfig = this.createNewSearchConfig(originalConfig, newChannelId, newParentId);
                this.searchConfigNewDao.insert(newConfig);
                idMappings.put(originalConfig.getId(), newConfig.getId());
                hasNewNodes = true;
            }
        } while (hasNewNodes);
    }

    private SearchConfigNew createNewSearchConfig(SearchConfigNew originalConfig, Long newChannelId, Integer newParentId) {
        SearchConfigNew newConfig = new SearchConfigNew();
        BeanUtils.copyProperties((Object)originalConfig, (Object)newConfig);
        newConfig.setId(Integer.valueOf(CodeUtil.generateIntKey()));
        newConfig.setPId(newParentId);
        newConfig.setSeChannelType(newChannelId);
        newConfig.setCreateTime(new Date());
        newConfig.setUpdateTime(new Date());
        return newConfig;
    }

    private void performEsIndexCopy(Long newChannelId) {
        try {
            log.info("\u5f00\u59cb\u6267\u884cES\u7d22\u5f15\u914d\u7f6e\u590d\u5236\u903b\u8f91, newChannelId: {}", (Object)newChannelId);
            List originalIndexes = this.esIndexMapper.queryBySeChannelType(Long.valueOf(1L));
            if (!CollectionUtils.isEmpty((Collection)originalIndexes)) {
                for (EsIndex originalIndex : originalIndexes) {
                    EsIndex newIndex = new EsIndex();
                    BeanUtils.copyProperties((Object)originalIndex, (Object)newIndex);
                    newIndex.setId(CodeUtil.generateTableCode());
                    newIndex.setSeChannelType(newChannelId);
                    newIndex.setCreateTime(new Date());
                    newIndex.setUpdateTime(new Date());
                    this.esIndexMapper.insert(newIndex);
                }
                log.info("ES\u7d22\u5f15\u914d\u7f6e\u590d\u5236\u5b8c\u6210, \u590d\u5236\u4e86 {} \u6761\u8bb0\u5f55", (Object)originalIndexes.size());
            } else {
                log.info("\u6ca1\u6709\u627e\u5230\u9700\u8981\u590d\u5236\u7684ES\u7d22\u5f15\u914d\u7f6e");
            }
        }
        catch (Exception e) {
            log.error("ES\u7d22\u5f15\u914d\u7f6e\u590d\u5236\u5931\u8d25, newChannelId: {}", (Object)newChannelId, (Object)e);
        }
    }

    private void performEsIndexTemplateCopy(Long newChannelId) {
        try {
            log.info("\u5f00\u59cb\u6267\u884cES\u7d22\u5f15\u6a21\u677f\u914d\u7f6e\u590d\u5236\u903b\u8f91, newChannelId: {}", (Object)newChannelId);
            List originalTemplates = this.esIndexTemplateMapper.queryBySeChannelType(Long.valueOf(1L));
            if (!CollectionUtils.isEmpty((Collection)originalTemplates)) {
                for (EsIndexTemplate originalTemplate : originalTemplates) {
                    EsIndexTemplate newTemplate = new EsIndexTemplate();
                    BeanUtils.copyProperties((Object)originalTemplate, (Object)newTemplate);
                    newTemplate.settId(CodeUtil.generateTableCode());
                    newTemplate.setSeChannelType(newChannelId);
                    newTemplate.setCreateTime(new Date());
                    newTemplate.setUpdateTime(new Date());
                    this.esIndexTemplateMapper.insert(newTemplate);
                }
                log.info("ES\u7d22\u5f15\u6a21\u677f\u914d\u7f6e\u590d\u5236\u5b8c\u6210, \u590d\u5236\u4e86 {} \u6761\u8bb0\u5f55", (Object)originalTemplates.size());
            } else {
                log.info("\u6ca1\u6709\u627e\u5230\u9700\u8981\u590d\u5236\u7684ES\u7d22\u5f15\u6a21\u677f\u914d\u7f6e");
            }
        }
        catch (Exception e) {
            log.error("ES\u7d22\u5f15\u6a21\u677f\u914d\u7f6e\u590d\u5236\u5931\u8d25, newChannelId: {}", (Object)newChannelId, (Object)e);
        }
    }

    private void performEntityCacheCopy(Long newChannelId) {
        try {
            log.info("\u5f00\u59cb\u6267\u884cEntityCache\u914d\u7f6e\u590d\u5236\u903b\u8f91, newChannelId: {}", (Object)newChannelId);
            List standSeEntityCachePos = this.standSeEntityCacheMapper.selectBySeChannelType(Long.valueOf(1L));
            if (!CollectionUtils.isEmpty((Collection)standSeEntityCachePos)) {
                for (StandSeEntityCachePo standSeEntityCachePo : standSeEntityCachePos) {
                    StandSeEntityCachePo newEntityCache = new StandSeEntityCachePo();
                    BeanUtils.copyProperties((Object)standSeEntityCachePo, (Object)newEntityCache);
                    newEntityCache.setEntityCacheId(this.generateAsyncId());
                    newEntityCache.setSeChannelType(newChannelId);
                    this.standSeEntityCacheMapper.insert(newEntityCache);
                }
                log.info("\u7f13\u5b58\u5b9e\u4f53\u914d\u7f6e\u590d\u5236\u5b8c\u6210, \u590d\u5236\u4e86 {} \u6761\u8bb0\u5f55", (Object)standSeEntityCachePos.size());
            } else {
                log.info("\u6ca1\u6709\u627e\u5230\u9700\u8981\u590d\u5236\u7684\u7f13\u5b58\u5b9e\u4f53\u914d\u7f6e");
            }
        }
        catch (Exception e) {
            log.error("\u7f13\u5b58\u5b9e\u4f53\u914d\u7f6e\u590d\u5236\u5931\u8d25, newChannelId: {}", (Object)newChannelId, (Object)e);
        }
    }

    private void performEsObjCacheCopy(Long newChannelId) {
        try {
            log.info("\u5f00\u59cb\u6267\u884cEs\u5b57\u6bb5\u5bf9\u8c61\u914d\u7f6e\u590d\u5236\u903b\u8f91, newChannelId: {}", (Object)newChannelId);
            List esFiledObjConfigPos = this.esFiledObjConfigMapper.selectBySeChannelType(Long.valueOf(1L));
            if (!CollectionUtils.isEmpty((Collection)esFiledObjConfigPos)) {
                for (EsFiledObjConfigPo esFiledObjConfigPo : esFiledObjConfigPos) {
                    EsFiledObjConfigPo newEsFieldObj = new EsFiledObjConfigPo();
                    BeanUtils.copyProperties((Object)esFiledObjConfigPo, (Object)newEsFieldObj);
                    newEsFieldObj.setId(this.generateAsyncId());
                    newEsFieldObj.setSeChannelType(newChannelId);
                    this.esFiledObjConfigMapper.insert(newEsFieldObj);
                }
                log.info("Es\u5b57\u6bb5\u5bf9\u8c61\u914d\u7f6e\u590d\u5236\u5b8c\u6210, \u590d\u5236\u4e86 {} \u6761\u8bb0\u5f55", (Object)esFiledObjConfigPos.size());
            } else {
                log.info("\u6ca1\u6709\u627e\u5230\u9700\u8981\u590d\u5236\u7684Es\u5b57\u6bb5\u5bf9\u8c61\u914d\u7f6e");
            }
        }
        catch (Exception e) {
            log.error("Es\u5b57\u6bb5\u5bf9\u8c61\u914d\u7f6e\u590d\u5236\u5931\u8d25, newChannelId: {}", (Object)newChannelId, (Object)e);
        }
    }

    private Integer generateAsyncId() {
        return CodeUtil.generateIntKey();
    }

    @Transactional(rollbackFor={Exception.class})
    public SearchChannelConfigRspBO updateSearchChannelConfig(SearchChannelConfigReqBO reqBO) {
        SearchChannelConfigRspBO rspBO = new SearchChannelConfigRspBO();
        if (reqBO == null || reqBO.getId() == null) {
            throw new IllegalArgumentException("\u9891\u9053\u914d\u7f6e\u4fe1\u606f\u6216ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SearchChannelConfigPO po = new SearchChannelConfigPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        po.setUpdateTime(new Date());
        int result = this.searchChannelConfigMapper.updateByPrimaryKeySelective(po);
        if (result == 1) {
            if (reqBO.getIsDefaultConfig() == 0) {
                this.cacheClient.set("{SEARCH}_DEFAULT_CHANNEL_TYPE", (Object)reqBO.getId());
            }
            rspBO.setData(po);
            rspBO.setMessage("\u6210\u529f");
            rspBO.setCode("0");
        } else {
            rspBO.setMessage("\u5931\u8d25");
            rspBO.setCode("1");
        }
        return rspBO;
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean deleteSearchChannelConfigById(SearchChannelConfigReqBO reqBO) {
        if (reqBO.getId() == null) {
            throw new IllegalArgumentException("ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getId() == 1L) {
            throw new IllegalArgumentException("\u521d\u59cb\u5316\u914d\u7f6e\u4e0d\u80fd\u5220\u9664");
        }
        if (reqBO.getId() == 2L) {
            throw new IllegalArgumentException("\u9ed8\u8ba4\u914d\u7f6e\u4e0d\u80fd\u5220\u9664");
        }
        try {
            int result = this.searchChannelConfigMapper.deleteByPrimaryKey(reqBO.getId());
            int resultConfigNew = this.searchConfigNewDao.deleteBySeChannelType(reqBO.getId());
            int resultIndex = this.esIndexMapper.deleteBySeChannelType(reqBO.getId());
            int resultTemplate = this.esIndexTemplateMapper.deleteBySeChannelType(reqBO.getId());
            return result > 0 && resultConfigNew > 0 && resultIndex > 0 && resultTemplate > 0;
        }
        catch (Exception e) {
            throw new SeBusinessException("\u6839\u636eID\u5220\u9664\u641c\u7d22\u9891\u9053\u914d\u7f6e\u5931\u8d25");
        }
    }
}

