/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.se.manage.api.CacheUpdateService;
import com.tydic.se.manage.api.SearchCommonWordService;
import com.tydic.se.manage.bo.CommonWordsImportBO;
import com.tydic.se.manage.bo.CommonWordsImportRsp;
import com.tydic.se.manage.bo.ExportCatalogRspBO;
import com.tydic.se.manage.bo.SearchCommonBO;
import com.tydic.se.manage.bo.SearchCommonReNameBO;
import com.tydic.se.manage.bo.SearchCommonReq;
import com.tydic.se.manage.bo.SearchCommonRsp;
import com.tydic.se.manage.bo.TableHeadInfo;
import com.tydic.se.manage.constants.Constants;
import com.tydic.se.manage.constants.XlsUtil;
import com.tydic.se.manage.dao.SearchCommonWordsMappingRecordDao;
import com.tydic.se.manage.dao.SearchCommonWordsRecordDao;
import com.tydic.se.manage.dao.po.SearchCommonWordsMappingRecordPO;
import com.tydic.se.manage.dao.po.SearchCommonWordsRecordPO;
import com.tydic.se.manage.util.CodeUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class SearchCommonWordsServiceImpl
implements SearchCommonWordService {
    private static final Logger log = LoggerFactory.getLogger(SearchCommonWordsServiceImpl.class);
    @Autowired
    private SearchCommonWordsRecordDao searchCommonWordsRecordDao;
    @Autowired
    private SearchCommonWordsMappingRecordDao commonWordsMappingRecordDao;
    @Autowired
    private CacheUpdateService cacheUpdateService;

    public SearchCommonRsp queryCommonWordsList(SearchCommonReq reqBO) throws ZTBusinessException {
        SearchCommonRsp rspBO = new SearchCommonRsp();
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize());
        List list = new ArrayList();
        try {
            SearchCommonBO searchCommonBO = new SearchCommonBO();
            searchCommonBO.setWName(reqBO.getWName());
            searchCommonBO.setWStatus(reqBO.getWStatus());
            list = this.searchCommonWordsRecordDao.queryCommonWordsList(searchCommonBO);
            if (list != null && list.size() > 0) {
                for (SearchCommonBO s : list) {
                    String wordContent = s.getWName() + "=>" + s.getReName();
                    s.setWordContent(wordContent);
                    List rsp = this.commonWordsMappingRecordDao.selectByWId(s.getWId());
                    if (rsp == null) continue;
                    s.setCommWordList(rsp);
                }
            }
        }
        catch (Exception e) {
            log.error("queryCommonWordsList========>qry\u67e5\u8be2\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u67e5\u8be2\u5217\u8868\u5931\u8d25");
        }
        PageInfo pageInfo = new PageInfo(list);
        rspBO.setRows(list);
        rspBO.setPageNo(reqBO.getPageNo().intValue());
        rspBO.setRecordsTotal((int)pageInfo.getTotal());
        rspBO.setTotal(pageInfo.getPages());
        return rspBO;
    }

    @Transactional(rollbackFor={Exception.class})
    public void addCommonWordInfo(SearchCommonReq reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        if (StringUtils.isEmpty((CharSequence)reqBO.getWName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u3010\u4e3b\u8bcd\u540d\u79f0\u3011\u4e3a\u7a7a");
        }
        if (reqBO.getCommWordList() == null) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u3010\u8bcd\u8bed\u5185\u5bb9\u3011\u4e3a\u7a7a");
        }
        SearchCommonWordsRecordPO isExist = this.searchCommonWordsRecordDao.checkCommWordExist(reqBO.getWName());
        if (isExist != null) {
            throw new ZTBusinessException("\u8bcd\u8bed\u5185\u5bb9\u540d\u79f0\u91cd\u590d\uff01");
        }
        SearchCommonWordsRecordPO commonWordsRecordPO = new SearchCommonWordsRecordPO();
        commonWordsRecordPO.setWId(CodeUtil.generateTableCode());
        commonWordsRecordPO.setWName(reqBO.getWName());
        commonWordsRecordPO.setWStatus(Constants.WORDS_STATE_1);
        commonWordsRecordPO.setCreateTime(new Date());
        commonWordsRecordPO.setUpdateTime(new Date());
        this.searchCommonWordsRecordDao.insertSelective(commonWordsRecordPO);
        List commWordList = JSONObject.parseArray((String)reqBO.getCommWordList(), SearchCommonReNameBO.class);
        for (SearchCommonReNameBO com : commWordList) {
            if (com.getWReWeight() == null || com.getWReWeight().floatValue() == 0.0f) {
                throw new ZTBusinessException("\u6539\u5199\u8bcd\u6743\u91cd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((CharSequence)com.getWReName())) {
                throw new ZTBusinessException(com.getWReName() + ":\u6539\u5199\u8bcd\u5185\u5bb9\u4e3a\u7a7a\uff01");
            }
            if (reqBO.getWName().equals(com.getWReName())) {
                throw new ZTBusinessException(com.getWReName() + ":\u6539\u5199\u8bcd\u4e0e\u8bcd\u8bed\u5185\u5bb9\u76f8\u540c\uff01");
            }
            SearchCommonReNameBO isReNameExist = this.commonWordsMappingRecordDao.selectByWRName(com.getWReName(), commonWordsRecordPO.getWId());
            if (isReNameExist != null) {
                throw new ZTBusinessException(com.getWReName() + ":\u6539\u5199\u8bcd\u5185\u5bb9\u91cd\u590d\uff01");
            }
            SearchCommonWordsMappingRecordPO po = new SearchCommonWordsMappingRecordPO();
            po.setWMId(CodeUtil.generateTableCode());
            po.setWId(commonWordsRecordPO.getWId());
            po.setWReName(com.getWReName());
            po.setWReWeight(com.getWReWeight());
            po.setWReStatus(Constants.WORDS_STATE_1);
            po.setCreateTime(new Date());
            po.setUpdateTime(new Date());
            this.commonWordsMappingRecordDao.insertSelective(po);
        }
        this.cacheUpdateService.updateRewriteWord(reqBO.getWName());
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateCommonWordInfo(SearchCommonReq reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        if (reqBO.getWId() == null) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u3010\u4e3b\u8bcdId\u3011\u4e3a\u7a7a");
        }
        if (reqBO.getCommWordList() == null) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u3010\u6539\u5199\u8bcd\u5217\u8868\u3011\u4e3a\u7a7a");
        }
        SearchCommonWordsRecordPO isExist = this.searchCommonWordsRecordDao.selectByPrimaryKey(reqBO.getWId());
        if (isExist == null) {
            throw new ZTBusinessException("\u8bcd\u8bed\u5185\u5bb9\u4e0d\u5b58\u5728\uff0c\u6570\u636e\u5f02\u5e38\uff01");
        }
        if (isExist.getWStatus() == 1) {
            throw new ZTBusinessException("\u542f\u7528\u72b6\u6001\u4e0d\u5141\u8bb8\u7f16\u8f91\uff01");
        }
        this.commonWordsMappingRecordDao.deleteByWId(reqBO.getWId());
        List commWordList = JSONObject.parseArray((String)reqBO.getCommWordList(), SearchCommonReNameBO.class);
        for (SearchCommonReNameBO com : commWordList) {
            if (com.getWReWeight() == null || com.getWReWeight().floatValue() == 0.0f) {
                throw new ZTBusinessException("\u6539\u5199\u8bcd\u6743\u91cd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((CharSequence)com.getWReName())) {
                throw new ZTBusinessException(com.getWReName() + ":\u6539\u5199\u8bcd\u5185\u5bb9\u4e3a\u7a7a\uff01");
            }
            if (reqBO.getWName().equals(com.getWReName())) {
                throw new ZTBusinessException(com.getWReName() + ":\u6539\u5199\u8bcd\u4e0e\u8bcd\u8bed\u5185\u5bb9\u76f8\u540c\uff01");
            }
            SearchCommonReNameBO isReNameExist = this.commonWordsMappingRecordDao.selectByWRName(com.getWReName(), reqBO.getWId());
            if (isReNameExist != null) {
                throw new ZTBusinessException(com.getWReName() + ":\u6539\u5199\u8bcd\u5185\u5bb9\u91cd\u590d\uff01");
            }
            SearchCommonWordsMappingRecordPO po = new SearchCommonWordsMappingRecordPO();
            po.setWMId(CodeUtil.generateTableCode());
            po.setWId(reqBO.getWId());
            po.setWReName(com.getWReName());
            po.setWReWeight(com.getWReWeight());
            po.setWReStatus(Constants.WORDS_STATE_1);
            po.setCreateTime(new Date());
            po.setUpdateTime(new Date());
            this.commonWordsMappingRecordDao.insertSelective(po);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateCommonWordStatus(SearchCommonReq reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        if (reqBO.getWId() == null || StringUtils.isEmpty((CharSequence)reqBO.getWId().toString())) {
            throw new ZTBusinessException("\u53c2\u6570\u5f02\u5e38\uff01");
        }
        if (reqBO.getWStatus() == null || StringUtils.isEmpty((CharSequence)reqBO.getWStatus().toString())) {
            throw new ZTBusinessException("\u53c2\u6570\u5f02\u5e38\uff01");
        }
        SearchCommonWordsRecordPO isExist = this.searchCommonWordsRecordDao.selectByPrimaryKey(reqBO.getWId());
        if (isExist == null) {
            throw new ZTBusinessException("\u8bcd\u8bed\u5185\u5bb9\u4e0d\u5b58\u5728\uff0c\u6570\u636e\u5f02\u5e38\uff01");
        }
        SearchCommonWordsRecordPO SearchCommonWordsRecordPO2 = new SearchCommonWordsRecordPO();
        SearchCommonWordsRecordPO2.setWId(reqBO.getWId());
        SearchCommonWordsRecordPO2.setWStatus(reqBO.getWStatus());
        SearchCommonWordsRecordPO2.setUpdateTime(new Date());
        this.searchCommonWordsRecordDao.updateStatusByPrimaryKey(SearchCommonWordsRecordPO2);
        List rsp = this.commonWordsMappingRecordDao.selectByWId(reqBO.getWId());
        if (rsp != null) {
            this.commonWordsMappingRecordDao.updateByWIdList(rsp, reqBO.getWStatus());
        }
        final Set nameList = this.commonWordsMappingRecordDao.selectNameByWId(reqBO.getWId());
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                SearchCommonWordsServiceImpl.this.cacheUpdateService.bathUpdateRewriteWord(nameList);
            }
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteCommonWordInfo(SearchCommonReq reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        if (StringUtils.isEmpty((CharSequence)reqBO.getWId().toString())) {
            throw new ZTBusinessException("wId\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SearchCommonWordsRecordPO isExist = this.searchCommonWordsRecordDao.selectByPrimaryKey(reqBO.getWId());
        if (isExist == null) {
            throw new ZTBusinessException("\u4e0d\u5b58\u5728\uff0c\u6570\u636e\u5f02\u5e38\uff01");
        }
        if (isExist.getWStatus() == 1) {
            throw new ZTBusinessException("\u542f\u7528\u72b6\u6001\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        this.commonWordsMappingRecordDao.deleteByWId(reqBO.getWId());
        this.searchCommonWordsRecordDao.deleteByPrimaryKey(reqBO.getWId());
        final Set nameList = this.commonWordsMappingRecordDao.selectNameByWId(reqBO.getWId());
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                SearchCommonWordsServiceImpl.this.cacheUpdateService.bathUpdateRewriteWord(nameList);
            }
        });
    }

    public ExportCatalogRspBO exportCommonWord() throws ZTBusinessException {
        ExportCatalogRspBO rspBO = new ExportCatalogRspBO();
        List allData = this.commonWordsMappingRecordDao.selectAllData();
        String[] variable = new String[]{"wName", "wReName", "wReWeight"};
        Object[][] data = XlsUtil.toArray((List)allData, (String[])variable);
        String jsonString = JSONObject.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        rspBO.setJsonString(jsonString);
        ArrayList<String> title = new ArrayList<String>();
        title.add("\u4e3b\u8bcd");
        title.add("\u6539\u5199\u8bcd");
        title.add("\u6539\u5199\u8bcd\u6743\u91cd");
        String titleString = JSONObject.toJSONString(title, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        rspBO.setTitleString(titleString);
        return rspBO;
    }

    public CommonWordsImportRsp importCommonWord(List<List<String>> cList) {
        CommonWordsImportRsp rspBo = new CommonWordsImportRsp();
        ArrayList<CommonWordsImportBO> errList = new ArrayList<CommonWordsImportBO>();
        int successNums = 0;
        int failNums = 0;
        int clistSize = cList.size();
        Sequence sequence = Sequence.getInstance();
        HashMap idMap = new HashMap();
        for (int ti = 0; ti < clistSize; ++ti) {
            List<String> row = cList.get(ti);
            CommonWordsImportBO cBO = new CommonWordsImportBO();
            try {
                String wName = "";
                String wReName = "";
                String wReWeight = "";
                Long wId = null;
                Long wMId = null;
                Boolean newData = false;
                if (row.size() >= 1) {
                    wName = row.get(0).trim();
                    if (idMap.get(wName) == null) {
                        wId = sequence.nextId();
                        newData = true;
                    } else {
                        wId = (Long)idMap.get(wName);
                    }
                    cBO.setWName(wName);
                }
                if (row.size() >= 2) {
                    wReName = row.get(1).trim();
                    wMId = sequence.nextId();
                    cBO.setWReName(wReName);
                }
                if (newData.booleanValue()) {
                    if (StringUtils.isEmpty((CharSequence)wName)) {
                        ++failNums;
                        cBO.setFailMsg(wName + ":\u4e3b\u8bcd\u4e3a\u7a7a");
                        errList.add(cBO);
                        continue;
                    }
                    SearchCommonWordsRecordPO isExist = this.searchCommonWordsRecordDao.checkCommWordExist(wName);
                    if (isExist != null) {
                        wId = isExist.getWId();
                    } else {
                        SearchCommonWordsRecordPO wPO = new SearchCommonWordsRecordPO();
                        wPO.setWId(wId);
                        wPO.setWName(wName);
                        wPO.setWStatus(Constants.WORDS_STATE_1);
                        wPO.setCreateTime(new Date());
                        wPO.setUpdateTime(new Date());
                        this.searchCommonWordsRecordDao.insertSelective(wPO);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)wReName)) {
                    ++failNums;
                    cBO.setFailMsg(wReName + ":\u6539\u5199\u8bcd\u4e3a\u7a7a");
                    errList.add(cBO);
                    continue;
                }
                if (wName.equals(wReName)) {
                    throw new ZTBusinessException(wReName + ":\u6539\u5199\u8bcd\u4e0e\u8bcd\u8bed\u5185\u5bb9\u76f8\u540c\uff01");
                }
                SearchCommonWordsMappingRecordPO wMPO = new SearchCommonWordsMappingRecordPO();
                wMPO.setWMId(wMId);
                wMPO.setWId(wId);
                wMPO.setWReName(wReName);
                wMPO.setWReStatus(Constants.WORDS_STATE_1);
                wMPO.setCreateTime(new Date());
                wMPO.setUpdateTime(new Date());
                SearchCommonReNameBO isExist = this.commonWordsMappingRecordDao.selectByWRName(wReName, wId);
                if (isExist != null) {
                    wMPO.setWMId(isExist.getWMId());
                    this.commonWordsMappingRecordDao.updateByPrimaryKeySelective(wMPO);
                } else {
                    this.commonWordsMappingRecordDao.insertSelective(wMPO);
                }
                ++successNums;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u5bfc\u5165\u5f02\u5e38", (Throwable)e);
                ++failNums;
                cBO.setFailMsg(e.getMessage());
                errList.add(cBO);
            }
        }
        rspBo.setFailNums(failNums);
        rspBo.setSuccessNums(successNums);
        ArrayList<String> title = new ArrayList<String>();
        title.add("\u4e3b\u8bcd");
        title.add("\u6539\u5199\u8bcd");
        title.add("\u6539\u5199\u8bcd\u6743\u91cd");
        String[] variable = new String[]{"wName", "wReName", "wReWeight"};
        String jsonString = "";
        String titleString = "";
        if (errList != null && errList.size() > 0) {
            Object[][] data = XlsUtil.toArray(errList, (String[])variable);
            jsonString = JSONObject.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
            rspBo.setJsonString(jsonString);
            titleString = JSONObject.toJSONString(title, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
            rspBo.setTitleString(titleString);
        }
        rspBo.setJsonString(jsonString);
        rspBo.setTitleString(titleString);
        rspBo.setFailList(errList);
        ArrayList<TableHeadInfo> tableHeadInfos = new ArrayList<TableHeadInfo>();
        for (int i = 0; i < title.size(); ++i) {
            TableHeadInfo tableHeadInfo1 = new TableHeadInfo();
            tableHeadInfo1.setTitle((String)title.get(i));
            tableHeadInfo1.setDataIndex(variable[i]);
            tableHeadInfos.add(tableHeadInfo1);
        }
        TableHeadInfo tableHeadInfo1 = new TableHeadInfo();
        tableHeadInfo1.setTitle("\u5931\u8d25\u539f\u56e0");
        tableHeadInfo1.setDataIndex("failMsg");
        tableHeadInfos.add(tableHeadInfo1);
        rspBo.setTitleList(tableHeadInfos);
        return rspBo;
    }
}

