/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Record;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.base.bo.SortConfigBO;
import com.tydic.se.base.dao.SearchConfigNewDao;
import com.tydic.se.base.dao.po.SearchConfigNew;
import com.tydic.se.manage.api.CacheUpdateService;
import com.tydic.se.manage.api.OperLogService;
import com.tydic.se.manage.api.SearchConfigService;
import com.tydic.se.manage.bo.SearConfigBO;
import com.tydic.se.manage.bo.SearchAllConfig;
import com.tydic.se.manage.bo.SearchAllConfigReq;
import com.tydic.se.manage.bo.SearchAllConfigRspBO;
import com.tydic.se.manage.bo.SearchCommonReq;
import com.tydic.se.manage.bo.SearchConfigBO;
import com.tydic.se.manage.bo.SearchConfigNewBo;
import com.tydic.se.manage.bo.SearchConfigRsp;
import com.tydic.se.manage.bo.SearchSortConfigReq;
import com.tydic.se.manage.bo.SwapInsertOperLogReqBO;
import com.tydic.se.manage.dao.DwdSkuChannelMapper;
import com.tydic.se.manage.enums.OperModeEnum;
import com.tydic.se.manage.util.CommTools;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SearchConfigServiceImpl
implements SearchConfigService {
    private static final Logger log = LoggerFactory.getLogger(SearchConfigServiceImpl.class);
    @Autowired
    private CacheUpdateService cacheUpdateService;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private SearchConfigNewDao searchConfigNewDao;
    @Autowired
    private DwdSkuChannelMapper dwdSkuChannelMapper;
    @Autowired
    private OperLogService operLogService;
    @Value(value="${spring.datasource.driver-class-name}")
    private String driverName;

    public SearchConfigRsp queryOptimizeConfigList(SearchCommonReq reqBO) throws ZTBusinessException {
        SearchConfigRsp rspBO = new SearchConfigRsp();
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        ArrayList list = new ArrayList();
        try {
            String sql = "";
            sql = this.driverName.contains("dm") ? "SELECT CONF_NAME AS \"confName\", CONF_VALUE AS \"confValue\", CONF_REMARK AS \"confRemark\", CONF_TITLE AS \"confTitle\", VALUE_TYPE AS \"valueType\" FROM STAND_SE_OPTIMIZE_CONFIG" : "select conf_name as confName, conf_value as confValue, conf_remark as confRemark,conf_title as confTitle,value_type as valueType from stand_se_optimize_config";
            List avgPVrow = Db.use((String)"DATAPLAT").find(sql);
            if (avgPVrow != null && avgPVrow.size() > 0) {
                list.addAll(CommTools.getBeanList((List)avgPVrow, SearchConfigBO.class));
            }
        }
        catch (Exception e) {
            log.error("queryConfigList========>qry\u67e5\u8be2\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u67e5\u8be2\u5217\u8868\u5931\u8d25");
        }
        rspBO.setRows(list);
        return rspBO;
    }

    public void updateOptimizeConfig(SearchSortConfigReq reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        try {
            if (!StringUtils.isEmpty((CharSequence)reqBO.getSortConfList())) {
                List infoList = JSON.parseArray((String)reqBO.getSortConfList(), SearConfigBO.class);
                if (this.driverName.contains("dm")) {
                    for (SearConfigBO bo : infoList) {
                        Record record = new Record();
                        record.set("CONF_NAME", (Object)bo.getConfName());
                        record.set("CONF_VALUE", (Object)(bo.getConfValue() + ""));
                        record.set("UPDATE_TIME", (Object)new Date());
                        Db.use((String)"DATAPLAT").update("STAND_SE_OPTIMIZE_CONFIG", "CONF_NAME", record);
                    }
                } else {
                    for (SearConfigBO bo : infoList) {
                        Record record = new Record();
                        record.set("conf_name", (Object)bo.getConfName());
                        record.set("conf_value", (Object)(bo.getConfValue() + ""));
                        record.set("update_time", (Object)new Date());
                        Db.use((String)"DATAPLAT").update("stand_se_optimize_config", "conf_name", record);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u66f4\u65b0\u5931\u8d25");
        }
    }

    public Map<String, Object> getInitConfig() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String openShading = null;
        try {
            SearchConfigNew searchConfig;
            openShading = this.cacheClient.hget("{SEARCH}_CONFIG", "searchOpenShading");
            if (CommTools.strIsEmpty((String)openShading) && (searchConfig = this.searchConfigNewDao.queryByConfName("searchOpenShading".toLowerCase())) != null) {
                openShading = searchConfig.getConfValue();
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u641c\u7d22\u9875\u9762\u521d\u59cb\u5316\u914d\u7f6e\u5931\u8d25\uff0cerr:{}", (Object)e.getMessage());
        }
        if (CommTools.strIsEmpty((String)openShading)) {
            openShading = "0";
        }
        result.put("openShading", openShading);
        try {
            List channelRecordList = this.dwdSkuChannelMapper.queryAllChannels();
            if (channelRecordList != null && channelRecordList.size() > 0) {
                result.put("channelList", channelRecordList);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u641c\u7d22\u9875\u9762\u521d\u59cb\u5316\u914d\u7f6e\u5931\u8d25\uff0cerr:{}", (Object)e.getMessage());
        }
        return result;
    }

    public SearchAllConfigRspBO queryAllConfigList(SearchAllConfigReq reqBO) throws ZTBusinessException {
        SearchAllConfigRspBO rspBO = new SearchAllConfigRspBO();
        if (reqBO.getConfigType() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u5b8c\u6574");
        }
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        ArrayList<SearchAllConfig> rows = new ArrayList<SearchAllConfig>();
        try {
            List list = this.searchConfigNewDao.queryAllConfigList(reqBO.getConfigType(), reqBO.getSeChannelType());
            if (list != null && list.size() > 0) {
                for (SearchConfigNew config : list) {
                    if (config.getPId() != null) continue;
                    SearchAllConfig allConfig = new SearchAllConfig();
                    allConfig.setConfTitle(config.getConfTitle());
                    List<SearchAllConfig> children = this.findConfigChildren(config.getId(), list);
                    allConfig.setChildren(children);
                    rows.add(allConfig);
                }
            }
        }
        catch (Exception e) {
            log.error("queryAllConfigList========>qry\u67e5\u8be2\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u67e5\u8be2\u5217\u8868\u5931\u8d25");
        }
        rspBO.setRows(rows);
        return rspBO;
    }

    private List<SearchAllConfig> findConfigChildren(Integer id, List<SearchConfigNew> list) {
        ArrayList<SearchAllConfig> children = new ArrayList<SearchAllConfig>();
        if (list != null && list.size() > 0) {
            for (SearchConfigNew config : list) {
                if (!Objects.equals(config.getPId(), id)) continue;
                SearchAllConfig bo = new SearchAllConfig();
                bo.setConfTitle(config.getConfTitle());
                if (config.getIsLeaf() == 1) {
                    bo.setConfName(config.getConfName());
                    bo.setConfValue(config.getConfValue());
                    bo.setConfRemark(config.getConfRemark());
                    bo.setValueType(config.getValueType());
                    bo.setIsLeaf(config.getIsLeaf());
                    bo.setIsOpen(config.getIsOpen());
                    bo.setIsComplex(config.getIsComplex());
                    bo.setConfSort(config.getConfSort());
                }
                List<SearchAllConfig> childrens = this.findConfigChildren(config.getId(), list);
                bo.setChildren(childrens);
                children.add(bo);
            }
        }
        return children;
    }

    public void updateAllConfig(SearchSortConfigReq reqBO) throws ZTBusinessException {
        List infoList;
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        if (reqBO.getConfigType() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u5b8c\u6574");
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getSortConfList()) && (infoList = JSON.parseArray((String)reqBO.getSortConfList(), SortConfigBO.class)) != null && !infoList.isEmpty()) {
            infoList.forEach(bo -> {
                SearchConfigNew po = new SearchConfigNew();
                po.setConfName(bo.getConfName().trim());
                po.setIsOpen(bo.getIsOpen());
                if (!StringUtils.isEmpty((CharSequence)bo.getConfValue())) {
                    po.setConfValue(bo.getConfValue().trim());
                }
                po.setUpdateTime(new Date());
                po.setSeChannelType(reqBO.getSeChannelType());
                this.recordLog(reqBO, (SortConfigBO)bo);
                int result = this.searchConfigNewDao.updateByPrimaryKeySelective(po);
                if (result == 0) {
                    log.error("\u66f4\u65b0\u5931\u8d25: {}", (Object)po);
                    throw new ZTBusinessException("\u66f4\u65b0\u5931\u8d25: " + po.getConfName());
                }
            });
            this.cacheUpdateService.syncSearchConfig();
        }
    }

    public void addAutoConfig(SearchConfigNewBo reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        try {
            if (reqBO.getConfTitle() == null) {
                throw new ZTBusinessException("\u914d\u7f6e\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBO.getConfValue() == null) {
                throw new ZTBusinessException("\u914d\u7f6e\u9879\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBO.getConfName())) {
                Integer sort = this.searchConfigNewDao.selectConfigByPId(2);
                SearchConfigNew po = new SearchConfigNew();
                po.setPId(Integer.valueOf(2));
                po.setConfName("custom_config_" + sort);
                po.setConfValue(reqBO.getConfValue());
                po.setConfTitle(reqBO.getConfTitle());
                po.setConfRemark(reqBO.getConfRemark());
                po.setSType(Integer.valueOf(1));
                po.setValueType(Integer.valueOf(3));
                po.setIsLeaf(Integer.valueOf(1));
                po.setIsOpen(Integer.valueOf(0));
                po.setIsComplex(Integer.valueOf(3));
                po.setConfSort(sort);
                po.setCreateTime(new Date());
                po.setUpdateTime(new Date());
                this.searchConfigNewDao.insertSelective(po);
            } else {
                SearchConfigNew po = new SearchConfigNew();
                po.setConfName(reqBO.getConfName());
                po.setConfValue(reqBO.getConfValue());
                po.setConfTitle(reqBO.getConfTitle());
                po.setConfRemark(reqBO.getConfRemark());
                po.setUpdateTime(new Date());
                this.searchConfigNewDao.updateByConfName(po);
            }
            this.cacheUpdateService.syncSearchConfig();
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u65b0\u589e\u5931\u8d25");
        }
    }

    public void autoCompleteConfig() {
        List searchConfigNews = this.searchConfigNewDao.queryAllConfig();
        try {
            String jsonPath = "service-boot/src/main/resources/basic/config-field-sql.json";
            String jsonContent = new String(Files.readAllBytes(Paths.get(jsonPath, new String[0])));
            JSONObject jsonObject = JSON.parseObject((String)jsonContent);
            HashMap configFieldMap = new HashMap();
            for (String key : jsonObject.keySet()) {
                JSONArray jsonArray = jsonObject.getJSONArray(key);
                ArrayList<String> sqlList = new ArrayList<String>();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    sqlList.add(jsonArray.getString(i));
                }
                configFieldMap.put(key, sqlList);
            }
            HashSet<String> existingConfNames = new HashSet<String>();
            HashSet<Integer> existingIds = new HashSet<Integer>();
            for (SearchConfigNew config : searchConfigNews) {
                if (config.getConfName() != null) {
                    existingConfNames.add(config.getConfName());
                }
                existingIds.add(config.getId());
            }
            ArrayList<String> sqlToExecute = new ArrayList<String>();
            Pattern idPattern = Pattern.compile("VALUES\\s*\\(\\s*(\\d+),", 2);
            for (Map.Entry entry : configFieldMap.entrySet()) {
                String confName = (String)entry.getKey();
                List sqlList = (List)entry.getValue();
                if (existingConfNames.contains(confName)) continue;
                for (String sql : sqlList) {
                    Integer id;
                    Matcher matcher = idPattern.matcher(sql);
                    if (!matcher.find() || existingIds.contains(id = Integer.valueOf(matcher.group(1)))) continue;
                    sqlToExecute.add(sql);
                    existingIds.add(id);
                }
            }
            for (String targetSql : sqlToExecute) {
                if (this.driverName.contains("dm") && !targetSql.toUpperCase().contains("DYC_UCC")) {
                    targetSql = targetSql.replace("INSERT INTO stand_se_config_new", "INSERT INTO STAND_SE_CONFIG_NEW").replace("(id, p_id, conf_name, conf_value, conf_title, conf_remark, s_type, value_type, is_leaf, is_open, is_complex, conf_sort, create_time, update_time)", "(ID, P_ID, CONF_NAME, CONF_VALUE, CONF_TITLE, CONF_REMARK, S_TYPE, VALUE_TYPE, IS_LEAF, IS_OPEN, IS_COMPLEX, CONF_SORT, CREATE_TIME, UPDATE_TIME)").replace("'null'", "NULL").replace(" null", " NULL").replace("TO_TIMESTAMP", "TO_TIMESTAMP");
                    Pattern timePattern = Pattern.compile("'(\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2})'");
                    Matcher timeMatcher = timePattern.matcher(targetSql);
                    if (timeMatcher.find()) {
                        targetSql = timeMatcher.replaceAll("TO_TIMESTAMP('$1', 'YYYY-MM-DD HH24:MI:SS')");
                    }
                }
                this.searchConfigNewDao.executeSql(targetSql);
                log.info("\u6267\u884c\u8865\u5145\u914d\u7f6eSQL: {}", (Object)targetSql);
            }
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u5931\u8d25: {}", (Object)e.getMessage());
        }
        catch (NumberFormatException e) {
            log.error("\u89e3\u6790SQL ID\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }

    private void recordLog(SearchSortConfigReq reqBO, SortConfigBO bo) {
        try {
            SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
            logReqBO.setOperType("U");
            SearchConfigNew searchConfig = new SearchConfigNew();
            searchConfig.setSType(reqBO.getConfigType());
            searchConfig.setConfName(bo.getConfName());
            SearchConfigNew po = this.searchConfigNewDao.selectByNameAndType(searchConfig);
            if (reqBO.getConfigType() == 0) {
                logReqBO.setOperMode(OperModeEnum.recallPolicyConfig.getDesc());
                logReqBO.setOperContent("\u4fee\u6539\u53ec\u56de\u7b56\u7565:[" + po.getConfTitle() + "],\u4fee\u6539\u524d\u503c:[" + po.getConfValue() + "],\u4fee\u6539\u540e\u503c:[" + bo.getConfValue() + "]");
            } else {
                logReqBO.setOperMode(OperModeEnum.sortPolicyConfig.getDesc());
                if (po.getIsComplex() != 0) {
                    logReqBO.setOperContent("\u4fee\u6539\u6392\u5e8f\u7b56\u7565:[" + po.getConfTitle() + "],\u4fee\u6539\u524d\u503c:[" + po.getConfValue() + "]-[" + po.getIsOpen() + "],\u4fee\u6539\u540e\u503c:[" + bo.getConfValue() + "]-[" + bo.getIsOpen() + "]");
                } else {
                    logReqBO.setOperContent("\u4fee\u6539\u6392\u5e8f\u7b56\u7565:[" + po.getConfTitle() + "],\u4fee\u6539\u524d\u503c:[" + po.getConfValue() + "],\u4fee\u6539\u540e\u503c:[" + bo.getConfValue() + "]");
                }
            }
            this.operLogService.insertOperLog(logReqBO);
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
        }
    }
}

