/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.se.base.SeBusinessException;
import com.tydic.se.base.ability.bo.EntityCacheEnumBO;
import com.tydic.se.base.ability.bo.QueryCacheEnumRspBO;
import com.tydic.se.base.dao.StandSeEntityCacheMapper;
import com.tydic.se.base.dao.po.StandSeEntityCachePo;
import com.tydic.se.manage.api.SearchEntityCacheService;
import com.tydic.se.manage.bo.EntityCacheReqBO;
import com.tydic.se.manage.bo.EntityCacheRspBO;
import com.tydic.se.manage.enums.CacheKeyDealEnum;
import com.tydic.se.manage.util.CodeUtil;
import com.tydic.se.search.job.SeEntityCache;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SearchEntityCacheServiceImpl
implements SearchEntityCacheService {
    private static final Logger log = LoggerFactory.getLogger(SearchEntityCacheServiceImpl.class);
    @Autowired
    private StandSeEntityCacheMapper standSeEntityCacheMapper;
    @Autowired
    private SeEntityCache seEntityCache;

    @Transactional
    public EntityCacheRspBO addEntityCache(EntityCacheReqBO reqBO) {
        EntityCacheRspBO rspBO = new EntityCacheRspBO();
        StandSeEntityCachePo standSeEntityCachePo = new StandSeEntityCachePo();
        BeanUtils.copyProperties((Object)reqBO, (Object)standSeEntityCachePo);
        standSeEntityCachePo.setEntityCacheId(Integer.valueOf(CodeUtil.generateIntKey()));
        standSeEntityCachePo.setStatus(Integer.valueOf(0));
        int result = this.standSeEntityCacheMapper.insert(standSeEntityCachePo);
        if (result != 1) {
            throw new SeBusinessException("\u65b0\u589e\u4fe1\u606f\u5931\u8d25\uff1a\u65b0\u589e\u4fe1\u606f\u5931\u8d25");
        }
        rspBO.setData(standSeEntityCachePo);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    @Transactional
    public EntityCacheRspBO updateEntityCache(EntityCacheReqBO reqBO) {
        EntityCacheRspBO rspBO = new EntityCacheRspBO();
        JSONObject seEntityCacheBO = new JSONObject();
        StandSeEntityCachePo standSeEntityCachePo = this.standSeEntityCacheMapper.selectByPrimaryKey(reqBO.getEntityCacheId());
        if (standSeEntityCachePo == null) {
            throw new SeBusinessException("\u5b9e\u4f53\u7f13\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        String searchFilterId = reqBO.getSearchFilterId() != null ? reqBO.getSearchFilterId() : standSeEntityCachePo.getSearchFilterId();
        BeanUtils.copyProperties((Object)reqBO, (Object)standSeEntityCachePo);
        int result = this.standSeEntityCacheMapper.updateByPrimaryKeySelective(standSeEntityCachePo);
        if (result != 1) {
            throw new SeBusinessException("\u4fee\u6539\u4fe1\u606f\u5931\u8d25\uff1a\u4fee\u6539\u4fe1\u606f\u5931\u8d25");
        }
        this.seEntityCache.initLoadEntityCache(searchFilterId, seEntityCacheBO);
        rspBO.setData(standSeEntityCachePo);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    public RspPage<StandSeEntityCachePo> selectEntityCacheList(EntityCacheReqBO reqBO) {
        if (reqBO.getPageNo() < 1) {
            reqBO.setPageNo(1);
        }
        if (reqBO.getPageSize() < 1) {
            reqBO.setPageSize(10);
        }
        StandSeEntityCachePo standSeEntityCachePo = new StandSeEntityCachePo();
        BeanUtils.copyProperties((Object)reqBO, (Object)standSeEntityCachePo);
        Page page = PageMethod.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.standSeEntityCacheMapper.selectByCondition(standSeEntityCachePo));
        List resultList = page.getResult();
        RspPage rspPage = new RspPage();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(resultList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    public QueryCacheEnumRspBO queryCacheEnum() {
        QueryCacheEnumRspBO rspBO = new QueryCacheEnumRspBO();
        rspBO.setCacheKeyDeal(Arrays.stream(CacheKeyDealEnum.values()).map(enumItem -> new EntityCacheEnumBO(enumItem.getCode(), enumItem.getDescription())).collect(Collectors.toList()));
        return rspBO;
    }
}

