/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.se.base.SeBusinessException;
import com.tydic.se.base.ability.bo.EntityCacheEnumBO;
import com.tydic.se.base.ability.bo.QueryCacheEnumRspBO;
import com.tydic.se.base.dao.EsFiledObjConfigMapper;
import com.tydic.se.base.dao.po.EsFiledObjConfigPo;
import com.tydic.se.manage.api.SearchEsFiledObjService;
import com.tydic.se.manage.bo.EsFiledObjConfigDelReqBO;
import com.tydic.se.manage.bo.EsFiledObjConfigReqBO;
import com.tydic.se.manage.bo.EsFiledObjConfigRspBO;
import com.tydic.se.manage.enums.EsObjFiledDealEnum;
import com.tydic.se.manage.util.CodeUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SearchEsFiledObjServiceImpl
implements SearchEsFiledObjService {
    private static final Logger log = LoggerFactory.getLogger(SearchEsFiledObjServiceImpl.class);
    @Autowired
    private EsFiledObjConfigMapper esFiledObjConfigMapper;

    public RspPage<EsFiledObjConfigPo> queryEsFiledObjConfigList(EsFiledObjConfigReqBO reqBO) {
        if (reqBO.getPageNo() < 1) {
            reqBO.setPageNo(1);
        }
        if (reqBO.getPageSize() < 1) {
            reqBO.setPageSize(10);
        }
        EsFiledObjConfigPo queryPo = new EsFiledObjConfigPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)queryPo);
        Page page = PageMethod.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.esFiledObjConfigMapper.selectByCondition(queryPo));
        List resultList = page.getResult();
        RspPage rspPage = new RspPage();
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(resultList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        return rspPage;
    }

    public EsFiledObjConfigPo queryEsFiledObjConfigById(EsFiledObjConfigReqBO reqBO) {
        if (reqBO.getId() == null) {
            throw new IllegalArgumentException("ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            EsFiledObjConfigPo po = this.esFiledObjConfigMapper.selectByPrimaryKey(reqBO.getId());
            if (po == null) {
                return null;
            }
            return po;
        }
        catch (Exception e) {
            throw new SeBusinessException("\u6839\u636eID\u67e5\u8be2ES\u5b57\u6bb5\u5bf9\u8c61\u914d\u7f6e\u8be6\u60c5\u5931\u8d25");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public EsFiledObjConfigRspBO addEsFiledObjConfig(EsFiledObjConfigReqBO reqBO) {
        int result;
        EsFiledObjConfigRspBO rspBO = new EsFiledObjConfigRspBO();
        if (reqBO == null) {
            throw new IllegalArgumentException("\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        EsFiledObjConfigPo esFiledObjConfigPo = new EsFiledObjConfigPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)esFiledObjConfigPo);
        esFiledObjConfigPo.setId(Integer.valueOf(CodeUtil.generateIntKey()));
        if (esFiledObjConfigPo.getStatus() == null) {
            esFiledObjConfigPo.setStatus(Integer.valueOf(0));
        }
        if ((result = this.esFiledObjConfigMapper.insert(esFiledObjConfigPo)) != 1) {
            throw new SeBusinessException("\u65b0\u589e\u4fe1\u606f\u5931\u8d25\uff1a\u65b0\u589e\u4fe1\u606f\u5931\u8d25");
        }
        rspBO.setData(esFiledObjConfigPo);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    @Transactional(rollbackFor={Exception.class})
    public EsFiledObjConfigRspBO updateEsFiledObjConfig(EsFiledObjConfigReqBO reqBO) {
        EsFiledObjConfigRspBO rspBO = new EsFiledObjConfigRspBO();
        if (reqBO == null || reqBO.getId() == null) {
            throw new IllegalArgumentException("\u914d\u7f6e\u4fe1\u606f\u6216id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        EsFiledObjConfigPo po = new EsFiledObjConfigPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        int result = this.esFiledObjConfigMapper.updateByPrimaryKeySelective(po);
        if (result != 1) {
            throw new SeBusinessException("\u66f4\u65b0\u4fe1\u606f\u5931\u8d25\uff1a\u66f4\u65b0\u4fe1\u606f\u5931\u8d25");
        }
        rspBO.setData(po);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean deleteEsFiledObjConfigById(EsFiledObjConfigReqBO reqBO) {
        if (reqBO.getId() == null) {
            throw new IllegalArgumentException("ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            int result = this.esFiledObjConfigMapper.deleteByPrimaryKey(reqBO.getId());
            return result > 0;
        }
        catch (Exception e) {
            throw new SeBusinessException("\u6839\u636eID\u5220\u9664ES\u5b57\u6bb5\u5bf9\u8c61\u914d\u7f6e\u5931\u8d25");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean deleteEsFiledObjConfigByIds(EsFiledObjConfigDelReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getIds())) {
            throw new IllegalArgumentException("ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            int result = this.esFiledObjConfigMapper.deleteByIds(reqBO.getIds());
            return result > 0;
        }
        catch (Exception e) {
            throw new SeBusinessException("\u6279\u91cf\u5220\u9664ES\u5b57\u6bb5\u5bf9\u8c61\u914d\u7f6e\u5931\u8d25");
        }
    }

    public QueryCacheEnumRspBO queryEnum() {
        QueryCacheEnumRspBO rspBO = new QueryCacheEnumRspBO();
        rspBO.setCacheKeyDeal(Arrays.stream(EsObjFiledDealEnum.values()).map(enumItem -> new EntityCacheEnumBO(enumItem.getCode(), enumItem.getDescription())).collect(Collectors.toList()));
        return rspBO;
    }
}

