/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.se.manage.api.CacheUpdateService;
import com.tydic.se.manage.api.SearchFourCatalogService;
import com.tydic.se.manage.bo.AddCatalogInfoReqBO;
import com.tydic.se.manage.bo.AddCatalogTreeBO;
import com.tydic.se.manage.bo.CatalogTreeBO;
import com.tydic.se.manage.bo.ChangeCatalogOrderReqBO;
import com.tydic.se.manage.bo.ChangeCatalogStatusReqBO;
import com.tydic.se.manage.bo.QryAddCatalogListRspBO;
import com.tydic.se.manage.bo.QryCatalogListReqBO;
import com.tydic.se.manage.bo.QryCatalogListRspBO;
import com.tydic.se.manage.bo.UpdateCatalogInfoReqBO;
import com.tydic.se.manage.constants.Constants;
import com.tydic.se.manage.dao.SearchCatalogRecordMapper;
import com.tydic.se.manage.dao.SearchExtCatalogConfigRecordDao;
import com.tydic.se.manage.dao.po.SearchCatalogRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.CollectionUtils;

@Service
public class SearchFourCatalogServiceImpl
implements SearchFourCatalogService {
    private static final Logger log = LoggerFactory.getLogger(SearchFourCatalogServiceImpl.class);
    @Autowired
    private SearchCatalogRecordMapper searchCatalogRecordDao;
    @Autowired
    private SearchExtCatalogConfigRecordDao extCatalogConfigRecordDao;
    @Autowired
    private CacheUpdateService cacheUpdateService;

    public QryCatalogListRspBO queryCatalogList(QryCatalogListReqBO reqBO) throws ZTBusinessException {
        List catalogRecordPOList;
        QryCatalogListRspBO rspBO = new QryCatalogListRspBO();
        ArrayList<CatalogTreeBO> retList = new ArrayList<CatalogTreeBO>();
        List allCataLogList = this.searchCatalogRecordDao.selectAllCatalogData(null);
        if (allCataLogList != null && allCataLogList.size() > 0 && (catalogRecordPOList = allCataLogList.stream().filter(catalog -> catalog.getPCId().equals("-1")).collect(Collectors.toList())) != null && catalogRecordPOList.size() > 0) {
            Integer len = catalogRecordPOList.size();
            Integer maxOrder = ((SearchCatalogRecord)catalogRecordPOList.get(len - 1)).getOrder();
            Integer minOrder = ((SearchCatalogRecord)catalogRecordPOList.get(0)).getOrder();
            for (SearchCatalogRecord parent : catalogRecordPOList) {
                CatalogTreeBO rsp = new CatalogTreeBO();
                rsp.setKey(parent.getCId() + "");
                rsp.setCategoryCode(parent.getCId());
                rsp.setCategoryName(parent.getCName());
                rsp.setOrder(parent.getOrder());
                rsp.setCLevel(parent.getCLevel());
                rsp.setUpdateTime(parent.getUpdateTime());
                rsp.setCStatus(parent.getCStatus());
                rsp.setCDesc(parent.getCDesc());
                rsp.setPrentName("");
                rsp.setPrentId("-1");
                Integer order = rsp.getOrder();
                if (len == 1) {
                    rsp.setIsUp(Boolean.valueOf(false));
                    rsp.setIsDown(Boolean.valueOf(false));
                } else if (len > 1 && order == maxOrder) {
                    rsp.setIsUp(Boolean.valueOf(true));
                    rsp.setIsDown(Boolean.valueOf(false));
                } else if (len > 1 && order == minOrder) {
                    rsp.setIsUp(Boolean.valueOf(false));
                    rsp.setIsDown(Boolean.valueOf(true));
                } else {
                    rsp.setIsUp(Boolean.valueOf(true));
                    rsp.setIsDown(Boolean.valueOf(true));
                }
                List<CatalogTreeBO> filed = this.findChildren(parent.getCId(), parent.getCName(), allCataLogList);
                rsp.setChildren(filed);
                retList.add(rsp);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getCName())) {
            this.treeMatchName(retList, reqBO.getCName());
        }
        if (reqBO.getCStatus() != null) {
            this.treeMatchStatus(retList, reqBO.getCStatus());
        }
        log.debug("\u76ee\u5f55tree" + retList);
        rspBO.setRows(retList);
        return rspBO;
    }

    private List<CatalogTreeBO> findChildren(String cId, String cPName, List<SearchCatalogRecord> cataLogList) {
        List catalogRecordPOList;
        ArrayList<CatalogTreeBO> retList = new ArrayList<CatalogTreeBO>();
        if (cataLogList != null && cataLogList.size() > 0 && (catalogRecordPOList = cataLogList.stream().filter(catalog -> catalog.getPCId().equals(cId)).collect(Collectors.toList())) != null && catalogRecordPOList.size() > 0) {
            Integer len = catalogRecordPOList.size();
            Integer maxOrder = ((SearchCatalogRecord)catalogRecordPOList.get(len - 1)).getOrder();
            Integer minOrder = ((SearchCatalogRecord)catalogRecordPOList.get(0)).getOrder();
            for (SearchCatalogRecord parent : catalogRecordPOList) {
                CatalogTreeBO rsp = new CatalogTreeBO();
                rsp.setKey(parent.getCId() + "");
                rsp.setCategoryCode(parent.getCId() + "");
                rsp.setCategoryName(parent.getCName());
                rsp.setOrder(parent.getOrder());
                rsp.setCLevel(parent.getCLevel());
                rsp.setUpdateTime(parent.getUpdateTime());
                rsp.setCStatus(parent.getCStatus());
                rsp.setCDesc(parent.getCDesc());
                rsp.setPrentName(cPName);
                rsp.setPrentId(cId);
                Integer order = rsp.getOrder();
                if (len == 1) {
                    rsp.setIsUp(Boolean.valueOf(false));
                    rsp.setIsDown(Boolean.valueOf(false));
                } else if (len > 1 && order == maxOrder) {
                    rsp.setIsUp(Boolean.valueOf(true));
                    rsp.setIsDown(Boolean.valueOf(false));
                } else if (len > 1 && order == minOrder) {
                    rsp.setIsUp(Boolean.valueOf(false));
                    rsp.setIsDown(Boolean.valueOf(true));
                } else {
                    rsp.setIsUp(Boolean.valueOf(true));
                    rsp.setIsDown(Boolean.valueOf(true));
                }
                List<CatalogTreeBO> filed = this.findChildren(parent.getCId(), parent.getCName(), cataLogList);
                rsp.setChildren(filed);
                retList.add(rsp);
            }
        }
        return retList;
    }

    public void treeMatchName(List<CatalogTreeBO> anyLevelCategoryList, String keyword) {
        Iterator<CatalogTreeBO> iter = anyLevelCategoryList.iterator();
        while (iter.hasNext()) {
            CatalogTreeBO category = iter.next();
            if (category.getCategoryName().contains(keyword)) continue;
            List childrenCategoryList = category.getChildren();
            if (!CollectionUtils.isEmpty((Collection)childrenCategoryList)) {
                this.treeMatchName(childrenCategoryList, keyword);
            }
            if (!CollectionUtils.isEmpty((Collection)category.getChildren())) continue;
            iter.remove();
        }
    }

    public void treeMatchStatus(List<CatalogTreeBO> anyLevelCategoryList, Integer status) {
        Iterator<CatalogTreeBO> iter = anyLevelCategoryList.iterator();
        while (iter.hasNext()) {
            CatalogTreeBO category = iter.next();
            if (category.getCStatus() == status) continue;
            List childrenCategoryList = category.getChildren();
            if (!CollectionUtils.isEmpty((Collection)childrenCategoryList)) {
                this.treeMatchStatus(childrenCategoryList, status);
            }
            if (!CollectionUtils.isEmpty((Collection)category.getChildren())) continue;
            iter.remove();
        }
    }

    public void changeCatalogOrderDown(ChangeCatalogOrderReqBO changeMenuOrderReqBO) throws ZTBusinessException {
        try {
            SearchCatalogRecord cPO = this.searchCatalogRecordDao.selectByPrimaryKey(changeMenuOrderReqBO.getCatalogId());
            SearchCatalogRecord downPO = this.searchCatalogRecordDao.selectDownOrderCatalog(cPO.getPCId(), cPO.getOrder());
            if (downPO != null) {
                SearchCatalogRecord rec = new SearchCatalogRecord();
                rec.setCId(cPO.getCId());
                rec.setOrder(downPO.getOrder());
                this.searchCatalogRecordDao.updateOrderByPrimaryKey(rec);
                SearchCatalogRecord rec2 = new SearchCatalogRecord();
                rec2.setCId(downPO.getCId());
                rec2.setOrder(cPO.getOrder());
                this.searchCatalogRecordDao.updateOrderByPrimaryKey(rec2);
            }
        }
        catch (Exception e) {
            log.error(" \u4e0b\u79fb\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u4e0b\u79fb\u5931\u8d25");
        }
    }

    public void changeCatalogOrderUp(ChangeCatalogOrderReqBO changeMenuOrderReqBO) throws ZTBusinessException {
        try {
            SearchCatalogRecord cPO = this.searchCatalogRecordDao.selectByPrimaryKey(changeMenuOrderReqBO.getCatalogId());
            SearchCatalogRecord upPO = this.searchCatalogRecordDao.selectUpOrderCatalog(cPO.getPCId(), cPO.getOrder());
            if (upPO != null) {
                SearchCatalogRecord rec = new SearchCatalogRecord();
                rec.setCId(cPO.getCId());
                rec.setOrder(upPO.getOrder());
                this.searchCatalogRecordDao.updateOrderByPrimaryKey(rec);
                SearchCatalogRecord rec2 = new SearchCatalogRecord();
                rec2.setCId(upPO.getCId());
                rec2.setOrder(cPO.getOrder());
                this.searchCatalogRecordDao.updateOrderByPrimaryKey(rec2);
            }
        }
        catch (Exception e) {
            log.error("\u4e0a\u79fb\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u4e0a\u79fb\u5931\u8d25");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteCatalog(ChangeCatalogOrderReqBO changeMenuOrderReqBO) throws ZTBusinessException {
        SearchCatalogRecord isExist = this.searchCatalogRecordDao.selectByPrimaryKey(changeMenuOrderReqBO.getCatalogId());
        if (isExist == null) {
            throw new ZTBusinessException("\u4e0d\u5b58\u5728\uff0c\u6570\u636e\u5f02\u5e38\uff01");
        }
        if (isExist.getCStatus() == 1) {
            throw new ZTBusinessException("\u542f\u7528\u72b6\u6001\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        List catalogs = this.searchCatalogRecordDao.selectCatalogData(changeMenuOrderReqBO.getCatalogId(), null);
        if (catalogs != null && catalogs.size() > 0) {
            throw new ZTBusinessException("\u8be5\u76ee\u5f55\u6709\u4e0b\u7ea7\u76ee\u5f55\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        List po = this.extCatalogConfigRecordDao.selectByCId(changeMenuOrderReqBO.getCatalogId());
        if (po != null && po.size() > 0) {
            throw new ZTBusinessException("\u8be5\u76ee\u5f55\u5df2\u7ed1\u5b9a\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        try {
            SearchCatalogRecord subPO = this.searchCatalogRecordDao.selectByPrimaryKey(changeMenuOrderReqBO.getCatalogId());
            this.searchCatalogRecordDao.deleteByPrimaryKey(changeMenuOrderReqBO.getCatalogId());
            if (subPO.getCLevel() == 4) {
                this.cacheUpdateService.deleteFourCatalog(subPO.getCName());
            }
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u5220\u9664\u5931\u8d25");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateByCatalogId(UpdateCatalogInfoReqBO updateByMenuIdReqBO) {
        try {
            SearchCatalogRecord po = new SearchCatalogRecord();
            BeanUtils.copyProperties((Object)updateByMenuIdReqBO, (Object)po);
            po.setUpdateTime(new Date());
            this.searchCatalogRecordDao.updateByPrimaryKeySelective(po);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u66f4\u65b0\u5931\u8d25");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void addCatalog(AddCatalogInfoReqBO addCatalogInfoReqBO) {
        if (StringUtils.isEmpty((CharSequence)addCatalogInfoReqBO.getCCode())) {
            throw new ZTBusinessException("\u7c7b\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SearchCatalogRecord namePO = this.searchCatalogRecordDao.selectByCName(addCatalogInfoReqBO.getCName(), addCatalogInfoReqBO.getPCId());
        String codePO = this.searchCatalogRecordDao.selectByCId(addCatalogInfoReqBO.getCCode());
        if (!StringUtils.isEmpty((CharSequence)codePO)) {
            throw new ZTBusinessException("\u7c7b\u76ee\u7f16\u7801\u5df2\u5b58\u5728");
        }
        if (namePO == null) {
            try {
                SearchCatalogRecord po = new SearchCatalogRecord();
                BeanUtils.copyProperties((Object)addCatalogInfoReqBO, (Object)po);
                po.setCId(addCatalogInfoReqBO.getCCode());
                po.setCStatus(Constants.WORDS_STATE_1);
                po.setPCId(addCatalogInfoReqBO.getPCId());
                po.setCreateTime(new Date());
                po.setUpdateTime(new Date());
                po.setCDesc(addCatalogInfoReqBO.getCDesc());
                this.searchCatalogRecordDao.insert(po);
            }
            catch (Exception e) {
                log.error("\u65b0\u589e\u5931\u8d25", (Throwable)e);
                throw new ZTBusinessException("\u65b0\u589e\u5931\u8d25");
            }
        } else {
            throw new ZTBusinessException("\u7c7b\u76ee\u540d\u79f0\u5df2\u5b58\u5728");
        }
    }

    @Transactional
    public void changeCatalogStatus(ChangeCatalogStatusReqBO reqBO) {
        try {
            this.searchCatalogRecordDao.changeFourCatalogStatus(reqBO.getCId(), reqBO.getCStatus());
            SearchCatalogRecord parent = this.searchCatalogRecordDao.selectByPrimaryKey(reqBO.getCId());
            Integer startStatus = reqBO.getCStatus();
            Integer upStatus = null;
            upStatus = reqBO.getCStatus() == 0 ? Integer.valueOf(1) : Integer.valueOf(0);
            if (parent.getCLevel() != 4) {
                this.findChildrenStatus(reqBO.getCId(), startStatus, upStatus, parent.getCLevel());
            } else if (startStatus == 0) {
                this.cacheUpdateService.deleteFourCatalog(parent.getCName());
            } else {
                this.cacheUpdateService.linkFourCatalog(parent.getCName());
            }
        }
        catch (Exception e) {
            log.error("\u5207\u6362\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u5207\u6362\u5931\u8d25");
        }
    }

    private void findChildrenStatus(String cId, final Integer startStatus, Integer upStatus, Integer cLevel) {
        List cataLogList = this.searchCatalogRecordDao.selectCatalogData(cId, upStatus);
        if (cataLogList != null && cataLogList.size() > 0) {
            this.searchCatalogRecordDao.updateByCaralogIdList(cataLogList, startStatus);
            if (cLevel == 3) {
                List nameLsit = cataLogList.stream().map(SearchCatalogRecord::getCName).collect(Collectors.toList());
                final HashSet nameSet = new HashSet();
                nameSet.addAll(nameLsit);
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                    public void afterCommit() {
                        if (startStatus == 0) {
                            SearchFourCatalogServiceImpl.this.cacheUpdateService.bathDeleteFourCatalog(nameSet);
                        } else {
                            SearchFourCatalogServiceImpl.this.cacheUpdateService.bathLinkFourCatalog(nameSet);
                        }
                    }
                });
            }
            for (SearchCatalogRecord parent : cataLogList) {
                if (parent.getCLevel() >= 4) continue;
                this.findChildrenStatus(parent.getCId(), startStatus, upStatus, parent.getCLevel());
            }
        }
    }

    public QryAddCatalogListRspBO queryAddCatalogList(QryCatalogListReqBO reqBO) {
        QryAddCatalogListRspBO rspBO = new QryAddCatalogListRspBO();
        ArrayList<AddCatalogTreeBO> retList = new ArrayList<AddCatalogTreeBO>();
        List firstCataLogList = this.searchCatalogRecordDao.selectCatalogData("-1", Integer.valueOf(1));
        if (firstCataLogList != null && firstCataLogList.size() > 0) {
            for (SearchCatalogRecord parent : firstCataLogList) {
                AddCatalogTreeBO rsp = new AddCatalogTreeBO();
                rsp.setKey(parent.getCId() + "");
                rsp.setValue(parent.getCId() + "");
                rsp.setTitle(parent.getCName());
                rsp.setOrder(parent.getOrder());
                rsp.setCLevel(parent.getCLevel());
                List<AddCatalogTreeBO> filed = this.findAddChildren(String.valueOf(parent.getCId()), reqBO);
                rsp.setChildren(filed);
                retList.add(rsp);
            }
        }
        log.info("\u76ee\u5f55tree" + retList);
        rspBO.setRows(retList);
        return rspBO;
    }

    private List<AddCatalogTreeBO> findAddChildren(String cId, QryCatalogListReqBO reqBO) {
        ArrayList<AddCatalogTreeBO> retList = new ArrayList<AddCatalogTreeBO>();
        List firstCataLogList = this.searchCatalogRecordDao.selectCatalogData(cId, Integer.valueOf(1));
        if (firstCataLogList != null && firstCataLogList.size() > 0) {
            for (SearchCatalogRecord parent : firstCataLogList) {
                AddCatalogTreeBO rsp = new AddCatalogTreeBO();
                rsp.setKey(parent.getCId() + "");
                rsp.setValue(parent.getCId() + "");
                rsp.setTitle(parent.getCName());
                rsp.setOrder(parent.getOrder());
                rsp.setCLevel(parent.getCLevel());
                if (parent.getCLevel() < 3) {
                    List<AddCatalogTreeBO> filed = this.findAddChildren(parent.getCId() + "", reqBO);
                    rsp.setChildren(filed);
                }
                retList.add(rsp);
            }
        }
        return retList;
    }
}

