/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.manage.api.CacheUpdateService;
import com.tydic.se.manage.api.SearchFrequentUsedWordsService;
import com.tydic.se.manage.bo.ExportInfoRspBO;
import com.tydic.se.manage.bo.ImportFrequentUsedWordsRspBO;
import com.tydic.se.manage.bo.SearchFrequentUsedWordsBO;
import com.tydic.se.manage.bo.SearchFrequentUsedWordsReqBO;
import com.tydic.se.manage.bo.SearchFrequentUsedWordsRspBO;
import com.tydic.se.manage.bo.TableHeadInfo;
import com.tydic.se.manage.constants.Constants;
import com.tydic.se.manage.constants.JedisHelper;
import com.tydic.se.manage.constants.XlsUtil;
import com.tydic.se.manage.dao.SearchFrequentUsedWordsMapper;
import com.tydic.se.manage.dao.SearchFrequentUsedWordsTypeMapper;
import com.tydic.se.manage.dao.po.SearchFrequentUsedWordsPO;
import com.tydic.se.manage.dao.po.SearchFrequentUsedWordsTypePO;
import com.tydic.se.manage.util.CodeUtil;
import com.tydic.se.manage.util.CommTools;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class SearchFrequentUsedWordsServiceImpl
implements SearchFrequentUsedWordsService {
    private static final Logger log = LoggerFactory.getLogger(SearchFrequentUsedWordsServiceImpl.class);
    @Autowired
    private SearchFrequentUsedWordsMapper searchFrequentUsedWordsMapper;
    @Autowired
    private SearchFrequentUsedWordsTypeMapper searchFrequentUsedWordsTypeMapper;
    @Autowired
    private CacheUpdateService cacheUpdateService;
    @Autowired
    private CacheClient cacheClient;

    public SearchFrequentUsedWordsRspBO queryFrequentUsedWordsList(SearchFrequentUsedWordsReqBO reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize());
        SearchFrequentUsedWordsRspBO rspBO = new SearchFrequentUsedWordsRspBO();
        List list = new ArrayList();
        try {
            list = this.searchFrequentUsedWordsMapper.querySearchFrequentUsedWordsList(reqBO);
        }
        catch (Exception e) {
            log.error("queryFrequentUsedWordsList========>qry\u67e5\u8be2\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u67e5\u8be2\u5217\u8868\u5931\u8d25");
        }
        PageInfo pageInfo = new PageInfo(list);
        rspBO.setRows(list);
        rspBO.setPageNo(reqBO.getPageNo().intValue());
        rspBO.setRecordsTotal((int)pageInfo.getTotal());
        rspBO.setTotal(pageInfo.getPages());
        return rspBO;
    }

    public SearchFrequentUsedWordsRspBO queryFrequentUsedWordsDetail(SearchFrequentUsedWordsReqBO reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        return null;
    }

    public void addFrequentUsedWordsInfo(SearchFrequentUsedWordsReqBO reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        this.validateParam(reqBO);
        List check = this.searchFrequentUsedWordsMapper.selectCheck(reqBO.getFWord());
        if (check != null && check.size() > 0) {
            for (SearchFrequentUsedWordsPO po : check) {
                if (po.getTypeId() == null && reqBO.getTypeId() == null) {
                    throw new ZTBusinessException("\u9891\u7528\u8bcd\u540d\u79f0\u548c\u54c1\u724c\u91cd\u590d\uff01");
                }
                if (po.getTypeId() == null || reqBO.getTypeId() == null || !po.getTypeId().equals(reqBO.getTypeId())) continue;
                throw new ZTBusinessException("\u9891\u7528\u8bcd\u540d\u79f0\u548c\u54c1\u724c\u91cd\u590d\uff01");
            }
        }
        SearchFrequentUsedWordsPO searchFrequentUsedWordsPO = new SearchFrequentUsedWordsPO();
        searchFrequentUsedWordsPO.setId(CodeUtil.generateTableCode());
        searchFrequentUsedWordsPO.setfWord(reqBO.getFWord());
        searchFrequentUsedWordsPO.setTypeId(reqBO.getTypeId());
        searchFrequentUsedWordsPO.setfStatus(Constants.WORDS_STATE_1);
        searchFrequentUsedWordsPO.setCreateTime(new Date());
        searchFrequentUsedWordsPO.setUpdateTime(new Date());
        this.searchFrequentUsedWordsMapper.insertSelective(searchFrequentUsedWordsPO);
        this.cacheUpdateService.addTypeFrequent(reqBO.getFWord());
    }

    public void updateFrequentUsedWordsInfo(SearchFrequentUsedWordsReqBO reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        if (reqBO.getId() == null || reqBO.getFStatus() == null) {
            throw new ZTBusinessException("\u53c2\u6570\u5f02\u5e38\uff01");
        }
        if (reqBO.getFStatus() == Constants.WORDS_STATE_1) {
            throw new ZTBusinessException("\u542f\u7528\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\uff01");
        }
        this.validateParam(reqBO);
        SearchFrequentUsedWordsPO isExist = this.searchFrequentUsedWordsMapper.selectByPrimaryKey(reqBO.getId());
        if (isExist == null) {
            throw new ZTBusinessException("\u9891\u7528\u8bcd\u4e0d\u5b58\u5728\uff0c\u6570\u636e\u5f02\u5e38\uff01");
        }
        List list = this.searchFrequentUsedWordsMapper.selectCheckForUpdate(reqBO.getFWord(), reqBO.getId());
        if (list != null && list.size() > 0) {
            throw new ZTBusinessException("\u9891\u7528\u8bcd\u540d\u79f0\u91cd\u590d\uff01");
        }
        SearchFrequentUsedWordsPO record = new SearchFrequentUsedWordsPO();
        record.setId(reqBO.getId());
        record.setfWord(reqBO.getFWord());
        record.setTypeId(reqBO.getTypeId());
        record.setUpdateTime(new Date());
        this.searchFrequentUsedWordsMapper.updateByPrimaryKeySelective(record);
    }

    public void updateFrequentUsedWordsStatus(SearchFrequentUsedWordsReqBO reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        if (reqBO.getId() == null || reqBO.getFStatus() == null) {
            throw new ZTBusinessException("\u53c2\u6570\u5f02\u5e38\uff01");
        }
        SearchFrequentUsedWordsPO isExist = this.searchFrequentUsedWordsMapper.selectByPrimaryKey(reqBO.getId());
        if (isExist == null) {
            throw new ZTBusinessException("\u9891\u7528\u8bcd\u4e0d\u5b58\u5728\uff0c\u6570\u636e\u5f02\u5e38\uff01");
        }
        SearchFrequentUsedWordsPO record = new SearchFrequentUsedWordsPO();
        record.setId(reqBO.getId());
        record.setfStatus(reqBO.getFStatus());
        record.setUpdateTime(new Date());
        this.searchFrequentUsedWordsMapper.updateStatus(record);
        if (reqBO.getFStatus() == Constants.WORDS_STATE_1) {
            this.cacheUpdateService.addTypeFrequent(isExist.getfWord());
        } else {
            this.cacheUpdateService.deleteTypeFrequent(isExist.getfWord());
        }
    }

    public void deleteFrequentUsedWordsInfo(SearchFrequentUsedWordsReqBO reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        if (reqBO.getId() == null || reqBO.getFStatus() == null) {
            throw new ZTBusinessException("\u53c2\u6570\u5f02\u5e38\uff01");
        }
        if (reqBO.getFStatus() == Constants.WORDS_STATE_1) {
            throw new ZTBusinessException("\u542f\u7528\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        SearchFrequentUsedWordsPO isExist = this.searchFrequentUsedWordsMapper.selectByPrimaryKey(reqBO.getId());
        if (isExist == null) {
            throw new ZTBusinessException("\u9891\u7528\u8bcd\u4e0d\u5b58\u5728\uff0c\u6570\u636e\u5f02\u5e38\uff01");
        }
        this.searchFrequentUsedWordsMapper.deleteByPrimaryKey(reqBO.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async(value="threadPoolTaskExecutor")
    public void importFrequentUsedWords(List<List<String>> list) throws ZTBusinessException {
        try {
            Constants.TaskStatus.typeFrequentImportStatus = true;
            this.cacheClient.delete(Constants.ImportRspKey.frequentUsedWords_lockKey_rspKey);
            ImportFrequentUsedWordsRspBO rspBo = new ImportFrequentUsedWordsRspBO();
            ArrayList<SearchFrequentUsedWordsBO> errList = new ArrayList<SearchFrequentUsedWordsBO>();
            Integer insertNums = list.size();
            Integer successNums = 0;
            Integer failNums = 0;
            int start = 0;
            int num = 0;
            Map tNameDataMap = this.searchFrequentUsedWordsTypeMapper.selectAllDataKeyTName();
            while (successNums + failNums < insertNums) {
                start = num;
                num = num + 1000 < insertNums ? num + 1000 : insertNums;
                List<List<String>> subList = list.subList(start, num);
                HashSet<String> importFWords = new HashSet<String>();
                ArrayList<SearchFrequentUsedWordsPO> updateList = new ArrayList<SearchFrequentUsedWordsPO>();
                ArrayList<SearchFrequentUsedWordsPO> addList = new ArrayList<SearchFrequentUsedWordsPO>();
                for (List<String> row : subList) {
                    if (row == null || row.size() <= 0 || CommTools.strIsEmpty((String)row.get(0))) continue;
                    importFWords.add(row.get(0).trim().toLowerCase());
                }
                List searchFrequentUsedWordsPOS = this.searchFrequentUsedWordsMapper.selectData(importFWords);
                HashMap map = new HashMap();
                if (searchFrequentUsedWordsPOS != null && searchFrequentUsedWordsPOS.size() > 0) {
                    searchFrequentUsedWordsPOS.forEach(searchFrequentUsedWordsPO -> {
                        if (map.get(searchFrequentUsedWordsPO.getfWord().trim().toLowerCase()) == null) {
                            map.put(searchFrequentUsedWordsPO.getfWord().trim().toLowerCase(), new ArrayList());
                        }
                        ((List)map.get(searchFrequentUsedWordsPO.getfWord().trim().toLowerCase())).add(searchFrequentUsedWordsPO);
                    });
                }
                for (List<String> row : subList) {
                    Integer indexField;
                    Integer tName;
                    try {
                        Integer n;
                        Integer typePO;
                        if (row == null || row.size() < 1 || CommTools.strIsEmpty((String)row.get(0))) {
                            throw new ZTBusinessException("\u9891\u7528\u8bcd\u4e3a\u7a7a\uff01");
                        }
                        String fWord = row.get(0);
                        tName = row.size() > 1 ? row.get(1) : null;
                        indexField = row.size() > 2 ? row.get(2) : null;
                        Boolean flag = true;
                        SearchFrequentUsedWordsPO updatePO = null;
                        List existsList = (List)map.get(fWord.trim().toLowerCase());
                        if (existsList != null && existsList.size() > 0) {
                            for (SearchFrequentUsedWordsPO po : existsList) {
                                Long typeId;
                                if (CommTools.strIsEmpty((String)((Object)tName))) {
                                    if (po.getfStatus() == 1) {
                                        throw new ZTBusinessException("\u9891\u7528\u8bcd\u5df2\u5b58\u5728\uff01|" + fWord + "||");
                                    }
                                    if (!flag.booleanValue() || updatePO != null) continue;
                                    updatePO = po;
                                    updatePO.setTypeId(null);
                                    updatePO.setfStatus(Integer.valueOf(1));
                                    flag = false;
                                    continue;
                                }
                                Long l = typeId = tNameDataMap.get(tName) == null ? null : ((SearchFrequentUsedWordsTypePO)tNameDataMap.get(tName)).getTypeId();
                                if (po.getfStatus() == 1 && po.getTypeId() != null && po.getTypeId().equals(typeId)) {
                                    throw new ZTBusinessException("\u9891\u7528\u8bcd\u5df2\u5b58\u5728\uff01|" + fWord + "|" + (String)((Object)tName) + "|" + ((SearchFrequentUsedWordsTypePO)tNameDataMap.get(tName)).getIndexField());
                                }
                                if (!flag.booleanValue() || po.getTypeId() != null && (po.getTypeId() == null || !po.getTypeId().equals(typeId) || po.getfStatus() != 0)) continue;
                                updatePO = po;
                                updatePO.setTypeId(null);
                                updatePO.setfStatus(Integer.valueOf(1));
                                flag = false;
                            }
                        }
                        if ((updatePO == null || flag.booleanValue()) && !flag.booleanValue()) continue;
                        if (!CommTools.strIsEmpty((String)((Object)tName)) && tNameDataMap.get(tName) == null) {
                            if (CommTools.strIsEmpty((String)((Object)indexField))) {
                                throw new ZTBusinessException("\u9891\u7528\u8bcd\u7c7b\u76ee\u4e0d\u5b58\u5728\uff0c\u4e14\u5bfc\u5165\u7d22\u5f15\u5b57\u6bb5\u4e3a\u7a7a\uff01|" + fWord + "|" + (String)((Object)tName) + "|" + ((SearchFrequentUsedWordsTypePO)tNameDataMap.get(tName)).getIndexField());
                            }
                            typePO = new SearchFrequentUsedWordsTypePO(CodeUtil.generateTableCode(), (String)((Object)tName), (String)((Object)indexField), Integer.valueOf(1), new Date(), new Date(), Float.valueOf(1.0f));
                            this.searchFrequentUsedWordsTypeMapper.insertSelective((SearchFrequentUsedWordsTypePO)typePO);
                            tNameDataMap.put(tName, typePO);
                        }
                        if (updatePO != null && !flag.booleanValue()) {
                            typePO = successNums;
                            n = successNums = Integer.valueOf(successNums + 1);
                            if (!CommTools.strIsEmpty((String)((Object)tName)) && updatePO.getTypeId() == null) {
                                updatePO.setTypeId(((SearchFrequentUsedWordsTypePO)tNameDataMap.get(tName)).getTypeId());
                            }
                            if (map.get(fWord.trim().toLowerCase()) == null) {
                                map.put(fWord.trim().toLowerCase(), new ArrayList());
                            }
                            ((List)map.get(fWord.trim().toLowerCase())).add(updatePO);
                            updateList.add(updatePO);
                            continue;
                        }
                        if (!flag.booleanValue()) continue;
                        typePO = successNums;
                        n = successNums = Integer.valueOf(successNums + 1);
                        SearchFrequentUsedWordsPO addPO = new SearchFrequentUsedWordsPO(CodeUtil.generateTableCode(), fWord.trim(), CommTools.strIsEmpty((String)((Object)tName)) ? null : ((SearchFrequentUsedWordsTypePO)tNameDataMap.get(tName)).getTypeId(), Integer.valueOf(1), new Date(), new Date());
                        if (map.get(fWord.trim().toLowerCase()) == null) {
                            map.put(fWord.trim().toLowerCase(), new ArrayList());
                        }
                        ((List)map.get(fWord.trim().toLowerCase())).add(addPO);
                        addList.add(addPO);
                    }
                    catch (Exception e) {
                        tName = failNums;
                        indexField = failNums = Integer.valueOf(failNums + 1);
                        SearchFrequentUsedWordsBO oBo = new SearchFrequentUsedWordsBO();
                        String[] err = e.getMessage() != null ? e.getMessage().split("\\|") : new String[]{};
                        oBo.setFailMsg("\u521b\u5efa\u9891\u7528\u8bcd\u4fe1\u606f\u5f02\u5e38\uff0crow\u6570\u636e\u4e3a\uff1a" + row == null ? null : row.toString() + ",\u5f02\u5e38\u539f\u56e0\uff1a" + err[0]);
                        if (err.length > 1) {
                            oBo.setFWord(err[1]);
                            if (err.length > 2) {
                                oBo.setTName(err[2]);
                                if (err.length == 4) {
                                    oBo.setIndexField(err[3]);
                                }
                            }
                        }
                        errList.add(oBo);
                    }
                }
                if (addList.size() > 0) {
                    this.searchFrequentUsedWordsMapper.batchInsert(addList);
                }
                if (updateList.size() > 0) {
                    this.searchFrequentUsedWordsMapper.batchUpdate(updateList);
                }
                rspBo.setInsertNums(insertNums.intValue());
                rspBo.setFailNums(failNums.intValue());
                rspBo.setSuccessNums(successNums.intValue());
                ArrayList<String> title = new ArrayList<String>();
                title.add("\u9891\u7528\u8bcd\u540d\u79f0");
                title.add("\u9891\u7528\u8bcd\u7c7b\u76ee\u540d\u79f0");
                title.add("\u7d22\u5f15\u5b57\u6bb5");
                title.add("\u5931\u8d25\u539f\u56e0");
                String[] variable = new String[]{"fWord", "tName", "indexField", "failMsg"};
                String jsonString = "";
                String titleString = "";
                if (errList.size() > 0) {
                    Object[][] data = XlsUtil.toArray(errList, (String[])variable);
                    jsonString = JSONObject.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
                    titleString = JSONObject.toJSONString(title, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
                }
                rspBo.setJsonString(jsonString);
                rspBo.setTitleString(titleString);
                ArrayList<TableHeadInfo> tableHeadInfos = new ArrayList<TableHeadInfo>();
                for (int i = 0; i < title.size(); ++i) {
                    TableHeadInfo tableHeadInfo1 = new TableHeadInfo();
                    tableHeadInfo1.setTitle((String)title.get(i));
                    tableHeadInfo1.setDataIndex(variable[i]);
                    tableHeadInfos.add(tableHeadInfo1);
                }
                rspBo.setTitleList(tableHeadInfos);
                rspBo.setFailList(errList);
                this.cacheClient.set(Constants.ImportRspKey.frequentUsedWords_lockKey_rspKey, (Object)rspBo);
            }
            if (successNums > 0) {
                this.cacheUpdateService.initSyncCache(Integer.valueOf(3));
            }
            log.info("\u9891\u7528\u8bcd\u5f02\u6b65\u5bfc\u5165\u7ed3\u675f");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Constants.TaskStatus.typeFrequentImportStatus = false;
            JedisHelper.releaseDistributedLock((CacheClient)this.cacheClient, (String)"import_frequent_used_words_lock", null);
        }
    }

    public ExportInfoRspBO exportFrequentUsedWords(SearchFrequentUsedWordsReqBO reqBO) throws ZTBusinessException {
        ExportInfoRspBO rspBO = new ExportInfoRspBO();
        List list = this.searchFrequentUsedWordsMapper.queryAllFrequentUsedWordsList();
        ArrayList data = new ArrayList();
        for (SearchFrequentUsedWordsBO bo : list) {
            ArrayList<String> subList = new ArrayList<String>();
            subList.add(bo.getFWord());
            subList.add(bo.getTName());
            subList.add(bo.getIndexField());
            data.add(subList);
        }
        String jsonString = JSONObject.toJSONString(data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        String zipString = XlsUtil.gzip((String)jsonString);
        rspBO.setJsonString(zipString);
        ArrayList<String> title = new ArrayList<String>();
        title.add("\u9891\u7528\u8bcd\u540d\u79f0");
        title.add("\u9891\u7528\u8bcd\u7c7b\u76ee\u540d\u79f0");
        title.add("\u7d22\u5f15\u5b57\u6bb5");
        String titleString = JSONObject.toJSONString(title, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        rspBO.setTitleString(titleString);
        return rspBO;
    }

    public List<String> exportFrequentUsedWords() throws ZTBusinessException {
        List list = this.searchFrequentUsedWordsMapper.queryAllFrequentUsedWordsList();
        ArrayList<String> data = new ArrayList<String>();
        for (SearchFrequentUsedWordsBO bo : list) {
            String subList = bo.getFWord();
            if (bo.getTName() != null) {
                subList = subList + "," + bo.getTName();
            }
            if (bo.getIndexField() != null) {
                subList = subList + "," + bo.getIndexField();
            }
            data.add(subList);
        }
        return data;
    }

    public List<String> querAllDsWordList() {
        List list = this.searchFrequentUsedWordsMapper.querAllDsWordList();
        List simWord = this.searchFrequentUsedWordsMapper.querSimWordWordList();
        for (String sim : simWord) {
            String[] words;
            for (String word : words = sim.split(",")) {
                list.add(word);
            }
        }
        return list;
    }

    private void validateParam(SearchFrequentUsedWordsReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getFWord())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u3010\u9891\u7528\u8bcd\u540d\u79f0\u3011\u4e3a\u7a7a");
        }
    }

    @PreDestroy
    public void onShutdown() {
        if (Constants.TaskStatus.typeFrequentImportStatus.booleanValue()) {
            JedisHelper.releaseDistributedLock((CacheClient)this.cacheClient, (String)"import_frequent_used_words_lock", null);
        }
    }
}

