/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.se.manage.api.CacheUpdateService;
import com.tydic.se.manage.api.SearchFrequentUsedWordsTypeService;
import com.tydic.se.manage.bo.ExportInfoRspBO;
import com.tydic.se.manage.bo.ImportFrequentUsedWordsTypeRspBO;
import com.tydic.se.manage.bo.SearchFrequentUsedWordsTypeBO;
import com.tydic.se.manage.bo.SearchFrequentUsedWordsTypeReqBO;
import com.tydic.se.manage.bo.SearchFrequentUsedWordsTypeRspBO;
import com.tydic.se.manage.bo.TableHeadInfo;
import com.tydic.se.manage.constants.Constants;
import com.tydic.se.manage.constants.XlsUtil;
import com.tydic.se.manage.dao.SearchFrequentUsedWordsMapper;
import com.tydic.se.manage.dao.SearchFrequentUsedWordsTypeMapper;
import com.tydic.se.manage.dao.po.SearchFrequentUsedWordsPO;
import com.tydic.se.manage.dao.po.SearchFrequentUsedWordsTypePO;
import com.tydic.se.manage.util.CodeUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class SearchFrequentUsedWordsTypeServiceImpl
implements SearchFrequentUsedWordsTypeService {
    private static final Logger log = LoggerFactory.getLogger(SearchFrequentUsedWordsTypeServiceImpl.class);
    @Autowired
    private SearchFrequentUsedWordsTypeMapper searchFrequentUsedWordsTypeMapper;
    @Autowired
    private SearchFrequentUsedWordsMapper searchFrequentUsedWordsMapper;
    @Autowired
    private CacheUpdateService cacheUpdateService;

    public SearchFrequentUsedWordsTypeRspBO queryFrequentUsedWordsTypeList(SearchFrequentUsedWordsTypeReqBO reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize());
        SearchFrequentUsedWordsTypeRspBO rspBO = new SearchFrequentUsedWordsTypeRspBO();
        List list = new ArrayList();
        try {
            list = this.searchFrequentUsedWordsTypeMapper.querySearchFrequentUsedWordsTypeList(reqBO);
        }
        catch (Exception e) {
            log.error("queryStopWordsList========>qry\u67e5\u8be2\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u67e5\u8be2\u5217\u8868\u5931\u8d25");
        }
        PageInfo pageInfo = new PageInfo(list);
        rspBO.setRows(list);
        rspBO.setPageNo(reqBO.getPageNo().intValue());
        rspBO.setRecordsTotal((int)pageInfo.getTotal());
        rspBO.setTotal(pageInfo.getPages());
        return rspBO;
    }

    public SearchFrequentUsedWordsTypeRspBO queryFrequentUsedWordsTypeDetail(SearchFrequentUsedWordsTypeReqBO reqBO) throws ZTBusinessException {
        return null;
    }

    public void addFrequentUsedWordsTypeInfo(SearchFrequentUsedWordsTypeReqBO reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        this.validateParam(reqBO);
        SearchFrequentUsedWordsTypePO isExist = this.searchFrequentUsedWordsTypeMapper.selectCheck(reqBO.getTName());
        if (isExist != null) {
            throw new ZTBusinessException("\u7c7b\u76ee\u540d\u79f0\u91cd\u590d\uff01");
        }
        SearchFrequentUsedWordsTypePO isExistIndexField = this.searchFrequentUsedWordsTypeMapper.selectCheckIndexField(reqBO.getIndexField());
        if (isExistIndexField != null) {
            throw new ZTBusinessException("\u7d22\u5f15\u5b57\u6bb5\u91cd\u590d\uff01");
        }
        SearchFrequentUsedWordsTypePO params = new SearchFrequentUsedWordsTypePO();
        params.setTypeId(CodeUtil.generateTableCode());
        params.settName(reqBO.getTName());
        params.setIndexField(reqBO.getIndexField());
        params.settStatus(Constants.WORDS_STATE_1);
        params.setCreateTime(new Date());
        params.setUpdateTime(new Date());
        params.settWeight(reqBO.getTWeight());
        this.searchFrequentUsedWordsTypeMapper.insertSelective(params);
    }

    public void updateFrequentUsedWordsTypeInfo(SearchFrequentUsedWordsTypeReqBO reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        if (reqBO.getTypeId() == null || reqBO.getTStatus() == null) {
            throw new ZTBusinessException("\u53c2\u6570\u5f02\u5e38\uff01");
        }
        if (reqBO.getTStatus() == Constants.WORDS_STATE_1) {
            throw new ZTBusinessException("\u542f\u7528\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\uff01");
        }
        if (reqBO.getTWeight() == null || reqBO.getTWeight().floatValue() == 0.0f) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u3010\u7c7b\u76ee\u6743\u91cd\u3011\u4e3a\u7a7a");
        }
        SearchFrequentUsedWordsTypePO isExist = this.searchFrequentUsedWordsTypeMapper.selectByPrimaryKey(reqBO.getTypeId());
        if (isExist == null) {
            throw new ZTBusinessException("\u7c7b\u76ee\u4e0d\u5b58\u5728\uff0c\u6570\u636e\u5f02\u5e38\uff01");
        }
        SearchFrequentUsedWordsTypePO record = new SearchFrequentUsedWordsTypePO();
        record.setTypeId(reqBO.getTypeId());
        record.setUpdateTime(new Date());
        record.settWeight(reqBO.getTWeight());
        this.searchFrequentUsedWordsTypeMapper.updateByPrimaryKeySelective(record);
    }

    public void deleteFrequentUsedWordsTypeInfo(SearchFrequentUsedWordsTypeReqBO reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        if (reqBO.getTypeId() == null || reqBO.getTStatus() == null) {
            throw new ZTBusinessException("\u53c2\u6570\u5f02\u5e38\uff01");
        }
        if (reqBO.getTStatus() == Constants.WORDS_STATE_1) {
            throw new ZTBusinessException("\u542f\u7528\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        SearchFrequentUsedWordsTypePO isExist = this.searchFrequentUsedWordsTypeMapper.selectByPrimaryKey(reqBO.getTypeId());
        if (isExist == null) {
            throw new ZTBusinessException("\u7c7b\u76ee\u4e0d\u5b58\u5728\uff0c\u6570\u636e\u5f02\u5e38\uff01");
        }
        List list = this.searchFrequentUsedWordsMapper.selectByTypeId(reqBO.getTypeId());
        if (list != null && list.size() > 0) {
            throw new ZTBusinessException("\u7c7b\u76ee\u88ab\u4f7f\u7528\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
        }
        this.searchFrequentUsedWordsTypeMapper.deleteByPrimaryKey(reqBO.getTypeId());
    }

    @Transactional
    public void updateFrequentUsedWordsTypeStatus(final SearchFrequentUsedWordsTypeReqBO reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        if (reqBO.getTypeId() == null || reqBO.getTStatus() == null) {
            throw new ZTBusinessException("\u53c2\u6570\u5f02\u5e38\uff01");
        }
        SearchFrequentUsedWordsTypePO isExist = this.searchFrequentUsedWordsTypeMapper.selectByPrimaryKey(reqBO.getTypeId());
        if (isExist == null) {
            throw new ZTBusinessException("\u7c7b\u76ee\u4e0d\u5b58\u5728\uff0c\u6570\u636e\u5f02\u5e38\uff01");
        }
        SearchFrequentUsedWordsTypePO record = new SearchFrequentUsedWordsTypePO();
        record.setTypeId(reqBO.getTypeId());
        record.settStatus(reqBO.getTStatus());
        record.setUpdateTime(new Date());
        this.searchFrequentUsedWordsTypeMapper.updateStatus(record);
        List list = this.searchFrequentUsedWordsMapper.selectByTypeId(reqBO.getTypeId());
        if (list != null && list.size() > 0) {
            final HashSet<String> fWords = new HashSet<String>();
            for (SearchFrequentUsedWordsPO s : list) {
                if (s.getfStatus() != 1) continue;
                fWords.add(s.getfWord());
            }
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    if (reqBO.getTStatus() == Constants.WORDS_STATE_0) {
                        SearchFrequentUsedWordsTypeServiceImpl.this.cacheUpdateService.bathDeleteTypeFrequent(fWords);
                    } else {
                        SearchFrequentUsedWordsTypeServiceImpl.this.cacheUpdateService.bathAddTypeFrequent(fWords);
                    }
                }
            });
        }
    }

    public SearchFrequentUsedWordsTypeRspBO queryFrequentUsedWordsTypeAllList(SearchFrequentUsedWordsTypeReqBO reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        SearchFrequentUsedWordsTypeRspBO rspBO = new SearchFrequentUsedWordsTypeRspBO();
        List list = this.searchFrequentUsedWordsTypeMapper.queryAllUsedWordsTypeList();
        rspBO.setRows(list);
        return rspBO;
    }

    public ImportFrequentUsedWordsTypeRspBO importFrequentUsedWordsType(List<List<String>> list) throws ZTBusinessException {
        ImportFrequentUsedWordsTypeRspBO rspBo = new ImportFrequentUsedWordsTypeRspBO();
        ArrayList<SearchFrequentUsedWordsTypeBO> errList = new ArrayList<SearchFrequentUsedWordsTypeBO>();
        int successNums = 0;
        int insertNums = 0;
        int failNums = 0;
        int clistSize = list.size();
        for (int ti = 0; ti < clistSize; ++ti) {
            List<String> row = list.get(ti);
            try {
                SearchFrequentUsedWordsTypeBO oBo;
                String tName = "";
                String indexField = "";
                if (row.size() >= 1) {
                    tName = row.get(0).trim();
                }
                if (row.size() >= 2) {
                    indexField = row.get(1).trim();
                }
                if (tName == null || "".equals(tName)) {
                    ++failNums;
                    oBo = new SearchFrequentUsedWordsTypeBO();
                    oBo.setTName(tName);
                    oBo.setIndexField(indexField);
                    oBo.setFailMsg("\u9891\u7528\u8bcd\u7c7b\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
                    errList.add(oBo);
                    continue;
                }
                if (indexField == null || "".equals(indexField)) {
                    ++failNums;
                    oBo = new SearchFrequentUsedWordsTypeBO();
                    oBo.setTName(tName);
                    oBo.setIndexField(indexField);
                    oBo.setFailMsg("\u7d22\u5f15\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
                    errList.add(oBo);
                    continue;
                }
                SearchFrequentUsedWordsTypePO isExist = this.searchFrequentUsedWordsTypeMapper.selectCheck(tName);
                if (isExist != null) {
                    ++failNums;
                    SearchFrequentUsedWordsTypeBO oBo2 = new SearchFrequentUsedWordsTypeBO();
                    oBo2.setTName(tName);
                    oBo2.setIndexField(indexField);
                    oBo2.setFailMsg("\u9891\u7528\u8bcd\u7c7b\u76ee\u540d\u79f0\u91cd\u590d!");
                    errList.add(oBo2);
                    continue;
                }
                SearchFrequentUsedWordsTypePO isExistIndexField = this.searchFrequentUsedWordsTypeMapper.selectCheckIndexField(indexField);
                if (isExistIndexField != null) {
                    ++failNums;
                    SearchFrequentUsedWordsTypeBO oBo3 = new SearchFrequentUsedWordsTypeBO();
                    oBo3.setTName(tName);
                    oBo3.setIndexField(indexField);
                    oBo3.setFailMsg("\u7d22\u5f15\u5b57\u6bb5\u540d\u79f0\u91cd\u590d!");
                    errList.add(oBo3);
                    continue;
                }
                SearchFrequentUsedWordsTypePO params = new SearchFrequentUsedWordsTypePO();
                params.setTypeId(CodeUtil.generateTableCode());
                params.settName(tName);
                params.setIndexField(indexField);
                params.settStatus(Constants.WORDS_STATE_1);
                params.setCreateTime(new Date());
                params.setUpdateTime(new Date());
                this.searchFrequentUsedWordsTypeMapper.insertSelective(params);
                ++successNums;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                ++failNums;
                SearchFrequentUsedWordsTypeBO oBo = new SearchFrequentUsedWordsTypeBO();
                oBo.setFailMsg("\u521b\u5efa\u505c\u7528\u8bcd\u4fe1\u606f\u5f02\u5e38\uff0crow\u6570\u636e\u4e3a\uff1a" + row.toString());
                errList.add(oBo);
            }
        }
        rspBo.setInsertNums(insertNums);
        rspBo.setFailNums(failNums);
        rspBo.setSuccessNums(successNums);
        ArrayList<String> title = new ArrayList<String>();
        title.add("\u9891\u7528\u8bcd\u7c7b\u76ee\u540d");
        title.add("\u5bf9\u5e94\u7d22\u5f15\u5b57\u6bb5");
        title.add("\u5931\u8d25\u539f\u56e0");
        String[] variable = new String[]{"tName", "indexField", "failMsg"};
        String jsonString = "";
        String titleString = "";
        if (errList.size() > 0) {
            Object[][] data = XlsUtil.toArray(errList, (String[])variable);
            jsonString = JSONObject.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
            titleString = JSONObject.toJSONString(title, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        }
        rspBo.setJsonString(jsonString);
        rspBo.setTitleString(titleString);
        ArrayList<TableHeadInfo> tableHeadInfos = new ArrayList<TableHeadInfo>();
        for (int i = 0; i < title.size(); ++i) {
            TableHeadInfo tableHeadInfo1 = new TableHeadInfo();
            tableHeadInfo1.setTitle((String)title.get(i));
            tableHeadInfo1.setDataIndex(variable[i]);
            tableHeadInfos.add(tableHeadInfo1);
        }
        rspBo.setTitleList(tableHeadInfos);
        rspBo.setCode("0");
        rspBo.setMessage("\u5bfc\u5165\u64cd\u4f5c\u7ed3\u675f\uff01");
        rspBo.setFailList(errList);
        return rspBo;
    }

    public ExportInfoRspBO exportFrequentUsedWordsType(SearchFrequentUsedWordsTypeReqBO reqBO) throws ZTBusinessException {
        ExportInfoRspBO rspBO = new ExportInfoRspBO();
        List allData = this.searchFrequentUsedWordsTypeMapper.queryAllWordsTypeList();
        String[] variable = new String[]{"tName", "indexField"};
        Object[][] data = XlsUtil.toArray((List)allData, (String[])variable);
        String jsonString = JSONObject.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        rspBO.setJsonString(jsonString);
        ArrayList<String> title = new ArrayList<String>();
        title.add("\u9891\u7528\u8bcd\u7c7b\u76ee\u540d");
        title.add("\u5bf9\u5e94\u7d22\u5f15\u5b57\u6bb5");
        String titleString = JSONObject.toJSONString(title, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        rspBO.setTitleString(titleString);
        return rspBO;
    }

    private void validateParam(SearchFrequentUsedWordsTypeReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getTName())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u3010\u7c7b\u76ee\u540d\u79f0\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getIndexField())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u3010\u7d22\u5f15\u5b57\u6bb5\u3011\u4e3a\u7a7a");
        }
        if (reqBO.getTWeight() == null || reqBO.getTWeight().floatValue() == 0.0f) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u3010\u7c7b\u76ee\u6743\u91cd\u3011\u4e3a\u7a7a");
        }
    }
}

