/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.impl;

import com.ohaotian.plugin.base.bo.RspBaseBO;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.manage.api.SearchLoginService;
import com.tydic.se.manage.bo.LoginInRspBO;
import com.tydic.se.manage.bo.LoginReqBo;
import com.tydic.se.manage.dao.SysUserMapper;
import com.tydic.se.manage.dao.po.SysUserPO;
import com.tydic.se.manage.util.RSAUtils;
import com.tydic.se.search.config.SearchProcessConfig;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class SearchLoginServiceImpl
implements SearchLoginService {
    private static final Logger log = LoggerFactory.getLogger(SearchLoginServiceImpl.class);
    @Autowired
    private SysUserMapper sysUserMapper;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private SearchProcessConfig searchProcessConfig;

    public Object login(LoginReqBo reqBO) {
        String userName = reqBO.getUserName();
        String passWord = reqBO.getPassWord();
        LoginInRspBO rBo = new LoginInRspBO();
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{userName, passWord})) {
            rBo.setCode("-9999");
            rBo.setMessage("\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            return rBo;
        }
        try {
            LoginReqBo loginReqBo = new LoginReqBo();
            loginReqBo.setUserName(userName);
            loginReqBo.setPassWord(passWord);
            SysUserPO userPO = this.sysUserMapper.selectByLoginName(userName);
            if (userPO == null) {
                rBo.setCode("-9999");
                rBo.setMessage("\u7528\u6237\u540d\u4e0d\u6b63\u786e!");
                return rBo;
            }
            boolean loginSuccess = false;
            if (StringUtils.isNotEmpty((CharSequence)userPO.getInitialpassword()) && passWord.equals(userPO.getInitialpassword())) {
                loginSuccess = true;
            }
            if (!loginSuccess) {
                rBo.setCode("-9999");
                rBo.setMessage("\u5bc6\u7801\u4e0d\u6b63\u786e!");
                return rBo;
            }
            String token = RSAUtils.defaultEncrypt((String)(userPO.getUserId() + "|" + System.currentTimeMillis()));
            Long seChannelType = (Long)this.cacheClient.get("{SEARCH}_DEFAULT_CHANNEL_TYPE");
            String expireTime = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)seChannelType)).tokenExpireTime;
            this.cacheClient.set("{SEARCH}" + token, (Object)String.valueOf(userPO.getUserId()), Integer.parseInt(expireTime));
            LoginInRspBO rspBo = new LoginInRspBO();
            rspBo.setCode("0");
            rspBo.setMessage("\u7528\u6237\u767b\u5f55\u6210\u529f!");
            rspBo.setToken(token);
            return rspBo;
        }
        catch (Exception e) {
            log.info(e.getMessage());
            rBo.setCode("-9999");
            rBo.setMessage("\u767b\u5f55\u5931\u8d25\uff0c\u670d\u52a1\u5f02\u5e38!");
            return rBo;
        }
    }

    public Object logout(HttpServletRequest request, HttpServletResponse response) {
        String token = request.getHeader("cas-x-token");
        if (token != null && !"".equals(token)) {
            this.cacheClient.delete("{SEARCH}" + token);
        }
        RspBaseBO rBo = new RspBaseBO();
        rBo.setCode("0");
        rBo.setMessage("\u64cd\u4f5c\u6210\u529f!");
        return rBo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void check(HttpServletRequest request) {
        String token = request.getHeader("cas-x-token");
        if (token == null || token.isEmpty()) throw new AuthenticationCredentialsNotFoundException("token\u83b7\u53d6\u5f02\u5e38");
        String realToken = RSAUtils.defaultDecrypt((String)token);
        if (StringUtils.isEmpty((CharSequence)realToken)) throw new AuthenticationCredentialsNotFoundException("token\u89e3\u6790\u5f02\u5e38");
        String[] t = realToken.split("\\|");
        String userId = t[0];
        Object cacheUserId = this.cacheClient.get("{SEARCH}" + token);
        if (ObjectUtils.isEmpty((Object)cacheUserId)) {
            throw new AuthenticationCredentialsNotFoundException("token\u7f13\u5b58\u5f02\u5e38");
        }
        if (Objects.equals(userId, cacheUserId.toString())) return;
        throw new AuthenticationCredentialsNotFoundException("token\u6821\u9a8c\u5f02\u5e38");
    }
}

