/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.manage.api.CacheUpdateService;
import com.tydic.se.manage.api.SearchOuterCatalogService;
import com.tydic.se.manage.bo.SkuCategoryInfoBO;
import com.tydic.se.manage.constants.Constants;
import com.tydic.se.manage.dao.IndexSyncCustomMapper;
import com.tydic.se.manage.dao.SearchExtCatalogRecordMapper;
import com.tydic.se.manage.dao.SearchFrequentUsedWordsMapper;
import com.tydic.se.manage.dao.SearchFrequentUsedWordsTypeMapper;
import com.tydic.se.manage.dao.po.SearchExtCatalogRecordPO;
import com.tydic.se.manage.dao.po.SearchFrequentUsedWordsPO;
import com.tydic.se.manage.dao.po.SearchFrequentUsedWordsTypePO;
import com.tydic.se.manage.util.CommTools;
import com.tydic.se.nlp.bo.AnalysisTypeFrequentBO;
import com.tydic.se.nlp.bo.AnalysisTypeFrequentCacheBO;
import com.tydic.se.nlp.constant.AnalysisCommCONST;
import com.tydic.se.search.config.SearchProcessConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SearchOuterCatalogServiceImpl
implements SearchOuterCatalogService {
    private static final Logger log = LoggerFactory.getLogger(SearchOuterCatalogServiceImpl.class);
    @Autowired
    private SearchFrequentUsedWordsTypeMapper searchFrequentUsedWordsTypeMapper;
    @Autowired
    private SearchFrequentUsedWordsMapper searchFrequentUsedWordsMapper;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private CacheUpdateService cacheUpdateService;
    @Autowired
    private IndexSyncCustomMapper indexSyncCustomMapper;
    @Autowired
    private SearchExtCatalogRecordMapper extCatalogRecordDao;
    @Autowired
    private SearchProcessConfig searchProcessConfig;

    @Transactional
    public void updateOuterCatalogData() {
        List skuCategoryInfoList;
        log.info("\u9891\u7528\u8bcd\u53ca\u7c7b\u76ee\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1=============start");
        String skuTableName = this.indexSyncCustomMapper.queryModelTableByMType(AnalysisCommCONST.ModelType.SKU);
        if (CommTools.strIsEmpty((String)skuTableName)) {
            log.error("\u5355\u54c1\u6a21\u578b\u8868\u672a\u914d\u7f6e\uff0c\u540c\u6b65\u5931\u8d25\uff01");
        }
        log.info("\u4ece\u6570\u4ed3-\u5355\u54c1\u6a21\u578b\u8868\u4e2d\u5206\u522b\u67e5\u8be2\u51fa\u6628\u65e5\u7684\u54c1\u724c\u548c\u4f9b\u5e94\u5546");
        HashSet<String> brandList = new HashSet<String>();
        HashSet<String> vendorList = new HashSet<String>();
        HashMap<String, SearchExtCatalogRecordPO> categoryMap = new HashMap<String, SearchExtCatalogRecordPO>();
        Integer allCount = this.indexSyncCustomMapper.queryAllCount(skuTableName);
        if (allCount == null || allCount < 1) {
            log.warn("\u6ca1\u6709\u5f85\u540c\u6b65\u7684\u7c7b\u76ee\u4fe1\u606f");
        }
        Long seChannelType = (Long)this.cacheClient.get("{SEARCH}_DEFAULT_CHANNEL_TYPE");
        String batchSize = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)seChannelType)).elasticsearchBatchSize;
        int numBatches = (int)Math.ceil((double)allCount.intValue() * 1.0 / (double)Integer.parseInt(batchSize));
        Long maxSkuId = null;
        for (int i = 0; i < numBatches && (skuCategoryInfoList = this.indexSyncCustomMapper.querySkuCategoryList(skuTableName, maxSkuId, Integer.valueOf(Integer.parseInt(batchSize)))) != null && skuCategoryInfoList.size() >= 1; ++i) {
            maxSkuId = ((SkuCategoryInfoBO)skuCategoryInfoList.get(skuCategoryInfoList.size() - 1)).getSkuId();
            for (SkuCategoryInfoBO bo : skuCategoryInfoList) {
                SearchExtCatalogRecordPO searchExtCatalogRecordPO;
                int j;
                if (!CommTools.strIsEmpty((String)bo.getBrandName())) {
                    brandList.add(bo.getBrandName());
                }
                if (!CommTools.strIsEmpty((String)bo.getVendorName())) {
                    vendorList.add(bo.getVendorName());
                }
                List<String> l1CategoryIdList = null;
                List<String> l2CategoryIdList = null;
                List<String> l3CategoryIdList = null;
                List<String> l1CategoryNameList = null;
                List<String> l2CategoryNameList = null;
                List<String> l3CategoryNameList = null;
                if (!CommTools.strIsEmpty((String)bo.getL1CategoryId())) {
                    l1CategoryIdList = Arrays.asList(bo.getL1CategoryId().split(","));
                }
                if (!CommTools.strIsEmpty((String)bo.getL2CategoryId())) {
                    l2CategoryIdList = Arrays.asList(bo.getL2CategoryId().split(","));
                }
                if (!CommTools.strIsEmpty((String)bo.getL3CategoryId())) {
                    l3CategoryIdList = Arrays.asList(bo.getL3CategoryId().split(","));
                }
                if (!CommTools.strIsEmpty((String)bo.getL1CategoryName())) {
                    l1CategoryNameList = Arrays.asList(bo.getL1CategoryName().split(","));
                }
                if (!CommTools.strIsEmpty((String)bo.getL2CategoryName())) {
                    l2CategoryNameList = Arrays.asList(bo.getL2CategoryName().split(","));
                }
                if (!CommTools.strIsEmpty((String)bo.getL3CategoryName())) {
                    l3CategoryNameList = Arrays.asList(bo.getL3CategoryName().split(","));
                }
                if (l1CategoryIdList == null || l1CategoryNameList == null || l1CategoryIdList.size() != l1CategoryNameList.size()) continue;
                for (j = 0; j < l1CategoryIdList.size(); ++j) {
                    if (categoryMap.containsKey(l1CategoryIdList.get(j))) continue;
                    searchExtCatalogRecordPO = new SearchExtCatalogRecordPO(l1CategoryIdList.get(j), l1CategoryNameList.get(j), "\u5355\u54c1\u6a21\u578b\u5b9a\u65f6\u4efb\u52a1\u540c\u6b65\u65b0\u589e", Integer.valueOf(1), "-1", Integer.valueOf(1), new Date(), new Date());
                    categoryMap.put(searchExtCatalogRecordPO.getExtCId(), searchExtCatalogRecordPO);
                }
                if (l2CategoryIdList == null || l2CategoryNameList == null || l2CategoryIdList.size() != l2CategoryNameList.size() || l2CategoryIdList.size() != l1CategoryIdList.size()) continue;
                for (j = 0; j < l2CategoryIdList.size(); ++j) {
                    if (categoryMap.containsKey(l2CategoryIdList.get(j))) continue;
                    searchExtCatalogRecordPO = new SearchExtCatalogRecordPO(l2CategoryIdList.get(j), l2CategoryNameList.get(j), "\u5355\u54c1\u6a21\u578b\u5b9a\u65f6\u4efb\u52a1\u540c\u6b65\u65b0\u589e", Integer.valueOf(2), l1CategoryIdList.get(j), Integer.valueOf(1), new Date(), new Date());
                    categoryMap.put(searchExtCatalogRecordPO.getExtCId(), searchExtCatalogRecordPO);
                }
                if (l3CategoryIdList == null || l3CategoryNameList == null || l3CategoryIdList.size() != l3CategoryNameList.size() || l3CategoryIdList.size() != l2CategoryIdList.size()) continue;
                for (j = 0; j < l3CategoryIdList.size(); ++j) {
                    if (categoryMap.containsKey(l3CategoryIdList.get(j))) continue;
                    searchExtCatalogRecordPO = new SearchExtCatalogRecordPO(l3CategoryIdList.get(j), l3CategoryNameList.get(j), "\u5355\u54c1\u6a21\u578b\u5b9a\u65f6\u4efb\u52a1\u540c\u6b65\u65b0\u589e", Integer.valueOf(3), l2CategoryIdList.get(j), Integer.valueOf(1), new Date(), new Date());
                    categoryMap.put(searchExtCatalogRecordPO.getExtCId(), searchExtCatalogRecordPO);
                }
            }
        }
        log.info("\u4ecemysql\u6570\u636e\u5e93-\u9891\u7528\u8bcd\u7c7b\u76ee\u8868\u4e2d\u67e5\u8be2\u6240\u6709\u7684\u7c7b\u76ee\u5b58\u5230map\u96c6\u5408 key=index_field value=po");
        Map map = this.searchFrequentUsedWordsTypeMapper.selectAllDataKeyIndexField();
        SearchFrequentUsedWordsTypePO brandPO = (SearchFrequentUsedWordsTypePO)map.get("brand_name");
        SearchFrequentUsedWordsTypePO vendorPO = (SearchFrequentUsedWordsTypePO)map.get("vendor_name");
        log.info("\u6570\u636e\u8f6c\u6362,\u5c06\u4ece\u6570\u4ed3\u67e5\u8be2\u7684\u6570\u636e\u8f6c\u6362\u6210po\u5b58\u5165List\u4e2d");
        ArrayList<SearchFrequentUsedWordsPO> brandListPO = new ArrayList<SearchFrequentUsedWordsPO>();
        ArrayList<SearchFrequentUsedWordsPO> vendorListPO = new ArrayList<SearchFrequentUsedWordsPO>();
        ArrayList catelogPoList = null;
        try {
            if (brandList != null && brandList.size() > 0) {
                brandListPO.addAll(brandList.stream().map(brand -> {
                    SearchFrequentUsedWordsPO po = new SearchFrequentUsedWordsPO();
                    po.setfWord(brand);
                    return po;
                }).collect(Collectors.toList()));
            }
            log.info("\u904d\u5386\u54c1\u724cList,\u53bb\u548credis\u4e2d\u7684\u6570\u636e\u8fdb\u884c\u6bd4\u5bf9\uff0c\u5224\u65ad\u662f\u5426\u5165\u5e93");
            this.syncCategory(brandListPO, "{SEARCH}_TYPE_SKU_FREQUENT", "brand_name", brandPO == null ? null : brandPO.getTypeId());
            log.info("\u904d\u5386\u54c1\u724cList\u7ed3\u675f\uff0c\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728\u7684\u54c1\u724c\u5165\u8868,\u540c\u6b65\u7f13\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u5b9a\u65f6\u4efb\u52a1\u540c\u6b65\u54c1\u724c\u5f02\u5e38\uff0cerr:{}", (Object)e.getMessage());
        }
        try {
            if (vendorList != null && vendorList.size() > 0) {
                vendorListPO.addAll(vendorList.stream().map(brand -> {
                    SearchFrequentUsedWordsPO po = new SearchFrequentUsedWordsPO();
                    po.setfWord(brand);
                    return po;
                }).collect(Collectors.toList()));
            }
            log.info("\u904d\u5386\u4f9b\u5e94\u5546List\u5f00\u59cb");
            this.syncCategory(vendorListPO, "{SEARCH}_TYPE_SKU_FREQUENT", "vendor_name", vendorPO == null ? null : vendorPO.getTypeId());
            log.info("\u904d\u5386\u4f9b\u5e94\u5546List\u7ed3\u675f\uff0c\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728\u7684\u4f9b\u5e94\u5546\u5165\u8868,\u540c\u6b65\u7f13\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u5b9a\u65f6\u4efb\u52a1\u540c\u6b65\u4f9b\u5e94\u5546\u5f02\u5e38\uff0cerr:{}", (Object)e.getMessage());
        }
        if (categoryMap.size() > 0) {
            try {
                catelogPoList = new ArrayList(categoryMap.values());
                this.extCatalogRecordDao.batchInsertAndUpdate(catelogPoList);
                this.cacheUpdateService.syncExtThreeCatalog();
            }
            catch (Exception e) {
                log.error("\u5b9a\u65f6\u4efb\u52a1\u540c\u6b65\u5916\u90e8\u4e09\u7ea7\u7c7b\u76ee\u5f02\u5e38\uff0cerr:{}", (Object)e.getMessage());
            }
        }
    }

    private void syncCategory(List<SearchFrequentUsedWordsPO> dataCategoryList, String cacheKey, String indexField, Long typeId) {
        if (dataCategoryList != null && dataCategoryList.size() > 0 && typeId != null) {
            for (SearchFrequentUsedWordsPO data : dataCategoryList) {
                AnalysisTypeFrequentCacheBO tfCacheBO;
                if (data.getfWord() == null) continue;
                boolean flag = false;
                String dataCategoryStr = this.cacheClient.hget(cacheKey, data.getfWord().toLowerCase());
                if (!CommTools.strIsEmpty((String)dataCategoryStr) && (tfCacheBO = (AnalysisTypeFrequentCacheBO)JSONObject.parseObject((String)dataCategoryStr, AnalysisTypeFrequentCacheBO.class)).getTypeFrequentList() != null && tfCacheBO.getTypeFrequentList().size() > 0) {
                    for (AnalysisTypeFrequentBO c : tfCacheBO.getTypeFrequentList()) {
                        if (!c.getIndexField().equals(indexField)) continue;
                        flag = true;
                        break;
                    }
                }
                if (flag) continue;
                data.setfStatus(Constants.WORDS_STATE_1);
                data.setTypeId(typeId);
                data.setCreateTime(new Date());
                data.setUpdateTime(new Date());
                this.searchFrequentUsedWordsMapper.insertSelective(data);
                this.cacheUpdateService.addTypeFrequent(data.getfWord());
            }
        }
    }
}

