/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.se.base.ability.bo.SeAppSkuSyncReqBO;
import com.tydic.se.base.ability.bo.SeAppSkuSyncRspBO;
import com.tydic.se.base.constant.ToOdpsCommConstant;
import com.tydic.se.base.dao.EsIndexTemplateMapper;
import com.tydic.se.base.dao.po.EsIndexTemplate;
import com.tydic.se.manage.api.SearchSkuSyncService;
import com.tydic.se.manage.bo.QueryStandSeAsyncSkusReqBO;
import com.tydic.se.manage.bo.QueryStandSeAsyncSkusRspBO;
import com.tydic.se.manage.bo.QuerySyncEnumRspBO;
import com.tydic.se.manage.bo.SyncEnumBO;
import com.tydic.se.manage.bo.VectorSyncReqBO;
import com.tydic.se.manage.bo.VectorSyncRspBO;
import com.tydic.se.manage.constants.Constants;
import com.tydic.se.manage.dao.SearchFrequentUsedWordsMapper;
import com.tydic.se.manage.dao.SearchFrequentUsedWordsTypeMapper;
import com.tydic.se.manage.dao.StandSeAsyncSkusHistoryMapper;
import com.tydic.se.manage.dao.StandSeAsyncSkusMapper;
import com.tydic.se.manage.dao.po.SearchFrequentUsedWordsPO;
import com.tydic.se.manage.dao.po.SearchFrequentUsedWordsTypePO;
import com.tydic.se.manage.dao.po.StandSeAsyncSkusHistoryPo;
import com.tydic.se.manage.dao.po.StandSeAsyncSkusPo;
import com.tydic.se.manage.enums.SyncOperateEnum;
import com.tydic.se.manage.enums.SyncStateEnum;
import com.tydic.se.manage.util.CodeUtil;
import com.tydic.se.manage.util.CommTools;
import com.tydic.se.nlp.api.SearchAnalysisService;
import com.tydic.se.nlp.req.NerEntityBO;
import com.tydic.se.nlp.req.QueryRewriteResultBO;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.sort.exception.SearchSortException;
import io.milvus.client.MilvusServiceClient;
import io.milvus.param.R;
import io.milvus.param.dml.DeleteParam;
import io.milvus.param.dml.InsertParam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SearchSkuSyncServiceImpl
implements SearchSkuSyncService {
    private static final Logger log = LoggerFactory.getLogger(SearchSkuSyncServiceImpl.class);
    @Autowired
    private StandSeAsyncSkusMapper asyncSkusMapper;
    @Autowired
    private StandSeAsyncSkusHistoryMapper asyncSkusHistoryMapper;
    @Autowired
    private EsIndexTemplateMapper esIndexTemplateMapper;
    @Autowired
    private SearchFrequentUsedWordsMapper searchFrequentUsedWordsMapper;
    @Autowired
    private SearchFrequentUsedWordsTypeMapper searchFrequentUsedWordsTypeMapper;
    @Autowired
    private CacheClient cacheClient;
    @Lazy
    @Autowired
    private MilvusServiceClient milvusClient;
    @Autowired
    private SearchAnalysisService searchAnalysisService;
    @Qualifier(value="restHighLevelClient")
    @Autowired
    private RestHighLevelClient esClient;
    @Autowired
    private SearchProcessConfig searchProcessConfig;

    @Transactional(rollbackFor={Exception.class})
    public SeAppSkuSyncRspBO recordSkuChanges(SeAppSkuSyncReqBO seAppSkuSyncReqBO) {
        SeAppSkuSyncRspBO rspBO = new SeAppSkuSyncRspBO();
        List records = seAppSkuSyncReqBO.getSkuIds().stream().map(skuId -> this.createAsyncRecord((Long)skuId, seAppSkuSyncReqBO.getDealType())).collect(Collectors.toList());
        int result = this.asyncSkusMapper.batchInsert(records);
        if (seAppSkuSyncReqBO.getDealType() == 1) {
            this.autoExtractAndAddFrequentWords(seAppSkuSyncReqBO.getSkuIds());
        }
        if (result > 0) {
            rspBO.setResult(Integer.valueOf(result));
        }
        return rspBO;
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean updateSyncStatus(String asyncSkuId, Integer status, String errorMsg, Integer flag) {
        Boolean result = false;
        if (flag == 1) {
            StandSeAsyncSkusPo updatePo = new StandSeAsyncSkusPo();
            updatePo.setAsyncSkuId(asyncSkuId);
            updatePo.setAsyncState(status);
            updatePo.setAsyncError(errorMsg);
            updatePo.setUpdateTime(new Date());
            int res = this.asyncSkusMapper.updateByPrimaryKeySelective(updatePo);
            if (res > 0) {
                result = true;
            }
        } else {
            StandSeAsyncSkusHistoryPo historyPo = this.asyncSkusHistoryMapper.selectByPrimaryKey(asyncSkuId);
            if (historyPo != null) {
                historyPo.setAsyncState(status);
                historyPo.setAsyncError(errorMsg);
                historyPo.setUpdateTime(new Date());
                int update = this.asyncSkusHistoryMapper.updateByPrimaryKey(historyPo);
                if (update > 0) {
                    result = true;
                }
            }
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public VectorSyncRspBO vectorSync() {
        String milvusIndex;
        VectorSyncRspBO rspBO = new VectorSyncRspBO();
        Long seChannelType = (Long)this.cacheClient.get("{SEARCH}_DEFAULT_CHANNEL_TYPE");
        String vectorOpen = ((SearchProcessConfig.VectorConfig)this.searchProcessConfig.getVector().get((Object)seChannelType)).searchUseVector;
        if (!Objects.equals("1", vectorOpen)) {
            log.error("\u5411\u91cf\u672a\u5f00\u542f\uff0c\u4e0d\u5141\u8bb8\u540c\u6b65\u5411\u91cf\u7d22\u5f15\uff01");
            return null;
        }
        String esVectorIndex = this.cacheClient.hget("{SEARCH}_INDEX", "indexEsVectorName");
        EsIndexTemplate template = this.getEsIndexTemplate(esVectorIndex, milvusIndex = this.cacheClient.hget("{SEARCH}_INDEX", "indexMilvusVectorName"));
        if (template == null) {
            log.error("\u672a\u627e\u5230\u5411\u91cf\u7d22\u5f15\u914d\u7f6e");
            return null;
        }
        JSONObject config = JSON.parseObject((String)template.getIndexConfig());
        List pendingSkus = this.asyncSkusMapper.selectAsyncSkusByState(Integer.valueOf(0));
        if (pendingSkus.isEmpty()) {
            return null;
        }
        pendingSkus.forEach(sku -> this.processSku((StandSeAsyncSkusPo)sku, esVectorIndex, milvusIndex, config, 1));
        rspBO.setCode("0");
        rspBO.setMessage("Success");
        return rspBO;
    }

    public QueryStandSeAsyncSkusRspBO queryStandSeAsyncSkus(QueryStandSeAsyncSkusReqBO reqBO) {
        List rspList;
        if (reqBO.getPageNo() < 1) {
            reqBO.setPageNo(1);
        }
        if (reqBO.getPageSize() < 1) {
            reqBO.setPageSize(10);
        }
        QueryStandSeAsyncSkusRspBO rspBO = new QueryStandSeAsyncSkusRspBO();
        PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize());
        StandSeAsyncSkusPo standSeAsyncSkusPo = new StandSeAsyncSkusPo();
        if (reqBO.getSkuDealType() != null) {
            standSeAsyncSkusPo.setSkuDealType(reqBO.getSkuDealType());
        }
        if (reqBO.getAsyncState() != null) {
            standSeAsyncSkusPo.setAsyncState(reqBO.getAsyncState());
        }
        try {
            rspList = this.asyncSkusMapper.queryStandSeAsyncSkusList(standSeAsyncSkusPo);
        }
        catch (Exception e) {
            log.error("queryStandSeAsyncSkus========>qry\u67e5\u8be2\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u67e5\u8be2\u5217\u8868\u5931\u8d25");
        }
        PageInfo pageInfo = new PageInfo(rspList);
        rspBO.setRows(rspList);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal((int)pageInfo.getTotal());
        rspBO.setTotal(pageInfo.getPages());
        return rspBO;
    }

    @Transactional(rollbackFor={Exception.class})
    public VectorSyncRspBO dealSyncFailed(VectorSyncReqBO reqBO) {
        String milvusIndex;
        VectorSyncRspBO rspBO = new VectorSyncRspBO();
        if (reqBO.getSkuIds().isEmpty()) {
            log.info("\u6ca1\u6709\u540c\u6b65\u5931\u8d25\u6570\u636e");
            return null;
        }
        List<StandSeAsyncSkusHistoryPo> pendingSkus = reqBO.getSkuIds().stream().map(skuId -> this.asyncSkusHistoryMapper.selectBySkuId(skuId)).collect(Collectors.toList());
        String esVectorIndex = this.cacheClient.hget("{SEARCH}_INDEX", "indexEsVectorName");
        EsIndexTemplate template = this.getEsIndexTemplate(esVectorIndex, milvusIndex = this.cacheClient.hget("{SEARCH}_INDEX", "indexMilvusVectorName"));
        if (template == null) {
            log.error("\u672a\u627e\u5230\u5411\u91cf\u7d22\u5f15\u914d\u7f6e");
            return null;
        }
        JSONObject config = JSON.parseObject((String)template.getIndexConfig());
        pendingSkus.forEach(sku -> this.processSku(this.convertToAsyncSkusPo((StandSeAsyncSkusHistoryPo)sku), esVectorIndex, milvusIndex, config, 2));
        rspBO.setCode("0");
        rspBO.setMessage("Success");
        return rspBO;
    }

    public QuerySyncEnumRspBO querySyncEnum() {
        QuerySyncEnumRspBO rspBO = new QuerySyncEnumRspBO();
        rspBO.setSyncOperate(Arrays.stream(SyncOperateEnum.values()).map(enumItem -> new SyncEnumBO(enumItem.getType(), enumItem.getDesc())).collect(Collectors.toList()));
        rspBO.setSyncState(Arrays.stream(SyncStateEnum.values()).map(enumItem -> new SyncEnumBO(enumItem.getCode(), enumItem.getDescription())).collect(Collectors.toList()));
        return rspBO;
    }

    private StandSeAsyncSkusPo createAsyncRecord(Long skuId, Integer dealType) {
        StandSeAsyncSkusPo record = new StandSeAsyncSkusPo();
        record.setAsyncSkuId(this.generateAsyncId());
        record.setSkuId(skuId);
        record.setSkuDealType(dealType);
        record.setAsyncState(Integer.valueOf(0));
        record.setCreateTime(new Date());
        record.setUpdateTime(new Date());
        return record;
    }

    private StandSeAsyncSkusHistoryPo insertInHistoryPo(String asyncSkuId, Long skuId, Integer dealType, String errorMsg) {
        StandSeAsyncSkusHistoryPo history = new StandSeAsyncSkusHistoryPo();
        history.setAsyncSkuId(asyncSkuId);
        history.setSkuId(skuId);
        history.setSkuDealType(dealType);
        history.setAsyncState(Integer.valueOf(2));
        history.setAsyncError(errorMsg);
        history.setCreateTime(new Date());
        history.setUpdateTime(new Date());
        return history;
    }

    private StandSeAsyncSkusPo convertToAsyncSkusPo(StandSeAsyncSkusHistoryPo source) {
        StandSeAsyncSkusPo asyncSkusPo = new StandSeAsyncSkusPo();
        asyncSkusPo.setAsyncSkuId(source.getAsyncSkuId());
        asyncSkusPo.setSkuId(source.getSkuId());
        asyncSkusPo.setSkuDealType(source.getSkuDealType());
        asyncSkusPo.setAsyncState(source.getAsyncState());
        asyncSkusPo.setAsyncError(source.getAsyncError());
        asyncSkusPo.setCreateTime(source.getCreateTime());
        asyncSkusPo.setUpdateTime(source.getUpdateTime());
        return asyncSkusPo;
    }

    private String generateAsyncId() {
        return CodeUtil.generateTableCode().toString();
    }

    private EsIndexTemplate getEsIndexTemplate(String esVectorIndex, String milvusIndex) {
        Long seChannelType = (Long)this.cacheClient.get("{SEARCH}_DEFAULT_CHANNEL_TYPE");
        if (!CommTools.strIsEmpty((String)esVectorIndex)) {
            return this.esIndexTemplateMapper.selectBytType(ToOdpsCommConstant.esType.TYPE_3, seChannelType);
        }
        if (!CommTools.strIsEmpty((String)milvusIndex)) {
            return this.esIndexTemplateMapper.selectBytType(ToOdpsCommConstant.esType.TYPE_5, seChannelType);
        }
        return null;
    }

    private void processSku(StandSeAsyncSkusPo sku, String esVectorIndex, String milvusIndex, JSONObject config, Integer flag) {
        try {
            switch (sku.getSkuDealType()) {
                case 0: {
                    this.handleDeleteOperation(sku, esVectorIndex, milvusIndex, flag);
                    break;
                }
                case 1: 
                case 2: {
                    this.handleAddOrUpdateOperation(sku, esVectorIndex, milvusIndex, config, flag);
                    break;
                }
                default: {
                    log.warn("\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b: {}", (Object)sku.getSkuDealType());
                    break;
                }
            }
        }
        catch (SearchSortException e) {
            this.logErrorAndRecordHistory(sku, e, flag);
        }
    }

    private void handleDeleteOperation(StandSeAsyncSkusPo sku, String esVectorIndex, String milvusIndex, Integer flag) {
        try {
            Boolean delMil;
            if (!CommTools.strIsEmpty((String)esVectorIndex)) {
                Boolean delEs = this.deleteFromEsVector(sku, esVectorIndex, flag);
                if (Boolean.TRUE.equals(delEs)) {
                    this.handleOperationResult(sku, flag);
                }
            } else if (!CommTools.strIsEmpty((String)milvusIndex) && Boolean.TRUE.equals(delMil = this.handleDeleteOperation(sku, milvusIndex, flag))) {
                this.handleOperationResult(sku, flag);
            }
        }
        catch (Exception e) {
            this.logErrorAndRecordHistory(sku, e, flag);
            throw new SearchSortException("DEL_OP_FAIL", "\u5220\u9664\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
        }
    }

    private void handleAddOrUpdateOperation(StandSeAsyncSkusPo sku, String esVectorIndex, String milvusIndex, JSONObject config, Integer flag) {
        try {
            Boolean milvusAdd;
            Map<String, Object> esData = this.queryEsData(sku, config, flag);
            if (esData.isEmpty()) {
                this.logErrorAndRecordHistory(sku, new SearchSortException("ES_EMPTY", "ES\u67e5\u8be2\u6570\u636e\u4e3anull"), flag);
                return;
            }
            List<Float> vector = this.generateVector(sku, esData, config, flag);
            if (vector.isEmpty()) {
                this.logErrorAndRecordHistory(sku, new SearchSortException("VECTOR_EMPTY", "\u5411\u91cf\u751f\u6210\u5931\u8d25"), flag);
                return;
            }
            if (!CommTools.strIsEmpty((String)esVectorIndex)) {
                Boolean esAdd = this.writeToEsVector(sku, esData, vector, config, esVectorIndex, flag);
                if (Boolean.TRUE.equals(esAdd)) {
                    this.handleOperationResult(sku, flag);
                }
            } else if (!CommTools.strIsEmpty((String)milvusIndex) && Boolean.TRUE.equals(milvusAdd = this.writeToMilvus(sku, esData, vector, config, milvusIndex, flag))) {
                this.handleOperationResult(sku, flag);
            }
        }
        catch (SearchSortException e) {
            throw e;
        }
        catch (Exception e) {
            this.logErrorAndRecordHistory(sku, e, flag);
            throw new SearchSortException("UPDATE_OP_FAIL", "\u66f4\u65b0\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
        }
    }

    private void handleOperationResult(StandSeAsyncSkusPo sku, Integer flag) {
        if (flag == 2) {
            this.updateSyncStatus(sku.getAsyncSkuId(), 1, null, 1);
            this.updateSyncStatus(sku.getAsyncSkuId(), 1, null, flag);
        } else {
            this.updateSyncStatus(sku.getAsyncSkuId(), 1, null, flag);
        }
    }

    private void logErrorAndRecordHistory(StandSeAsyncSkusPo sku, Throwable e, Integer flag) {
        String errorMsg = this.buildErrorDetail(e);
        if (flag == 1) {
            this.updateSyncStatus(sku.getAsyncSkuId(), 2, errorMsg, flag);
            this.asyncSkusHistoryMapper.insert(this.insertInHistoryPo(sku.getAsyncSkuId(), sku.getSkuId(), sku.getSkuDealType(), errorMsg));
        } else if (flag == 2) {
            this.updateSyncStatus(sku.getAsyncSkuId(), 2, errorMsg, flag);
        }
    }

    private String buildErrorDetail(Throwable e) {
        if (e instanceof SearchSortException) {
            SearchSortException ex = (SearchSortException)e;
            return String.format("[%s]%s | \u4f4d\u7f6e:%s", ex.getMsgCode(), StringUtils.defaultIfEmpty((String)ex.getMsgDesc(), (String)"\u65e0\u8be6\u7ec6\u63cf\u8ff0"), ex.getStackDesc());
        }
        StackTraceElement[] stack = e.getStackTrace();
        String className = "";
        String methodName = "";
        int lineNumber = 0;
        if (stack.length > 0) {
            className = stack[0].getClassName();
            methodName = stack[0].getMethodName();
            lineNumber = stack[0].getLineNumber();
        }
        return String.format("[UNKNOWN_ERROR]%s | \u4f4d\u7f6e:%s.%s():%d", e.getMessage(), className, methodName, lineNumber);
    }

    private Map<String, Object> queryEsData(StandSeAsyncSkusPo sku, JSONObject config, Integer flag) {
        try {
            List<String> fields = this.buildQueryFields(config);
            SearchRequest request = new SearchRequest();
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            sourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)"skuId", (Object)sku.getSkuId()));
            sourceBuilder.fetchSource(fields.toArray(new String[0]), null);
            sourceBuilder.size(1);
            String esSkuIndex = this.cacheClient.hget("{SEARCH}_INDEX", "indexEsSkuName");
            request.indices(new String[]{esSkuIndex});
            request.source(sourceBuilder);
            SearchResponse response = this.esClient.search(request, RequestOptions.DEFAULT);
            if (response.getHits().getHits().length > 0) {
                return response.getHits().getHits()[0].getSourceAsMap();
            }
        }
        catch (SearchSortException | IOException e) {
            log.error("{}{}{}", new Object[]{"9999", "ES\u67e5\u8be2\u5931\u8d25\uff01skuId={}", sku.getSkuId(), e});
        }
        return Collections.emptyMap();
    }

    private List<Float> generateVector(StandSeAsyncSkusPo sku, Map<String, Object> data, JSONObject config, Integer flag) {
        String text;
        String indexKey;
        String vectorField = null;
        if (config.containsKey((Object)"mappings")) {
            JSONObject properties = config.getJSONObject("mappings").getJSONObject("properties");
            for (String fieldName : properties.keySet()) {
                JSONObject fieldConfig = properties.getJSONObject(fieldName);
                String fieldType = fieldConfig.getString("type");
                if (!"dense_vector".equals(fieldType)) continue;
                vectorField = fieldName.replace("_emberdding", "");
                break;
            }
        } else if (config.containsKey((Object)"fields") && (indexKey = config.getString("index_key")) != null && indexKey.endsWith("_emberdding")) {
            vectorField = indexKey.replace("_emberdding", "");
        }
        if (!(text = Optional.ofNullable(data.get(vectorField)).map(Object::toString).orElse("")).isEmpty()) {
            try {
                Long seChannelType = (Long)this.cacheClient.get("{SEARCH}_DEFAULT_CHANNEL_TYPE");
                List vectorList = this.searchAnalysisService.getVectorList(Collections.singletonList(text), seChannelType);
                if (vectorList != null) {
                    return (List)vectorList.get(0);
                }
            }
            catch (SearchSortException e) {
                this.logErrorAndRecordHistory(sku, e, flag);
                log.error("{}{}{}", new Object[]{"9999", "\u5411\u91cf\u751f\u6210\u5931\u8d25\uff01skuId={}", sku.getSkuId(), e});
            }
        }
        return Collections.emptyList();
    }

    private Boolean writeToMilvus(StandSeAsyncSkusPo sku, Map<String, Object> data, List<Float> vector, JSONObject config, String milvusIndex, Integer flag) {
        Boolean result = false;
        try {
            Long skuId = (Long)JSON.parseObject((String)data.get("skuId").toString(), Long.class);
            String deleteExpr = String.format("skuId in [%d]", skuId);
            R deleteResult = this.milvusClient.delete(DeleteParam.newBuilder().withCollectionName(milvusIndex).withExpr(deleteExpr).build());
            if (!deleteResult.getStatus().equals(R.Status.Success.getCode())) {
                log.error("{}{}{}", new Object[]{"9999", "Milvus\u5220\u9664\u65e7\u6570\u636e\u5931\u8d25!", deleteResult.getMessage()});
            }
            ArrayList fields = new ArrayList();
            config.getJSONArray("fields").forEach(f -> {
                int targetLevel;
                List catalogList;
                Object value;
                JSONObject field = (JSONObject)f;
                String name = field.getString("name");
                Object object = value = name.endsWith("_emberdding") ? vector : data.get(name);
                if ("skuId".equals(name)) {
                    value = skuId;
                }
                if ("l3_category_id".equals(name) && (catalogList = (List)data.get("manageCatalogList")) != null && !catalogList.isEmpty()) {
                    targetLevel = catalogList.size() == 3 ? 3 : 2;
                    value = catalogList.stream().filter(catalog -> (Integer)catalog.get("manageCatalogLevel") == targetLevel).findFirst().map(catalog -> (String)catalog.get("manageCatalogId")).orElse(null);
                }
                if ("l3_category_name".equals(name) && (catalogList = (List)data.get("manageCatalogList")) != null && !catalogList.isEmpty()) {
                    targetLevel = catalogList.size() == 3 ? 3 : 2;
                    value = catalogList.stream().filter(catalog -> (Integer)catalog.get("manageCatalogLevel") == targetLevel).findFirst().map(catalog -> catalog.get("manageCatalogName")).orElse(null);
                }
                fields.add(new InsertParam.Field(name, Collections.singletonList(value)));
            });
            InsertParam insertParam = InsertParam.newBuilder().withCollectionName(milvusIndex).withFields(fields).build();
            R insertResult = this.milvusClient.insert(insertParam);
            if (insertResult.getStatus().equals(R.Status.Success.getCode())) {
                result = true;
            }
        }
        catch (SearchSortException e) {
            this.logErrorAndRecordHistory(sku, e, flag);
            log.error("{}{}{}", new Object[]{"9999", "Milvus\u63d2\u5165\u6570\u636e\u5931\u8d25!", e});
        }
        return result;
    }

    private Boolean handleDeleteOperation(StandSeAsyncSkusPo sku, String milvusIndex, Integer flag) {
        Boolean res = false;
        try {
            String deleteExpr = String.format("skuId in [%d]", sku.getSkuId());
            R result = this.milvusClient.delete(DeleteParam.newBuilder().withCollectionName(milvusIndex).withExpr(deleteExpr).build());
            if (result != null) {
                res = true;
                log.info("Milvus\u5220\u9664\u7ed3\u679c: {}", (Object)result);
            }
        }
        catch (SearchSortException e) {
            this.logErrorAndRecordHistory(sku, e, flag);
            log.error("{}{}{}", new Object[]{"9999", "Milvus\u5220\u9664\u7d22\u5f15\u4fe1\u606f\u5931\u8d25", e});
        }
        return res;
    }

    private Boolean writeToEsVector(StandSeAsyncSkusPo sku, Map<String, Object> data, List<Float> vector, JSONObject config, String esVectorIndex, Integer flag) {
        Boolean result = false;
        try {
            JSONObject esVectorDoc = new JSONObject();
            Map properties = (Map)((Map)config.get((Object)"mappings")).get("properties");
            for (String fieldName : properties.keySet()) {
                if (fieldName.endsWith("_emberdding")) {
                    esVectorDoc.put(fieldName, vector);
                    continue;
                }
                if (!data.containsKey(fieldName)) continue;
                esVectorDoc.put(fieldName, data.get(fieldName));
            }
            DeleteByQueryRequest deleteRequest = new DeleteByQueryRequest(new String[]{esVectorIndex});
            deleteRequest.setQuery((QueryBuilder)QueryBuilders.termQuery((String)"skuId", (Object)data.get("skuId")));
            this.esClient.deleteByQuery(deleteRequest, RequestOptions.DEFAULT);
            IndexRequest indexRequest = new IndexRequest(esVectorIndex).id(data.get("skuId").toString()).source(esVectorDoc.toJSONString(), XContentType.JSON);
            this.esClient.index(indexRequest, RequestOptions.DEFAULT);
            result = true;
            log.info("ES\u5411\u91cf\u7d22\u5f15\u5199\u5165\u6210\u529f: skuId={}", data.get("skuId"));
        }
        catch (SearchSortException | IOException e) {
            this.logErrorAndRecordHistory(sku, e, flag);
            log.error("{}{}{}", new Object[]{"9999", "ES\u5411\u91cf\u7d22\u5f15\u5199\u5165\u5931\u8d25", e});
        }
        return result;
    }

    private Boolean deleteFromEsVector(StandSeAsyncSkusPo sku, String esVectorIndex, Integer flag) {
        Boolean result = false;
        try {
            DeleteByQueryRequest deleteRequest = new DeleteByQueryRequest(new String[]{esVectorIndex});
            deleteRequest.setQuery((QueryBuilder)QueryBuilders.termQuery((String)"skuId", (Object)sku.getSkuId()));
            this.esClient.deleteByQuery(deleteRequest, RequestOptions.DEFAULT);
            log.info("ES\u5411\u91cf\u7d22\u5f15\u5220\u9664\u6210\u529f: skuId={}", (Object)sku.getSkuId());
            result = true;
        }
        catch (Exception e) {
            this.logErrorAndRecordHistory(sku, e, flag);
            log.error("{}{}{}", new Object[]{"9999", "ES\u5411\u91cf\u7d22\u5f15\u5220\u9664\u5931\u8d25!", e});
        }
        return result;
    }

    private List<String> buildQueryFields(JSONObject config) {
        List<String> fields = new ArrayList<String>();
        if (config.containsKey((Object)"mappings")) {
            JSONObject properties = config.getJSONObject("mappings").getJSONObject("properties");
            fields = properties.keySet().stream().filter(fieldName -> {
                JSONObject fieldConfig = properties.getJSONObject(fieldName);
                String fieldType = fieldConfig.getString("type");
                return !"dense_vector".equals(fieldType) && !fieldName.endsWith("_emberdding");
            }).collect(Collectors.toList());
        } else if (config.containsKey((Object)"fields")) {
            fields = config.getJSONArray("fields").stream().map(f -> ((JSONObject)f).getString("name")).filter(name -> !name.endsWith("_emberdding")).collect(Collectors.toList());
            fields.add("manageCatalogList");
        }
        return fields;
    }

    private void autoExtractAndAddFrequentWords(List<Long> skuIds) {
        try {
            log.info("\u5f00\u59cb\u4e3a\u5546\u54c1\u81ea\u52a8\u63d0\u53d6\u548c\u6dfb\u52a0\u9891\u7528\u8bcd\uff0c\u5546\u54c1\u6570\u91cf: {}", (Object)skuIds.size());
            SearchFrequentUsedWordsTypePO brandType = this.searchFrequentUsedWordsTypeMapper.selectCheckIndexField("brand_name");
            if (brandType == null) {
                return;
            }
            SearchFrequentUsedWordsTypePO tokenType = this.searchFrequentUsedWordsTypeMapper.selectCheckIndexField("sku_name");
            if (tokenType == null) {
                return;
            }
            String esSkuIndex = this.cacheClient.hget("{SEARCH}_INDEX", "indexEsSkuName");
            if (StringUtils.isEmpty((String)esSkuIndex)) {
                return;
            }
            List existingWords = this.searchFrequentUsedWordsMapper.querFreWordList();
            HashSet existingWordSet = new HashSet(existingWords);
            HashSet<String> newFrequentWords = new HashSet<String>();
            ArrayList<SearchFrequentUsedWordsPO> wordsToInsert = new ArrayList<SearchFrequentUsedWordsPO>();
            for (Long skuId : skuIds) {
                try {
                    Sequence sequence;
                    SearchFrequentUsedWordsPO wordPO;
                    String skuName = this.querySkuNameFromEs(skuId, esSkuIndex);
                    if (StringUtils.isEmpty((String)skuName)) continue;
                    Long seChannelType = (Long)this.cacheClient.get("{SEARCH}_DEFAULT_CHANNEL_TYPE");
                    QueryRewriteResultBO queryRewriteResult = this.searchAnalysisService.queryRewrite(skuName, Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), seChannelType);
                    if (queryRewriteResult == null) continue;
                    if (queryRewriteResult.getNerEntities() != null) {
                        for (NerEntityBO entity : queryRewriteResult.getNerEntities()) {
                            String brandName;
                            if (!"HP".equals(entity.getType()) || StringUtils.isEmpty((String)entity.getSpan()) || existingWordSet.contains(brandName = entity.getSpan().trim()) || newFrequentWords.contains(brandName)) continue;
                            newFrequentWords.add(brandName);
                            wordPO = new SearchFrequentUsedWordsPO();
                            sequence = Sequence.getInstance();
                            wordPO.setId(Long.valueOf(sequence.nextId()));
                            wordPO.setfWord(brandName);
                            wordPO.setTypeId(brandType.getTypeId());
                            wordPO.setfStatus(Constants.WORDS_STATE_1);
                            wordPO.setCreateTime(new Date());
                            wordPO.setUpdateTime(new Date());
                            wordsToInsert.add(wordPO);
                        }
                    }
                    if (queryRewriteResult.getTokens() == null || queryRewriteResult.getTokens().isEmpty()) continue;
                    for (String token : queryRewriteResult.getTokens()) {
                        String tokenWord;
                        if (StringUtils.isEmpty((String)token) || (tokenWord = token.trim()).length() <= 1 || this.isInvalidToken(tokenWord) || existingWordSet.contains(tokenWord) || newFrequentWords.contains(tokenWord)) continue;
                        newFrequentWords.add(tokenWord);
                        wordPO = new SearchFrequentUsedWordsPO();
                        sequence = Sequence.getInstance();
                        wordPO.setId(Long.valueOf(sequence.nextId()));
                        wordPO.setfWord(tokenWord);
                        wordPO.setTypeId(tokenType.getTypeId());
                        wordPO.setfStatus(Constants.WORDS_STATE_1);
                        wordPO.setCreateTime(new Date());
                        wordPO.setUpdateTime(new Date());
                        wordsToInsert.add(wordPO);
                    }
                }
                catch (Exception e) {
                    log.error("\u5904\u7406\u5546\u54c1 {} \u7684\u9891\u7528\u8bcd\u63d0\u53d6\u65f6\u53d1\u751f\u9519\u8bef: {}", new Object[]{skuId, e.getMessage(), e});
                }
            }
            if (!wordsToInsert.isEmpty()) {
                this.searchFrequentUsedWordsMapper.batchInsert(wordsToInsert);
                log.info("\u6210\u529f\u6dfb\u52a0 {} \u4e2a\u65b0\u7684\u9891\u7528\u8bcd", (Object)wordsToInsert.size());
            } else {
                log.info("\u672a\u53d1\u73b0\u65b0\u7684\u9891\u7528\u8bcd");
            }
        }
        catch (Exception e) {
            log.error("\u81ea\u52a8\u63d0\u53d6\u9891\u7528\u8bcd\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private boolean isInvalidToken(String token) {
        if (token.matches("\\d+")) {
            return true;
        }
        if (token.matches("[a-zA-Z]+")) {
            return true;
        }
        HashSet<String> stopWords = new HashSet<String>();
        stopWords.add("\u7684");
        stopWords.add("\u662f");
        stopWords.add("\u548c");
        stopWords.add("\u6216");
        stopWords.add("\u4e0e");
        stopWords.add("\u53ca");
        stopWords.add("\u7b49");
        stopWords.add("\u4e86");
        stopWords.add("\u5728");
        stopWords.add("\u6709");
        stopWords.add("\u4e2a");
        stopWords.add("\u4e00");
        stopWords.add("\u4e8c");
        stopWords.add("\u4e09");
        stopWords.add("\u56db");
        stopWords.add("\u4e94");
        stopWords.add("\u516d");
        stopWords.add("\u4e03");
        stopWords.add("\u516b");
        stopWords.add("\u4e5d");
        stopWords.add("\u5341");
        return stopWords.contains(token);
    }

    private String querySkuNameFromEs(Long skuId, String esSkuIndex) {
        try {
            SearchRequest request = new SearchRequest(new String[]{esSkuIndex});
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            sourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)"skuId", (Object)skuId));
            sourceBuilder.fetchSource(new String[]{"skuName"}, null);
            sourceBuilder.size(1);
            request.source(sourceBuilder);
            SearchResponse response = this.esClient.search(request, RequestOptions.DEFAULT);
            if (response.getHits().getHits().length > 0) {
                Map source = response.getHits().getHits()[0].getSourceAsMap();
                Object skuName = source.get("skuName");
                return skuName != null ? skuName.toString() : null;
            }
        }
        catch (IOException e) {
            log.error("\u4eceES\u67e5\u8be2\u5546\u54c1\u540d\u79f0\u5931\u8d25\uff0cskuId: {}, error: {}", new Object[]{skuId, e.getMessage(), e});
        }
        return null;
    }
}

