/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.se.manage.api.SearchStopWordsService;
import com.tydic.se.manage.bo.ExportInfoRspBO;
import com.tydic.se.manage.bo.ImportStopWordsRspBO;
import com.tydic.se.manage.bo.SearchStopWordsBO;
import com.tydic.se.manage.bo.SearchStopWordsReqBO;
import com.tydic.se.manage.bo.SearchStopWordsRspBO;
import com.tydic.se.manage.bo.TableHeadInfo;
import com.tydic.se.manage.constants.Constants;
import com.tydic.se.manage.constants.XlsUtil;
import com.tydic.se.manage.dao.SearchStopWordsMapper;
import com.tydic.se.manage.dao.po.SearchStopWordsPO;
import com.tydic.se.manage.util.CodeUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchStopWordsServiceImpl
implements SearchStopWordsService {
    private static final Logger log = LoggerFactory.getLogger(SearchStopWordsServiceImpl.class);
    @Autowired
    private SearchStopWordsMapper searchStopWordsMapper;

    public SearchStopWordsRspBO queryStopWordsList(SearchStopWordsReqBO reqBO) throws ZTBusinessException {
        SearchStopWordsRspBO rspBO = new SearchStopWordsRspBO();
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize());
        List list = new ArrayList();
        try {
            SearchStopWordsPO searchStopWordsPO = new SearchStopWordsPO();
            searchStopWordsPO.setStopWord(reqBO.getStopWord());
            searchStopWordsPO.setsStatus(reqBO.getSStatus());
            searchStopWordsPO.setFlag(reqBO.isFlag());
            list = this.searchStopWordsMapper.querySearchStopWordsList(searchStopWordsPO);
        }
        catch (Exception e) {
            log.error("queryStopWordsList========>qry\u67e5\u8be2\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u67e5\u8be2\u5217\u8868\u5931\u8d25");
        }
        PageInfo pageInfo = new PageInfo(list);
        rspBO.setRows(list);
        rspBO.setPageNo(reqBO.getPageNo().intValue());
        rspBO.setRecordsTotal((int)pageInfo.getTotal());
        rspBO.setTotal(pageInfo.getPages());
        return rspBO;
    }

    public SearchStopWordsRspBO queryStopWordsDetail(SearchStopWordsReqBO reqBO) throws ZTBusinessException {
        return null;
    }

    public void addStopWordsInfo(SearchStopWordsReqBO reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        this.validateParam(reqBO);
        SearchStopWordsPO searchStopWordsPO = this.searchStopWordsMapper.selectForCheck(reqBO.getStopWord());
        if (searchStopWordsPO != null) {
            throw new ZTBusinessException("\u505c\u7528\u8bcd\u540d\u79f0\u91cd\u590d\uff01");
        }
        SearchStopWordsPO param = new SearchStopWordsPO();
        param.setId(CodeUtil.generateTableCode());
        param.setStopWord(reqBO.getStopWord());
        param.setsStatus(Constants.WORDS_STATE_1);
        param.setCreateTime(new Date());
        param.setUpdateTime(new Date());
        this.searchStopWordsMapper.insertSelective(param);
    }

    public void updateStopWordsInfo(SearchStopWordsReqBO reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        if (reqBO.getId() == null || reqBO.getSStatus() == null || StringUtils.isEmpty((CharSequence)reqBO.getStopWord())) {
            throw new ZTBusinessException("\u53c2\u6570\u5f02\u5e38\uff01");
        }
        if (reqBO.getSStatus() == Constants.WORDS_STATE_1) {
            throw new ZTBusinessException("\u542f\u7528\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\uff01");
        }
        SearchStopWordsPO searchStopWordsPO = this.searchStopWordsMapper.selectByPrimaryKey(reqBO.getId());
        if (searchStopWordsPO == null) {
            throw new ZTBusinessException("\u505c\u7528\u8bcd\u4e0d\u5b58\u5728\uff0c\u6570\u636e\u5f02\u5e38\uff01");
        }
        List check = this.searchStopWordsMapper.selectForCheckUpdate(reqBO.getStopWord(), reqBO.getId());
        if (check != null && check.size() > 0) {
            throw new ZTBusinessException("\u505c\u7528\u8bcd\u540d\u79f0\u91cd\u590d\uff01");
        }
        SearchStopWordsPO param = new SearchStopWordsPO();
        param.setId(reqBO.getId());
        param.setStopWord(reqBO.getStopWord());
        param.setUpdateTime(new Date());
        this.searchStopWordsMapper.updateByPrimaryKeySelective(param);
    }

    public void updateStopWordsStatus(SearchStopWordsReqBO reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        if (reqBO.getId() == null || reqBO.getSStatus() == null) {
            throw new ZTBusinessException("\u53c2\u6570\u5f02\u5e38\uff01");
        }
        SearchStopWordsPO isExist = this.searchStopWordsMapper.selectByPrimaryKey(reqBO.getId());
        if (isExist == null) {
            throw new ZTBusinessException("\u505c\u7528\u8bcd\u4e0d\u5b58\u5728\uff0c\u6570\u636e\u5f02\u5e38\uff01");
        }
        SearchStopWordsPO searchStopWordsPO = new SearchStopWordsPO();
        searchStopWordsPO.setId(reqBO.getId());
        searchStopWordsPO.setsStatus(reqBO.getSStatus());
        searchStopWordsPO.setUpdateTime(new Date());
        this.searchStopWordsMapper.updateStatusByPrimaryKey(searchStopWordsPO);
    }

    public void deleteStopWordsInfo(SearchStopWordsReqBO reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        if (reqBO.getId() == null) {
            throw new ZTBusinessException("\u53c2\u6570\u5f02\u5e38\uff01");
        }
        if (reqBO.getSStatus() == null) {
            throw new ZTBusinessException("\u6570\u636e\u5f02\u5e38\uff01");
        }
        if (reqBO.getSStatus() == Constants.WORDS_STATE_1) {
            throw new ZTBusinessException("\u542f\u7528\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        SearchStopWordsPO searchStopWordsPO = this.searchStopWordsMapper.selectByPrimaryKey(reqBO.getId());
        if (searchStopWordsPO == null) {
            throw new ZTBusinessException("\u505c\u7528\u8bcd\u4e0d\u5b58\u5728\uff0c\u6570\u636e\u5f02\u5e38\uff01");
        }
        this.searchStopWordsMapper.deleteByPrimaryKey(reqBO.getId());
    }

    public ImportStopWordsRspBO importStopWords(List<List<String>> list) throws ZTBusinessException {
        ImportStopWordsRspBO rspBo = new ImportStopWordsRspBO();
        ArrayList<SearchStopWordsBO> errList = new ArrayList<SearchStopWordsBO>();
        int successNums = 0;
        int insertNums = 0;
        int failNums = 0;
        int clistSize = list.size();
        for (int ti = 0; ti < clistSize; ++ti) {
            List<String> row = list.get(ti);
            try {
                SearchStopWordsPO isExist;
                String stopWord = "";
                if (row.size() >= 1) {
                    stopWord = row.get(0).trim();
                }
                if ((isExist = this.searchStopWordsMapper.selectForCheck(stopWord)) != null) {
                    ++failNums;
                    SearchStopWordsBO oBo = new SearchStopWordsBO();
                    oBo.setStopWord(stopWord);
                    oBo.setFailMsg("\u505c\u7528\u8bcd\u540d\u79f0\u91cd\u590d!");
                    errList.add(oBo);
                    continue;
                }
                SearchStopWordsPO param = new SearchStopWordsPO();
                param.setId(CodeUtil.generateTableCode());
                param.setStopWord(stopWord);
                param.setsStatus(Constants.WORDS_STATE_1);
                param.setCreateTime(new Date());
                param.setUpdateTime(new Date());
                this.searchStopWordsMapper.insertSelective(param);
                ++successNums;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                ++failNums;
                SearchStopWordsBO oBo = new SearchStopWordsBO();
                oBo.setFailMsg("\u521b\u5efa\u505c\u7528\u8bcd\u4fe1\u606f\u5f02\u5e38\uff0crow\u6570\u636e\u4e3a\uff1a" + row.toString());
                errList.add(oBo);
            }
        }
        rspBo.setInsertNums(insertNums);
        rspBo.setFailNums(failNums);
        rspBo.setSuccessNums(successNums);
        ArrayList<String> title = new ArrayList<String>();
        title.add("\u505c\u7528\u8bcd\u540d\u79f0");
        title.add("\u5931\u8d25\u539f\u56e0");
        String[] variable = new String[]{"stopWord", "failMsg"};
        String jsonString = "";
        String titleString = "";
        if (errList.size() > 0) {
            Object[][] data = XlsUtil.toArray(errList, (String[])variable);
            jsonString = JSONObject.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
            titleString = JSONObject.toJSONString(title, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        }
        rspBo.setJsonString(jsonString);
        rspBo.setTitleString(titleString);
        ArrayList<TableHeadInfo> tableHeadInfos = new ArrayList<TableHeadInfo>();
        for (int i = 0; i < title.size(); ++i) {
            TableHeadInfo tableHeadInfo1 = new TableHeadInfo();
            tableHeadInfo1.setTitle((String)title.get(i));
            tableHeadInfo1.setDataIndex(variable[i]);
            tableHeadInfos.add(tableHeadInfo1);
        }
        rspBo.setTitleList(tableHeadInfos);
        rspBo.setCode("0");
        rspBo.setMessage("\u5bfc\u5165\u64cd\u4f5c\u7ed3\u675f\uff01");
        rspBo.setFailList(errList);
        return rspBo;
    }

    public ExportInfoRspBO exportStopWords(SearchStopWordsReqBO reqBO) throws ZTBusinessException {
        ExportInfoRspBO rspBO = new ExportInfoRspBO();
        List list = this.searchStopWordsMapper.queryAllStopWordsList(null);
        String[] variable = new String[]{"stopWord"};
        Object[][] data = XlsUtil.toArray((List)list, (String[])variable);
        String jsonString = JSONObject.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        rspBO.setJsonString(jsonString);
        ArrayList<String> title = new ArrayList<String>();
        title.add("\u505c\u7528\u8bcd\u540d\u79f0");
        String titleString = JSONObject.toJSONString(title, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        rspBO.setTitleString(titleString);
        return rspBO;
    }

    public List<SearchStopWordsBO> queryStopWordsList() {
        return this.searchStopWordsMapper.queryAllStopWordsList(Integer.valueOf(1));
    }

    private void validateParam(SearchStopWordsReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getStopWord())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u3010\u8bcd\u8bed\u5185\u5bb9\u3011\u4e3a\u7a7a");
        }
    }
}

