/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.se.manage.api.CacheUpdateService;
import com.tydic.se.manage.api.SearchSynonymWordsService;
import com.tydic.se.manage.bo.ExportInfoRspBO;
import com.tydic.se.manage.bo.ImportSynonymWordsRspBO;
import com.tydic.se.manage.bo.SearchSynonymWordsBO;
import com.tydic.se.manage.bo.SearchSynonymWordsReq;
import com.tydic.se.manage.bo.SearchSynonymWordsRsp;
import com.tydic.se.manage.bo.TableHeadInfo;
import com.tydic.se.manage.constants.Constants;
import com.tydic.se.manage.constants.XlsUtil;
import com.tydic.se.manage.dao.SearchSynonymWordsMapper;
import com.tydic.se.manage.dao.po.SearchSynonymWords;
import com.tydic.se.manage.util.CodeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchSynonymWordsServiceImpl
implements SearchSynonymWordsService {
    private static final Logger log = LoggerFactory.getLogger(SearchSynonymWordsServiceImpl.class);
    @Autowired
    private SearchSynonymWordsMapper searchSynonymWordsMapper;
    @Autowired
    private CacheUpdateService cacheUpdateService;

    public SearchSynonymWordsRsp querySynonymWordsList(SearchSynonymWordsReq reqBO) throws ZTBusinessException {
        SearchSynonymWordsRsp rspBO = new SearchSynonymWordsRsp();
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize());
        List list = new ArrayList();
        try {
            SearchSynonymWordsBO searchSynonymWordsBO = new SearchSynonymWordsBO();
            searchSynonymWordsBO.setType(reqBO.getType());
            searchSynonymWordsBO.setMainWord(reqBO.getMainWord());
            searchSynonymWordsBO.setSStatus(reqBO.getSStatus());
            searchSynonymWordsBO.setFlag(Boolean.valueOf(reqBO.isFlag()));
            list = this.searchSynonymWordsMapper.querySearchSynonymWordsList(searchSynonymWordsBO);
            if (list != null && list.size() > 0) {
                for (SearchSynonymWordsBO s : list) {
                    String wordContent = "";
                    wordContent = s.getType() == 0 ? s.getMainWord() + "=>" + s.getSimWords() + "," + s.getMainWord() : s.getMainWord() + "," + s.getSimWords();
                    s.setWordContent(wordContent);
                    List<String> simWord = Arrays.asList(s.getSimWords().split(","));
                    s.setSimWordList(simWord);
                }
            }
        }
        catch (Exception e) {
            log.error("querySynonymWordsList========>qry\u67e5\u8be2\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u67e5\u8be2\u5217\u8868\u5931\u8d25");
        }
        PageInfo pageInfo = new PageInfo(list);
        rspBO.setRows(list);
        rspBO.setPageNo(reqBO.getPageNo().intValue());
        rspBO.setRecordsTotal((int)pageInfo.getTotal());
        rspBO.setTotal(pageInfo.getPages());
        return rspBO;
    }

    public SearchSynonymWordsRsp querySynonymWordsDetail(SearchSynonymWordsReq reqBO) throws ZTBusinessException {
        return null;
    }

    public void addSynonymWordsInfo(SearchSynonymWordsReq reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        this.validateParam(reqBO);
        SearchSynonymWords isExist = this.searchSynonymWordsMapper.checkMainWordExist(reqBO.getMainWord(), reqBO.getType());
        String simWords = "";
        if (isExist != null) {
            String[] strArr;
            simWords = isExist.getSimWords();
            String[] strArrIsExist = simWords.split(",");
            for (String str : strArr = reqBO.getSimWords().split(",")) {
                if (!Arrays.stream(strArrIsExist).noneMatch(str::equals)) continue;
                simWords = simWords + "," + str;
            }
            SearchSynonymWords searchSynonymWordsPO = new SearchSynonymWords();
            searchSynonymWordsPO.setId(isExist.getId());
            searchSynonymWordsPO.setSimWords(simWords);
            searchSynonymWordsPO.setUpdateTime(new Date());
            this.searchSynonymWordsMapper.updateByPrimaryKeySelective(searchSynonymWordsPO);
            this.cacheUpdateService.updateSynonymWord(isExist.getId());
            return;
        }
        SearchSynonymWords searchSynonymWordsPO = new SearchSynonymWords();
        Long id = CodeUtil.generateTableCode();
        searchSynonymWordsPO.setId(id);
        searchSynonymWordsPO.setMainWord(reqBO.getMainWord());
        searchSynonymWordsPO.setSimWords(reqBO.getSimWords());
        searchSynonymWordsPO.setType(reqBO.getType());
        searchSynonymWordsPO.setsStatus(Constants.WORDS_STATE_1);
        searchSynonymWordsPO.setCreateTime(new Date());
        searchSynonymWordsPO.setUpdateTime(new Date());
        this.searchSynonymWordsMapper.insertSelective(searchSynonymWordsPO);
        this.cacheUpdateService.updateSynonymWord(id);
    }

    public void updateSynonymWordsInfo(SearchSynonymWordsReq reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        if (reqBO.getSStatus() == null) {
            throw new ZTBusinessException("\u6570\u636e\u5f02\u5e38\uff01");
        }
        if (reqBO.getSStatus() == Constants.WORDS_STATE_1) {
            throw new ZTBusinessException("\u542f\u7528\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\uff01");
        }
        this.validateParam(reqBO);
        SearchSynonymWords isExist = this.searchSynonymWordsMapper.selectByPrimaryKey(reqBO.getId());
        if (isExist == null) {
            throw new ZTBusinessException("\u540c\u4e49\u8bcd\u4e0d\u5b58\u5728\uff0c\u6570\u636e\u5f02\u5e38\uff01");
        }
        SearchSynonymWords searchSynonymWordsPO = new SearchSynonymWords();
        searchSynonymWordsPO.setId(reqBO.getId());
        searchSynonymWordsPO.setMainWord(reqBO.getMainWord());
        searchSynonymWordsPO.setSimWords(reqBO.getSimWords());
        searchSynonymWordsPO.setUpdateTime(new Date());
        searchSynonymWordsPO.setType(reqBO.getType());
        this.searchSynonymWordsMapper.updateByPrimaryKeySelective(searchSynonymWordsPO);
    }

    public void updateSynonymWordsStatus(SearchSynonymWordsReq reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        if (reqBO.getId() == null || StringUtils.isEmpty((CharSequence)reqBO.getId().toString())) {
            throw new ZTBusinessException("\u53c2\u6570\u5f02\u5e38\uff01");
        }
        if (reqBO.getSStatus() == null || StringUtils.isEmpty((CharSequence)reqBO.getSStatus().toString())) {
            throw new ZTBusinessException("\u53c2\u6570\u5f02\u5e38\uff01");
        }
        SearchSynonymWords isExist = this.searchSynonymWordsMapper.selectByPrimaryKey(reqBO.getId());
        if (isExist == null) {
            throw new ZTBusinessException("\u540c\u4e49\u8bcd\u4e0d\u5b58\u5728\uff0c\u6570\u636e\u5f02\u5e38\uff01");
        }
        SearchSynonymWords searchSynonymWordsPO = new SearchSynonymWords();
        searchSynonymWordsPO.setId(reqBO.getId());
        searchSynonymWordsPO.setsStatus(reqBO.getSStatus());
        searchSynonymWordsPO.setUpdateTime(new Date());
        this.searchSynonymWordsMapper.updateStatusByPrimaryKey(searchSynonymWordsPO);
        this.cacheUpdateService.updateSynonymWord(reqBO.getId());
    }

    public void deleteSynonymWordsInfo(SearchSynonymWordsReq reqBO) throws ZTBusinessException {
        log.info("\u5165\u53c2\u4fe1\u606f:{}", (Object)reqBO.toString());
        if (StringUtils.isEmpty((CharSequence)reqBO.getId().toString())) {
            throw new ZTBusinessException("\u53c2\u6570\u5f02\u5e38\uff0c\u5220\u9664\u5931\u8d25\uff01");
        }
        if (reqBO.getSStatus() == null) {
            throw new ZTBusinessException("\u6570\u636e\u5f02\u5e38\uff01");
        }
        if (reqBO.getSStatus() == Constants.WORDS_STATE_1) {
            throw new ZTBusinessException("\u542f\u7528\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        SearchSynonymWords isExist = this.searchSynonymWordsMapper.selectByPrimaryKey(reqBO.getId());
        if (isExist == null) {
            throw new ZTBusinessException("\u540c\u4e49\u8bcd\u4e0d\u5b58\u5728\uff0c\u6570\u636e\u5f02\u5e38\uff01");
        }
        this.searchSynonymWordsMapper.deleteByPrimaryKey(reqBO.getId());
        try {
            ArrayList<String> words = new ArrayList<String>();
            words.add(isExist.getMainWord());
            words.addAll(Arrays.asList(isExist.getSimWords().split(",")));
            this.cacheUpdateService.updateSynonymWord(words);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u540c\u4e49\u8bcd\u7f13\u5b58\u5931\u8d25\uff01err:{}", (Object)e.getMessage());
        }
    }

    public ImportSynonymWordsRspBO importSynonymWords(List<List<String>> list) throws ZTBusinessException {
        ImportSynonymWordsRspBO rspBo = new ImportSynonymWordsRspBO();
        ArrayList<SearchSynonymWordsBO> errList = new ArrayList<SearchSynonymWordsBO>();
        int successNums = 0;
        int insertNums = 0;
        int failNums = 0;
        ArrayList<String> mainWords = new ArrayList<String>();
        int clistSize = list.size();
        for (int ti = 0; ti < clistSize; ++ti) {
            List<String> row = list.get(ti);
            try {
                SearchSynonymWordsBO oBo;
                String type = "";
                String mainWord = "";
                String simWords = "";
                if (row.size() >= 1) {
                    type = row.get(0).trim();
                }
                if (row.size() >= 2) {
                    mainWord = row.get(1).trim();
                }
                if (row.size() >= 3) {
                    simWords = row.get(2).trim();
                }
                if (type == null || "".equals(type)) {
                    ++failNums;
                    oBo = new SearchSynonymWordsBO();
                    oBo.setTypeDesc(type);
                    oBo.setMainWord(mainWord);
                    oBo.setSimWords(simWords);
                    oBo.setFailMsg("\u8bcd\u8bed\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
                    errList.add(oBo);
                    continue;
                }
                if (mainWord == null || "".equals(mainWord)) {
                    ++failNums;
                    oBo = new SearchSynonymWordsBO();
                    oBo.setTypeDesc(type);
                    oBo.setMainWord(mainWord);
                    oBo.setSimWords(simWords);
                    oBo.setFailMsg("\u4e3b\u8bcd\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!");
                    errList.add(oBo);
                    continue;
                }
                if (simWords == null || "".equals(simWords)) {
                    ++failNums;
                    oBo = new SearchSynonymWordsBO();
                    oBo.setTypeDesc(type);
                    oBo.setMainWord(mainWord);
                    oBo.setSimWords(simWords);
                    oBo.setFailMsg("\u540c\u4e49\u8bcd\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!");
                    errList.add(oBo);
                    continue;
                }
                SearchSynonymWords isExist = this.searchSynonymWordsMapper.checkMainWordExist(mainWord, Integer.valueOf("\u5355\u5411".equals(type) ? 0 : 1));
                String simWordsExist = "";
                if (isExist != null) {
                    String[] strArr;
                    simWordsExist = isExist.getSimWords();
                    String[] strArrIsExist = simWordsExist.split(",");
                    for (String str : strArr = simWords.split(",")) {
                        if (!Arrays.stream(strArrIsExist).noneMatch(str::equals)) continue;
                        simWordsExist = simWordsExist + "," + str;
                    }
                    SearchSynonymWords searchSynonymWordsPO = new SearchSynonymWords();
                    searchSynonymWordsPO.setId(isExist.getId());
                    searchSynonymWordsPO.setSimWords(simWordsExist);
                    searchSynonymWordsPO.setUpdateTime(new Date());
                    this.searchSynonymWordsMapper.updateByPrimaryKeySelective(searchSynonymWordsPO);
                    if (mainWords.stream().noneMatch(mainWord::equals)) {
                        mainWords.add(mainWord);
                    }
                    ++successNums;
                    continue;
                }
                SearchSynonymWords searchSynonymWordsPO = new SearchSynonymWords();
                searchSynonymWordsPO.setId(CodeUtil.generateTableCode());
                searchSynonymWordsPO.setMainWord(mainWord);
                searchSynonymWordsPO.setSimWords(simWords);
                searchSynonymWordsPO.setType(Integer.valueOf("\u5355\u5411".equals(type) ? 0 : 1));
                searchSynonymWordsPO.setsStatus(Constants.WORDS_STATE_1);
                searchSynonymWordsPO.setCreateTime(new Date());
                searchSynonymWordsPO.setUpdateTime(new Date());
                this.searchSynonymWordsMapper.insertSelective(searchSynonymWordsPO);
                if (mainWords.stream().noneMatch(mainWord::equals)) {
                    mainWords.add(mainWord);
                }
                ++successNums;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                ++failNums;
                SearchSynonymWordsBO oBo = new SearchSynonymWordsBO();
                oBo.setFailMsg("\u521b\u5efa\u540c\u4e49\u8bcd\u4fe1\u606f\u5f02\u5e38\uff0crow\u6570\u636e\u4e3a\uff1a" + row.toString());
                errList.add(oBo);
            }
        }
        if (successNums < 100) {
            this.cacheUpdateService.updateSynonymWord(mainWords);
        } else {
            this.cacheUpdateService.initSyncCache(Integer.valueOf(6));
        }
        rspBo.setInsertNums(insertNums);
        rspBo.setFailNums(failNums);
        rspBo.setSuccessNums(successNums);
        ArrayList<String> title = new ArrayList<String>();
        title.add("\u540c\u4e49\u8bcd\u7c7b\u578b");
        title.add("\u4e3b\u8bcd\u540d\u79f0");
        title.add("\u540c\u4e49\u8bcd\u5185\u5bb9");
        title.add("\u5931\u8d25\u539f\u56e0");
        String[] variable = new String[]{"typeDesc", "mainWord", "simWords", "failMsg"};
        String jsonString = "";
        String titleString = "";
        if (errList.size() > 0) {
            Object[][] data = XlsUtil.toArray(errList, (String[])variable);
            jsonString = JSONObject.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
            titleString = JSONObject.toJSONString(title, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        }
        rspBo.setJsonString(jsonString);
        rspBo.setTitleString(titleString);
        ArrayList<TableHeadInfo> tableHeadInfos = new ArrayList<TableHeadInfo>();
        for (int i = 0; i < title.size(); ++i) {
            TableHeadInfo tableHeadInfo1 = new TableHeadInfo();
            tableHeadInfo1.setTitle((String)title.get(i));
            tableHeadInfo1.setDataIndex(variable[i]);
            tableHeadInfos.add(tableHeadInfo1);
        }
        rspBo.setTitleList(tableHeadInfos);
        rspBo.setCode("0");
        rspBo.setMessage("\u5bfc\u5165\u64cd\u4f5c\u7ed3\u675f\uff01");
        rspBo.setFailList(errList);
        return rspBo;
    }

    public ExportInfoRspBO exportSynonymWords(SearchSynonymWordsReq reqBO) throws ZTBusinessException {
        ExportInfoRspBO rspBO = new ExportInfoRspBO();
        List list = this.searchSynonymWordsMapper.queryAllSynonymWordsList();
        String[] variable = new String[]{"typeDesc", "mainWord", "simWords"};
        Object[][] data = XlsUtil.toArray((List)list, (String[])variable);
        String jsonString = JSONObject.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        rspBO.setJsonString(jsonString);
        ArrayList<String> title = new ArrayList<String>();
        title.add("\u540c\u4e49\u8bcd\u7c7b\u578b");
        title.add("\u4e3b\u8bcd\u540d\u79f0");
        title.add("\u540c\u4e49\u8bcd\u5185\u5bb9");
        String titleString = JSONObject.toJSONString(title, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        rspBO.setTitleString(titleString);
        return rspBO;
    }

    private void validateParam(SearchSynonymWordsReq reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getMainWord())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u3010\u4e3b\u8bcd\u540d\u79f0\u3011\u4e3a\u7a7a");
        }
        if (reqBO.getType() == null || StringUtils.isEmpty((CharSequence)reqBO.getType().toString())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u3010\u8bcd\u8bed\u7c7b\u578b\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getSimWords())) {
            throw new ZTBusinessException("\u5fc5\u4f20\u53c2\u6570\u3010\u8bcd\u8bed\u5185\u5bb9\u3011\u4e3a\u7a7a");
        }
    }

    public SearchSynonymWordsRsp querySynonymWordsList() throws ZTBusinessException {
        List list;
        SearchSynonymWordsRsp rspBO = new SearchSynonymWordsRsp();
        try {
            list = this.searchSynonymWordsMapper.querySynonymWordsList();
            if (list != null && list.size() > 0) {
                for (SearchSynonymWordsBO s : list) {
                    String wordContent = "";
                    wordContent = s.getType() == 0 ? s.getMainWord() + "=>" + s.getSimWords() + "," + s.getMainWord() : s.getMainWord() + "," + s.getSimWords();
                    s.setWordContent(wordContent);
                }
            }
        }
        catch (Exception e) {
            log.error("querySynonymWordsList========>qry\u67e5\u8be2\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u67e5\u8be2\u5217\u8868\u5931\u8d25");
        }
        rspBO.setRows(list);
        return rspBO;
    }

    public void synonymWordsSync(Map<String, Set<String>> wordsMap) {
        if (wordsMap.isEmpty()) {
            throw new ZTBusinessException("\u5165\u53c2\u4e3a\u7a7a");
        }
        for (String mainWord : wordsMap.keySet()) {
            Set<String> simWords = wordsMap.get(mainWord);
            SearchSynonymWords isExist = this.searchSynonymWordsMapper.checkMainWordExist(mainWord, Constants.SYNONYM_STATE_1);
            String simWordsExist = "";
            if (isExist != null) {
                simWordsExist = isExist.getSimWords();
                String[] strArrIsExist = simWordsExist.split(",");
                for (String string : simWords) {
                    if (!Arrays.stream(strArrIsExist).noneMatch(string::equals)) continue;
                    simWordsExist = simWordsExist + "," + string;
                }
                SearchSynonymWords searchSynonymWordsPO = new SearchSynonymWords();
                searchSynonymWordsPO.setId(isExist.getId());
                searchSynonymWordsPO.setSimWords(simWordsExist);
                searchSynonymWordsPO.setUpdateTime(new Date());
                this.searchSynonymWordsMapper.updateByPrimaryKeySelective(searchSynonymWordsPO);
                this.cacheUpdateService.updateSynonymWord(isExist.getId());
                return;
            }
            SearchSynonymWords searchSynonymWordsPO = new SearchSynonymWords();
            String addSimWords = "";
            if (simWords != null && simWords.size() > 0) {
                for (String str2 : simWords) {
                    addSimWords = addSimWords + str2 + ",";
                }
                addSimWords = addSimWords.substring(0, addSimWords.length() - 1);
            }
            Long l = CodeUtil.generateTableCode();
            searchSynonymWordsPO.setId(l);
            searchSynonymWordsPO.setMainWord(mainWord);
            searchSynonymWordsPO.setSimWords(addSimWords);
            searchSynonymWordsPO.setType(Constants.SYNONYM_STATE_1);
            searchSynonymWordsPO.setsStatus(Constants.WORDS_STATE_1);
            searchSynonymWordsPO.setCreateTime(new Date());
            searchSynonymWordsPO.setUpdateTime(new Date());
            this.searchSynonymWordsMapper.insertSelective(searchSynonymWordsPO);
            this.cacheUpdateService.updateSynonymWord(l);
        }
    }
}

