/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.impl;

import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.se.manage.api.CacheUpdateService;
import com.tydic.se.manage.api.SearchThreeCatalogService;
import com.tydic.se.manage.bo.AddCatalogInfoReqBO;
import com.tydic.se.manage.bo.AddCatalogMappingReqBO;
import com.tydic.se.manage.bo.AddCatalogTreeBO;
import com.tydic.se.manage.bo.CatalogMappingTreeBO;
import com.tydic.se.manage.bo.CatalogTreeBO;
import com.tydic.se.manage.bo.ChangeCatalogOrderReqBO;
import com.tydic.se.manage.bo.ChangeCatalogStatusReqBO;
import com.tydic.se.manage.bo.QryAddCatalogListRspBO;
import com.tydic.se.manage.bo.QryCatalogListReqBO;
import com.tydic.se.manage.bo.QryCatalogListRspBO;
import com.tydic.se.manage.bo.QryCatalogTreeReqBO;
import com.tydic.se.manage.bo.QryCatalogTreeRspBO;
import com.tydic.se.manage.bo.UpdateCatalogInfoReqBO;
import com.tydic.se.manage.dao.IndexSyncCustomMapper;
import com.tydic.se.manage.dao.SearchCatalogRecordMapper;
import com.tydic.se.manage.dao.SearchExtCatalogConfigRecordDao;
import com.tydic.se.manage.dao.SearchExtCatalogRecordMapper;
import com.tydic.se.manage.dao.po.SearchCatalogRecord;
import com.tydic.se.manage.dao.po.SearchExtCatalogConfigRecordPO;
import com.tydic.se.manage.dao.po.SearchExtCatalogRecordPO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.CollectionUtils;

@Service
public class SearchThreeCatalogServiceImpl
implements SearchThreeCatalogService {
    private static final Logger log = LoggerFactory.getLogger(SearchThreeCatalogServiceImpl.class);
    @Autowired
    private SearchCatalogRecordMapper searchCatalogRecordDao;
    @Autowired
    private SearchExtCatalogConfigRecordDao extCatalogConfigRecordDao;
    @Autowired
    private SearchExtCatalogRecordMapper extCatalogRecordDao;
    @Autowired
    private CacheUpdateService cacheUpdateService;
    @Autowired
    private IndexSyncCustomMapper indexSyncCustomMapper;

    public QryCatalogListRspBO queryCatalogList(QryCatalogListReqBO reqBO) throws ZTBusinessException {
        List catalogRecordPOList;
        QryCatalogListRspBO rspBO = new QryCatalogListRspBO();
        ArrayList<CatalogTreeBO> retList = new ArrayList<CatalogTreeBO>();
        List allCataLogList = this.extCatalogRecordDao.selectAllCatalogData(null);
        if (allCataLogList != null && allCataLogList.size() > 0 && (catalogRecordPOList = allCataLogList.stream().filter(catalog -> catalog.getExtPCId().equals("-1")).collect(Collectors.toList())) != null && catalogRecordPOList.size() > 0) {
            Integer len = catalogRecordPOList.size();
            Integer maxOrder = ((SearchExtCatalogRecordPO)catalogRecordPOList.get(len - 1)).getOrder();
            Integer minOrder = ((SearchExtCatalogRecordPO)catalogRecordPOList.get(0)).getOrder();
            for (SearchExtCatalogRecordPO parent : catalogRecordPOList) {
                CatalogTreeBO rsp = new CatalogTreeBO();
                rsp.setKey(parent.getExtCId() + "");
                rsp.setCategoryCode(parent.getExtCId());
                rsp.setCategoryName(parent.getExtCName());
                rsp.setOrder(parent.getOrder());
                rsp.setCLevel(parent.getExtCLevel());
                rsp.setUpdateTime(parent.getUpdateTime());
                rsp.setCStatus(parent.getExtCStatus());
                rsp.setCDesc(parent.getExtCDesc());
                rsp.setPrentName("");
                rsp.setPrentId("-1");
                Integer order = rsp.getOrder();
                if (len == 1) {
                    rsp.setIsUp(Boolean.valueOf(false));
                    rsp.setIsDown(Boolean.valueOf(false));
                } else if (len > 1 && order == maxOrder) {
                    rsp.setIsUp(Boolean.valueOf(true));
                    rsp.setIsDown(Boolean.valueOf(false));
                } else if (len > 1 && order == minOrder) {
                    rsp.setIsUp(Boolean.valueOf(false));
                    rsp.setIsDown(Boolean.valueOf(true));
                } else {
                    rsp.setIsUp(Boolean.valueOf(true));
                    rsp.setIsDown(Boolean.valueOf(true));
                }
                List<CatalogTreeBO> filed = this.findChildren(parent.getExtCId(), parent.getExtCName(), allCataLogList, null);
                rsp.setChildren(filed);
                retList.add(rsp);
            }
        }
        if (!StringUtils.isEmpty((String)reqBO.getCName())) {
            this.treeMatchName(retList, reqBO.getCName());
        }
        if (reqBO.getCStatus() != null) {
            this.treeMatchStatus(retList, reqBO.getCStatus());
        }
        log.debug("\u76ee\u5f55tree" + retList);
        rspBO.setRows(retList);
        return rspBO;
    }

    private List<CatalogTreeBO> findChildren(String cId, String cPName, List<SearchExtCatalogRecordPO> cataLogList, Integer level) {
        List catalogRecordPOList;
        ArrayList<CatalogTreeBO> retList = new ArrayList<CatalogTreeBO>();
        if (cataLogList != null && cataLogList.size() > 0 && (catalogRecordPOList = cataLogList.stream().filter(catalog -> catalog.getExtPCId().equals(cId)).collect(Collectors.toList())) != null && catalogRecordPOList.size() > 0) {
            Integer len = catalogRecordPOList.size();
            Integer maxOrder = ((SearchExtCatalogRecordPO)catalogRecordPOList.get(len - 1)).getOrder();
            Integer minOrder = ((SearchExtCatalogRecordPO)catalogRecordPOList.get(0)).getOrder();
            Map relMap = null;
            if (level != null && level == 2) {
                relMap = this.extCatalogConfigRecordDao.selectMapByExtCId();
            }
            for (SearchExtCatalogRecordPO parent : catalogRecordPOList) {
                Map fourCatalog;
                CatalogTreeBO rsp = new CatalogTreeBO();
                rsp.setKey(parent.getExtCId() + "");
                rsp.setCategoryCode(parent.getExtCId());
                rsp.setCategoryName(parent.getExtCName());
                rsp.setOrder(parent.getOrder());
                rsp.setCLevel(parent.getExtCLevel());
                rsp.setUpdateTime(parent.getUpdateTime());
                rsp.setCStatus(parent.getExtCStatus());
                rsp.setCDesc(parent.getExtCDesc());
                rsp.setPrentName(cPName);
                rsp.setPrentId(cId);
                Integer order = rsp.getOrder();
                if (len == 1) {
                    rsp.setIsUp(Boolean.valueOf(false));
                    rsp.setIsDown(Boolean.valueOf(false));
                } else if (len > 1 && order == maxOrder) {
                    rsp.setIsUp(Boolean.valueOf(true));
                    rsp.setIsDown(Boolean.valueOf(false));
                } else if (len > 1 && order == minOrder) {
                    rsp.setIsUp(Boolean.valueOf(false));
                    rsp.setIsDown(Boolean.valueOf(true));
                } else {
                    rsp.setIsUp(Boolean.valueOf(true));
                    rsp.setIsDown(Boolean.valueOf(true));
                }
                if (parent.getExtCLevel() == 3 && relMap != null && (fourCatalog = (Map)relMap.get(parent.getExtCId())) != null) {
                    rsp.setFourCatalog(fourCatalog.get("extCName").toString());
                }
                List<CatalogTreeBO> filed = this.findChildren(parent.getExtCId(), parent.getExtCName(), cataLogList, parent.getExtCLevel());
                rsp.setChildren(filed);
                retList.add(rsp);
            }
        }
        return retList;
    }

    public void treeMatchName(List<CatalogTreeBO> anyLevelCategoryList, String keyword) {
        Iterator<CatalogTreeBO> iter = anyLevelCategoryList.iterator();
        while (iter.hasNext()) {
            CatalogTreeBO category = iter.next();
            if (category.getCategoryName().contains(keyword)) continue;
            List childrenCategoryList = category.getChildren();
            if (!CollectionUtils.isEmpty((Collection)childrenCategoryList)) {
                this.treeMatchName(childrenCategoryList, keyword);
            }
            if (!CollectionUtils.isEmpty((Collection)category.getChildren())) continue;
            iter.remove();
        }
    }

    public void treeMatchStatus(List<CatalogTreeBO> anyLevelCategoryList, Integer status) {
        Iterator<CatalogTreeBO> iter = anyLevelCategoryList.iterator();
        while (iter.hasNext()) {
            CatalogTreeBO category = iter.next();
            if (category.getCStatus() == status) continue;
            List childrenCategoryList = category.getChildren();
            if (!CollectionUtils.isEmpty((Collection)childrenCategoryList)) {
                this.treeMatchStatus(childrenCategoryList, status);
            }
            if (!CollectionUtils.isEmpty((Collection)category.getChildren())) continue;
            iter.remove();
        }
    }

    public void changeCatalogOrderDown(ChangeCatalogOrderReqBO changeMenuOrderReqBO) throws ZTBusinessException {
        try {
            SearchExtCatalogRecordPO cPO = this.extCatalogRecordDao.selectByPrimaryKey(changeMenuOrderReqBO.getCatalogId());
            SearchExtCatalogRecordPO downPO = this.extCatalogRecordDao.selectDownOrderCatalog(cPO.getExtPCId(), cPO.getOrder());
            if (downPO != null) {
                SearchExtCatalogRecordPO rec = new SearchExtCatalogRecordPO();
                rec.setExtCId(cPO.getExtCId());
                rec.setOrder(downPO.getOrder());
                this.extCatalogRecordDao.updateOrderByPrimaryKey(rec);
                SearchExtCatalogRecordPO rec2 = new SearchExtCatalogRecordPO();
                rec2.setExtCId(downPO.getExtCId());
                rec2.setOrder(cPO.getOrder());
                this.extCatalogRecordDao.updateOrderByPrimaryKey(rec2);
            }
        }
        catch (Exception e) {
            log.error(" \u4e0b\u79fb\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u4e0b\u79fb\u5931\u8d25");
        }
    }

    public void changeCatalogOrderUp(ChangeCatalogOrderReqBO changeMenuOrderReqBO) throws ZTBusinessException {
        try {
            SearchExtCatalogRecordPO cPO = this.extCatalogRecordDao.selectByPrimaryKey(changeMenuOrderReqBO.getCatalogId());
            SearchExtCatalogRecordPO upPO = this.extCatalogRecordDao.selectUpOrderCatalog(cPO.getExtPCId(), cPO.getOrder());
            if (upPO != null) {
                SearchExtCatalogRecordPO rec = new SearchExtCatalogRecordPO();
                rec.setExtCId(cPO.getExtCId());
                rec.setOrder(upPO.getOrder());
                this.extCatalogRecordDao.updateOrderByPrimaryKey(rec);
                SearchExtCatalogRecordPO rec2 = new SearchExtCatalogRecordPO();
                rec2.setExtCId(upPO.getExtCId());
                rec2.setOrder(cPO.getOrder());
                this.extCatalogRecordDao.updateOrderByPrimaryKey(rec2);
            }
        }
        catch (Exception e) {
            log.error("\u4e0a\u79fb\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u4e0a\u79fb\u5931\u8d25");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteCatalog(ChangeCatalogOrderReqBO changeMenuOrderReqBO) throws ZTBusinessException {
        SearchExtCatalogRecordPO isExist = this.extCatalogRecordDao.selectByPrimaryKey(changeMenuOrderReqBO.getCatalogId());
        if (isExist == null) {
            throw new ZTBusinessException("\u4e0d\u5b58\u5728\uff0c\u6570\u636e\u5f02\u5e38\uff01");
        }
        if (isExist.getExtCStatus() == 1) {
            throw new ZTBusinessException("\u542f\u7528\u72b6\u6001\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        List menus = this.extCatalogRecordDao.selectCatalogData(changeMenuOrderReqBO.getCatalogId(), null);
        if (menus != null && menus.size() > 0) {
            throw new ZTBusinessException("\u8be5\u76ee\u5f55\u6709\u4e0b\u7ea7\u76ee\u5f55\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        try {
            this.extCatalogRecordDao.deleteByPrimaryKey(changeMenuOrderReqBO.getCatalogId());
            this.extCatalogConfigRecordDao.deleteByExtCId(changeMenuOrderReqBO.getCatalogId());
            this.cacheUpdateService.syncExtThreeCatalog();
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u5220\u9664\u5931\u8d25");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateByCatalogId(UpdateCatalogInfoReqBO updateByMenuIdReqBO) {
        try {
            SearchExtCatalogRecordPO po = new SearchExtCatalogRecordPO();
            po.setExtCId(updateByMenuIdReqBO.getCId());
            po.setExtCDesc(updateByMenuIdReqBO.getCDesc());
            po.setUpdateTime(new Date());
            this.extCatalogRecordDao.updateByPrimaryKeySelective(po);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u66f4\u65b0\u5931\u8d25");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void addCatalog(AddCatalogInfoReqBO addCatalogInfoReqBO) {
        SearchExtCatalogRecordPO namePO = this.extCatalogRecordDao.selectByCName(addCatalogInfoReqBO.getCName(), addCatalogInfoReqBO.getPCId());
        if (namePO == null) {
            try {
                Sequence sequence = Sequence.getInstance();
                long l = sequence.nextId();
                SearchExtCatalogRecordPO po = new SearchExtCatalogRecordPO();
                po.setExtCName(addCatalogInfoReqBO.getCName());
                po.setExtCDesc(addCatalogInfoReqBO.getCDesc());
                po.setExtCLevel(addCatalogInfoReqBO.getCLevel());
                po.setExtPCId(addCatalogInfoReqBO.getPCId());
                po.setExtCId(l + "");
                po.setExtCStatus(Integer.valueOf(1));
                po.setCreateTime(new Date());
                po.setUpdateTime(new Date());
                this.extCatalogRecordDao.insert(po);
                this.cacheUpdateService.syncExtThreeCatalog();
            }
            catch (Exception e) {
                log.error("\u65b0\u589e\u5931\u8d25", (Throwable)e);
                throw new ZTBusinessException("\u65b0\u589e\u5931\u8d25");
            }
        } else {
            throw new ZTBusinessException("\u7c7b\u76ee\u540d\u79f0\u5df2\u5b58\u5728");
        }
    }

    public void changeCatalogStatus(ChangeCatalogStatusReqBO reqBO) {
        try {
            this.extCatalogRecordDao.changeFourCatalogStatus(reqBO.getCId(), reqBO.getCStatus());
            SearchExtCatalogRecordPO parent = this.extCatalogRecordDao.selectByPrimaryKey(reqBO.getCId());
            Integer startStatus = reqBO.getCStatus();
            Integer upStatus = null;
            upStatus = reqBO.getCStatus() == 0 ? Integer.valueOf(1) : Integer.valueOf(0);
            if (parent.getExtCLevel() < 3) {
                this.findChildren(reqBO.getCId(), startStatus, upStatus);
            }
            this.cacheUpdateService.syncExtThreeCatalog();
            this.cacheUpdateService.initSyncCache(Integer.valueOf(2));
        }
        catch (Exception e) {
            log.error("\u5207\u6362\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u5207\u6362\u5931\u8d25");
        }
    }

    private void findChildren(String cId, Integer startStatus, Integer upStatus) {
        List cataLogList = this.extCatalogRecordDao.selectCatalogData(cId, upStatus);
        if (cataLogList != null && cataLogList.size() > 0) {
            this.extCatalogRecordDao.updateByCaralogIdList(cataLogList, startStatus);
            for (SearchExtCatalogRecordPO parent : cataLogList) {
                if (parent.getExtCLevel() >= 3) continue;
                this.findChildren(parent.getExtCId(), startStatus, upStatus);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void addCatalogMappping(AddCatalogMappingReqBO reqBO) {
        try {
            List cNameList = this.extCatalogConfigRecordDao.selectNameByExtCId(reqBO.getExtCId());
            this.extCatalogConfigRecordDao.deleteByExtCId(reqBO.getExtCId());
            ArrayList<SearchExtCatalogConfigRecordPO> poList = new ArrayList<SearchExtCatalogConfigRecordPO>();
            final Set<Object> setList = cNameList != null && cNameList.size() > 0 ? this.ListToSet(cNameList) : new HashSet();
            if (reqBO.getCIdLIst() != null && reqBO.getCIdLIst().size() > 0) {
                for (String cId : reqBO.getCIdLIst()) {
                    SearchCatalogRecord fourPO = this.searchCatalogRecordDao.selectByPrimaryKey(cId);
                    setList.add(fourPO.getCName());
                    SearchExtCatalogConfigRecordPO po = new SearchExtCatalogConfigRecordPO();
                    Sequence sequence = Sequence.getInstance();
                    long key = sequence.nextId();
                    po.setConfId(Long.valueOf(key));
                    po.setCId(cId);
                    poList.add(po);
                }
                this.extCatalogConfigRecordDao.addCatalogMappping(reqBO.getExtCId(), poList);
            }
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    SearchThreeCatalogServiceImpl.this.cacheUpdateService.bathLinkFourCatalog(setList);
                }
            });
        }
        catch (Exception e) {
            log.error("\u5173\u8054\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u5173\u8054\u5931\u8d25");
        }
    }

    public Set<String> ListToSet(List<String> list) {
        String[] strings1 = new String[list.size()];
        list.toArray(strings1);
        String[] strings2 = list.toArray(new String[0]);
        HashSet<String> set = new HashSet<String>(Arrays.asList(strings2));
        return set;
    }

    public QryCatalogTreeRspBO queryMappingCatalogTree(QryCatalogTreeReqBO reqBO) {
        QryCatalogTreeRspBO rspBO = new QryCatalogTreeRspBO();
        ArrayList<CatalogMappingTreeBO> retList = new ArrayList<CatalogMappingTreeBO>();
        List allCataLogList = this.searchCatalogRecordDao.selectAllCatalogData(Integer.valueOf(1));
        if (allCataLogList != null && allCataLogList.size() > 0) {
            for (SearchCatalogRecord parent : allCataLogList) {
                if (!parent.getPCId().equals("-1")) continue;
                CatalogMappingTreeBO rsp = new CatalogMappingTreeBO();
                rsp.setKey(parent.getCId() + "");
                rsp.setValue(parent.getCId() + "");
                rsp.setTitle(parent.getCName());
                rsp.setOrder(parent.getOrder());
                rsp.setCLevel(parent.getCLevel());
                rsp.setUpdateTime(parent.getUpdateTime());
                List<CatalogMappingTreeBO> filed = this.findMappingChildren(parent.getCId(), allCataLogList);
                rsp.setChildren(filed);
                retList.add(rsp);
            }
        }
        log.debug("\u76ee\u5f55tree" + retList);
        rspBO.setRows(retList);
        List selectedIdList = this.extCatalogConfigRecordDao.selectListByExtCId(reqBO.getExtCId());
        if (selectedIdList != null) {
            rspBO.setSelectedIdList(selectedIdList);
        }
        return rspBO;
    }

    public QryAddCatalogListRspBO queryAddCatalogList(QryCatalogListReqBO reqBO) {
        QryAddCatalogListRspBO rspBO = new QryAddCatalogListRspBO();
        ArrayList<AddCatalogTreeBO> retList = new ArrayList<AddCatalogTreeBO>();
        List allCataLogList = this.extCatalogRecordDao.selectAllCatalogData(Integer.valueOf(1));
        if (allCataLogList != null && allCataLogList.size() > 0) {
            for (SearchExtCatalogRecordPO parent : allCataLogList) {
                if (!parent.getExtPCId().equals("-1")) continue;
                AddCatalogTreeBO rsp = new AddCatalogTreeBO();
                rsp.setKey(parent.getExtCId() + "");
                rsp.setValue(parent.getExtCId());
                rsp.setTitle(parent.getExtCName());
                rsp.setOrder(parent.getOrder());
                rsp.setCLevel(parent.getExtCLevel());
                List<AddCatalogTreeBO> filed = this.findAddChildren(parent.getExtCId(), allCataLogList);
                rsp.setChildren(filed);
                retList.add(rsp);
            }
        }
        log.debug("\u76ee\u5f55tree" + retList);
        rspBO.setRows(retList);
        return rspBO;
    }

    private List<AddCatalogTreeBO> findAddChildren(String cId, List<SearchExtCatalogRecordPO> allCataLogList) {
        ArrayList<AddCatalogTreeBO> retList = new ArrayList<AddCatalogTreeBO>();
        if (allCataLogList != null && allCataLogList.size() > 0) {
            for (SearchExtCatalogRecordPO parent : allCataLogList) {
                if (!parent.getExtPCId().equals(cId)) continue;
                AddCatalogTreeBO rsp = new AddCatalogTreeBO();
                rsp.setKey(parent.getExtCId() + "");
                rsp.setValue(parent.getExtCId());
                rsp.setTitle(parent.getExtCName());
                rsp.setOrder(parent.getOrder());
                rsp.setCLevel(parent.getExtCLevel());
                if (parent.getExtCLevel() < 2) {
                    List<AddCatalogTreeBO> filed = this.findAddChildren(parent.getExtCId(), allCataLogList);
                    rsp.setChildren(filed);
                }
                retList.add(rsp);
            }
        }
        return retList;
    }

    private List<CatalogMappingTreeBO> findMappingChildren(String cId, List<SearchCatalogRecord> allCataLogList) {
        ArrayList<CatalogMappingTreeBO> retList = new ArrayList<CatalogMappingTreeBO>();
        if (allCataLogList != null && allCataLogList.size() > 0) {
            for (SearchCatalogRecord parent : allCataLogList) {
                if (!parent.getPCId().equals(cId)) continue;
                CatalogMappingTreeBO rsp = new CatalogMappingTreeBO();
                rsp.setKey(parent.getCId() + "");
                rsp.setValue(parent.getCId() + "");
                rsp.setTitle(parent.getCName());
                rsp.setCLevel(parent.getCLevel());
                rsp.setUpdateTime(parent.getUpdateTime());
                if (parent.getCLevel() == 4) {
                    rsp.setSelectable(Boolean.valueOf(true));
                }
                List<CatalogMappingTreeBO> filed = this.findMappingChildren(parent.getCId(), allCataLogList);
                rsp.setChildren(filed);
                retList.add(rsp);
            }
        }
        return retList;
    }
}

