/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Record;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.se.manage.api.SearchResultService;
import com.tydic.se.manage.bo.SearchRecordReqBO;
import com.tydic.se.manage.bo.SearchResultUseActionBO;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserActionServiceImpl
implements SearchResultService {
    private static final Logger log = LoggerFactory.getLogger(UserActionServiceImpl.class);
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${spring.datasource.driver-class-name}")
    private String driverName;

    @Transactional
    public String insertSearchRecord(SearchRecordReqBO reqBO) {
        reqBO.setUserId(Long.valueOf(1L));
        Long searchId = 0L;
        Long traceId = Sequence.getInstance().nextId();
        if (this.cacheClient.get("{SEARCH}_USER_ACTION_" + reqBO.getUserId()) == null) {
            searchId = Sequence.getInstance().nextId();
            HashMap<String, Object> rMap = new HashMap<String, Object>();
            rMap.put("queryStr", reqBO.getQueryStr());
            rMap.put("searchId", searchId);
            rMap.put("traceId", traceId);
            this.cacheClient.set("{SEARCH}_USER_ACTION_" + reqBO.getUserId(), (Object)JSON.toJSONString(rMap));
        } else {
            String info = this.cacheClient.get("{SEARCH}_USER_ACTION_" + reqBO.getUserId()).toString();
            JSONObject infoMap = JSON.parseObject((String)info);
            String queryStr = infoMap.get("queryStr").toString();
            if (reqBO.getQueryStr().equals(queryStr)) {
                searchId = Long.valueOf(infoMap.get("searchId").toString());
                infoMap.put("traceId", traceId);
                this.cacheClient.set("{SEARCH}_USER_ACTION_" + reqBO.getUserId(), (Object)JSON.toJSONString((Object)infoMap));
            } else {
                searchId = Sequence.getInstance().nextId();
                HashMap<String, Object> rMap = new HashMap<String, Object>();
                rMap.put("queryStr", reqBO.getQueryStr());
                rMap.put("searchId", searchId);
                rMap.put("traceId", traceId);
                this.cacheClient.set("{SEARCH}_USER_ACTION_" + reqBO.getUserId(), (Object)JSON.toJSONString(rMap));
            }
        }
        try {
            String insertSql;
            String filter = reqBO.getQueryFilterList() == null ? "[]" : reqBO.getQueryFilterList();
            filter = filter.replace("\"filterName\":\"\u54c1\u724c\u540d\u79f0\"", "\"filterName\":\"\u54c1\u724c\"");
            filter = filter.replace("\"filterName\":\"\u4e09\u7ea7\u7c7b\u76ee\u540d\u79f0\"", "\"filterName\":\"\u5206\u7c7b\"");
            filter = filter.replace("\"filterName\":\"\u4f9b\u5e94\u5546\u540d\u79f0\"", "\"filterName\":\"\u4f9b\u5e94\u5546\"");
            Record record = new Record();
            record.set("TRACE_ID", (Object)traceId);
            record.set("SEARCH_ID", (Object)searchId);
            record.set("CREATE_TIME", (Object)new Date());
            record.set("PAGE_NO", (Object)reqBO.getPageNo());
            record.set("PAGE_SIZE", (Object)reqBO.getPageSize());
            record.set("QUERY_STR", (Object)reqBO.getQueryStr());
            record.set("USER_PERMISSION", (Object)"22");
            record.set("QUERY_FILTER_LIST", (Object)filter);
            record.set("USER_ID", (Object)(reqBO.getUserId() + ""));
            if (this.driverName.contains("dm")) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String createTime = sdf.format(new Date());
                String queryStr = reqBO.getQueryStr() != null ? reqBO.getQueryStr().replace("'", "''") : "";
                String filterEscaped = filter != null ? filter.replace("'", "''") : "";
                String userId = (reqBO.getUserId() + "").replace("'", "''");
                String pageNo = reqBO.getPageNo() != null ? reqBO.getPageNo().replace("'", "''") : "";
                String pageSize = reqBO.getPageSize() != null ? reqBO.getPageSize().replace("'", "''") : "";
                insertSql = "INSERT INTO STAND_SE_IN_LOG (TRACE_ID, SEARCH_ID, CREATE_TIME, PAGE_NO, PAGE_SIZE, QUERY_STR, USER_PERMISSION, QUERY_FILTER_LIST, USER_ID) VALUES (" + traceId + ", " + searchId + ", TO_TIMESTAMP('" + createTime + "', 'YYYY-MM-DD HH24:MI:SS'), '" + pageNo + "', '" + pageSize + "', '" + queryStr + "', '22', '" + filterEscaped + "', '" + userId + "')";
                Db.use((String)"DATAPLAT").update(insertSql);
            } else {
                Db.use((String)"DATAPLAT").save("stand_se_in_log", record);
            }
            Record record1 = new Record();
            record1.set("TRACE_ID", (Object)traceId);
            record1.set("SEARCH_ID", (Object)searchId);
            record1.set("CREATE_TIME", (Object)new Date());
            record1.set("PAGE_NO", (Object)reqBO.getPageNo());
            record1.set("PAGE_SIZE", (Object)reqBO.getPageSize());
            record1.set("records_total", (Object)reqBO.getRecordsTotal());
            record1.set("total", (Object)reqBO.getTotal());
            if (this.driverName.contains("dm")) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String createTime = sdf.format(new Date());
                String pageNo = reqBO.getPageNo() != null ? reqBO.getPageNo().replace("'", "''") : "";
                String pageSize = reqBO.getPageSize() != null ? reqBO.getPageSize().replace("'", "''") : "";
                String recordsTotal = reqBO.getRecordsTotal() != null ? reqBO.getRecordsTotal().toString() : "NULL";
                String totalVal = reqBO.getTotal() != null ? reqBO.getTotal().toString() : "NULL";
                insertSql = "INSERT INTO STAND_SE_OUT_LOG (TRACE_ID, SEARCH_ID, CREATE_TIME, PAGE_NO, PAGE_SIZE, RECORDS_TOTAL, TOTAL) VALUES (" + traceId + ", " + searchId + ", TO_TIMESTAMP('" + createTime + "', 'YYYY-MM-DD HH24:MI:SS'), '" + pageNo + "', '" + pageSize + "', " + recordsTotal + ", " + totalVal + ")";
                Db.use((String)"DATAPLAT").update(insertSql);
            } else {
                Db.use((String)"DATAPLAT").save("stand_se_out_log", record1);
            }
            return searchId + "";
        }
        catch (Exception e) {
            log.error("\u63d2\u5165\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u63d2\u5165\u5931\u8d25");
        }
    }

    public void insertUserActionRecord(SearchResultUseActionBO reqBO) {
        reqBO.setUserId(Long.valueOf(1L));
        Long traceId = 0L;
        Long searchId = 0L;
        String info = this.cacheClient.get("{SEARCH}_USER_ACTION_" + reqBO.getUserId()).toString();
        JSONObject infoMap = JSON.parseObject((String)info);
        if (infoMap == null) {
            return;
        }
        traceId = Long.valueOf(infoMap.get("traceId").toString());
        searchId = Long.valueOf(infoMap.get("searchId").toString());
        try {
            log.info("\u6536\u85cf\u52a0\u8d2d\u8be6\u60c5\u65e5\u5fd7\u5165\u53c2:{}", (Object)reqBO);
            switch (reqBO.getActionType()) {
                case "0": {
                    Record record = new Record();
                    record.set("COLLECTION_ID", (Object)Sequence.getInstance().nextId());
                    record.set("TRACE_ID", (Object)traceId);
                    record.set("SEARCH_ID", (Object)searchId);
                    record.set("CREATE_TIME", (Object)new Date());
                    record.set("SKU_ID", (Object)reqBO.getSkuId());
                    record.set("SKU_NAME", (Object)reqBO.getSkuName());
                    record.set("SHOP_CODE", (Object)reqBO.getSupplierId());
                    record.set("USER_ID", (Object)(reqBO.getUserId() + ""));
                    record.set("USER_PERMISSION", (Object)"22");
                    if (this.driverName.contains("dm")) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String createTime = sdf.format(new Date());
                        Long collectionId = Sequence.getInstance().nextId();
                        String skuId = reqBO.getSkuId() != null ? reqBO.getSkuId().replace("'", "''") : "";
                        String skuName = reqBO.getSkuName() != null ? reqBO.getSkuName().replace("'", "''") : "";
                        String shopCode = reqBO.getSupplierId() != null ? reqBO.getSupplierId().replace("'", "''") : "";
                        String userId = (reqBO.getUserId() + "").replace("'", "''");
                        String insertSql = "INSERT INTO STAND_SE_COLLECTION_IN_LOG (COLLECTION_ID, TRACE_ID, SEARCH_ID, CREATE_TIME, SKU_ID, SKU_NAME, SHOP_CODE, USER_ID, USER_PERMISSION) VALUES (" + collectionId + ", " + traceId + ", " + searchId + ", TO_TIMESTAMP('" + createTime + "', 'YYYY-MM-DD HH24:MI:SS'), '" + skuId + "', '" + skuName + "', '" + shopCode + "', '" + userId + "', '22')";
                        Db.use((String)"DATAPLAT").update(insertSql);
                        break;
                    }
                    Db.use((String)"DATAPLAT").save("stand_se_collection_in_log", record);
                    break;
                }
                case "1": {
                    Record record1 = new Record();
                    record1.set("ADD_ID", (Object)Sequence.getInstance().nextId());
                    record1.set("TRACE_ID", (Object)traceId);
                    record1.set("SEARCH_ID", (Object)searchId);
                    record1.set("CREATE_TIME", (Object)new Date());
                    record1.set("SKU_ID", (Object)reqBO.getSkuId());
                    record1.set("USER_ID", (Object)(reqBO.getUserId() + ""));
                    record1.set("USER_PERMISSION", (Object)"22");
                    if (this.driverName.contains("dm")) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String createTime = sdf.format(new Date());
                        Long addId = Sequence.getInstance().nextId();
                        String skuId = reqBO.getSkuId() != null ? reqBO.getSkuId().replace("'", "''") : "";
                        String userId = (reqBO.getUserId() + "").replace("'", "''");
                        String insertSql = "INSERT INTO STAND_SE_ADD_PURCHASE_IN_LOG (ADD_ID, TRACE_ID, SEARCH_ID, CREATE_TIME, SKU_ID, USER_ID, USER_PERMISSION) VALUES (" + addId + ", " + traceId + ", " + searchId + ", TO_TIMESTAMP('" + createTime + "', 'YYYY-MM-DD HH24:MI:SS'), '" + skuId + "', '" + userId + "', '22')";
                        Db.use((String)"DATAPLAT").update(insertSql);
                        break;
                    }
                    Db.use((String)"DATAPLAT").save("stand_se_add_purchase_in_log", record1);
                    break;
                }
                case "2": {
                    Record record2 = new Record();
                    record2.set("DETAIL_ID", (Object)Sequence.getInstance().nextId());
                    record2.set("TRACE_ID", (Object)traceId);
                    record2.set("SEARCH_ID", (Object)searchId);
                    record2.set("CREATE_TIME", (Object)new Date());
                    record2.set("SKU_ID", (Object)reqBO.getSkuId());
                    record2.set("USER_ID", (Object)(reqBO.getUserId() + ""));
                    record2.set("USER_PERMISSION", (Object)"22");
                    if (this.driverName.contains("dm")) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String createTime = sdf.format(new Date());
                        Long detailId = Sequence.getInstance().nextId();
                        String skuId = reqBO.getSkuId() != null ? reqBO.getSkuId().replace("'", "''") : "";
                        String userId = (reqBO.getUserId() + "").replace("'", "''");
                        String insertSql = "INSERT INTO STAND_SE_COMM_DETAIL_IN_LOG (DETAIL_ID, TRACE_ID, SEARCH_ID, CREATE_TIME, SKU_ID, USER_ID, USER_PERMISSION) VALUES (" + detailId + ", " + traceId + ", " + searchId + ", TO_TIMESTAMP('" + createTime + "', 'YYYY-MM-DD HH24:MI:SS'), '" + skuId + "', '" + userId + "', '22')";
                        Db.use((String)"DATAPLAT").update(insertSql);
                        break;
                    }
                    Db.use((String)"DATAPLAT").save("stand_se_comm_detail_in_log", record2);
                }
            }
        }
        catch (Exception e) {
            log.error("\u63d2\u5165\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u63d2\u5165\u5931\u8d25");
        }
    }
}

