/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.impl;

import com.tydic.se.base.ability.bo.DeleteUserSearchRecordReqBO;
import com.tydic.se.base.ability.bo.QueryUserSearchRecordReqBO;
import com.tydic.se.base.ability.bo.SeAppQueryUserSearchRecordRspBO;
import com.tydic.se.base.ability.bo.SeQueryRspBaseBO;
import com.tydic.se.base.ability.bo.UserSearchRecordBO;
import com.tydic.se.manage.api.UserSearchRecordService;
import com.tydic.se.manage.dao.UserSearchRecordMapper;
import com.tydic.se.manage.dao.po.SeSearchInLogPO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserSearchRecordServiceImpl
implements UserSearchRecordService {
    private static final Logger log = LoggerFactory.getLogger(UserSearchRecordServiceImpl.class);
    @Autowired
    private UserSearchRecordMapper userSearchRecordMapper;

    public SeAppQueryUserSearchRecordRspBO queryUserSearchRecord(QueryUserSearchRecordReqBO reqBO) {
        try {
            SeSearchInLogPO queryParam = new SeSearchInLogPO();
            if (reqBO.getUserId() != null && !reqBO.getUserId().isEmpty()) {
                queryParam.setUserId(reqBO.getUserId());
            }
            List searchInLogPOList = this.userSearchRecordMapper.selectUserSearchHistory(queryParam);
            List filteredList = searchInLogPOList.stream().filter(log -> log != null && (log.getDeleteFlag() == null || log.getDeleteFlag() != 1)).collect(Collectors.toList());
            SeAppQueryUserSearchRecordRspBO rspBO = new SeAppQueryUserSearchRecordRspBO();
            if (filteredList != null && !filteredList.isEmpty()) {
                ArrayList<UserSearchRecordBO> userSearchRecords = new ArrayList<UserSearchRecordBO>();
                for (SeSearchInLogPO logPO : filteredList) {
                    UserSearchRecordBO recordBO = new UserSearchRecordBO();
                    recordBO.setCreateTime(logPO.getCreateTime());
                    recordBO.setRecordId(logPO.getTraceId());
                    recordBO.setSearchWord(logPO.getQueryStr());
                    recordBO.setUserId(logPO.getUserId());
                    userSearchRecords.add(recordBO);
                }
                rspBO.setRows(userSearchRecords);
                rspBO.setTotal(userSearchRecords.size());
                rspBO.setRecordsTotal(userSearchRecords.size());
            } else {
                rspBO.setRows(new ArrayList());
                rspBO.setTotal(0);
                rspBO.setRecordsTotal(0);
            }
            rspBO.setPageNo(1);
            rspBO.setBusiCode("0");
            rspBO.setBusiMsg("\u6210\u529f");
            UserSearchRecordServiceImpl.log.info("\u7528\u6237\u5386\u53f2\u641c\u7d22\u8bb0\u5f55\u67e5\u8be2\u5b8c\u6210\uff0c\u5171\u8fd4\u56de{}\u6761\u8bb0\u5f55", (Object)rspBO.getTotal());
            return rspBO;
        }
        catch (Exception e) {
            UserSearchRecordServiceImpl.log.error("\u67e5\u8be2\u7528\u6237\u5386\u53f2\u641c\u7d22\u8bb0\u5f55\u5f02\u5e38", (Throwable)e);
            SeAppQueryUserSearchRecordRspBO rspBO = new SeAppQueryUserSearchRecordRspBO();
            rspBO.setRows(new ArrayList());
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(0);
            rspBO.setPageNo(1);
            rspBO.setBusiCode("1");
            rspBO.setBusiMsg("\u7cfb\u7edf\u5f02\u5e38");
            return rspBO;
        }
    }

    public SeQueryRspBaseBO deleteUserSearchRecord(DeleteUserSearchRecordReqBO reqBO) {
        SeQueryRspBaseBO seQueryRspBaseBO = new SeQueryRspBaseBO();
        int result = 0;
        try {
            if (reqBO.getRecordIds() != null && !reqBO.getRecordIds().isEmpty()) {
                for (String recordId : reqBO.getRecordIds()) {
                    if (recordId == null) continue;
                    SeSearchInLogPO updateParam = new SeSearchInLogPO();
                    updateParam.setTraceId(recordId);
                    updateParam.setDeleteFlag(Integer.valueOf(1));
                    int updateResult = this.userSearchRecordMapper.updateDeleteFlag(updateParam);
                    result += updateResult;
                    log.info("\u5220\u9664\u641c\u7d22\u8bb0\u5f55, ID: {}, \u7ed3\u679c: {}", (Object)recordId, (Object)(updateResult > 0 ? "\u6210\u529f" : "\u5931\u8d25"));
                }
            }
            if (result > 0) {
                seQueryRspBaseBO.setBusiCode("0");
                seQueryRspBaseBO.setBusiMsg("\u6210\u529f");
                log.info("\u5220\u9664\u7528\u6237\u5386\u53f2\u641c\u7d22\u8bb0\u5f55\u6210\u529f, \u5171\u5220\u9664{}\u6761\u8bb0\u5f55", (Object)result);
            } else {
                seQueryRspBaseBO.setBusiCode("1");
                seQueryRspBaseBO.setBusiMsg("\u5931\u8d25");
            }
        }
        catch (Exception e) {
            seQueryRspBaseBO.setBusiCode("1");
            seQueryRspBaseBO.setBusiMsg("\u5220\u9664\u5931\u8d25: " + e.getMessage());
            log.error("\u5220\u9664\u7528\u6237\u5386\u53f2\u641c\u7d22\u8bb0\u5f55\u5f02\u5e38", (Throwable)e);
        }
        return seQueryRspBaseBO;
    }
}

