/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.job;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.manage.api.ReportStatisticsService;
import com.tydic.se.search.config.SearchProcessConfig;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class createUserBehaviorTable {
    private static final Logger log = LoggerFactory.getLogger(createUserBehaviorTable.class);
    @Autowired
    ReportStatisticsService reportStatisticsService;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private SearchProcessConfig searchProcessConfig;

    @Scheduled(cron="0 50 23 28-31 * ?")
    protected void statisticUserBehavior() {
        try {
            LocalDate now = LocalDate.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
            String yearMonth = now.withDayOfMonth(1).format(formatter);
            LocalDate nextMonthDate = now.plusMonths(1L).withDayOfMonth(1);
            String nextMonth = nextMonthDate.format(formatter);
            Long seChannelType = (Long)this.cacheClient.get("{SEARCH}_DEFAULT_CHANNEL_TYPE");
            String lifeTime = ((SearchProcessConfig.ManageConfig)this.searchProcessConfig.getManage().get((Object)seChannelType)).logLifeMonth;
            LocalDate threeMonthsAgo = now.minusMonths(Integer.parseInt(lifeTime)).withDayOfMonth(1);
            String monthToDelete = threeMonthsAgo.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            this.reportStatisticsService.cleanOldBehaviorTable(monthToDelete);
            this.reportStatisticsService.createBehaviorTable(yearMonth, nextMonth);
        }
        catch (Exception e) {
            log.error("\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u4e3a:", (Throwable)e);
        }
    }
}

