/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.job;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.manage.api.ReportStatisticsService;
import com.tydic.se.manage.constants.JedisHelper;
import com.tydic.se.manage.util.DateUtil;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

@Configuration
public class statisticUserBehavior {
    private static final Logger log = LoggerFactory.getLogger(statisticUserBehavior.class);
    @Autowired
    ReportStatisticsService reportStatisticsService;
    @Autowired
    private CacheClient cacheClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void statisticUserBehavior() {
        String lockKey2 = "user_action_statistic_" + DateUtil.getCurrentDateNew();
        try {
            Boolean flag = JedisHelper.tryGetDistributedLock((CacheClient)this.cacheClient, (String)lockKey2, (Boolean)false, null);
            if (!flag.booleanValue()) {
                log.info("-----------\u7528\u6237\u884c\u4e3a\u7edf\u8ba1\u5b9a\u65f6\u4efb\u52a1\u6709\u5176\u4ed6\u8fdb\u7a0b\u6b63\u5728\u6267\u884c\u4e2d,\u76f4\u63a5\u8fd4\u56de----");
                return;
            }
            String yearMonth = DateUtil.getYesMonth();
            String yesterdayDate = DateUtil.getYesterday();
            log.info("\u6628\u5929\u6708\u4e3a:{},\u6628\u5929\u65e5\u671f\u4e3a:{}", (Object)yearMonth, (Object)yesterdayDate);
            this.reportStatisticsService.incrementStatistics(yearMonth, yesterdayDate);
            LocalDate date30DaysAgo = LocalDate.now().minusDays(30L);
            DateTimeFormatter formatter2 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            String formatted30Date = date30DaysAgo.format(formatter2);
            this.reportStatisticsService.deleteWordStatistic(formatted30Date);
        }
        catch (Exception e) {
            log.error("\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u4e3a:", (Throwable)e);
        }
        finally {
            log.error("\u91ca\u653e\u9501:--");
            JedisHelper.releaseDistributedLock((CacheClient)this.cacheClient, (String)lockKey2, null);
        }
    }
}

