/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.bo.RspBaseBO;
import com.ohaotian.plugin.base.bo.RspPage;
import com.tydic.se.manage.config.ResponseResultBody;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice
public class ResultBodyAdvice
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(ResultBodyAdvice.class);
    private static final Class<? extends Annotation> ANNOTATION_TYPE = ResponseResultBody.class;

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)returnType.getContainingClass(), ANNOTATION_TYPE) || returnType.hasMethodAnnotation(ANNOTATION_TYPE);
    }

    public Object beforeBodyWrite(Object obj, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        HashMap<String, Object> rsp = new HashMap<String, Object>();
        try {
            if (obj instanceof RspPage) {
                rsp.put("data", obj);
                if (StringUtils.isNotEmpty((CharSequence)((RspPage)obj).getCode())) {
                    rsp.put("code", ((RspPage)obj).getCode());
                    rsp.put("message", ((RspPage)obj).getMessage());
                } else {
                    rsp.put("code", "0");
                    rsp.put("message", "\u6210\u529f");
                }
            } else if (obj instanceof RspBaseBO) {
                LinkedHashMap linkedHashMap = (LinkedHashMap)JSONObject.parseObject((String)this.objToJsonString(obj), LinkedHashMap.class, (Feature[])new Feature[]{Feature.OrderedField});
                JSONObject jsonObject = new JSONObject();
                jsonObject.putAll((Map)linkedHashMap);
                if (jsonObject.size() == 1) {
                    Set keySet = jsonObject.keySet();
                    for (String str : keySet) {
                        Object o = jsonObject.get((Object)str);
                        rsp.put("data", o);
                    }
                } else {
                    rsp.put("data", jsonObject);
                }
                if (StringUtils.isNotEmpty((CharSequence)((RspBaseBO)obj).getCode())) {
                    rsp.put("code", ((RspBaseBO)obj).getCode());
                    rsp.put("message", ((RspBaseBO)obj).getMessage());
                } else {
                    rsp.put("code", "0");
                    rsp.put("message", "\u6210\u529f");
                }
            } else {
                rsp.put("code", "0");
                rsp.put("message", "\u6210\u529f");
                if (obj != null) {
                    rsp.put("data", obj);
                }
            }
        }
        catch (Exception var13) {
            log.error("\u8f6c\u6362\u4fe1\u606f\u5931\u8d25\uff0c\u8fd4\u56de\u6d88\u606f\u8f6c\u6362", (Throwable)var13);
            return null;
        }
        return rsp;
    }

    private String objToJsonString(Object msg) {
        return JSON.toJSONString((Object)msg, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullBooleanAsFalse});
    }
}

