/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.controller;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.base.ability.bo.ExecuteSearchReqBO;
import com.tydic.se.base.exception.BusinessException;
import com.tydic.se.manage.config.ResponseResultBody;
import com.tydic.se.manage.dao.SearchAnalyticWordsTypeMapper;
import com.tydic.se.nlp.api.AnalysisMateService;
import com.tydic.se.nlp.bo.AnalysisSearchReqBO;
import com.tydic.se.nlp.req.RaNERMateResultBO;
import com.tydic.se.nlp.util.AnalysisCommTools;
import com.tydic.se.search.ability.bo.CoreWordExtractionRspBO;
import com.tydic.se.search.ability.bo.ProductRecReqBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/search/v3/data/analysis"})
@ResponseResultBody
public class AnalysisController {
    private static final Logger log = LoggerFactory.getLogger(AnalysisController.class);
    @Autowired
    private AnalysisMateService analysisMateService;
    @Autowired
    private SearchAnalyticWordsTypeMapper analyticWordsTypeMapper;
    @Autowired
    private CacheClient cacheClient;

    @RequestMapping(value={"/coreWordExtraction"}, method={RequestMethod.POST})
    public Object coreWordExtraction(@Valid ProductRecReqBO reqBO) {
        CoreWordExtractionRspBO coreWordExtractionRspBO = new CoreWordExtractionRspBO();
        String esIndex = null;
        try {
            esIndex = AnalysisCommTools.getIndexName((CacheClient)this.cacheClient, (String)"indexEsSkuName");
        }
        catch (BusinessException e) {
            coreWordExtractionRspBO.setCode("-1");
            coreWordExtractionRspBO.setMessage("\u65e0\u53ef\u7528\u5355\u54c1\u7d22\u5f15\uff01");
            return coreWordExtractionRspBO;
        }
        try {
            List typeList = this.analyticWordsTypeMapper.queryEffectiveList();
            if (typeList != null && typeList.size() > 0) {
                LinkedHashMap wordTypeMap = new LinkedHashMap();
                typeList.forEach(type -> wordTypeMap.put(type.getIndexField(), type.gettName()));
                coreWordExtractionRspBO.setWordTypeMap(wordTypeMap);
            }
            ArrayList analyzeTokenList = new ArrayList();
            String rewriteWord = null;
            StringBuffer analysisWord = new StringBuffer();
            HashSet<String> cataLogList = new HashSet<String>();
            HashMap dataCatalogMap = new HashMap();
            ExecuteSearchReqBO seAppSearchReqBO = new ExecuteSearchReqBO();
            seAppSearchReqBO.setQueryStr(reqBO.getpName());
            AnalysisSearchReqBO searchReqBO = new AnalysisSearchReqBO(seAppSearchReqBO);
            searchReqBO.setUccIndex(esIndex);
            Long seChannelType = (Long)this.cacheClient.get("{SEARCH}_DEFAULT_CHANNEL_TYPE");
            RaNERMateResultBO resultBO = this.analysisMateService.rewriteAndAnalyzerQueryKey(searchReqBO, analyzeTokenList, seChannelType);
            if (!AnalysisCommTools.strIsEmpty((String)searchReqBO.getRewrite())) {
                rewriteWord = searchReqBO.getRewrite();
            }
            if (analyzeTokenList != null && analyzeTokenList.size() > 0) {
                analyzeTokenList.forEach(analyzeTokenBO -> {
                    if (analyzeTokenBO.getNotQuery() == null || !analyzeTokenBO.getNotQuery().booleanValue()) {
                        analysisWord.append(analyzeTokenBO.getTerm()).append("\uff0c");
                    }
                    if (analyzeTokenBO.getExtCatalogList() != null && analyzeTokenBO.getExtCatalogList().size() > 0) {
                        for (String catalog : analyzeTokenBO.getExtCatalogList()) {
                            cataLogList.add(catalog + (analyzeTokenBO.getCatalogType() == 0 ? "[\u5916\u90e8\u4e09\u7ea7\u7c7b\u76ee\u5339\u914d]" : "[\u5185\u90e8\u7c7b\u76ee\u5339\u914d]"));
                        }
                    }
                    if (coreWordExtractionRspBO.getWordTypeMap() != null && coreWordExtractionRspBO.getWordTypeMap().size() > 0 && analyzeTokenBO.getTypeMap() != null && analyzeTokenBO.getTypeMap().size() > 0) {
                        analyzeTokenBO.getTypeMap().forEach((indexField, weight) -> coreWordExtractionRspBO.getWordTypeMap().forEach((f, tName) -> {
                            if (indexField.equals(f)) {
                                if (dataCatalogMap.get(indexField) == null) {
                                    dataCatalogMap.put((String)indexField, new HashSet());
                                }
                                ((Set)dataCatalogMap.get(indexField)).add(analyzeTokenBO.getTerm() + "[\u5185\u90e8\u7c7b\u76ee\u5339\u914d]");
                            }
                        }));
                    }
                });
            }
            if (resultBO != null && (resultBO.getCatalogList() != null && resultBO.getCatalogList().size() > 0 || resultBO.getBrandNameList() != null && resultBO.getBrandNameList().size() > 0)) {
                if (cataLogList.size() < 1 && resultBO.getCatalogList() != null && resultBO.getCatalogList().size() > 0) {
                    for (String catalog : resultBO.getCatalogList()) {
                        cataLogList.add(catalog + (resultBO.getCatalogType() == null ? "[\u5b9e\u4f53\u8bc6\u522b]" : (resultBO.getCatalogType() == 0 ? "[\u5b9e\u4f53\u8bc6\u522b\u5916\u90e8\u4e09\u7ea7\u7c7b\u76ee\u5339\u914d]" : "[\u5b9e\u4f53\u8bc6\u522b\u7c7b\u76ee\u5339\u914d]")));
                    }
                }
                if (resultBO.getBrandNameList() != null && resultBO.getBrandNameList().size() > 0) {
                    dataCatalogMap.put("brand_name", new HashSet());
                    resultBO.getBrandNameList().forEach(brandName -> ((Set)dataCatalogMap.get("brand_name")).add(brandName + "[\u5b9e\u4f53\u8bc6\u522b]"));
                }
            }
            coreWordExtractionRspBO.setRewriteWord(rewriteWord);
            coreWordExtractionRspBO.setAnalysisWord(analysisWord.toString().endsWith("\uff0c") ? analysisWord.toString().substring(0, analysisWord.length() - 1) : analysisWord.toString());
            coreWordExtractionRspBO.setCataLogList(cataLogList);
            coreWordExtractionRspBO.setDataCatalogMap(dataCatalogMap);
            return coreWordExtractionRspBO;
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u67e5\u8be2\u5931\u8d25\uff01" + e.getMessage());
        }
    }
}

