/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.controller;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.se.manage.api.CatalogImportService;
import com.tydic.se.manage.api.OperLogService;
import com.tydic.se.manage.api.SearchFourCatalogService;
import com.tydic.se.manage.api.SearchThreeCatalogService;
import com.tydic.se.manage.bo.AddCatalogInfoReqBO;
import com.tydic.se.manage.bo.AddCatalogMappingReqBO;
import com.tydic.se.manage.bo.ChangeCatalogOrderReqBO;
import com.tydic.se.manage.bo.ChangeCatalogStatusReqBO;
import com.tydic.se.manage.bo.ExportCatalogRspBO;
import com.tydic.se.manage.bo.FourCatalogImportRsp;
import com.tydic.se.manage.bo.QryAddCatalogListRspBO;
import com.tydic.se.manage.bo.QryCatalogListReqBO;
import com.tydic.se.manage.bo.QryCatalogListRspBO;
import com.tydic.se.manage.bo.QryCatalogTreeReqBO;
import com.tydic.se.manage.bo.QryCatalogTreeRspBO;
import com.tydic.se.manage.bo.SwapInsertOperLogReqBO;
import com.tydic.se.manage.bo.ThreeCatalogImportRsp;
import com.tydic.se.manage.bo.UpdateCatalogInfoReqBO;
import com.tydic.se.manage.config.ResponseResultBody;
import com.tydic.se.manage.constants.XlsUtil;
import com.tydic.se.manage.dao.SearchCatalogRecordMapper;
import com.tydic.se.manage.dao.po.SearchCatalogRecord;
import com.tydic.se.manage.enums.OperModeEnum;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/search/v3/data/catalog"})
@ResponseResultBody
public class CatalogManageController {
    private static final Logger log = LoggerFactory.getLogger(CatalogManageController.class);
    private static final Logger logger = LoggerFactory.getLogger(CatalogManageController.class);
    @Autowired
    private SearchFourCatalogService searchFourCatalogService;
    @Autowired
    private SearchThreeCatalogService searchThreeCatalogService;
    @Autowired
    private CatalogImportService catalogImportService;
    @Autowired
    private HttpServletResponse httpResponse;
    @Autowired
    private OperLogService operLogService;
    @Autowired
    private SearchCatalogRecordMapper searchCatalogRecordDao;

    @RequestMapping(value={"/queryCatalogList"}, method={RequestMethod.POST})
    public Object queryCatalogList(QryCatalogListReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        QryCatalogListRspBO rsp = reqBO.getType().equals("0") ? this.searchFourCatalogService.queryCatalogList(reqBO) : this.searchThreeCatalogService.queryCatalogList(reqBO);
        return rsp;
    }

    @RequestMapping(value={"/addCatalog"})
    public Object addCatalog(@Valid AddCatalogInfoReqBO reqBO) {
        if (reqBO.getType().equals("0")) {
            this.searchFourCatalogService.addCatalog(reqBO);
            SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
            logReqBO.setOperMode(OperModeEnum.standardCateManage.getDesc());
            logReqBO.setOperType("A");
            logReqBO.setOperContent("\u65b0\u589e" + reqBO.getCLevel() + "\u7ea7\u6807\u51c6\u7c7b\u76ee\uff1a" + reqBO.getCName());
            this.operLogService.insertOperLog(logReqBO);
        } else {
            this.searchThreeCatalogService.addCatalog(reqBO);
            SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
            logReqBO.setOperMode(OperModeEnum.outCateManage.getDesc());
            logReqBO.setOperType("A");
            logReqBO.setOperContent("\u65b0\u589e" + reqBO.getCLevel() + "\u7ea7\u5916\u90e8\u7c7b\u76ee\uff1a" + reqBO.getCName());
            this.operLogService.insertOperLog(logReqBO);
        }
        return null;
    }

    @RequestMapping(value={"/updateCatalog"})
    public Object update(@Valid UpdateCatalogInfoReqBO reqBO) {
        if (reqBO.getType().equals("0")) {
            this.searchFourCatalogService.updateByCatalogId(reqBO);
            SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
            logReqBO.setOperMode(OperModeEnum.standardCateManage.getDesc());
            logReqBO.setOperType("M");
            logReqBO.setOperContent("\u6807\u51c6\u7c7b\u76ee\uff1a" + reqBO.getCName() + ",\u4fee\u6539\u63cf\u8ff0\u4e3a\uff1a" + reqBO.getCDesc());
            this.operLogService.insertOperLog(logReqBO);
        } else {
            this.searchThreeCatalogService.updateByCatalogId(reqBO);
            SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
            logReqBO.setOperMode(OperModeEnum.outCateManage.getDesc());
            logReqBO.setOperType("M");
            logReqBO.setOperContent("\u5916\u90e8\u7c7b\u76ee\uff1a" + reqBO.getCName() + ",\u4fee\u6539\u63cf\u8ff0\u4e3a\uff1a" + reqBO.getCDesc());
            this.operLogService.insertOperLog(logReqBO);
        }
        return null;
    }

    @RequestMapping(value={"/deleteCatalog"})
    public Object delete(@Valid ChangeCatalogOrderReqBO reqBO) {
        if (reqBO.getType().equals("0")) {
            this.searchFourCatalogService.deleteCatalog(reqBO);
            SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
            logReqBO.setOperMode(OperModeEnum.standardCateManage.getDesc());
            logReqBO.setOperType("D");
            logReqBO.setOperContent("\u5220\u9664\u6807\u51c6\u7c7b\u76ee\uff1a" + reqBO.getCName());
            this.operLogService.insertOperLog(logReqBO);
        } else {
            this.searchThreeCatalogService.deleteCatalog(reqBO);
            SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
            logReqBO.setOperMode(OperModeEnum.outCateManage.getDesc());
            logReqBO.setOperType("D");
            logReqBO.setOperContent("\u5220\u9664\u5916\u90e8\u7c7b\u76ee\uff1a" + reqBO.getCName());
            this.operLogService.insertOperLog(logReqBO);
        }
        return null;
    }

    @RequestMapping(value={"/upCatalog"})
    public Object upOrder(@Valid ChangeCatalogOrderReqBO reqBO) {
        if (reqBO.getType().equals("0")) {
            this.searchFourCatalogService.changeCatalogOrderUp(reqBO);
        } else {
            this.searchThreeCatalogService.changeCatalogOrderUp(reqBO);
        }
        return null;
    }

    @RequestMapping(value={"/downCatalog"})
    public Object downOrder(@Valid ChangeCatalogOrderReqBO reqBO) {
        if (reqBO.getType().equals("0")) {
            this.searchFourCatalogService.changeCatalogOrderDown(reqBO);
        } else {
            this.searchThreeCatalogService.changeCatalogOrderDown(reqBO);
        }
        return null;
    }

    @RequestMapping(value={"/changeCatalogStatus"})
    public Object changeCatalogStatus(ChangeCatalogStatusReqBO reqBO) {
        if (reqBO.getType().equals("0")) {
            this.searchFourCatalogService.changeCatalogStatus(reqBO);
            SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
            logReqBO.setOperMode(OperModeEnum.standardCateManage.getDesc());
            if (reqBO.getCStatus() == 0) {
                logReqBO.setOperType("C");
                logReqBO.setOperContent("\u505c\u7528\u6807\u51c6\u7c7b\u76ee\uff1a" + reqBO.getCName());
            } else {
                logReqBO.setOperType("O");
                logReqBO.setOperContent("\u542f\u7528\u6807\u51c6\u7c7b\u76ee\uff1a" + reqBO.getCName());
            }
            this.operLogService.insertOperLog(logReqBO);
        } else {
            this.searchThreeCatalogService.changeCatalogStatus(reqBO);
            SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
            logReqBO.setOperMode(OperModeEnum.outCateManage.getDesc());
            if (reqBO.getCStatus() == 0) {
                logReqBO.setOperType("C");
                logReqBO.setOperContent("\u505c\u7528\u5916\u90e8\u7c7b\u76ee\uff1a" + reqBO.getCName());
            } else {
                logReqBO.setOperType("O");
                logReqBO.setOperContent("\u542f\u7528\u5916\u90e8\u7c7b\u76ee\uff1a" + reqBO.getCName());
            }
            this.operLogService.insertOperLog(logReqBO);
        }
        return null;
    }

    @RequestMapping(value={"/addCatalogMappping"})
    public Object addCatalogMappping(AddCatalogMappingReqBO reqBO) {
        this.searchThreeCatalogService.addCatalogMappping(reqBO);
        try {
            SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
            logReqBO.setOperMode(OperModeEnum.outCateManage.getDesc());
            logReqBO.setOperType("R");
            StringBuffer fourName = new StringBuffer();
            if (reqBO.getCIdLIst() != null && reqBO.getCIdLIst().size() > 0) {
                for (String cId : reqBO.getCIdLIst()) {
                    SearchCatalogRecord fourPO = this.searchCatalogRecordDao.selectByPrimaryKey(cId);
                    if (fourPO == null) continue;
                    fourName.append(fourPO.getCName()).append(",");
                }
                logReqBO.setOperContent("\u5c06\u5916\u90e8\u4e09\u7ea7\u7c7b\u76ee\uff1a" + reqBO.getExtCName() + "-\u5173\u8054\u6807\u51c6\u56db\u7ea7\u7c7b\u76ee\u6620\u5c04\u4e3a\uff1a" + fourName.substring(0, fourName.length() - 1));
            } else {
                logReqBO.setOperContent("\u53d6\u6d88\u5916\u90e8\u4e09\u7ea7\u7c7b\u76ee\uff1a" + reqBO.getExtCName() + "-\u5173\u8054\u7684\u6807\u51c6\u56db\u7ea7\u7c7b\u76ee");
            }
            this.operLogService.insertOperLog(logReqBO);
        }
        catch (Exception e) {
            logger.error("\u5173\u8054\u6807\u51c6\u56db\u7ea7\u7c7b\u76ee\u6620\u5c04\u7559\u75d5\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    @RequestMapping(value={"/queryMappingCatalogTree"}, method={RequestMethod.POST})
    public Object queryMappingCatalogTree(QryCatalogTreeReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        QryCatalogTreeRspBO rsp = this.searchThreeCatalogService.queryMappingCatalogTree(reqBO);
        return rsp;
    }

    @RequestMapping(value={"/queryAddCatalogList"}, method={RequestMethod.POST})
    public Object queryAddCatalogList(QryCatalogListReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        QryAddCatalogListRspBO rsp = reqBO.getType().equals("0") ? this.searchFourCatalogService.queryAddCatalogList(reqBO) : this.searchThreeCatalogService.queryAddCatalogList(reqBO);
        return rsp;
    }

    @RequestMapping(value={"/importFourCatalog"}, method={RequestMethod.POST})
    public void importFourCatalog(HttpServletRequest request, HttpServletResponse response) throws IOException {
        FourCatalogImportRsp rspBO = null;
        try {
            response.setContentType("application/json;charset=utf-8");
            PrintWriter printWriter = response.getWriter();
            HashMap<String, String> res = new HashMap<String, String>();
            Workbook work = XlsUtil.readXls((HttpServletRequest)request);
            if (work == null) {
                throw new ZTBusinessException("\u8bfb\u53d6excel\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u786e\u4fdd\u6587\u4ef6\u683c\u5f0f\u6b63\u786e!");
            }
            if ((work = this.checkTemplate(work, 0)) == null) {
                throw new ZTBusinessException("\u8bf7\u786e\u4fdd\u4f7f\u7528\u6b63\u786e\u7684excel\u6a21\u677f!");
            }
            List cList = null;
            cList = XlsUtil.getBankListByExcel((Workbook)work);
            if (cList == null || cList.size() <= 0) {
                throw new ZTBusinessException("\u5bfc\u5165\u7684\u5185\u5bb9\u4e3a\u7a7a!");
            }
            rspBO = this.catalogImportService.fourCatalogImport(cList);
            res.put("code", "0");
            res.put("message", "success");
            res.put("data", (String)rspBO);
            printWriter.write(JSON.toJSONString(res));
            printWriter.flush();
            SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
            logReqBO.setOperMode(OperModeEnum.standardCateManage.getDesc());
            logReqBO.setOperType("I");
            logReqBO.setOperContent("\u5bfc\u5165\u6807\u51c6\u7c7b\u76ee");
            this.operLogService.insertOperLog(logReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException("\u4e0a\u4f20\u5931\u8d25:" + e.getMessage());
        }
    }

    @RequestMapping(value={"/importThreeCatalog"}, method={RequestMethod.POST})
    public void importThreeCatalog(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ThreeCatalogImportRsp rspBO = null;
        try {
            response.setContentType("application/json;charset=utf-8");
            PrintWriter printWriter = response.getWriter();
            HashMap<String, String> res = new HashMap<String, String>();
            Workbook work = XlsUtil.readXls((HttpServletRequest)request);
            if (work == null) {
                throw new ZTBusinessException("\u8bfb\u53d6excel\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u786e\u4fdd\u6587\u4ef6\u683c\u5f0f\u6b63\u786e!");
            }
            if ((work = this.checkTemplate(work, 1)) == null) {
                throw new ZTBusinessException("\u8bf7\u786e\u4fdd\u4f7f\u7528\u6b63\u786e\u7684excel\u6a21\u677f!");
            }
            List cList = null;
            cList = XlsUtil.getBankListByExcel((Workbook)work);
            if (cList == null || cList.size() <= 0) {
                throw new ZTBusinessException("\u5bfc\u5165\u7684\u5185\u5bb9\u4e3a\u7a7a!");
            }
            rspBO = this.catalogImportService.threeCatalogImport(cList);
            res.put("code", "0");
            res.put("message", "success");
            res.put("data", (String)rspBO);
            printWriter.write(JSON.toJSONString(res));
            printWriter.flush();
            SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
            logReqBO.setOperMode(OperModeEnum.outCateManage.getDesc());
            logReqBO.setOperType("I");
            logReqBO.setOperContent("\u5bfc\u5165\u6807\u51c6\u7c7b\u76ee");
            this.operLogService.insertOperLog(logReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException("\u4e0a\u4f20\u5931\u8d25:" + e.getMessage());
        }
    }

    public Workbook checkTemplate(Workbook workbook, Integer type) {
        Row row1;
        if (workbook.getNumberOfSheets() <= 0) {
            workbook = null;
            return workbook;
        }
        Sheet sheet = workbook.getSheetAt(0);
        if (sheet != null && (row1 = sheet.getRow(0)) != null) {
            System.out.println(row1.getLastCellNum());
            if (type == 1 && row1.getLastCellNum() != 9) {
                workbook = null;
                return workbook;
            }
            if (type == 0 && row1.getLastCellNum() != 12) {
                workbook = null;
                return workbook;
            }
            Cell cell = row1.getCell(0);
            Cell cell1 = row1.getCell(1);
            Cell cell2 = row1.getCell(2);
            Cell cell3 = row1.getCell(3);
            Cell cell4 = row1.getCell(4);
            Cell cell5 = row1.getCell(5);
            Cell cell6 = row1.getCell(6);
            Cell cell7 = row1.getCell(7);
            Cell cell8 = row1.getCell(8);
            if (cell == null || !cell.toString().equals("\u4e00\u7ea7\u5206\u7c7b\u7f16\u7801")) {
                workbook = null;
                return workbook;
            }
            if (cell1 == null || !cell1.toString().equals("\u4e00\u7ea7\u5206\u7c7b\u540d\u79f0")) {
                workbook = null;
                return workbook;
            }
            if (cell2 == null || !cell2.toString().equals("\u4e00\u7ea7\u5206\u7c7b\u63cf\u8ff0")) {
                workbook = null;
                return workbook;
            }
            if (cell3 == null || !cell3.toString().equals("\u4e8c\u7ea7\u5206\u7c7b\u7f16\u7801")) {
                workbook = null;
                return workbook;
            }
            if (cell4 == null || !cell4.toString().equals("\u4e8c\u7ea7\u5206\u7c7b\u540d\u79f0")) {
                workbook = null;
                return workbook;
            }
            if (cell5 == null || !cell5.toString().equals("\u4e8c\u7ea7\u5206\u7c7b\u63cf\u8ff0")) {
                workbook = null;
                return workbook;
            }
            if (cell6 == null || !cell6.toString().equals("\u4e09\u7ea7\u5206\u7c7b\u7f16\u7801")) {
                workbook = null;
                return workbook;
            }
            if (cell7 == null || !cell7.toString().equals("\u4e09\u7ea7\u5206\u7c7b\u540d\u79f0")) {
                workbook = null;
                return workbook;
            }
            if (cell8 == null || !cell8.toString().equals("\u4e09\u7ea7\u5206\u7c7b\u63cf\u8ff0")) {
                workbook = null;
                return workbook;
            }
            if (type == 0) {
                Cell cell9 = row1.getCell(9);
                Cell cell10 = row1.getCell(10);
                Cell cell11 = row1.getCell(11);
                if (cell9 == null || !cell9.toString().equals("\u56db\u7ea7\u5206\u7c7b\u7f16\u7801")) {
                    workbook = null;
                    return workbook;
                }
                if (cell10 == null || !cell10.toString().equals("\u56db\u7ea7\u5206\u7c7b\u540d\u79f0")) {
                    workbook = null;
                    return workbook;
                }
                if (cell11 == null || !cell11.toString().equals("\u56db\u7ea7\u5206\u7c7b\u63cf\u8ff0")) {
                    workbook = null;
                    return workbook;
                }
            }
        }
        return workbook;
    }

    @RequestMapping(value={"/exportCatalogList"}, method={RequestMethod.POST})
    public Object exportCatalogList() {
        ExportCatalogRspBO rsp = this.catalogImportService.exportCatalogList();
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        logReqBO.setOperMode(OperModeEnum.standardCateManage.getDesc());
        logReqBO.setOperType("E");
        logReqBO.setOperContent("\u5bfc\u51fa\u6807\u51c6\u7c7b\u76ee");
        this.operLogService.insertOperLog(logReqBO);
        return rsp;
    }
}

