/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.controller;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.se.manage.api.QueryESIndexManageService;
import com.tydic.se.manage.bo.AddEsIndexReqBO;
import com.tydic.se.manage.bo.ESIndexTemplateReqBO;
import com.tydic.se.manage.bo.ESIndexTemplateRspBO;
import com.tydic.se.manage.bo.IndexDetailRespBO;
import com.tydic.se.manage.bo.IndexInfoReqBO;
import com.tydic.se.manage.bo.QueryESIndexManageReqBO;
import com.tydic.se.manage.bo.QueryESIndexManageRspBO;
import com.tydic.se.manage.bo.QueryIndexTypeRspBO;
import com.tydic.se.manage.bo.QueryThemeModelByThemeIdRspBO;
import com.tydic.se.manage.config.ResponseResultBody;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/search/v3/data/esIndex"})
@ResponseResultBody
public class ESIndexManageMentServiceController {
    private static final Logger log = LoggerFactory.getLogger(ESIndexManageMentServiceController.class);
    @Autowired
    private QueryESIndexManageService queryESIndexManageService;

    @RequestMapping(value={"/queryESIndexManageList"}, method={RequestMethod.POST})
    public Object queryESIndexManageList(@Valid QueryESIndexManageReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        QueryESIndexManageRspBO rspBO = this.queryESIndexManageService.queryESIndexManageList(reqBO);
        return rspBO;
    }

    @RequestMapping(value={"/addEsIndex"}, method={RequestMethod.POST})
    public Object addEsIndex(@Valid AddEsIndexReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.queryESIndexManageService.addEsIndex(reqBO);
        return null;
    }

    @RequestMapping(value={"/updateEsIndex"}, method={RequestMethod.POST})
    public Object updateEsIndex(@Valid AddEsIndexReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.queryESIndexManageService.updateEsIndex(reqBO);
        return null;
    }

    @RequestMapping(value={"/deleteEsIndex"}, method={RequestMethod.POST})
    public Object deleteEsIndex(@Valid AddEsIndexReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.queryESIndexManageService.deleteEsIndex(reqBO);
        return null;
    }

    @RequestMapping(value={"/startEsIndex"}, method={RequestMethod.POST})
    public Object startEsIndex(@Valid AddEsIndexReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.queryESIndexManageService.startEsIndex(reqBO);
        return null;
    }

    @RequestMapping(value={"/stopEsIndex"}, method={RequestMethod.POST})
    public Object stopEsIndex(@Valid AddEsIndexReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.queryESIndexManageService.stopEsIndex(reqBO);
        return null;
    }

    @RequestMapping(value={"/queryIndexTemplateByType"}, method={RequestMethod.POST})
    public Object queryIndexTemplateByType(@Valid ESIndexTemplateReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        ESIndexTemplateRspBO rspBO = this.queryESIndexManageService.queryIndexTemplateByType(reqBO);
        return rspBO;
    }

    @RequestMapping(value={"/queryIndexModel"}, method={RequestMethod.POST})
    public Object queryThemeModel(@Valid ESIndexTemplateReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        QueryThemeModelByThemeIdRspBO rspBO = this.queryESIndexManageService.queryIndexModel();
        return rspBO;
    }

    @RequestMapping(value={"/createESIndexTemplate"}, method={RequestMethod.POST})
    public Object createESIndexTemplate(@Valid ESIndexTemplateReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.queryESIndexManageService.createESIndexTemplate(reqBO);
        return null;
    }

    @RequestMapping(value={"/queryIndexType"}, method={RequestMethod.POST})
    public Object queryIndexType(@Valid QueryESIndexManageReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        QueryIndexTypeRspBO rspBO = this.queryESIndexManageService.queryIndexType(reqBO);
        return rspBO;
    }

    @RequestMapping(value={"/queryIndexInfo"}, method={RequestMethod.POST})
    public Object getIndexInfo(@Valid IndexInfoReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        IndexDetailRespBO rspBO = this.queryESIndexManageService.getIndexInfo(reqBO);
        return rspBO;
    }
}

